<?php
	/************************************************
	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspackplus/admin/infrasplussetup.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup the module InfraS
	************************************************/
	function num_col(&$selectvalue, $listselect)
	{
		$nums	= array('options' => '', 'err' => 0);
		for ($i = 1 ; $i < 12 ; $i++)
		{
			$afficher							= $i < 10 ? '0'.$i : $i;
			$nums['options']					.= '<option name = "'.$selectvalue['select'].'" value = "'.$i.'"';
			if ($selectvalue['value'] == $i)	$nums['options']	.= ' selected';
			$nums['options']					.= '>'.$afficher.'</option>';
		}	// for ($i = 1 ; $i < 12 ; $i++)
		foreach ($listselect as $selectvalues)	if ($selectvalues['select'] != $selectvalue['select'] && $selectvalues['value'] == $selectvalue['value'])	$nums['err']++;
		return $nums;
	}	// function num_col(&$selectvalue, $listselect)

	// Dolibarr environment *************************
	require '../config.php';

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
	include_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
	dol_include_once('/infraspackplus/core/lib/infraspackplus.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load("companies");
	$langs->load("orders");
	$langs->load("sendings");
	$langs->load("contracts");
	$langs->load("bills");
	$langs->load('errors');
	$langs->load('infraspackplus@infraspackplus');

	// Access control *******************************
	$accessright													= 0;
	if (! empty($user->admin))										$accessright	= 1;
	if (! empty($user->rights->infraspackplus->paramInfraSPlus))	$accessright	= 1;
	if (! empty($user->rights->infraspackplus->paramBkpRest))		$accessright	= 2;
	if (empty($accessright))										accessforbidden();

	// Actions **************************************
	$form							= new Form($db);
	$formfile						= new FormFile($db);
	$formother						= new FormOther($db);
	$confirm_mesg					= '';
	$action							= GETPOST('action','alpha');
	$confirm						= GETPOST('confirm', 'alpha');
	$urlfile						= GETPOST('urlfile', 'alpha');
	$result							= '';
	//Sauvegarde / Restauration
	if ($action == 'bkupParams')	$result	= infraspackplus_bkup_module ('infraspackplus', 1);
	if ($action == 'restoreParams')	$result	= infraspackplus_restore_module ('infraspackplus');
	if ($action == 'corechange')
	{
		$dolibranch										= explode('.', DOL_VERSION);
		$path											= dol_buildpath('infraspackplus', 0);
		$pathCoreChange									= $dolibranch[0] == 9 && $dolibranch[2] == 4 ? $path.'/corechange-dlb904' : $path.'/corechange-dlb'.$dolibranch[0].'0x';
		if (strtoupper(substr(PHP_OS, 0, 3)) != 'WIN')	$resultChmod	= infraspackplus_chmod_r($pathCoreChange, '0755', '0755', 'www-data', 'www-data');
		else											$resultChmod	= 1;
		if ($resultChmod)
		{
			$resultCopy	= dolCopyDir($pathCoreChange, DOL_DOCUMENT_ROOT, 0, 1);
			if ($resultCopy > 0)
			{
				$currentversion	= infraspackplus_getLocalVersionMinDoli('infraspackplus');
				$validcorechg	= $conf->global->INFRASPLUS_PDF_VALID_CORE_CHGT;
				$validcorechg	= $validcorechg	== 0 ? 1 : $validcorechg;
				$result			= dolibarr_set_const($db, "INFRASPLUS_PDF_VALID_CORE_CHGT",	$validcorechg,		'chaine', 0, '', $conf->entity);
				$result			= dolibarr_set_const($db, "INFRASPLUS_MAIN_VERSION",		$currentversion[0],	'chaine', 0, '', $conf->entity);
			}	// if ($resultCopy > 0)
		}	// if ($resultChmod)
		else	$result	= -1;
	}	// if ($action == 'corechange')
	//Comportement général -> génération automatique, 1 fichier par modèle
	if ($action == 'setautoupd')		$result	= dolibarr_set_const($db, "MAIN_DISABLE_PDF_AUTOUPDATE",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setmultifiles')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_MULTI_FILES",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setprjtimestamp')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROJECT_TIMESTAMP",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setfilesfromPj')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FILES_FROM_PROJECT",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	//Apparence générale -> police, couleur de texte, style des en-têtes et des cadres, fond, symbol monétaire
	if ($action == 'setfont')
	{
		$extension	= pathinfo($_FILES['fontfile']['name'], PATHINFO_EXTENSION);
		if ($extension == 'ttf' || $extension == 'TTF')
		{
			$pathfonts	= dol_buildpath('infraspackplus', 0).'/ttf/';
			$fontfile	= $_FILES['fontfile']['tmp_name'];
			$dest_file	= $_FILES['fontfile']['name'];
			$moved		= dol_move_uploaded_file($fontfile, $pathfonts.$dest_file, 1, 0, $_FILES['fontfile']['error']);
			if ($moved > 0)
			{
				$outpath					= dol_buildpath('infraspackplus', 0).'/tmp/';
				$fontname					= infraspackplus_Add_TCPDF_Font ('TrueTypeUnicode', '', 32, $outpath, 3, 1, true, false, $pathfonts.$dest_file);
				if ($fontname === false)	setEventMessages($langs->trans("InfraSPlusParamAddFontKo", $fontname), null, 'errors');
				else
				{
					if (strtoupper(substr(PHP_OS, 0, 3)) != 'WIN')	$resultChmod	= infraspackplus_chmod_r($outpath, '0755', '0755', 'www-data', 'www-data');
					else											$resultChmod	= 1;
					if ($resultChmod)
					{
						dolCopyDir($outpath, dol_buildpath('infraspackplus', 0).'/fonts', 0, 1);
						dolCopyDir($outpath, TCPDF_PATH.'fonts', 0, 1);
						array_map('unlink', glob($outpath.'*'));
						setEventMessages($langs->trans("InfraSPlusParamAddFontOk", $fontname), null, 'mesgs');
					}	// if ($resultChmod)
					else	setEventMessages($langs->trans("InfraSPlusParamAddTTFKo", $_FILES['fontfile']['name']), null, 'errors');
				}	// else	// if ($fontname === false)
			}	// if ($moved > 0)
		}	// if ($extension == 'ttf')
		else	setEventMessages($langs->trans("InfraSPlusParamAddTTFKo", $_FILES['fontfile']['name']), null, 'errors');
	}	// if ($action == 'setfont')
	if ($action == 'testfont')	$resultTest	= infraspackplus_test_font();
	if ($resultTest == 1)		header("Location: ".DOL_URL_ROOT."/document.php?modulepart=ecm&attachment=0&file=temp/TEST.pdf&entity=".$conf->entity, false);
	$listcolGen					= array('INFRASPLUS_PDF_BODY_TEXT_COLOR');
	$listGen					= array('INFRASPLUS_PDF_ROUNDED_REC', 'INFRASPLUS_PDF_FACTURE_PAID_WATERMARK');
	if ($action == 'updateGen')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FONT",	GETPOST('defaultfont'), 'chaine', 0, '', $conf->entity);
		$error	= 0;
		foreach ($listcolGen as $constname)
		{
			$constvalue	= implode(', ', colorStringToArray(GETPOST($constname, 'alpha')));
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listcolGen as $constname)
		foreach ($listGen as $constname)
		{
			$constvalue	= $constname == 'INFRASPLUS_PDF_ROUNDED_REC' ? (GETPOST($constname, 'alpha') == 0 ? 0.001 : GETPOST($constname, 'alpha')) : GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listGen as $constname)
	}	// if ($action == 'updateGen')
	if ($action == 'setrefdatemerge')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_REFDATE_MERGE",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcursymb')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_CUR_SYMB",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	//Haut de page -> cadres, contenu des en-têtes, adresses, note, pliage, filigrame, dommées additionnelles (douanes)
	$listcolHead						= array('INFRASPLUS_PDF_HEADER_TEXT_COLOR',
												'INFRASPLUS_PDF_FRM_E_LINE_COLOR',	'INFRASPLUS_PDF_FRM_E_BG_COLOR',	'INFRASPLUS_PDF_FRM_E_TEXT_COLOR',
												'INFRASPLUS_PDF_FRM_R_LINE_COLOR',	'INFRASPLUS_PDF_FRM_R_BG_COLOR',	'INFRASPLUS_PDF_FRM_R_TEXT_COLOR');
	$listHead							= array ('INFRASPLUS_PDF_TITLE_SIZE', 	'INFRASPLUS_PDF_FRM_E_LINE_WIDTH',	'INFRASPLUS_PDF_FRM_E_LINE_DASH',
												'INFRASPLUS_PDF_FRM_E_OPACITY',	'INFRASPLUS_PDF_FRM_R_LINE_WIDTH',	'INFRASPLUS_PDF_FRM_R_LINE_DASH',
												'INFRASPLUS_PDF_FRM_R_OPACITY',	'INFRASPLUS_PDF_FOLD_MARK');
	if ($action == 'updateHead')
	{
		$error	= 0;
		foreach ($listcolHead as $constname)
		{
			$constvalue	= implode(', ', colorStringToArray(GETPOST($constname, 'alpha')));
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listcolHead as $constname)
		foreach ($listHead as $constname)
		{
			$constvalue	= GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listHead as $constname)
	}	// if ($action == 'updateHead')
	if ($action == 'setpage1vide')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FIRST_PAGE_EMPTY",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setheader2')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SMALL_HEAD_2",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setheaderleft')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HEADER_ALIGN_LEFT",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcreatorheader')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CREATOR_IN_HEADER",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdatesbr')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_DATES_BR",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdatesbold')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_DATES_BOLD",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdatelinked')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_NO_DATE_LINKED",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setrefproject')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_REF_PROJECT",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdescproject')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_DESC_PROJECT",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcadrerecep')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_RECEP_FRAME",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setfrmdash0')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_0",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setfrmdash0')
	if ($action == 'setfrmdash1')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_1",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputFrmLineDashCleanValue		= 1;
		$inputFrmLineDashplaceholder	= 'W';
	}	// if ($action == 'setfrmdash1')
	if ($action == 'setfrmdash2')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_2",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputFrmLineDashCleanValue		= 1;
		$inputFrmLineDashplaceholder	= 'W,X';
	}	// if ($action == 'setfrmdash2')
	if ($action == 'setfrmdash4')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_4",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_E_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$inputFrmLineDashCleanValue		= 1;
		$inputFrmLineDashplaceholder	= 'W,X,Y,Z';
	}	// if ($action == 'setfrmdash4')
	if ($action == 'setfrmrdash0')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_0",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setfrmrdash0')
	if ($action == 'setfrmrdash1')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_1",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputFrmRLineDashCleanValue	= 1;
		$inputFrmRLineDashplaceholder	= 'W';
	}	// if ($action == 'setfrmrdash1')
	if ($action == 'setfrmrdash2')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_2",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputFrmRLineDashCleanValue	= 1;
		$inputFrmRLineDashplaceholder	= 'W,X';
	}	// if ($action == 'setfrmrdash2')
	if ($action == 'setfrmrdash4')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_4",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_FRM_R_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$inputFrmRLineDashCleanValue	= 1;
		$inputFrmRLineDashplaceholder	= 'W,X,Y,Z';
	}	// if ($action == 'setfrmrdash4')
	if ($action == 'setsenderetstatus')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_STATUS_WITH_SENDER_NAME",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setclientetstatus')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_STATUS_WITH_CLIENT_NAME",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setemetdetails')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_EMET_DETAILS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setrecepdetails')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_RECEP_DETAILS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setadrprod')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_ADR_PROD",					GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setnumcli')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_NUM_CLI",					GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settvaintra')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TVAINTRA_IN_SOURCE_ADDRESS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid1')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROFID1_IN_SOURCE_ADDRESS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid2')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROFID2_IN_SOURCE_ADDRESS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid3')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROFID3_IN_SOURCE_ADDRESS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid4')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROFID4_IN_SOURCE_ADDRESS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid5')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROFID5_IN_SOURCE_ADDRESS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setprjdateonotes')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PRJ_DATEO_IN_NOTE",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsalesrepnotes')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FIRST_SALES_REP_IN_NOTE",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setlastnotetable')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_LAST_NOTE_AS_TABLE",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	//Contenu, colonnage -> Colonnes additionnelles et masquées (référence, tva, remises), taille et position
	$listcolBody						= array('INFRASPLUS_PDF_BACKGROUND_COLOR', 'INFRASPLUS_PDF_TEXT_COLOR', 'INFRASPLUS_PDF_TBL_LINE_COLOR',
												'INFRASPLUS_PDF_HOR_LINE_COLOR', 'INFRASPLUS_PDF_TEXT_SUBTI_COLOR', 'INFRASPLUS_PDF_TEXT_SUBTO_COLOR');
	$listBody							= array('INFRASPLUS_PDF_HEIGHT_TOP_TABLE',	'INFRASPLUS_PDF_TBL_LINE_WIDTH',	'INFRASPLUS_PDF_TBL_LINE_DASH',
												'INFRASPLUS_PDF_LINESEP_HIGHT',
												'INFRASPLUS_PDF_HT_BC',				'INFRASPLUS_PDF_LARG_BC',			'INFRASPLUS_PDF_DIM_C2D',
												'INFRASPLUS_PDF_LARGCOL_REF',		'INFRASPLUS_PDF_LARGCOL_QTY',		'INFRASPLUS_PDF_LARGCOL_UNIT',
												'INFRASPLUS_PDF_LARGCOL_UP',		'INFRASPLUS_PDF_LARGCOL_TVA',		'INFRASPLUS_PDF_LARGCOL_DISC',
												'INFRASPLUS_PDF_LARGCOL_UPD',		'INFRASPLUS_PDF_LARGCOL_PROGRESS',	'INFRASPLUS_PDF_LARGCOL_TOTAL',
												'INFRASPLUS_PDF_LARGCOL_TOTAL_TTC',
												'INFRASPLUS_PDF_NUMCOL_REF',		'INFRASPLUS_PDF_NUMCOL_DESC',		'INFRASPLUS_PDF_NUMCOL_QTY',
												'INFRASPLUS_PDF_NUMCOL_UNIT',		'INFRASPLUS_PDF_NUMCOL_UP',			'INFRASPLUS_PDF_NUMCOL_TVA',
												'INFRASPLUS_PDF_NUMCOL_DISC',		'INFRASPLUS_PDF_NUMCOL_UPD',		'INFRASPLUS_PDF_NUMCOL_PROGRESS',
												'INFRASPLUS_PDF_NUMCOL_TOTAL',		'INFRASPLUS_PDF_NUMCOL_TOTAL_TTC');
	if ($action == 'updateBody')
	{
		$error	= 0;
		foreach ($listcolBody as $constname)
		{
			$constvalue	= implode(', ', colorStringToArray(GETPOST($constname, 'alpha')));
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listcolBody as $constname)
		foreach ($listBody as $constname)
		{
			$constvalue	= GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listBody as $constname)
	}	// if ($action == 'updateBody')
	if ($action == 'settitlebg')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TITLE_BG",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settextcolorauto')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TEXT_COLOR_AUTO",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'sethidetoptable')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_TOP_TABLE",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settbldash0')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_0",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'settbldash0')
	if ($action == 'settbldash1')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_1",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputTblLineDashCleanValue		= 1;
		$inputTblLineDashplaceholder	= 'W';
	}	// if ($action == 'settbldash1')
	if ($action == 'settbldash2')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_2",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputTblLineDashCleanValue		= 1;
		$inputTblLineDashplaceholder	= 'W,X';
	}	// if ($action == 'settbldash2')
	if ($action == 'settbldash4')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_4",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_TBL_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$inputTblLineDashCleanValue		= 1;
		$inputTblLineDashplaceholder	= 'W,X,Y,Z';
	}	// if ($action == 'settbldash4')
	if ($action == 'setrefcol')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_REF_COLUMN",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_REF_COLUMN))
		{
			$result	= dolibarr_set_const($db, "MAIN_GENERATE_DOCUMENTS_HIDE_REF", 1, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_NUM_COLUMN", 0, 'chaine', 0, '', $conf->entity);
		}	// if (! empty($conf->global->INFRASPLUS_PDF_WITH_REF_COLUMN))
	}	// if ($action == 'setrefcol')
	if ($action == 'setblbccol')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_BL_WITH_BC_COLUMN",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setnumcol')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_NUM_COLUMN",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_NUM_COLUMN))	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_REF_COLUMN", 0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setnumcol')
	if ($action == 'setsuprefcol')
	{
		$result																	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_SUPPLIER_REF_COLUMN",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_SUPPLIER_REF_COLUMN))	$result	= dolibarr_set_const($db, "MAIN_GENERATE_DOCUMENTS_HIDE_REF", 1, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setsuprefcol')
	if ($action == 'sethidelabel')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_LABEL",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdescdev')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_DESC_DEV",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "MAIN_GENERATE_DOCUMENTS_HIDE_DESC",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setdescdev')
	if ($action == 'setlabelbold')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_LABEL_BOLD",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setextradet2')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXTRADET_SECOND",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setservdates')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_SERVICE_DATES",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settimespentfi')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_TIME_SPENT_FI",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdateshoursfi')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_DATES_HOURS_FI",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setqty')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_QTY",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setordered')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_ORDERED",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setup')				$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_UP",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdiscount')
	{
		$result														= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_DISCOUNT",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_DISCOUNT))	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_UP_DISCOUNTED",	0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setdiscount')
	if ($action == 'setupdiscounted')
	{
		if (empty($conf->global->INFRASPLUS_PDF_HIDE_DISCOUNT))	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_UP_DISCOUNTED",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		else													setEventMessages($langs->trans("InfraSPlusParamShowUPDiscountedKo"), null, 'warnings');
	}	// if ($action == 'setupdiscounted')
	if ($action == 'setttccolumn')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_TTC_COLUMN",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_TTC_COLUMN))
		{
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TTC_WITH_VAT_TOT",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_TTC",			0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_HT",				0, 'chaine', 0, '', $conf->entity);
		}	// if (! empty($conf->global->INFRASPLUS_PDF_WITH_TTC_COLUMN))
	}	// if ($action == 'setttccolumn')
	if ($action == 'setvatcolumn')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITHOUT_VAT_COLUMN",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_WITHOUT_VAT_COLUMN))
		{
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TTC_WITH_VAT_TOT",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_TTC",			0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_HT",				0, 'chaine', 0, '', $conf->entity);
		}	// if (! empty($conf->global->INFRASPLUS_PDF_WITHOUT_VAT_COLUMN))
	}	// if ($action == 'setvatcolumn')
	if ($action == 'setttctotvat')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TTC_WITH_VAT_TOT",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_TTC_WITH_VAT_TOT))
		{
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_TTC_COLUMN",		0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITHOUT_VAT_COLUMN",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_TTC",			0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_HT",				0, 'chaine', 0, '', $conf->entity);
		}	// if (! empty($conf->global->INFRASPLUS_PDF_TTC_WITH_VAT_TOT))
	}	// if ($action == 'setttctotvat')
	if ($action == 'setvat')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_TTC",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_ONLY_TTC))
		{
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_TTC_COLUMN",		0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITHOUT_VAT_COLUMN",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TTC_WITH_VAT_TOT",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_HT",				0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HT_BY_VAT_P_OR_S",	0, 'chaine', 0, '', $conf->entity);
		}	// if (! empty($conf->global->INFRASPLUS_PDF_ONLY_TTC))
	}	// if ($action == 'setvat')
	if ($action == 'setonlyht')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_HT",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_ONLY_HT))
		{
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_TTC_COLUMN",		0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITHOUT_VAT_COLUMN",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_TTC_WITH_VAT_TOT",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_TTC",			0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HT_BY_VAT_P_OR_S",	0, 'chaine', 0, '', $conf->entity);
		}	// if (! empty($conf->global->INFRASPLUS_PDF_ONLY_HT))
	}	// if ($action == 'setonlyht')
	if ($action == 'sethtbytvapors')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HT_BY_VAT_P_OR_S",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (! empty($conf->global->INFRASPLUS_PDF_HT_BY_VAT_P_OR_S))
		{
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_TTC", 0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_ONLY_HT", 0, 'chaine', 0, '', $conf->entity);
		}	// if (! empty($conf->global->INFRASPLUS_PDF_HT_BY_VAT_P_OR_S))
	}	// if ($action == 'sethtbytvapors')
	if ($action == 'sethidecols')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_COLS",					GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'sethidetotcoldst')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_TOT_COL_DEVST",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setwvcc')			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_WVCC",					GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setwvccproposals')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WVCC_BY_DEF_FOR_PROPOSALS",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setwvccorders')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WVCC_BY_DEF_FOR_ORDERS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setwvccexped')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WVCC_BY_DEF_FOR_EXPEDITION",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setwvccinvoices')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WVCC_BY_DEF_FOR_INVOICES",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	//Pied de document -> encours, total des remises, multi-devises, number-words, zones de signature, mentions complémentaires
	$listcolFoot	= array('INFRASPLUS_PDF_SIGN_LINE_COLOR', 'INFRASPLUS_PDF_CUSTOMER_SIGNING_COLOR');
	$listFoot		= array('INFRASPLUS_PDF_PAY_SPEC', 'INFRASPLUS_PDF_HT_SIGN_AREA', 'INFRASPLUS_PDF_SIGN_LINE_WIDTH',	'INFRASPLUS_PDF_SIGN_LINE_DASH');
	if ($action == 'updateFoot')
	{
		$error		= 0;
		foreach ($listcolFoot as $constname)
		{
			$constvalue	= implode(', ', colorStringToArray(GETPOST($constname, 'alpha')));
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listcolFoot as $constname)
		foreach ($listFoot as $constname)
		{
			$constvalue	= GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listFoot as $constname)
	}	// if ($action == 'updateFoot')
	if ($action == 'setqtyprodtot')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_QTY_PROD_TOT",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settotdisc')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_TOT_DISCOUNT",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setoutstdbill')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_OUTSTDBILL",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settotloccur')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_TOTAL_LOCAL_CUR",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setnumwords' && in_array('numberwords', $conf->modules))
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_NUMBER_WORDS",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	elseif ($action == 'setnumwords')	setEventMessages($langs->trans("InfraSPlusParamErrorNumWords"), null, 'errors');
	if ($action == 'setsigndash0')
	{
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_0",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setsigndash0')
	if ($action == 'setsigndash1')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_1",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputSignLineDashCleanValue	= 1;
		$inputSignLineDashplaceholder	= 'W';
	}	// if ($action == 'setsigndash1')
	if ($action == 'setsigndash2')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_2",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_4",	0, 'chaine', 0, '', $conf->entity);
		$inputSignLineDashCleanValue	= 1;
		$inputSignLineDashplaceholder	= 'W,X';
	}	// if ($action == 'setsigndash2')
	if ($action == 'setsigndash4')
	{
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_4",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_0",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_1",	0, 'chaine', 0, '', $conf->entity);
		$result							= dolibarr_set_const($db, "INFRASPLUS_PDF_SIGN_LINE_DASH_2",	0, 'chaine', 0, '', $conf->entity);
		$inputSignLineDashCleanValue	= 1;
		$inputSignLineDashplaceholder	= 'W,X,Y,Z';
	}	// if ($action == 'setsigndash4')
	if ($action == 'setesigning')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_E_SIGNING",						GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcustomsign')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_GET_CUSTOMER_SIGNING",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignprop')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROPAL_SHOW_SIGNATURE",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignpropst')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_PROPAL_ST_SHOW_SIGNATURE",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsigncom')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_COMMANDE_SHOW_SIGNATURE",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'set2signcomof')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_COMMANDE_OF_SHOW_2_SIGNATURES",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignexp')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXPEDITION_SHOW_SIGNATURE",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignfi')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignfiemet')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE_EMET",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsignfifull')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_INTERVENTION_SIGNATURE_FULL",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	//Pied de page -> Lignes d'informations supplémentaires, n° de page, LCR
	$listFootP	= array('INFRASPLUS_PDF_X_PAGE_NUM', 'INFRASPLUS_PDF_Y_PAGE_NUM');
	if ($action == 'updateFootP')
	{
		$error		= 0;
		foreach ($listFootP as $constname)
		{
			$constvalue	= GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($listFootP as $constname)
	}	// if ($action == 'updateFootP')
	if ($action == 'setfootadress' || $action == 'setfootcontacts' || $action == 'setfootmanager' || $action == 'setfoottypesoc' || $action == 'setfootids' || $action == 'setfootadress2')
	{
		$typefoot		= isset($conf->global->INFRASPLUS_PDF_TYPE_FOOT) ? $conf->global->INFRASPLUS_PDF_TYPE_FOOT : '0000';
		$footAdress		= $action == 'setfootadress'	? GETPOST('value') : ((substr($typefoot, 0, 1) == 1 || substr($typefoot, 0, 1) == 3) ? 1 : 0);	// line 1
		$footContacts	= $action == 'setfootcontacts'	? GETPOST('value') : ((substr($typefoot, 0, 1) == 2 || substr($typefoot, 0, 1) == 3) ? 1 : 0);	// line 2
		$footManager	= $action == 'setfootmanager'	? GETPOST('value') : (substr($typefoot, 1, 1) == 1 ? 1 : 0);									// line 3
		$footTypeSoc	= $action == 'setfoottypesoc'	? GETPOST('value') : ((substr($typefoot, 2, 1) == 1 || substr($typefoot, 2, 1) == 3) ? 1 : 0);	// line 3
		$footIds		= $action == 'setfootids'		? GETPOST('value') : ((substr($typefoot, 2, 1) == 2 || substr($typefoot, 2, 1) == 3) ? 1 : 0);	// line 4
		$footAdress2	= $action == 'setfootadress2'	? GETPOST('value') : (substr($typefoot, 3, 1) == 1 ? 1 : 0);									// line 1bis (2 lines for address)
		$typefoot1		= $footAdress	? ($footContacts	? '3' : '1') : ($footContacts	? '2' : '0');	// 1er digit = 0 (no address nor contact) / 1 (address only) / 2 (contact only) /3 (address and contact)
		$typefoot2		= $footManager	? '1' : '0';	// 2ème digit = 0(no manager) / 1 (manager)
		$typefoot3		= $footTypeSoc	? ($footIds			? '3' : '1') : ($footIds		? '2' : '0');	// 3ème digit = 0 (no type nor IDs) / 1 (type only) / 2 (Ids only) /3 (type and IDs)
		$typefoot4		= $footAdress2	? '1' : '0';	// 4ème digit = 0(1 line for address) / 1 (2 lines for address)
		$typefoot		= $typefoot1.$typefoot2.$typefoot3.$typefoot4;
		$result			= dolibarr_set_const($db, "INFRASPLUS_PDF_TYPE_FOOT",	$typefoot, 'chaine', 0, '', $conf->entity);
	}	// if ($action == 'setfootadress' || $action == 'setfootcontacts' || $action == 'setfootmanager' || $action == 'setfoottypesoc' || $action == 'setfootids' || $action == 'setfootadress2')
	if ($action == 'setfooterbold')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FOOTER_BOLD",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpagenumber')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_HIDE_PAGE_NUM",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setLCR')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_LCR",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	//Conditions générales -> vente, interventions, achats
	if($action == 'addcgv')
	{
		$extension	= pathinfo($_FILES['CGVFile']['name'], PATHINFO_EXTENSION);
		$dest_file	= GETPOST('typeCG', 'alpha').'_'.GETPOST('CGVName', 'alpha').'.'.$extension;
		$moved		= dol_move_uploaded_file($_FILES['CGVFile']['tmp_name'], $conf->mycompany->dir_output.'/'.$dest_file, 1, 0, $_FILES['CGVFile']['error']);
		if ($moved > 0)
		{
			if (strtoupper(substr(PHP_OS, 0, 3)) != 'WIN')	$resultChmod	= infraspackplus_chmod_r($conf->mycompany->dir_output.'/'.$dest_file, '0755', '0755', 'www-data', 'www-data');
			else											$resultChmod	= 1;
			if ($resultChmod)								setEventMessages($dest_file.' : '.$langs->trans("FileSaved"), null, 'mesgs');
		}	// if ($moved > 0)
		else if ($moved !== 1)	// errors
		{
			if ($moved < 0)	setEventMessages('UknownFileUploadError', null, 'errors');	// API documented error
			else			setEventMessages($moved, null, 'errors');	// We got an error string /o\
		}	// else if ($moved !== 1)
	}	// if($action == 'addcgv')
	if ($action == 'delete')	$confirm_mesg	= $form->formconfirm($_SERVER["PHP_SELF"].'?urlfile='.$urlfile, $langs->trans("InfraSPlusParamDeleteAFile"), $langs->trans("InfraSPlusParamConfirmDeleteAFile").' '.$urlfile.' ?', 'delete_ok', '', 1, (int) $conf->use_javascript_ajax);
	if ($action == 'delete_ok' && $confirm == 'yes')
	{
		$urlfile_dirname	= pathinfo($urlfile, PATHINFO_DIRNAME);
		$urlfile_filename	= pathinfo($urlfile, PATHINFO_FILENAME);
		$urlfile_ext		= pathinfo($urlfile, PATHINFO_EXTENSION);
		$a					= dol_delete_file($conf->mycompany->dir_output.$urlfile, 1);
		if ($a)				setEventMessages($urlfile_filename.'.'.$urlfile_ext.' '.$langs->trans("Deleted"), null, 'mesgs');
		else				setEventMessages($langs->trans("ErrorFailToDeleteFile", $urlfile), null, 'errors');
	}	// if ($action == 'delete_ok' && $confirm == 'yes')
	if ($action == 'setcgvfromlang')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGV_FROM_LANG",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcgvproposals')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGV_BY_DEF_FOR_PROPOSALS",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcgvorderss')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGV_BY_DEF_FOR_ORDERS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcgvcontarcts')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGV_BY_DEF_FOR_CONTRACTS",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcgvinvoices')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGV_BY_DEF_FOR_INVOICES",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'defaultCGV')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGV", 						GETPOST('defaultcgvs'), 'chaine', 0, '', $conf->entity);
	if ($action == 'defaultCGI')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGI", 						GETPOST('defaultcgis'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcgaproposals')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGA_BY_DEF_FOR_PROPOSALS",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setcgaorderss')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGA_BY_DEF_FOR_ORDERS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'defaultCGA')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_CGA", 						GETPOST('defaultcgas'), 'chaine', 0, '', $conf->entity);
	//Retour => message Ok ou Ko
	if ($result == 1)	setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	if ($result == -1)	setEventMessages($langs->trans("Error"), null, 'errors');

	// init variables *******************************
	//Sauvegarde / Restauration
	$validcorechg	= $conf->global->INFRASPLUS_PDF_VALID_CORE_CHGT;
	$classcorechg	= $validcorechg	== 2 ? 'button' : 'butActionDelete';
	//Comportement général -> génération automatique, 1 fichier par modèle
	//Apparence générale -> police, couleur de texte, style des en-têtes et des cadres, fond
	$selected_font	= isset($conf->global->INFRASPLUS_PDF_FONT)	? $conf->global->INFRASPLUS_PDF_FONT : 'cambria';
	$dirfonts		= DOL_DOCUMENT_ROOT.'/includes/tecnickcom/tcpdf/fonts/';
	$listfonts		= dol_dir_list($dirfonts, 'files');
	$listfontuse	= array();
	foreach ($listfonts as $font)
	{
		$extension	= pathinfo($font['name'], PATHINFO_EXTENSION);
		if ($extension == 'php')
		{
			$fontname			= pathinfo($font['name'], PATHINFO_FILENAME);
			include_once ($font['fullname']);
			if ($name != '')	$listfontuse[]	= array('name' => $name, 'fontname' => $fontname);
			$name				= '';
		}	// if ($extension == 'php')
	}	// foreach ($listfonts as $font)
	$roundedRect	= $conf->global->INFRASPLUS_PDF_ROUNDED_REC == 0.001 ? 0 : $conf->global->INFRASPLUS_PDF_ROUNDED_REC;
	//Haut de page -> cadres, contenu des en-têtes, adresses, note, pliage, filigrame, dommées additionnelles (douanes)
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_0))	$inputFrmLineDash	= 'size = "1" value = "0" readonly';
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_1))	$inputFrmLineDash	= 'size = "2" value = "'.($inputFrmLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputFrmLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_2))	$inputFrmLineDash	= 'size = "5" value = "'.($inputFrmLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputFrmLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_4))	$inputFrmLineDash	= 'size = "8" value = "'.($inputFrmLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputFrmLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_0))	$inputFrmRLineDash	= 'size = "1" value = "0" readonly';
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_1))	$inputFrmRLineDash	= 'size = "2" value = "'.($inputFrmRLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputFrmRLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_2))	$inputFrmRLineDash	= 'size = "5" value = "'.($inputFrmRLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputFrmRLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_4))	$inputFrmRLineDash	= 'size = "8" value = "'.($inputFrmRLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputFrmRLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	$noCountryCode	= (empty($mysoc->country_code) ? true : false);
	if (! $noCountryCode)
	{
		$pid1				= $langs->transcountry("ProfId1", $mysoc->country_code);
		if ($pid1 == '-')	$pid1	= false;
		$pid2				= $langs->transcountry("ProfId2", $mysoc->country_code);
		if ($pid2 == '-')	$pid2	= false;
		$pid3				= $langs->transcountry("ProfId3", $mysoc->country_code);
		if ($pid3 == '-')	$pid3	= false;
		$pid4				= $langs->transcountry("ProfId4", $mysoc->country_code);
		if ($pid4 == '-')	$pid4	= false;
		$pid5				= $langs->transcountry("ProfId5", $mysoc->country_code);
		if ($pid5 == '-')	$pid5	= false;
	}	// if (! $noCountryCode)
	else
	{
		$pid1	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid2	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid3	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid4	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid5	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
	}	// else // if (! $noCountryCode)
	$rowSpan3	= ! empty($conf->projet->enabled)					? 42	: 41;
	$rowSpan3	+= $conf->global->INFRASPLUS_PDF_SHOW_REF_PROJECT	? 1		: 0;
	//Contenu, colonnage -> Colonnes additionnelles et masquées (référence, tva, remises), taille et position
	if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_0))	$inputTblLineDash	= 'size = "1" value = "0" readonly';
	if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_1))	$inputTblLineDash	= 'size = "2" value = "'.($inputTblLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_TBL_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputTblLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_2))	$inputTblLineDash	= 'size = "5" value = "'.($inputTblLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_TBL_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputTblLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_4))	$inputTblLineDash	= 'size = "8" value = "'.($inputTblLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_TBL_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputTblLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	if ($conf->global->INFRASPLUS_PDF_HIDE_LABEL)	dolibarr_set_const($db, "MAIN_GENERATE_DOCUMENTS_HIDE_DESC", 0, 'chaine', 0, '', $conf->entity);
	dolibarr_set_const($db, "INFRASPLUS_PDF_DIM_C2D", ($conf->global->INFRASPLUS_PDF_DIM_C2D > $conf->global->INFRASPLUS_PDF_LARG_BC ? $conf->global->INFRASPLUS_PDF_LARG_BC : $conf->global->INFRASPLUS_PDF_DIM_C2D), 'chaine', 0, '', $conf->entity);
	if (! $conf->global->MAIN_MODULE_MANAGEMENT)	dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_DATES_HOURS_FI", 0, 'chaine', 0, '', $conf->entity);
	$listselect		= array(array('select' => 'INFRASPLUS_PDF_NUMCOL_REF',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_REF)			? $conf->global->INFRASPLUS_PDF_NUMCOL_REF			: 1),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_DESC',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_DESC)			? $conf->global->INFRASPLUS_PDF_NUMCOL_DESC			: 2),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_QTY',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_QTY)			? $conf->global->INFRASPLUS_PDF_NUMCOL_QTY			: 3),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_UNIT',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_UNIT)			? $conf->global->INFRASPLUS_PDF_NUMCOL_UNIT			: 4),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_UP',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_UP)			? $conf->global->INFRASPLUS_PDF_NUMCOL_UP			: 5),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_TVA',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_TVA)			? $conf->global->INFRASPLUS_PDF_NUMCOL_TVA			: 6),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_DISC',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_DISC)			? $conf->global->INFRASPLUS_PDF_NUMCOL_DISC			: 7),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_UPD',			'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_UPD)			? $conf->global->INFRASPLUS_PDF_NUMCOL_UPD			: 8),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_PROGRESS',		'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_PROGRESS)		? $conf->global->INFRASPLUS_PDF_NUMCOL_PROGRESS		: 9),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_TOTAL',		'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_TOTAL)		? $conf->global->INFRASPLUS_PDF_NUMCOL_TOTAL		: 10),
							array('select' => 'INFRASPLUS_PDF_NUMCOL_TOTAL_TTC',	'value' => isset($conf->global->INFRASPLUS_PDF_NUMCOL_TOTAL_TTC)	? $conf->global->INFRASPLUS_PDF_NUMCOL_TOTAL_TTC	: 11));
	$listcol		= array($langs->transnoentities(! empty($conf->global->INFRASPLUS_PDF_WITH_NUM_COLUMN) ? "PDFInfraSPlusNum" : "PDFInfraSPlusRef"),
							$langs->transnoentities("Designation"),
							$langs->transnoentities("Qty"),
							$langs->transnoentities("Unit"),
							$langs->transnoentities("PriceU"),
							$langs->transnoentities("VAT"),
							$langs->transnoentities("ReductionShort"),
							$langs->transnoentities("PDFInfraSPlusDiscountedPrice"),
							'('.$langs->transnoentities("Situation").')*',
							$langs->transnoentities(! empty($conf->global->INFRASPLUS_PDF_TTC_WITH_VAT_TOT) || ! empty($conf->global->INFRASPLUS_PDF_ONLY_TTC) ? "TotalTTC" : "TotalHT"),
							$langs->transnoentities(! empty($conf->global->INFRASPLUS_PDF_WITH_TTC_COLUMN) ? "TotalTTC" : "-"));
	$listlarg		= array(array('key' => 'INFRASPLUS_PDF_LARGCOL_REF',		'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_REF)			? $conf->global->INFRASPLUS_PDF_LARGCOL_REF			: 28),
							array('key' => 'DESC',								'value' => 0),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_QTY',		'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_QTY)			? $conf->global->INFRASPLUS_PDF_LARGCOL_QTY			: 10),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_UNIT',		'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_UNIT)		? $conf->global->INFRASPLUS_PDF_LARGCOL_UNIT		: 10),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_UP',			'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_UP)			? $conf->global->INFRASPLUS_PDF_LARGCOL_UP			: 22),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_TVA',		'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_TVA)			? $conf->global->INFRASPLUS_PDF_LARGCOL_TVA			: 14),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_DISC',		'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_DISC)		? $conf->global->INFRASPLUS_PDF_LARGCOL_DISC		: 14),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_UPD',		'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_UPD)			? $conf->global->INFRASPLUS_PDF_LARGCOL_UPD			: 22),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_PROGRESS',	'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_PROGRESS)	? $conf->global->INFRASPLUS_PDF_LARGCOL_PROGRESS	: 10),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_TOTAL',		'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_TOTAL)		? $conf->global->INFRASPLUS_PDF_LARGCOL_TOTAL		: 24),
							array('key' => 'INFRASPLUS_PDF_LARGCOL_TOTAL_TTC',	'value' => isset($conf->global->INFRASPLUS_PDF_LARGCOL_TOTAL_TTC)	? $conf->global->INFRASPLUS_PDF_LARGCOL_TOTAL_TTC	: 24));
	$marge_gauche	= isset($conf->global->MAIN_PDF_MARGIN_LEFT)	? $conf->global->MAIN_PDF_MARGIN_LEFT	: 10;
	$marge_droite	= isset($conf->global->MAIN_PDF_MARGIN_RIGHT)	? $conf->global->MAIN_PDF_MARGIN_RIGHT	: 10;
	$largutil		= $marge_gauche + $marge_droite;
	foreach ($listlarg as $largs)
		if ($largs['key'] != 'DESC')	$largutil	+= $largs['value'];
	$formatarray											= pdf_getFormat();
	$larg_desc_progress										= $formatarray['width'] - $largutil;
	$larg_desc												= $larg_desc_progress + $listlarg[8]['value'];
	$listlarg[1]['value']									= $larg_desc.' / ('.$larg_desc_progress.')*';
	$wvccopt												= 0;
	if (empty($conf->global->PRODUCT_DISABLE_SIZE))			$wvccopt++;
	if (empty($conf->global->PRODUCT_DISABLE_LENGTH ))		$wvccopt++;
	if (empty($conf->global->PRODUCT_DISABLE_SURFACE ))		$wvccopt++;
	if (empty($conf->global->PRODUCT_DISABLE_VOLUME ))		$wvccopt++;
	if (empty($conf->global->PRODUCT_DISABLE_CUSTOM_INFO ))	$wvccopt++;
	$rowSpan4												= $conf->global->INFRASPLUS_PDF_HIDE_LABEL		? 40	: 42;
	$rowSpan4												+= $conf->global->MAIN_MODULE_BARCODE			? 4		: 0;
	$rowSpan4												+= $conf->global->INFRASPLUS_PDF_SHOW_WVCC		? 1		: 0;
	$rowSpan4												+= $conf->global->MAIN_MODULE_SUBTOTAL			? 3		: 0;
	$rowSpan4												+= $conf->global->MAIN_MODULE_MILESTONE			? 3		: 0;
	$rowSpan4												+= $conf->global->MAIN_PDF_DASH_BETWEEN_LINES	? 0		: 1;
	//Pied de document -> encours, total des remises, multi-devises, number-words, zones de signature, mentions complémentaires
	if (! in_array('numberwords', $conf->modules))					dolibarr_set_const($db, "INFRASPLUS_PDF_NUMBER_WORDS",	0, 'chaine', 0, '', $conf->entity);
	if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_0))	$inputSignLineDash	= 'size = "1" value = "0" readonly';
	if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_1))	$inputSignLineDash	= 'size = "2" value = "'.($inputSignLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputSignLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_2))	$inputSignLineDash	= 'size = "5" value = "'.($inputSignLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputSignLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_4))	$inputSignLineDash	= 'size = "8" value = "'.($inputSignLineDashCleanValue ? '' : $conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH).'" title = "'.$langs->trans("InfraSPlusParamLineDashTitle").'" required = "required" placeholder = "'.$inputSignLineDashplaceholder.'" pattern = "^(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30),(0?[1-9]|[1-2][0-9]|30)$"';
	$rowSpan5														= $conf->global->INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE_EMET	? 20	: 19;
	$rowSpan5														+= $conf->global->INFRASPLUS_PDF_CUSTOMER_SIGNING_COLOR				? 1		: 0;
	//Pied de page -> Lignes d'informations supplémentaires, n° de page, LCR
	$typefoot		= isset($conf->global->INFRASPLUS_PDF_TYPE_FOOT) ? $conf->global->INFRASPLUS_PDF_TYPE_FOOT : '0000';
	$footAdress		= (substr($typefoot, 0, 1) == 1 || substr($typefoot, 0, 1) == 3) ? 1 : 0;	// line 1
	$footContacts	= (substr($typefoot, 0, 1) == 2 || substr($typefoot, 0, 1) == 3) ? 1 : 0;	// line 2
	$footManager	= substr($typefoot, 1, 1) == 1 ? 1 : 0;										// line 3
	$footTypeSoc	= (substr($typefoot, 2, 1) == 1 || substr($typefoot, 2, 1) == 3) ? 1 : 0;	// line 3
	$footIds		= (substr($typefoot, 2, 1) == 2 || substr($typefoot, 2, 1) == 3) ? 1 : 0;	// line 4
	$footAdress2	= substr($typefoot, 3, 1) == 1 ? 1 : 0;										// line 1bis (2 lines for address)
	//Conditions générales -> vente, interventions, achats
	$CGVs	= infraspackplus_get_CGfiles ('CGV');
	$CGIs	= infraspackplus_get_CGfiles ('CGI');
	$CGAs	= infraspackplus_get_CGfiles ('CGA');
	if ($conf->global->MAIN_MULTILANGS && $conf->global->INFRASPLUS_PDF_CGV_FROM_LANG)
	{
		dolibarr_set_const($db, "INFRASPLUS_PDF_CGV", infraspackplus_get_CGfiles_lang ($CGVs, $conf->global->MAIN_LANG_DEFAULT), 'chaine', 0, '', $conf->entity);
		dolibarr_set_const($db, "INFRASPLUS_PDF_CGI", infraspackplus_get_CGfiles_lang ($CGIs, $conf->global->MAIN_LANG_DEFAULT), 'chaine', 0, '', $conf->entity);
		dolibarr_set_const($db, "INFRASPLUS_PDF_CGA", infraspackplus_get_CGfiles_lang ($CGAs, $conf->global->MAIN_LANG_DEFAULT), 'chaine', 0, '', $conf->entity);
	}	// if ($conf->global->MAIN_MULTILANGS && $conf->global->INFRASPLUS_PDF_CGV_FROM_LANG)
	$selected_cgv	= $conf->global->INFRASPLUS_PDF_CGV;
	$selected_cgi	= $conf->global->INFRASPLUS_PDF_CGI;
	$selected_cga	= $conf->global->INFRASPLUS_PDF_CGA;

	// View *****************************************
	$page_name					= $langs->trans("infrasplussetup")." - ".$langs->trans("InfraSPlusParamsPDF");
	llxHeader('', $page_name);
	echo $confirm_mesg;
	if (! empty($user->admin))	$linkback	= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	else						$linkback	= '';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	$titleoption				= img_picto($langs->trans('Setup'), 'setup', 'style="vertical-align: bottom; height: 20px;"');

	// Configuration header *************************
	$head	= infraspackplus_admin_prepare_head();
	$picto	= 'infraspackplus@infraspackplus';
	dol_fiche_head($head, 'infrasplussetup', $langs->trans("modcomnamePackPlus"), 0, $picto);

	// setup page goes here *************************
	if ($conf->use_javascript_ajax)
	{
		print '	<script type = "text/javascript">
					$(document).ready(function(){
						$(".toggle_bloc").hide();
					});
					$(function (){
						$(".foldable .toggle_bloc_title").click(function(){
							$(".toggle_bloc").hide();
							$(this).siblings().toggle();
						});
					});
				</script>';
	}	// if ($conf->use_javascript_ajax)
	print '	<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
				<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">';
	//Sauvegarde / Restauration
	if ($accessright == 2)
	{
		print '	<table width = "100%" style = "border-spacing: 0px;">
					<colgroup>
						<col width = "*">
						<col width = "90px">
						<col width = "156px">
						<col width = "120px">
					</colgroup>
					<tr>
						<td colspan = "2" align = "center" style = "font-size: 14px;">'.$langs->trans("InfraSPlusParamAction").'</td>
						<td align = "center"><button class = "button" style = "width: 110px; padding: 3px 0px;" type = "submit" value = "bkupParams" name = "action">'.$langs->trans("InfraSPlusParamBkup").'</button></td>
						<td align = "center"><button class = "button" style = "width: 110px; padding: 3px 0px;" type = "submit" value = "restoreParams" name = "action">'.$langs->trans("InfraSPlusParamRestore").'</button></td>
					</tr>';
	}	// if ($accessright == 2)
	if (! empty($user->admin))
	{
		print '		<tr><td colspan = "4" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '		<tr class="oddeven">
						<td colspan = "3" style = "font-size: 14px;">'.$langs->trans("InfraSPlusParamValidCoreChgt").'</td>
						<td align = "center"><button class = "'.$classcorechg.'" style = "width: 110px;" type = "submit" value = "corechange" name = "action">'.$langs->trans("InfraSPlusParamChange").'</button></td>
					</tr>';
		print '		<tr><td colspan = "4" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '		<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
	}	// if (! empty($user->admin))
	if ($accessright == 2)
	{
		print '	</table>';
	}	// if ($accessright == 2)
	//Comportement général -> génération automatique, 1 fichier par modèle
	if (! empty($accessright))
	{
		print '	<div class = "foldable">';
		print load_fiche_titre($langs->trans("InfraSPlusParamTitleComp"), $titleoption, dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
		print '		<table class = "noborder toggle_bloc" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "156px">
							<col width = "120px">
						</colgroup>';
		print '			<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
							<td>&nbsp;</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamAutoUpdate").'</td>';
		if (! empty($conf->global->MAIN_DISABLE_PDF_AUTOUPDATE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setautoupd&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setautoupd&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '				<td>&nbsp;</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamMultiFiles").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_MULTI_FILES))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setmultifiles&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setmultifiles&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '				<td>&nbsp;</td>';
		print '			</tr>';
		if (! empty($conf->global->INFRASPLUS_PDF_MULTI_FILES))
		{
			print '		<tr>
							<td colspan = "4" align="center">'.$langs->trans("InfraSPlusParamMultiFilesText").'</td>
						</tr>';
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamProjectTimeStamp").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_PROJECT_TIMESTAMP))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setprjtimestamp&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setprjtimestamp&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '			<td>&nbsp;</td>';
			print '		</tr>';
		}	// if (! empty($conf->global->INFRASPLUS_PDF_MULTI_FILES))
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFilesFromProject").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_FILES_FROM_PROJECT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfilesfromPj&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfilesfromPj&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '				<td>&nbsp;</td>';
		print '			</tr>';
		print '			<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
		print '		</table>';
		print '	</div>';
	}	// if (! empty($accessright))
	//Apparence générale -> police, couleur de texte, style des en-têtes et des cadres, fond
	if (! empty($accessright))
	{
		print '	<div class = "foldable">';
		print load_fiche_titre($langs->trans("InfraSPlusParamTitleGen"), $titleoption, dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
		print '		<table class = "noborder toggle_bloc" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "156px">
							<col width = "120px">
						</colgroup>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamAddFont").'</td>
							<td colspan = "2" align = "center"><input type = "file" id = "fontfile" name = "fontfile" accept = ".ttf" style = "margin: 0; padding: 0; cursor: pointer;"></td>
							<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "setfont" name = "action">'.$langs->trans("Add").'</button></td>';
		print '			</tr>';
		print '			<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
							<td>&nbsp;</td>
						</tr>';
		print '			<tr>
							<td colspan = "3" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "6" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "updateGen" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamFont").'</td>
							<td align = "center"><button class = "button" style = "width: 110px; padding: 3px 0px;" type = "submit" value = "testfont" name = "action">'.$langs->trans("InfraSPlusParamTestFont").'</button></td>';
		print '				<td align="center">
								<select name = "defaultfont" style = "margin: 0; padding: 0; width: 60%; cursor: pointer;">';
		for ($i = 0; $i < count($listfontuse); $i++)
		{
			print '					<option name = "defaultfont" value = "'.$listfontuse[$i]['fontname'].'"';
			if ($selected_font === $listfontuse[$i]['fontname'])	print ' selected';
			print '					>'.$listfontuse[$i]['name'].'</option>';
		}	// for ($i = 0; $i < count($listfontuse); $i++)
		print '					</select>
							</td>
						</tr>';
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_BODY_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamBodyTextColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_BODY_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_BODY_TEXT_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamRefDateMerge").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_REFDATE_MERGE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefdatemerge&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefdatemerge&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamRoundedRec").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_ROUNDED_REC" name = "INFRASPLUS_PDF_ROUNDED_REC" min = "0" max = "5" value = "'.$roundedRect.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamInvoicePaidMark").'</td>
							<td align="center"><input type = "text" size = "6" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_FACTURE_PAID_WATERMARK" name = "INFRASPLUS_PDF_FACTURE_PAID_WATERMARK" value = "'.$conf->global->INFRASPLUS_PDF_FACTURE_PAID_WATERMARK.'"></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamCurSymb").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_CUR_SYMB))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcursymb&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcursymb&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
		print '		</table>';
		print '	</div>';
	}	// if (! empty($accessright))
	//Haut de page -> cadres, contenu des en-têtes, adresses, note, pliage, filigrame, dommées additionnelles (douanes)
	if (! empty($accessright))
	{
		print '	<div class = "foldable">';
		print load_fiche_titre($langs->trans("InfraSPlusParamTitleHeader"), $titleoption, dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
		print '		<table class = "noborder toggle_bloc" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "156px">
							<col width = "120px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
							<td>&nbsp;</td>
						</tr>';
		print '			<tr>
							<td colspan = "3" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "'.$rowSpan3.'" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "updateHead" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFirstPageEmpty").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_FIRST_PAGE_EMPTY))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpage1vide&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpage1vide&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamSmallHead2").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SMALL_HEAD_2))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setheader2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setheader2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_HEADER_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHeaderTextColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_HEADER_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_HEADER_TEXT_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTitleSize").$langs->trans("InfraSPlusParamFontSize").'</td>
							<td align="center"><input type = "number" size = "2" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_TITLE_SIZE" name = "INFRASPLUS_PDF_TITLE_SIZE" min = "0.1" max = "3" step = "0.1" value = "'.$conf->global->INFRASPLUS_PDF_TITLE_SIZE.'">&nbsp;pt</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHeaderAlignLeft").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HEADER_ALIGN_LEFT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setheaderleft&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setheaderleft&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamCreatorHeader").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_CREATOR_IN_HEADER))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcreatorheader&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcreatorheader&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamDatesBR").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_DATES_BR))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdatesbr&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdatesbr&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamDatesBold").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_DATES_BOLD))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdatesbold&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdatesbold&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamNoDateLinked").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_NO_DATE_LINKED))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdatelinked&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdatelinked&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if (! empty($conf->projet->enabled))
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowRefProject").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_REF_PROJECT))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefproject&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefproject&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_REF_PROJECT))
			{
				print '	<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowDescProject").'</td>';
				if (! empty($conf->global->INFRASPLUS_PDF_SHOW_DESC_PROJECT))
					print '	<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescproject&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '	<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescproject&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
				print '	</tr>';
			}	// if (! empty($conf->global->INFRASPLUS_PDF_SHOW_REF_PROJECT))
		}	// if (! empty($conf->projet->enabled))
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideRecepFrame", $langs->transnoentities("BillFrom"), $langs->transnoentities("BillTo")).'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_RECEP_FRAME))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcadrerecep&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcadrerecep&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmELineW").$langs->trans("InfraSPlusParamLineW").'</td>
							<td align="center"><input type = "number" size = "2" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_FRM_E_LINE_WIDTH" name = "INFRASPLUS_PDF_FRM_E_LINE_WIDTH" min = "0.1" max = "5" step = "0.1" value = "'.$conf->global->INFRASPLUS_PDF_FRM_E_LINE_WIDTH.'">&nbsp;pt</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">
								<table width = "100%">
									<tr>
										<td rowspan = "2" style = "width: 300px; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamFrmELineDash").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash0").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash1").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash2").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash4").'</td>
									</tr>
									<tr>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_0))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash0&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash0&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne continue', 'Dash0.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_1))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash1&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash1&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés égaux', 'Dash1.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_2))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés inégaux', 'Dash2.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_E_LINE_DASH_4))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash4&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmdash4&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne discontinue', 'Dash4.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
									</tr>
								</table>
							</td>
							<td align="center"><input type = "text" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_FRM_E_LINE_DASH" name = "INFRASPLUS_PDF_FRM_E_LINE_DASH" '.$inputFrmLineDash.'></td>
						</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_FRM_E_LINE_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmELineColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_FRM_E_LINE_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_FRM_E_LINE_COLOR').'</td>';
		print '			</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_FRM_E_BG_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmEBgColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_FRM_E_BG_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_FRM_E_BG_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmEOpacity").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_FRM_E_OPACITY" name = "INFRASPLUS_PDF_FRM_E_OPACITY" min = "0" max = "100" value = "'.$conf->global->INFRASPLUS_PDF_FRM_E_OPACITY.'">&nbsp;%
							</td>
						</tr>';
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_FRM_E_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmETextColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_FRM_E_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_FRM_E_TEXT_COLOR').'</td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmRLineW").$langs->trans("InfraSPlusParamLineW").'</td>
							<td align="center"><input type = "number" size = "2" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_FRM_R_LINE_WIDTH" name = "INFRASPLUS_PDF_FRM_R_LINE_WIDTH" min = "0.1" max = "5" step = "0.1" value = "'.$conf->global->INFRASPLUS_PDF_FRM_R_LINE_WIDTH.'">&nbsp;pt</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">
								<table width = "100%">
									<tr>
										<td rowspan = "2" style = "width: 300px; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamFrmRLineDash").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash0").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash1").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash2").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash4").'</td>
									</tr>
									<tr>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_0))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash0&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash0&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne continue', 'Dash0.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_1))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash1&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash1&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés égaux', 'Dash1.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_2))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés inégaux', 'Dash2.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_FRM_R_LINE_DASH_4))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash4&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setfrmrdash4&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne discontinue', 'Dash4.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
									</tr>
								</table>
							</td>
							<td align="center"><input type = "text" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_FRM_R_LINE_DASH" name = "INFRASPLUS_PDF_FRM_R_LINE_DASH" '.$inputFrmRLineDash.'></td>
						</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_FRM_R_LINE_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmRLineColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_FRM_R_LINE_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_FRM_R_LINE_COLOR').'</td>';
		print '			</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_FRM_R_BG_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmRBgColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_FRM_R_BG_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_FRM_R_BG_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmROpacity").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_FRM_R_OPACITY" name = "INFRASPLUS_PDF_FRM_R_OPACITY" min = "0" max = "100" value = "'.$conf->global->INFRASPLUS_PDF_FRM_R_OPACITY.'">&nbsp;%
							</td>
						</tr>';
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_FRM_R_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFrmRTextColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_FRM_R_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_FRM_R_TEXT_COLOR').'</td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamshowStatusWithSenderName").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_STATUS_WITH_SENDER_NAME))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsenderetstatus&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsenderetstatus&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamshowStatusWithClientName").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_STATUS_WITH_CLIENT_NAME))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setclientetstatus&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setclientetstatus&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamshowEmetFDetails").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_EMET_DETAILS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setemetdetails&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setemetdetails&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamshowRecepFDetails").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_RECEP_DETAILS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrecepdetails&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrecepdetails&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if ($conf->global->MAIN_MODULE_PRODUCT)
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamshowAdrProd").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_ADR_PROD))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setadrprod&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setadrprod&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_PRODUCT)
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamshowNumCli").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_NUM_CLI))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumcli&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumcli&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("ShowTvaIntraInSourceAddress").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_TVAINTRA_IN_SOURCE_ADDRESS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settvaintra&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settvaintra&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if ($pid1)
		{
				print '	<tr class = "oddeven">
							<td colspan = "2">'.$langs->trans("ShowProfIdInSourceAddress").' - '.$pid1.'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_PROFID1_IN_SOURCE_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid1&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid1&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($pid1)
		if ($pid2)
		{
				print '	<tr class = "oddeven">
							<td colspan = "2">'.$langs->trans("ShowProfIdInSourceAddress").' - '.$pid2.'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_PROFID2_IN_SOURCE_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($pid2)
		if ($pid3)
		{
				print '	<tr class = "oddeven">
							<td colspan = "2">'.$langs->trans("ShowProfIdInSourceAddress").' - '.$pid3.'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_PROFID3_IN_SOURCE_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid3&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid3&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($pid3)
		if ($pid4)
		{
				print '	<tr class = "oddeven">
							<td colspan = "2">'.$langs->trans("ShowProfIdInSourceAddress").' - '.$pid4.'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_PROFID4_IN_SOURCE_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid4&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid4&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($pid4)
		if ($pid5)
		{
				print '	<tr class = "oddeven">
							<td colspan = "2">'.$langs->trans("ShowProfIdInSourceAddress").' - '.$pid5.'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_PROFID5_IN_SOURCE_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid5&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid5&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($pid5)
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamPrjDateoNote").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_PRJ_DATEO_IN_NOTE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setprjdateonotes&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setprjdateonotes&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParam1SalesRepNote").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_FIRST_SALES_REP_IN_NOTE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsalesrepnotes&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsalesrepnotes&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParam1LastNoteAsTable").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_LAST_NOTE_AS_TABLE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlastnotetable&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlastnotetable&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFoldMark").'</td>
							<td align="center"><input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_FOLD_MARK" name = "INFRASPLUS_PDF_FOLD_MARK" min = "0" max = "10" value = "'.$conf->global->INFRASPLUS_PDF_FOLD_MARK.'">&nbsp;pt</td>
						</tr>';
		print '			<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
		print '		</table>';
		print '	</div>';
	}	// if (! empty($accessright))
	//Contenu, colonnage -> Colonnes additionnelles et masquées (référence, tva, remises), taille et position
	if (! empty($accessright))
	{
		print '	<div class = "foldable">';
		print load_fiche_titre($langs->trans("InfraSPlusParamTitleCorps"), $titleoption, dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
		print '		<table class = "noborder toggle_bloc" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "156px">
							<col width = "120px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
							<td>&nbsp;</td>
						</tr>';
		print '			<tr>
							<td colspan = "3" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "'.$rowSpan4.'" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "updateBody" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_BACKGROUND_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamBackgroundColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_BACKGROUND_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_BACKGROUND_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamtTitleBackground").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_TITLE_BG))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settitlebg&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settitlebg&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTextColorAuto").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_TEXT_COLOR_AUTO))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settextcolorauto&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settextcolorauto&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTextColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_TEXT_COLOR').'</td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHeightTopTable").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_HEIGHT_TOP_TABLE" name = "INFRASPLUS_PDF_HEIGHT_TOP_TABLE" min = "4" max = "20"  step = "0.1" value = "'.$conf->global->INFRASPLUS_PDF_HEIGHT_TOP_TABLE.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamhidetoptable").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_TOP_TABLE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidetoptable&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidetoptable&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTblLineW").$langs->trans("InfraSPlusParamLineW").'</td>
							<td align="center"><input type = "number" size = "2" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_TBL_LINE_WIDTH" name = "INFRASPLUS_PDF_TBL_LINE_WIDTH" min = "0.1" max = "5" step = "0.1" value = "'.$conf->global->INFRASPLUS_PDF_TBL_LINE_WIDTH.'">&nbsp;pt</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">
								<table width = "100%">
									<tr>
										<td rowspan = "2" style = "width: 300px; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamTblLineDash").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash0").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash1").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash2").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash4").'</td>
									</tr>
									<tr>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_0))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash0&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash0&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne continue', 'Dash0.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_1))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash1&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash1&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés égaux', 'Dash1.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_2))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés inégaux', 'Dash2.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH_4))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash4&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=settbldash4&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne discontinue', 'Dash4.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
									</tr>
								</table>
							</td>
							<td align="center"><input type = "text" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_TBL_LINE_DASH" name = "INFRASPLUS_PDF_TBL_LINE_DASH" '.$inputTblLineDash.'></td>
						</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_TBL_LINE_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTblLineColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_TBL_LINE_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_TBL_LINE_COLOR').'</td>';
		print '			</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_HOR_LINE_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHorLineColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_HOR_LINE_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_HOR_LINE_COLOR').'</td>';
		print '			</tr>';
		if (! $conf->global->MAIN_PDF_DASH_BETWEEN_LINES)
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamLineSepHight").'</td>
							<td align="center"><input type = "number" size = "2" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_LINESEP_HIGHT" name = "INFRASPLUS_PDF_LINESEP_HIGHT" min = "1" max = "10" step = "1" value = "'.$conf->global->INFRASPLUS_PDF_LINESEP_HIGHT.'">&nbsp;pt</td>
						</tr>';
		}	// if (! $conf->global->MAIN_PDF_DASH_BETWEEN_LINES)
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		if ($conf->global->MAIN_MODULE_BARCODE)
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHtBC").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_HT_BC" name = "INFRASPLUS_PDF_HT_BC" min = "5" max = "20" step = "1" value = "'.$conf->global->INFRASPLUS_PDF_HT_BC.'">&nbsp;pt
							</td>
						</tr>';
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamLargBC").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_LARG_BC" name = "INFRASPLUS_PDF_LARG_BC" min = "25" max = "45" step = "10" value = "'.$conf->global->INFRASPLUS_PDF_LARG_BC.'">&nbsp;pt
							</td>
						</tr>';
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamDimC2D").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_DIM_C2D" name = "INFRASPLUS_PDF_DIM_C2D" min = "15" max = "40" step = "1" value = "'.$conf->global->INFRASPLUS_PDF_DIM_C2D.'">&nbsp;pt
							</td>
						</tr>';
			print '		<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		}	// if ($conf->global->MAIN_MODULE_BARCODE)
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowRefCol").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_REF_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefcol&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setrefcol&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowBLBCCol").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_BL_WITH_BC_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setblbccol&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setblbccol&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowNumCol").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_NUM_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumcol&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumcol&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowSupRefCol").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_SUPPLIER_REF_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsuprefcol&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsuprefcol&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideLabel").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_LABEL))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidelabel&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidelabel&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if (empty($conf->global->INFRASPLUS_PDF_HIDE_LABEL))
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowDescDev").' '.$langs->trans("GenModif").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_DESC_DEV))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescdev&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescdev&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamLabelBold").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_LABEL_BOLD))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlabelbold&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlabelbold&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if (empty($conf->global->INFRASPLUS_PDF_HIDE_LABEL))
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamExtraDetSecond").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXTRADET_SECOND))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setextradet2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setextradet2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamServiceDates").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_SERVICE_DATES))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setservdates&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setservdates&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTimeSpentFI").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_TIME_SPENT_FI))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settimespentfi&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settimespentfi&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if ($conf->global->MAIN_MODULE_MANAGEMENT)
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamDatesHoursFI").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_DATES_HOURS_FI))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdateshoursfi&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdateshoursfi&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_MANAGEMENT)
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideQty").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_QTY))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setqty&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setqty&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideOrdered").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_ORDERED))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setordered&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setordered&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideUP").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_UP))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setup&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setup&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideDiscount").' '.$langs->trans("GenModif").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_DISCOUNT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdiscount&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdiscount&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowUPDiscounted").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_UP_DISCOUNTED))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setupdiscounted&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setupdiscounted&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowTTCColumn").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_TTC_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setttccolumn&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setttccolumn&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideVATColumn").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_WITHOUT_VAT_COLUMN))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvatcolumn&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvatcolumn&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTTCWithVATTotal").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_TTC_WITH_VAT_TOT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setttctotvat&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setttctotvat&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideAnyVATInformation").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_ONLY_TTC))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvat&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setvat&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowOlnyHT").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_ONLY_HT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setonlyht&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setonlyht&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHTbyTvaPorS").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HT_BY_VAT_P_OR_S))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethtbytvapors&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethtbytvapors&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideCols").' '.$langs->trans("GenModif").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_COLS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidecols&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidecols&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHideTotColDevSt").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_TOT_COL_DEVST))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidetotcoldst&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethidetotcoldst&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class = "oddeven">
							<td colspan = "3">
								<table width = "100%">';
		print '						<tr>
										<td style = "margin: 0; padding: 0; border: none;">
											'.$langs->trans("InfraSPlusParamColNum").'
										</td>';
		foreach ($listselect as $selectvalues)
		{
			$numcol	= num_col($selectvalues, $listselect);
			print '						<td style = "text-align: center; margin: 0; padding: 0; border: none;">
											<select name = "'.$selectvalues['select'].'" style = "margin: 0; padding: 0; border: none; cursor: pointer;';
			if ($numcol['err'] > 0)	print ' background-color: red;">';
			else					print '">';
			print								$numcol['options'].'
											</select>
										</td>';
		}	// foreach ($listselect as $selectvalues)
		print '						</tr>';
		print '						<tr>
										<td style = "margin: 0; padding: 0; border: none;">
											'.$langs->trans("InfraSPlusParamColName").'
										</td>';
		foreach ($listcol as $col)
			print '						<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$col.'</td>';
		print '						</tr>';
		print '						<tr>
										<td style = "margin: 0; padding: 0; border: none;">
											'.$langs->trans("InfraSPlusParamColLarg").'
										</td>';
		foreach ($listlarg as $largs)
		{
			print '						<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
			if ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_PROGRESS')	print '(';
			if ($largs['key'] == 'DESC')	print $largs['value'];
			else
			{
				print '						<input type = "number" size = "2" style = "text-align: center; margin: 0; padding: 0;" dir="rtl" id = "'.$largs['key'].'" name = "'.$largs['key'].'"';
				if ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_REF' && empty($conf->global->INFRASPLUS_PDF_WITH_REF_COLUMN) && empty($conf->global->INFRASPLUS_PDF_WITH_NUM_COLUMN) && empty($conf->global->INFRASPLUS_PDF_WITH_SUPPLIER_REF_COLUMN))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_UNIT' && empty($conf->global->PRODUCT_USE_UNITS))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_QTY' && ! empty($conf->global->INFRASPLUS_PDF_HIDE_QTY))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_UP' && ! empty($conf->global->INFRASPLUS_PDF_HIDE_UP))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_TVA' && (! empty($conf->global->INFRASPLUS_PDF_WITHOUT_VAT_COLUMN) || ! empty($conf->global->INFRASPLUS_PDF_TTC_WITH_VAT_TOT) || ! empty($conf->global->INFRASPLUS_PDF_ONLY_TTC) || ! empty($conf->global->INFRASPLUS_PDF_ONLY_HT)))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_DISC' && ! empty($conf->global->INFRASPLUS_PDF_HIDE_DISCOUNT))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_UPD' && (empty($conf->global->INFRASPLUS_PDF_SHOW_UP_DISCOUNTED) || ! empty($conf->global->INFRASPLUS_PDF_HIDE_DISCOUNT)))
					print '					 min = "0" max = "0" value = "0" readonly>';
				elseif ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_TOTAL_TTC' && empty($conf->global->INFRASPLUS_PDF_WITH_TTC_COLUMN))
					print '					 min = "0" max = "0" value = "0" readonly>';
				else
					print '					 min = "10" max = "40" value = "'.$largs['value'].'">';
			}	// else	// if ($largs['key'] == 'DESC')
			if ($largs['key'] == 'INFRASPLUS_PDF_LARGCOL_PROGRESS')	print ')*';
			print '						</td>';
		}	// foreach ($listlarg as $largs)
		print '						</tr>';
		print '						<tr>
										<td colspan = "12" align = "center">'.$langs->trans('InfraSPlusParamColProgress').'</td>
									</tr>';
		print '					</table>
							</td>
						</tr>';
		if ($wvccopt > 0)
		{
			print '		<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowWVCC").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_WVCC))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setwvcc&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setwvcc&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
			if ($conf->global->INFRASPLUS_PDF_SHOW_WVCC)
			{
				print '	<tr class="oddeven">
							<td colspan ="3">
								<table class = "" width = "100%">
									<colgroup>
										<col width = "*">
										<col width = "230px">
										<col width = "82px">
										<col width = "112px">
										<col width = "162px">
										<col width = "92px">
									</colgroup>
									<tr>
										<td>'.$langs->trans("InfraSPlusParamShowWVCCbyDef").'</td>';
				print '					<td align = "right"> '.$langs->trans('InfraSPlusParamTypeDocCGV').'&nbsp;</td>';
				if ($conf->global->MAIN_MODULE_PROPALE)
				{
					if (! empty($conf->global->INFRASPLUS_PDF_WVCC_BY_DEF_FOR_PROPOSALS))
						print '			<td align="right">'.$langs->trans('Proposals').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccproposals&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
					else
						print '			<td align="right">'.$langs->trans('Proposals').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccproposals&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
				}	// if ($conf->global->MAIN_MODULE_PROPALE)
				else	print '			<td>&nbsp;</td>';
				if ($conf->global->MAIN_MODULE_COMMANDE)
				{
					if (! empty($conf->global->INFRASPLUS_PDF_WVCC_BY_DEF_FOR_ORDERS))
						print '			<td align="right">'.$langs->trans('Orders').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccorders&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
					else
						print '			<td align="right">'.$langs->trans('Orders').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccorders&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
				}	// if ($conf->global->MAIN_MODULE_COMMANDE)
				else	print '			<td>&nbsp;</td>';
				if ($conf->global->MAIN_MODULE_EXPEDITION)
				{
					if (! empty($conf->global->INFRASPLUS_PDF_WVCC_BY_DEF_FOR_EXPEDITION))
						print '			<td align="right">'.$langs->trans('SendingCard').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccexped&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
					else
						print '			<td align="right">'.$langs->trans('SendingCard').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccexped&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
				}	// if ($conf->global->MAIN_MODULE_EXPEDITION)
				else	print '			<td>&nbsp;</td>';
				if ($conf->global->MAIN_MODULE_FACTURE)
				{
					if (! empty($conf->global->INFRASPLUS_PDF_WVCC_BY_DEF_FOR_INVOICES))
						print '			<td align="right">'.$langs->trans('Invoices').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccinvoices&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
					else
						print '			<td align="right">'.$langs->trans('Invoices').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setwvccinvoices&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
				}	// if ($conf->global->MAIN_MODULE_FACTURE)
				else	print '			<td>&nbsp;</td>';
				print '				</tr>';
				print '			</table>';
				print '		</td>';
				print '	</tr>';
			}	// if ($conf->global->INFRASPLUS_PDF_SHOW_WVCC)
		}	// if ($wvccopt > 0)
		if ($conf->global->MAIN_MODULE_SUBTOTAL)
		{
			print '		<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
			$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_TEXT_SUBTI_COLOR));
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTextSubTiColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_TEXT_SUBTI_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_TEXT_SUBTI_COLOR').'</td>';
			print '		</tr>';
			$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_TEXT_SUBTO_COLOR));
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTextSubToColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_TEXT_SUBTO_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_TEXT_SUBTO_COLOR').'</td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_SUBTOTAL)
		if ($conf->global->MAIN_MODULE_MILESTONE)
		{
			print '		<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
			$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_TEXT_SUBTI_COLOR));
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamTextJalonColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_TEXT_SUBTI_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_TEXT_SUBTI_COLOR').'</td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_MILESTONE)
		print '			<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
		print '		</table>';
		print '	</div>';
	}	// if (! empty($accessright))
	//Pied de document -> encours, total des remises, multi-devises, number-words, zones de signature, mentions complémentaires
	if (! empty($accessright))
	{
		print '	<div class = "foldable">';
		print load_fiche_titre($langs->trans("InfraSPlusParamTitleFooter"), $titleoption, dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
		print '		<table class = "noborder toggle_bloc" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "156px">
							<col width = "120px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
							<td>&nbsp;</td>
						</tr>';
		print '			<tr>
							<td colspan = "3" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "'.$rowSpan5.'" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "updateFoot" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowQtyProdTot").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_QTY_PROD_TOT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setqtyprodtot&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setqtyprodtot&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowTotDisc").' '.$langs->trans("GenModif").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_TOT_DISCOUNT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settotdisc&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settotdisc&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowOutStdBill").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_OUTSTDBILL))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoutstdbill&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoutstdbill&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowTotLocCur").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_TOTAL_LOCAL_CUR))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settotloccur&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=settotloccur&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamNumWords").'<a href="'.$langs->trans("InfraSPlusParamNumWordsLink").'" target="_blank">'.$langs->trans("InfraSPlusParamNumWordsLinkText").'</a></td>';
		if (! empty($conf->global->INFRASPLUS_PDF_NUMBER_WORDS))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumwords&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnumwords&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamPaySpec").'</td>
							<td align="center">';
		$form->select_types_paiements($conf->global->INFRASPLUS_PDF_PAY_SPEC, 'INFRASPLUS_PDF_PAY_SPEC', 'CRDT', 0, 1, 1, 20);
		print '				</td>
						</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHtSignArea").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_HT_SIGN_AREA" name = "INFRASPLUS_PDF_HT_SIGN_AREA" min = "8" max = "48" value = "'.$conf->global->INFRASPLUS_PDF_HT_SIGN_AREA.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamSignLineW").$langs->trans("InfraSPlusParamLineW").'</td>
							<td align="center">
								<input type = "number" size = "2" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_SIGN_LINE_WIDTH" name = "INFRASPLUS_PDF_SIGN_LINE_WIDTH" min = "0.1" max = "5" step = "0.1" value = "'.$conf->global->INFRASPLUS_PDF_SIGN_LINE_WIDTH.'">&nbsp;pt
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">
								<table width = "100%">
									<tr>
										<td rowspan = "2" style = "width: 300px; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamSignLineDash").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash0").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash1").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash2").'</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">'.$langs->trans("InfraSPlusParamLineDash4").'</td>
									</tr>
									<tr>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_0))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash0&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash0&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne continue', 'Dash0.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_1))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash1&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash1&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés égaux', 'Dash1.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_2))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Pointillés inégaux', 'Dash2.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
										<td style = "text-align: center; margin: 0; padding: 0; border: none;">';
		if (! empty($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH_4))
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash4&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a>';
		else
			print '							<a href="'.$_SERVER['PHP_SELF'].'?action=setsigndash4&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
		print '								&nbsp;&nbsp;'.img_picto('Ligne discontinue', 'Dash4.png@infraspackplus', 'style = "vertical-align: bottom; height: 20pt;"');
		print '							</td>
									</tr>
								</table>
							</td>
							<td align="center"><input type = "text" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_SIGN_LINE_DASH" name = "INFRASPLUS_PDF_SIGN_LINE_DASH" '.$inputSignLineDash.'></td>
						</tr>';
		$color		= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_SIGN_LINE_COLOR));
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamSignLineColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_SIGN_LINE_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_SIGN_LINE_COLOR').'</td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowESigning").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_E_SIGNING))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setesigning&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setesigning&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamGetCustomerSign").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_GET_CUSTOMER_SIGNING))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcustomsign&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcustomsign&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if ($conf->global->INFRASPLUS_PDF_GET_CUSTOMER_SIGNING)
		{
			$color	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_CUSTOMER_SIGNING_COLOR));
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamCustomerSignColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_CUSTOMER_SIGNING_COLOR).'</td>
							<td align="center">'.$formother->selectColor($color, 'INFRASPLUS_PDF_CUSTOMER_SIGNING_COLOR').'</td>';
			print '		</tr>';
		}	// if ($conf->global->INFRASPLUS_PDF_GET_CUSTOMER_SIGNING)
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowSignature").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_PROPAL_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignprop&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignprop&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowSignatureSt").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_PROPAL_ST_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignpropst&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignpropst&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowSignatureCom").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_COMMANDE_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsigncom&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsigncom&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShow2SignaturesCom").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_COMMANDE_OF_SHOW_2_SIGNATURES))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=set2signcomof&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=set2signcomof&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowSignatureExp").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXPEDITION_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignexp&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignexp&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowSignatureFi").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfi&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfi&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowSignatureFiEmet").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE_EMET))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfiemet&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfiemet&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if (! empty($conf->global->INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE_EMET))
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamSignatureFiFull").'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_INTERVENTION_SIGNATURE_FULL))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfifull&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsignfifull&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if (! empty($conf->global->INFRASPLUS_PDF_INTERVENTION_SHOW_SIGNATURE_EMET))
		print '			<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
		print '		</table>';
		print '	</div>';
	}	// if (! empty($accessright))
	//Pied de page -> Lignes d'informations supplémentaires, n° de page, LCR
	if (! empty($accessright))
	{
		print '	<div class = "foldable">';
		print load_fiche_titre($langs->trans("InfraSPlusParamTitleFooterPage"), $titleoption, dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
		print '		<table class = "noborder toggle_bloc" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "156px">
							<col width = "120px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "2" align = "center">'.$langs->trans('Description').'</td>
							<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
							<td>&nbsp;</td>
						</tr>';
		print '			<tr>
							<td colspan = "3" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "13" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "updateFootP" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFooterAdress").'</td>';
		if (! empty($footAdress))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootadress&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootadress&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if (! empty($footAdress))
		{
			print '		<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFooterAdress2").'</td>';
			if (! empty($footAdress2))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootadress2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootadress2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if (! empty($footAdress))
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFooterContacts").'</td>';
		if (! empty($footContacts))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootcontacts&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootcontacts&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFooterManager").'</td>';
		if (! empty($footManager))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootmanager&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootmanager&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFooterTypeSoc").'</td>';
		if (! empty($footTypeSoc))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfoottypesoc&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfoottypesoc&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFooterIds").'</td>';
		if (! empty($footIds))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootids&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfootids&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamFooterBold").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_FOOTER_BOLD))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfooterbold&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfooterbold&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamHidePageNum").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_HIDE_PAGE_NUM))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpagenumber&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpagenumber&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamPosXPageNum").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_X_PAGE_NUM" name = "INFRASPLUS_PDF_X_PAGE_NUM" min = "10" max = "267" step="0.1" value = "'.$conf->global->INFRASPLUS_PDF_X_PAGE_NUM.'">&nbsp;mm
							</td>
						</tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamPosYPageNum").'</td>
							<td align="center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_Y_PAGE_NUM" name = "INFRASPLUS_PDF_Y_PAGE_NUM" min = "10" max = "285" step="0.1" value = "'.$conf->global->INFRASPLUS_PDF_Y_PAGE_NUM.'">&nbsp;mm
							</td>
						</tr>';
		print '			<tr><td colspan = "3" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamShowLCR").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SHOW_LCR))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setLCR&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setLCR&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
		print '		</table>';
		print '	</div>';
	}	// if (! empty($accessright))
	//Conditions générales -> vente, interventions, achats
	if (! empty($accessright))
	{
		print '	<div class = "foldable">';
		print load_fiche_titre($langs->trans("InfraSPlusParamCGVs"), $titleoption, dol_buildpath('/infraspackplus/img/Tools.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
		print '		<table class = "noborder toggle_bloc" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "90px">
							<col width = "156px">
							<col width = "120px">
						</colgroup>';
		print '			<tr class="oddeven">
							<td colspan ="3">
								<table width = "100%">
								<tr>
										<td>
											'.fieldLabel('InfraSPlusParamCGVFile', 'CGVFile').'
											<input type = "file" id = "CGVFile" name = "CGVFile" accept="*/*" style = "cursor: pointer;">
										</td>
										<td>
											'.fieldLabel($langs->trans("InfraSPlusParamTypeCG"), 'typeCG').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
											<select name = "typeCG" style = "margin: 0; padding: 0; cursor: pointer;">
												<option name = "typeCG" value = "CGV">'.$langs->trans('InfraSPlusParamTypeCGV').'</option>
												<option name = "typeCG" value = "CGI">'.$langs->trans('InfraSPlusParamTypeCGI').'</option>
												<option name = "typeCG" value = "CGA">'.$langs->trans('InfraSPlusParamTypeCGA').'</option>
											</select>
										</td>
										<td align = "right">
											'.fieldLabel('InfraSPlusParamCGVName', 'CGVName').'
											<input type = "text" size = "30" id = "CGVName" name = "CGVName">
										</td>
									</tr>
								</table>
							</td>
							<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "addcgv" name = "action">'.$langs->trans("Add").'</button></td>
						</tr>';
		print '			<tr>
							<td colspan ="4">';
		$CGV_files	= dol_dir_list($conf->mycompany->dir_output, 'files', 0, '',  '', null, null, 1);
		print load_fiche_titre($langs->trans("InfraSPlusParamListCGV"), '', dol_buildpath('/infraspackplus/img/list.png', 1), 1, '', 'NoBCollapse');
		$formfile->list_of_documents($CGV_files, null, 'cgv', '', 1, '', 1, 0, '', 0, 'none');
		print '				</td>
						</tr>';
		if (count($CGVs) > 0 || count($CGIs) > 0 || count($CGAs) > 0)
		{
			if ($conf->global->MAIN_MULTILANGS)
			{
				print '	<tr class="oddeven">
							<td colspan = "2">'.$langs->trans("InfraSPlusParamCGVFromLang").'</td>';
				if (! empty($conf->global->INFRASPLUS_PDF_CGV_FROM_LANG))
					print '	<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcgvfromlang&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '	<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setcgvfromlang&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
				print '		<td>&nbsp;</td>';
				print '	</tr>';
			}	// if ($conf->global->MAIN_MULTILANGS)
			print '		<tr class="oddeven">
							<td colspan ="3">
								<table class = "" width = "100%">
									<colgroup>
										<col width = "*">
										<col width = "180px">
										<col width = "70px">
										<col width = "102px">
										<col width = "82px">
										<col width = "82px">
									</colgroup>
									<tr>
										<td>
											'.fieldLabel($langs->trans("InfraSPlusParamDefaultCGV"), 'defaultcgvs').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
											<select name = "defaultcgvs" style = "margin: 0; padding: 0; cursor: pointer;">
												<option name = "defaultcgvs" value = "">'.$langs->trans('InfraSPlusParamNoCGV').'</option>';
			for ($i = 0; $i < count($CGVs); $i++)
			{
				print '							<option name = "defaultcgvs" value = "'.$CGVs[$i].'"';
				if ($selected_cgv === $CGVs[$i])	print ' selected';
				print '								>'.$CGVs[$i].'</option>';
			}	// for ($i = 0; $i < count($CGVs); $i++)
			print '							</select>
										</td>';
			print '						<td align = "right"> '.$langs->trans('InfraSPlusParamTypeDocCGV').'&nbsp;</td>';
			if ($conf->global->MAIN_MODULE_PROPALE)
			{
				if (! empty($conf->global->INFRASPLUS_PDF_CGV_BY_DEF_FOR_PROPOSALS))
					print '				<td align="center">'.$langs->trans('Proposals').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvproposals&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '				<td align="center">'.$langs->trans('Proposals').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvproposals&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			}	// if ($conf->global->MAIN_MODULE_PROPALE)
			else	print '				<td>&nbsp;</td>';
			if ($conf->global->MAIN_MODULE_COMMANDE)
			{
				if (! empty($conf->global->INFRASPLUS_PDF_CGV_BY_DEF_FOR_ORDERS))
					print '				<td align="center">'.$langs->trans('Orders').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvorderss&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '				<td align="center">'.$langs->trans('Orders').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvorderss&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			}	// if ($conf->global->MAIN_MODULE_COMMANDE)
			else	print '				<td>&nbsp;</td>';
			if ($conf->global->MAIN_MODULE_CONTRAT)
			{
				if (! empty($conf->global->INFRASPLUS_PDF_CGV_BY_DEF_FOR_CONTRACTS))
					print '				<td align="center">'.$langs->trans('Contracts').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvcontarcts&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '				<td align="center">'.$langs->trans('Contracts').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvcontarcts&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			}	// if ($conf->global->MAIN_MODULE_CONTRAT)
			else	print '				<td>&nbsp;</td>';
			if ($conf->global->MAIN_MODULE_FACTURE)
			{
				if (! empty($conf->global->INFRASPLUS_PDF_CGV_BY_DEF_FOR_INVOICES))
					print '				<td align="center">'.$langs->trans('Invoices').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvinvoices&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '				<td align="center">'.$langs->trans('Invoices').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgvinvoices&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			}	// if ($conf->global->MAIN_MODULE_FACTURE)
			else	print '				<td>&nbsp;</td>';
			print '					</tr>';
			print '				</table>';
			print '			</td>';
			print '			<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "defaultCGV" name = "action">'.$langs->trans("Validate").'</button></td>
						</tr>';
			print '		<tr class="oddeven">
							<td colspan ="3">
								<table class = "" width = "100%">
									<colgroup>
										<col width = "*">
										<col width = "180px">
										<col width = "70px">
										<col width = "102px">
										<col width = "82px">
										<col width = "82px">
									</colgroup>
									<tr>
										<td>
											'.fieldLabel($langs->trans("InfraSPlusParamDefaultCGI"), 'defaultcgis').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
											<select name = "defaultcgis" style = "margin: 0; padding: 0; cursor: pointer;">
												<option name = "defaultcgis" value = "">'.$langs->trans('InfraSPlusParamNoCGI').'</option>';
			for ($i = 0; $i < count($CGIs); $i++)
			{
				print '							<option name = "defaultcgis" value = "'.$CGIs[$i].'"';
				if ($selected_cgi === $CGIs[$i])	print ' selected';
				print '								>'.$CGIs[$i].'</option>';
			}	// for ($i = 0; $i < count($CGIs); $i++)
			print '							</select>';
			print '						</td>';
			print '						<td>&nbsp;</td>';
			print '						<td>&nbsp;</td>';
			print '						<td>&nbsp;</td>';
			print '						<td>&nbsp;</td>';
			print '						<td>&nbsp;</td>';
			print '					</tr>';
			print '				</table>';
			print '			</td>';
			print '			<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "defaultCGI" name = "action">'.$langs->trans("Validate").'</button></td>
						</tr>';
			print '		<tr class="oddeven">
							<td colspan ="3">
								<table class = "" width = "100%">
									<colgroup>
										<col width = "*">
										<col width = "180px">
										<col width = "70px">
										<col width = "102px">
										<col width = "82px">
										<col width = "82px">
									</colgroup>
									<tr>
										<td>
											'.fieldLabel($langs->trans("InfraSPlusParamDefaultCGA"), 'defaultcgas').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
											<select name = "defaultcgas" style = "margin: 0; padding: 0; cursor: pointer;">
												<option name = "defaultcgas" value = "">'.$langs->trans('InfraSPlusParamNoCGA').'</option>';
			for ($i = 0; $i < count($CGAs); $i++)
			{
				print '							<option name = "defaultcgas" value = "'.$CGAs[$i].'"';
				if ($selected_cga === $CGAs[$i])	print ' selected';
				print '							>'.$CGAs[$i].'</option>';
			}	// for ($i = 0; $i < count($CGAs); $i++)
			print '							</select>
										</td>';
			print '						<td align = "right"> '.$langs->trans('InfraSPlusParamTypeDocCGV').'&nbsp;</td>';
			if ($conf->global->MAIN_MODULE_SUPPLIERPROPOSAL)
			{
				if (! empty($conf->global->INFRASPLUS_PDF_CGA_BY_DEF_FOR_PROPOSALS))
					print '				<td align="center">'.$langs->trans('Proposals').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgaproposals&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '				<td align="center">'.$langs->trans('Proposals').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgaproposals&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			}	// if ($conf->global->MAIN_MODULE_SUPPLIERPROPOSAL)
			else	print '				<td>&nbsp;</td>';
			if ($conf->global->MAIN_MODULE_FOURNISSEUR)
			{
				if (! empty($conf->global->INFRASPLUS_PDF_CGA_BY_DEF_FOR_ORDERS))
					print '				<td align="center">'.$langs->trans('Orders').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgaorderss&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
				else
					print '				<td align="center">'.$langs->trans('Orders').'&nbsp;&nbsp;<a href="'.$_SERVER['PHP_SELF'].'?action=setcgaorderss&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			}	// if ($conf->global->MAIN_MODULE_FOURNISSEUR)
			else	print '				<td>&nbsp;</td>';
			print '						<td>&nbsp;</td>';
			print '						<td>&nbsp;</td>';
			print '					</tr>';
			print '				</table>';
			print '			</td>';
			print '			<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "defaultCGA" name = "action">'.$langs->trans("Validate").'</button></td>
						</tr>';
		}	// 	if (count($CGVs) > 0 || count($CGIs) > 0 || count($CGAs) > 0)
		print '			<tr><td colspan = "4" style = "line-height: 1px;">&nbsp;</td></tr>';
		print '		</table>';
	}	// if (! empty($accessright))
	print '		</form>';
	dol_fiche_end();
	llxFooter();
	$db->close();
?>
