<?php
	/************************************************
	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspackplus/core/modules/expedition/doc/pdf_InfraSPlus_BLX.modules.php
	* 	\ingroup	InfraS
	* 	\brief		Class file for InfraS PDF expedition
	************************************************/

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/modules/expedition/modules_expedition.php';
	require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
	require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
	dol_include_once('/infraspackplus/core/lib/infraspackplus.pdf.lib.php');

	/************************************************
	*	Class to generate PDF proposal InfraS
	************************************************/
	class pdf_InfraSPlus_BLX extends ModelePdfExpedition
	{
		public $db;
		public $name;
		public $description;
		public $update_main_doc_field;	// Save the name of generated file as the main doc when generating a doc with this template
		public $type;
		public $phpmin	= array(5, 5);
		public $version	= 'dolibarr';
		public $page_largeur;
		public $page_hauteur;
		public $format;
		public $marge_gauche;
		public $marge_droite;
		public $marge_haute;
		public $marge_basse;
		public $emetteur;

		/********************************************
		*	Constructor
		*
		*	@param		DoliDB		$db      Database handler
		********************************************/
		public function __construct($db)
		{
			global $conf, $langs, $mysoc;

			$langs->load('main');
			$langs->load('dict');
			$langs->load('bills');
			$langs->load('products');
			$langs->load('companies');
			$langs->load('propal');
			$langs->load('orders');
			$langs->load('contracts');
			$langs->load('interventions');
			$langs->load('deliveries');
			$langs->load('sendings');
			$langs->load('projects');
			$langs->load("productbatch");
			$langs->load('infraspackplus@infraspackplus');
			
			$this->name									= $langs->trans('PDFInfraSPlusExpeditionXName');
			$this->description							= $langs->trans('PDFInfraSPlusExpeditionXDescription');
			$this->emetteur								= $mysoc;
			if (empty($this->emetteur->country_code))	$this->emetteur->country_code									= substr($langs->defaultlang, -2);
			$this->type									= 'pdf';
			$this->defaulttemplate						= isset($conf->global->EXPEDITION_ADDON_PDF)					? $conf->global->EXPEDITION_ADDON_PDF : '';
			$this->multilangs							= isset($conf->global->MAIN_MULTILANGS)							? $conf->global->MAIN_MULTILANGS : 0;
			$this->use_fpdf								= isset($conf->global->MAIN_USE_FPDF)							? $conf->global->MAIN_USE_FPDF : 0;
			$this->main_umask							= isset($conf->global->MAIN_UMASK)								? $conf->global->MAIN_UMASK : '0755';
			$formatarray								= pdf_InfraSPlus_getFormat();
			$this->page_largeur							= $formatarray['width'];
			$this->page_hauteur							= $formatarray['height'];
			$this->format								= array($this->page_largeur, $this->page_hauteur);
			$this->marge_gauche							= isset($conf->global->MAIN_PDF_MARGIN_LEFT)					? $conf->global->MAIN_PDF_MARGIN_LEFT : 10;
			$this->marge_haute							= isset($conf->global->MAIN_PDF_MARGIN_TOP)						? $conf->global->MAIN_PDF_MARGIN_TOP : 10;
			$this->marge_droite							= isset($conf->global->MAIN_PDF_MARGIN_RIGHT)					? $conf->global->MAIN_PDF_MARGIN_RIGHT : 10;
			$this->marge_basse							= isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)					? $conf->global->MAIN_PDF_MARGIN_BOTTOM : 10;
			$this->formatpage							= array('largeur'=>$this->page_largeur, 'hauteur'=>$this->page_hauteur, 'mgauche'=>$this->marge_gauche, 
																'mdroite'=>$this->marge_droite, 'mhaute'=>$this->marge_haute, 'mbasse'=>$this->marge_basse);
			$this->includealias							= isset($conf->global->PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME)	? $conf->global->PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME : 0;
			$this->multi_files							= isset($conf->global->INFRASPLUS_PDF_MULTI_FILES)				? $conf->global->INFRASPLUS_PDF_MULTI_FILES : 0;
			$this->font									= isset($conf->global->INFRASPLUS_PDF_FONT)						? $conf->global->INFRASPLUS_PDF_FONT : 'Helvetica';
			$this->headertxtcolor						= isset($conf->global->INFRASPLUS_PDF_HEADER_TEXT_COLOR)		? $conf->global->INFRASPLUS_PDF_HEADER_TEXT_COLOR : 0;
			$this->headertxtcolor						= explode(',', $this->headertxtcolor);
			$this->bodytxtcolor							= isset($conf->global->INFRASPLUS_PDF_BODY_TEXT_COLOR)			? $conf->global->INFRASPLUS_PDF_BODY_TEXT_COLOR : 0;
			$this->bodytxtcolor							= explode(',', $this->bodytxtcolor);
			$this->showadrlivr							= isset($conf->global->INFRASPLUS_PDF_SHOW_ADRESSE_RECEPTION)	? $conf->global->INFRASPLUS_PDF_SHOW_ADRESSE_RECEPTION : 0;
			$this->type_foot							= isset($conf->global->INFRASPLUS_PDF_TYPE_FOOT)				? $conf->global->INFRASPLUS_PDF_TYPE_FOOT : '0000';
			$this->hidepagenum							= 1;
			$this->wpicturefoot							= isset($conf->global->INFRASPLUS_PDF_PICTURE_FOOT_WIDTH)		? $conf->global->INFRASPLUS_PDF_PICTURE_FOOT_WIDTH : 188;
			$this->hpicturefoot							= isset($conf->global->INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT)		? $conf->global->INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT : 12;
			$this->maxsizeimgfoot						= array('largeur'=>$this->wpicturefoot, 'hauteur'=>$this->hpicturefoot);
			$this->option_logo							= 0;	// Affiche logo
			$this->option_freetext						= 0;	// Support add of a personalised text
			$this->option_draft_watermark				= 0;	// Support add of a watermark on drafts
		}	// public function __construct($db)

		/********************************************
		*	Function to build pdf onto disk
		*
		*	@param		Object		$object				Object to generate
		*	@param		Translate	$outputlangs		Lang output object
		*	@param		string		$srctemplatepath	Full path of source filename for generator using a template file
		*	@param		int			$hidedetails		Do not show line details (inutilisée ! laissé pour la compatibilité)
		*	@param		int			$hidedesc			Do not show desc
		*	@param		int			$hideref			Do not show ref
		*	@return     int             				1=OK, 0=KO
		********************************************/
		public function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)
		{
			global $user, $langs, $conf, $db, $hookmanager;

			if (! is_object($outputlangs))	$outputlangs					= $langs;			
			$outputlangs->load('main');
			$outputlangs->load('dict');
			$outputlangs->load('bills');
			$outputlangs->load('products');
			$outputlangs->load('companies');
			$outputlangs->load('propal');
			$outputlangs->load('orders');
			$outputlangs->load('contracts');
			$outputlangs->load('interventions');
			$outputlangs->load('deliveries');
			$outputlangs->load('sendings');
			$outputlangs->load('projects');
			$outputlangs->load("productbatch");
			$outputlangs->load('infraspackplus@infraspackplus');

			// For backward compatibility with FPDF, force output charset to ISO, because FPDF expect text to be encoded in ISO
			if (! empty($this->use_fpdf)) $outputlangs->charset_output	= 'ISO-8859-1';
			$filesufixe						= ! $this->multi_files || ($this->defaulttemplate && $this->defaulttemplate == 'InfraSPlus_BLX') ? '' : '_BLX';

			if ($conf->expedition->dir_output)
			{
				// Definition of $dir and $file
				if ($object->specimen)
				{
					$dir	= $conf->expedition->dir_output.'/sending';
					$file	= $dir.'/SPECIMEN.pdf';
				}	// if ($object->specimen)
				else
				{
					$objectref	= dol_sanitizeFileName($object->ref);
					$dir		= $conf->expedition->dir_output.'/sending/'.$objectref;
					$file		= $dir.'/'.$objectref.$filesufixe.'.pdf';
				}	// else	// if ($object->specimen)
				if (! file_exists($dir))
				{
					if (dol_mkdir($dir) < 0)
					{
						$this->error=$langs->transnoentities("ErrorCanNotCreateDir", $dir);
						return 0;
					}	// if (dol_mkdir($dir) < 0)
				}	// if (! file_exists($dir))
				if (file_exists($dir))
				{
					if (! is_object($hookmanager))	// Add pdfgeneration hook
					{
						include_once DOL_DOCUMENT_ROOT.'/core/class/hookmanager.class.php';
						$hookmanager	= new HookManager($db);
					}	// if (! is_object($hookmanager))
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters			= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook			= $hookmanager->executeHooks('beforePDFCreation', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
	//				$this->logo			= $hookmanager->resArray['logo'];
	//				$this->adrlivr		= $hookmanager->resArray['adrlivr'];
					$this->pied			= $hookmanager->resArray['pied'];
					$nblignes			= count($object->lines);	// Set nblignes with the new facture lines content after hook
					// Create pdf instance
					$pdf				= pdf_getInstance($this->format, 'mm', 'P');
					$default_font_size	= pdf_getPDFFontSize($outputlangs);	// Must be after pdf_getInstance
					$pdf->SetAutoPageBreak(1, 0);
					if (class_exists('TCPDF'))
					{
						$pdf->setPrintHeader(false);
						$pdf->setPrintFooter(false);
					}	// if (class_exists('TCPDF'))
					$pdf->SetFont($this->font);
					// reduce the top margin before ol / il tag
					$tagvs				= array('p' => array(1 => array('h' => 0.0001, 'n' => 1)), 'ul' => array(0 => array('h' => 0.0001, 'n' => 1)));
					$pdf->setHtmlVSpace($tagvs);
					$pdf->Open();
					$pdf->SetTitle($outputlangs->convToOutputCharset($object->ref).$filesufixe);
					$pdf->SetSubject($outputlangs->transnoentities("Shipment"));
					$pdf->SetCreator("Dolibarr ".DOL_VERSION);
					$pdf->SetAuthor($outputlangs->convToOutputCharset($user->getFullName($outputlangs)));
					$pdf->SetKeyWords($outputlangs->convToOutputCharset($object->ref)." ".$outputlangs->transnoentities("Shipment"));
					$pdf->SetMargins($this->marge_gauche, $this->marge_haute, $this->marge_droite);   // Left, Top, Right
					// Default PDF parameters
					$this->stdLineW		= 0.2; // épaisseur par défaut dans TCPDF = 0.2
					$this->stdLineDash	= '0';	// 0 = continue ; w = discontinue espace et tiret identiques ; w,x = tiret,espace ; w,x,y,z = tiret long,espace,tiret court,espace
					$this->stdLineCap	= 'butt';	// fin de trait : butt = rectangle/lg->Dash ; round = rond/lg->Dash + width : square = rectangle/lg->Dash + width
					$this->stdLineColor	= array(128, 128, 128);
					$this->stdLineStyle	= array('width'=>$this->stdLineW, 'dash'=>$this->stdLineDash, 'cap'=>$this->stdLineCap, 'color'=>$this->stdLineColor);
					// Define width and position of main table columns
					$this->heightline	= 4;
					// test template
					$template			= $dir.'/pdf_InfraSPlus_BLX.pdf';
					$isTemplate			= false;
					if (file_exists($template) && is_readable($template))
					{
						$finfo	= finfo_open(FILEINFO_MIME_TYPE);
						if (finfo_file($finfo, $template) == 'application/pdf')
						{
							try
							{
								$isTemplate		= true;
								$nbPtemplate	= $pdf->setSourceFile($template);
								for ($i = 1; $i <= $nbPtemplate; $i ++)
								{
									$tplIdx	= $pdf->importPage($i);
									if ($tplIdx === false)
									{
										$isTemplate	= false;
										setEventMessages(null, array($outputlangs->trans("PDFInfraSPlusPdfFileError1", $template)), 'warnings');
									}	// if ($tplIdx!==false)
								}	// for ($i = 1; $i <= $nbPtemplate; $i ++)
							}	// try
							catch (exception $e)
							{
								setEventMessages(null, array($outputlangs->trans("PDFInfraSPlusPdfFileError1", $template).$outputlangs->trans("PDFInfraSPlusPdfFileError2", $e->getMessage())), 'warnings');
							}	// try	// catch (exception $e)
						}	// if (finfo_file($finfo, $template) == 'application/pdf')
					}	// if (file_exists($template) && is_readable($template))
					// Template Ok we use it
					if ($isTemplate)
					{
						$sql_adrlivr		= 'SELECT DISTINCT sa.name, sa.address, sa.zip, sa.town, sa.fk_soc';
						$sql_adrlivr		.= ' FROM '.MAIN_DB_PREFIX.'societe_address AS sa';
						$sql_adrlivr		.= ' INNER JOIN '.MAIN_DB_PREFIX.'societe AS s';
						$sql_adrlivr		.= ' ON sa.fk_soc = s.rowid';
						$sql_adrlivr		.= ' WHERE s.nom = "'.$object->thirdparty->name.'"';
						$resultat_adrlivr	= $db->query($sql_adrlivr);
						if ($resultat_adrlivr)
						{
							// shipping address
							$obj_adrlivr	= array();
							$nbAdrLivr		= $db->num_rows($resultat_adrlivr);
							// linked orders and invoices
							$object->fetchObjectLinked();
							foreach($object->linkedObjects as $objecttype => $objects)
							{
								if ($objecttype == 'commande')
								{
									foreach($objects as $elementobject)
									{
										$dateOrderLinked	= dol_print_date($elementobject->date, 'day', '', $outputlangs);
										$elementobject->fetchObjectLinked();
										foreach($elementobject->linkedObjects as $elementobjecttype => $elementobjects)
										{
											if ($elementobjecttype == 'propal')
												foreach($elementobjects as $elementelementobject)	$datePropalLinked	= dol_print_date($elementelementobject->date, 'day', '', $outputlangs);
											if ($elementobjecttype == 'facture')
											{
												foreach($elementobjects as $elementelementobject)
												{
													$dateFactureLinked	= dol_print_date($elementelementobject->date, 'day', '', $outputlangs);
													$refFactureLinked	= $outputlangs->transnoentities($elementelementobject->ref);
												}	// foreach($elementobjects as $elementelementobject)
											}	// if (($elementobjecttype == 'facture')
										}	// foreach($elementobject->linkedObjects as $elementobjecttype => $elementobjects)
									}	// foreach($objects as $elementobject)
								}	// if (($objecttype == 'commande')
							}	// foreach($object->linkedObjects as $objecttype => $objects)
							$origin			= $object->origin;
							$arrayidcontact	= $object->$origin->getIdContact('external', 'SHIPPING');
							if (is_array($arrayidcontact) && count($arrayidcontact) > 0)
							{
								$result		= $object->fetch_contact($arrayidcontact[0]);
								$contact	= $outputlangs->convToOutputCharset($object->contact->getFullName($outputlangs, 1, -1));
							}	// if (is_array($arrayidcontact) && count($arrayidcontact) > 0)
							for ($i = 0; $i < $nbAdrLivr; $i++)
							{
								$obj_adrlivr	= $db->fetch_object($resultat_adrlivr);
								// loop on line to add a complete document for each product
								for ($j = 0 ; $j < $nblignes ; $j++)
								{
									$ref			= pdf_getlineref($object, $j, $outputlangs, $hidedetails);
									$pageposbefore	= $pdf->getPage();
									for ($k = 1; $k <= $nbPtemplate; $k ++)
									{
										$tplIdx			= $pdf->importPage($k);
										if ($tplIdx !== false)
										{
											$templateSize		= $pdf->getTemplatesize($tplIdx);
											$pdf->AddPage($templateSize['h'] > $templateSize['w'] ? 'P' : 'L', array($templateSize['w'], $templateSize['h']));
											$pdf->useTemplate($tplIdx);
											// Default PDF parameters
											$pdf->MultiCell(0, 3, '');		// Set interline to 3
											$pdf->SetTextColor($this->headertxtcolor[0], $this->headertxtcolor[1], $this->headertxtcolor[2]);
											$pdf->SetFont('', '', $default_font_size);
											$pdf->SetDrawColor(0, 0, 0);
											if ($pdf->getPage() == ($pageposbefore + 1))	// first page of the template
											{
												$pdf->MultiCell(0, $this->heightline, $datePropalLinked, 0, 'L', 0, 1, 126, 60.5, true, 0, 0, false, 0, 'M', false);	// propal date
												$pdf->MultiCell(0, $this->heightline, $dateFactureLinked, 0, 'L', 0, 1, 124, 68.5, true, 0, 0, false, 0, 'M', false);	// invoice date
												$pdf->MultiCell(0, $this->heightline, $refFactureLinked, 0, 'L', 0, 1, 54.5, 76.4, true, 0, 0, false, 0, 'M', false);	// invoice ref
												$pdf->MultiCell(0, $this->heightline, $obj_adrlivr->name, 0, 'L', 0, 1, 94.5, 84.3, true, 0, 0, false, 0, 'M', false);	// site name
												$pdf->MultiCell(0, $this->heightline, $obj_adrlivr->address, 0, 'L', 0, 1, 53, 92.5, true, 0, 0, false, 0, 'M', false);	// address
												$pdf->MultiCell(0, $this->heightline, $obj_adrlivr->zip, 0, 'L', 0, 1, 35.6, 104.9, true, 0, 0, false, 0, 'M', false);	// zip
												$pdf->MultiCell(0, $this->heightline, $obj_adrlivr->town, 0, 'L', 0, 1, 23, 113.1, true, 0, 0, false, 0, 'M', false);	// town
												$pdf->MultiCell(0, $this->heightline, $object->lines[$j]->qty_shipped / $nbAdrLivr, 0, 'L', 0, 1, 70.9, 133.5, true, 0, 0, false, 0, 'M', false);	// product Qty
												pdf_InfraSPlus_writelinedesc($pdf, $object, $j, $outputlangs, 0, $this->heightline, 40, 146, 1, 1, 0, '');	// Product label
												$pdf->MultiCell(0, $this->heightline, $ref, 0, 'L', 0, 1, 33, 184.3, true, 0, 0, false, 0, 'M', false);	// product Ref												
											}	// if ($pdf->getPage() == ($pageposbefore + 1))
											elseif ($pdf->getPage() == ($pageposbefore + 2))	// second page of the template
											{
												$pdf->MultiCell(0, $this->heightline, $contact, 0, 'L', 0, 1, 45, 15, true, 0, 0, false, 0, 'M', false);	// Custommer contact name
												$txtCustName	= $outputlangs->convToOutputCharset($object->thirdparty->name);
												$pdf->MultiCell(0, $this->heightline, $txtCustName, 0, 'L', 0, 1, 62.5, 31.1, true, 0, 0, false, 0, 'M', false);	// Custommer Social name
												$profID			= $outputlangs->convToOutputCharset($object->thirdparty->idprof1);
												if (dol_strlen($profID) == 9)	$profID	= substr($profID, 0, 3).' '.substr($profID, 3, 3).' '.substr($profID, 6, 3);
												$pdf->MultiCell(0, $this->heightline, $profID, 0, 'L', 0, 1, 62.5, 39.1, true, 0, 0, false, 0, 'M', false);	// Custommer ID1
												$pdf->MultiCell(0, $this->heightline, $object->thirdparty->address, 0, 'L', 0, 1, 53.5, 72.7, true, 0, 0, false, 0, 'M', false);	// Custommer address
												$pdf->MultiCell(0, $this->heightline, $object->thirdparty->zip, 0, 'L', 0, 1, 36, 85.1, true, 0, 0, false, 0, 'M', false);	// Custommer zip
												$pdf->MultiCell(0, $this->heightline, $object->thirdparty->town, 0, 'L', 0, 1, 23, 93.1, true, 0, 0, false, 0, 'M', false);	// Custommer town
												$txtPhone		= $outputlangs->convToOutputCharset(dol_string_nohtmltag(dol_print_phone($object->thirdparty->phone)));
												$pdf->MultiCell(0, $this->heightline, $txtPhone, 0, 'L', 0, 1, 33, 105.5, true, 0, 0, false, 0, 'M', false);	// Custommer phone
												$txtEmail		= $outputlangs->convToOutputCharset($object->thirdparty->email);
												$pdf->MultiCell(0, $this->heightline, $txtEmail, 0, 'L', 0, 1, 28.5, 114.3, true, 0, 0, false, 0, 'M', false);	// Custommer email
											}	// elseif ($pdf->getPage() == ($pageposbefore + 2))
											elseif ($pdf->getPage() == ($pageposbefore + 3))	// third page of the template
											{
												$txtCustName	= $outputlangs->convToOutputCharset($this->emetteur->name);
												$pdf->MultiCell(0, $this->heightline, $txtCustName, 0, 'L', 0, 1, 38.5, 24, true, 0, 0, false, 0, 'M', false);	// My Social name
												$profID			= $outputlangs->convToOutputCharset($this->emetteur->idprof2);
												$pdf->MultiCell(0, $this->heightline, $profID, 0, 'L', 0, 1, 37.5, 28.5, true, 0, 0, false, 0, 'M', false);	// My ID2
												$txtAddr		= dolGetFirstLineOfText($this->emetteur->address);
												$pdf->MultiCell(0, $this->heightline, $txtAddr, 0, 'L', 0, 1, 29, 33, true, 0, 0, false, 0, 'M', false);	// My address
												$pdf->MultiCell(0, $this->heightline, $this->emetteur->zip, 0, 'L', 0, 1, 35.8, 37.5, true, 0, 0, false, 0, 'M', false);	// My zip
												$pdf->MultiCell(0, $this->heightline, $this->emetteur->town, 0, 'L', 0, 1, 23, 41.9, true, 0, 0, false, 0, 'M', false);	// My town
												$txtPhone		= $outputlangs->convToOutputCharset(dol_string_nohtmltag(dol_print_phone($this->emetteur->phone)));
												$pdf->MultiCell(0, $this->heightline, $txtPhone, 0, 'L', 0, 1, 33, 50.8, true, 0, 0, false, 0, 'M', false);	// My phone
												$txtEmail		= $outputlangs->convToOutputCharset($this->emetteur->email);
												$pdf->MultiCell(0, $this->heightline, $txtEmail, 0, 'L', 0, 1, 28.5, 59.7, true, 0, 0, false, 0, 'M', false);	// My email
											}	// elseif ($pdf->getPage() == ($pageposbefore + 3))
											$this->_pagefoot($pdf, $object, $outputlangs, 0);
										}	// if ($tplIdx!==false)
										else	setEventMessages(null, array($outputlangs->trans("PDFInfraSPlusPdfFileError1", $template)), 'warnings');
									}	// for ($k = 1; $k <= $nbPtemplate; $k ++)
								}	// for ($j = 0 ; $j < $nblignes ; $j++)
							}	// for ($i = 0; $i < $nbAdrLivr; $i++)
						}	// if ($resultat_adrlivr)
					}	// if ($isTemplate)
					$pdf->Close();
					$pdf->Output($file, 'F');
					// Add pdfgeneration hook
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters						= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook=$hookmanager->executeHooks('afterPDFCreation',$parameters,$this,$action);    // Note that $action and $object may have been modified by some hooks
					if (! empty($this->main_umask))	@chmod($file, octdec($this->main_umask));
					$this->result					= array('fullpath' => $file);
					return 1;   // Pas d'erreur
				}	// if (file_exists($dir))
				else
				{
					$this->error=$langs->trans("ErrorCanNotCreateDir",$dir);
					return 0;
				}	// else	// if (file_exists($dir))
			}	// if ($conf->expedition->dir_output)
			else
			{
				$this->error=$langs->trans("ErrorConstantNotDefined","EXP_OUTPUTDIR");
				return 0;
			}	// else	// if ($conf->expedition->dir_output)
		}	// public function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)
		/********************************************
		*	Show footer of page. Need this->emetteur object
		*
		*	@param		PDF			$pdf     		The PDF factory
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		Societe		$fromcompany	Object company
		*	@param		int			$marge_basse	Margin bottom we use for the autobreak
		*	@param		int			$marge_gauche	Margin left
		*	@param		int			$page_hauteur	Page height
		*	@param		Object		$object			Object shown in PDF
		*	@param		int			$showdetails	Show company details into footer
		*	@param		int			$hidesupline	Completly hide the line up to footer (for some edition with only table)
		*	@param		int			$calculseul		Arrête la fonction au calcul de hauteur nécessaire
		*	@return		int							Return height of bottom margin including footer text
		********************************************/
		protected function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
		{
			global $conf;
			
			$showdetails				= $this->type_foot;
			if (! empty($this->pied))	$showdetails	.= 1;
			else						$showdetails	.= 0;
			return pdf_InfraSPlus_pagefoot($pdf, $outputlangs, $this->emetteur, $this->formatpage, $showdetails, 0, $calculseul, $this->pied, $this->maxsizeimgfoot, $this->hidepagenum, $this->bodytxtcolor, $this->stdLineStyle);
		}	// protected function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)

	}	// class pdf_InfraSPlus_BLX extends ModelePdfExpedition
?>