<?php
/* Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/**
  Support class for other driver message
 */
Class DMessage {

    /**
      @var int
     */
    protected $id = 0;

    /**
      @var int
     */
    protected $uid = 0;

    /**
      @var string
     */
    protected $charset = '';

    /**
      @var string
     */
    protected $htmlmsg = '';

    /**
      @var
     */
    protected $plainmsg = '';

    /**
      @var
     */
    protected $attachments = array();

    /**
      @var object
     */
    protected $header;
	public $from; 
	protected $to; 
	protected $subject; 
	protected $size; 
	protected $sizeunit; 

	protected $recent; 
	protected $answered; 
	protected $flagged; 
	protected $deleted; 
	protected $unseen; 
	
	
	protected $linkedObject; 
    /**
      @var from
     */
//     protected $from_name;

    /**
      @var from
     */
//     protected $from_mail;

    /**
      @var date current local display
     */
    protected $date;

    /**
      @brief
     */
    public function GetHeader() {
        return $this->header;
    }

    /**
      @brief
     */
    public function GetId() {
        return $this->id;
    }
    /**
      @brief
     */
    public function SetId($id) {
        $this->id=$id;
    }
    /**
      @brief
     */
    public function SetUid($uid) {
        $this->uid = $uid; 
    }
    
    /**
      @brief
     */
    public function GetUid() {
        return $this->uid;
    }

	/**
      @brief
	*/
    public function SetLinked( $obj ) {
        return $this->linkedObject = $obj; ;
    }
    
	/**
      @brief
	*/
    public function GetLinked() {
        return (array)$this->linkedObject;
    }
    
    /**
      @brief
     */
    public function GetAnswered() {
        return $this->answered;
    }
    
    /**
      @brief
     */
    public function GetUnseen() {
        return $this->unseen;
    }
    /**
      @brief
     */
    public function GetFlagged() {
        return $this->flagged;
    }
    /**
      @brief
     */
    public function GetDeleted() {
        return $this->deleted;
    }
    
    /**
      @brief
     */
//     public function GetDate() {
//             return $this->header->date;
//     }

	/**
	*/
	public function SetSubject($_subject){
		return $this->subject = $_subject;// ;
	}
	
	/**
	*/
	public function GetSubject(){
		return $this->subject;
	}
	
	public function SetContent( $html, $plain){
	  $this->htmlmsg = $html; 
	  $this->plainmsg = $plain; 
	}
	/**
	  @param $_type string from, to, reply
	  @param $_string "dlfldflk"<lsklsdk@lskdlk.lan>
	*/
	public function SetRecipient($_type='from', $_string){
		$this->$_type = new StructureContactListener($_string); 
	}
	
	/**
	*/
	public function GetFromName(){
		return $this->from->name;
	}

	/**
	*/
	public function GetFromMail(){
		return $this->from->email;
	}

	/**
	*/
	public function GetFrom($modeEntity= TRUE){
    if ($this->from->name != '') {
            if ($modeEntity) {
                return $this->from->name.' &lt;'.$this->from->email.'&gt;';
            } else {
                return $this->from->name.' <'.$this->from->email.'>';
            }
        } else {
            return $this->from->email;
        }
    }
	
	/**
	*/
	public function GetToName(){
		return $this->to->name;
	}
	
	/**
	*/
	public function GetToMail(){
		return $this->to->email;
	}
	
	/**
	*/
	public function SetDate($_date){
	  $this->date = $_date; 
	}
	
	/**
	*/
	public function GetDate($short=false){
        $time = strtotime($this->date);
		if($short){
			if (date('d/m/Y')==date("d/m/Y", $time)){  /* only hours if day is the same */
					$shortDate= dol_print_date($time,'hourduration');
			} elseif(date('Y')!=date("Y", $time)) {    /* if not this year*/
					$shortDate= dol_print_date($time,'daytextshort');
			} else {                                                    /* if year is implicite */
					$shortDate= dol_print_date($time,'daytextshort');
                    $shortDate= str_replace(' '.date('Y'), '', $shortDate);
                    $shortDate= str_replace(date('Y').' ', '', $shortDate);
			}
			return $shortDate; 
		}
		
		
			return $this->date;
		
	}
	
	/**
	*/
	public function GetSize($unit=true){
		return number_format($this->size,0,',',' ' ) . (($unit)? $this->sizeunit : '');
	}

	public function SetCharset($_charset){
	  $this->charset =  $_charset; 
	}
    /**
      @brief
     */
    public function GetCharset() {
        return $this->charset;
    }

    /**
      @brief
     */
    public function GetHtmlMsg() {
        //return str_replace(array('=3D"',"=\r","=\n",'=09'), array('="','','',''),html_entity_decode($this->htmlmsg));
        return quoted_printable_decode($this->htmlmsg);
    }

    /**
      @brief
     */
    public function GetPlainMsg() {
        return $this->plainmsg;
    }

    /**
      @brief
     */
    public function GetDefaultMsg()
    {
        if (isset($this->htmlmsg) && strlen($this->htmlmsg) > 0) {
            return $this->GetHtmlMsg();
        } else {
            return nl2br($this->GetPlainMsg());
        }
    }

    /**
      @brief
     */
    public function SetAttach($attach = array()) {
        return $this->attachments = $attach;
    }

    /**
      @brief
     */
    public function GetAttach() {
        return $this->attachments;
    }
    
    
    
    
	/**
		*    	Return a link on thirdparty (with picto)
		*
		*		@param	int		$withpicto		Add picto into link (0=No picto, 1=Include picto with link, 2=Picto only)
		*		@param	string	$option			Target of link ('', 'customer', 'prospect', 'supplier')
		*		@param	int		$maxlen			Max length of text
		*		@return	string					String with URL
		*/
	function getNomUrl($withpicto=0,$option='',$maxlen=0, $params=""){
        global $conf,$langs;

        $name=$this->GetSubject();//(!preg_match('#<|>#',$this->message_id)?$this->message_id:$this->id);

        $result='';

        
        if( $option =='dolmessage')
					$file = 'info.php'; 
				else 
					$file = 'fiche.php'; 
					
				$title = '<div class="FixedToolipDolmessage">';
				$title.= '<h4 class="title">'.$this->GetSubject();
				
					$title.= '<span class="flag flagged">'.( ($this->flagged) ? img_picto('flagged', 'flagged@dolmessage') : img_picto('unflagged', 'unflagged@dolmessage') ).'</span>';
					$title.= '<span class="flag answered">'.(($this->answered) ? img_picto('answered', 'answered@dolmessage') : '&nbsp;' ).'</span>';
					$title.= '<span class="flag linked">'.(($this->GetLinked()) ? img_picto('sync', 'sync@dolmessage') : '&nbsp;' ).'</span>';
				

				$title.= '</h4>';
				
				$title.= '<span class="to"><strong>'. $langs->trans('DolmessageTo').'</strong> '.$this->GetToName().' '.$this->GetToMail().'</span>';
				$title.= '<span class="from"><strong>'. $langs->trans('DolmessageFrom').'</strong> '.$this->GetFromName().' '.$this->GetFromMail().'</span>';
				
				$title.= '<span class="from">'. $langs->trans('DolmessageDate').' '.$this->GetDate().'</span>';
				
				$title.= '<span class="size">'. $langs->trans('DolmessageState').' '.($this->GetUnseen()? $langs->trans('DolmessageSeen') : $langs->trans('DolmessageUnseen') ).'</span>';
				
				$title.= '<span class="size">'. $langs->trans('DolmessageSize').' '.$this->GetSize(true).'</span>';
				
				$title.= '</div>'; 
					
        $lien = '<a class="classfortooltip linkSubject" title="'.dol_escape_htmltag($title, 1, 1).'"  href="'. dol_buildpath('/dolmessage/'.$file, 1) .'?';

        if($this->id > 0 )
					$lien.='id='.$this->id;
        elseif($this->uid > 0 )
					$lien.='uid='.$this->uid;

				
				if(strlen($params) > 1)
					$lien.=(substr($params,0,1)=='&')? $params : '&'.$params; 
					
					
					
					
        // Add type of canvas
        $lien.=(!empty($this->canvas)?'&amp;canvas='.$this->canvas:'').'">';
        $lienfin='</a>';

        if ($withpicto) $result.=($lien.img_object($langs->trans("DolMessageView").'','dolmessage@dolmessage').$lienfin);
        if ($withpicto && $withpicto != 2) $result.=' ';
        $result.=$lien.($maxlen?dol_trunc($name,$maxlen):$name).$lienfin;

        return $result;
    }
}

Class dattachment {

    /**
     */
    public $name;

    /**
     */
    public $appType;

    /**
     */
    public $encoding;

    /**
     */
    public $data;

    public function __construct($type, $name, $encoding, $data) {
        $this->appType = $type;
        $this->name = $name;
        $this->encoding = $encoding;

        if (trim($this->encoding) == 'base64')
            $this->data = base64_decode($data);
        else
            $this->data = $data;
    }

    public function GetName() {
        return $this->name;
    }

    public function GetApplicationType() {
        return $this->appType;
    }

    public function GetEncoding() {
        return $this->encoding;
    }

    public function GetData() {
        return $this->data;
    }

}

