<?php
/* Copyright (C) 2014 Oscim 	<support@oscim.fr>
 * Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       dev/skeletons/skeleton_page.php
 * 		\ingroup    mymodule othermodule1 othermodule2
 * 		\brief      This file is an example of a php page
 * 					Put here some comments
 */
$res = 0;
if (!$res && file_exists("../main.inc.php")) $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php")) $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php")) $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php")) $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res) die("Include of main fails");

require_once(DOL_DOCUMENT_ROOT."/core/lib/agenda.lib.php");
require_once(DOL_DOCUMENT_ROOT."/comm/action/class/cactioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT."/comm/action/class/actioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php');
require_once(DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php');
require_once(DOL_DOCUMENT_ROOT.'/ecm/class/htmlecm.form.class.php');
include_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';

dol_include_once('dolmessage/class/connector/dolimap.class.php');
dol_include_once('dolmessage/class/connector/dollocalmessage.class.php');

dol_include_once('dolmessage/core/lib/message.lib.php');
dol_include_once('dolmessage/class/dolCMailFile.class.php');


include_once DOL_DOCUMENT_ROOT.'/includes/swiftmailer/egulias/email-validator/EmailValidator/Exception/InvalidEmail.php';
include_once DOL_DOCUMENT_ROOT.'/includes/swiftmailer/egulias/email-validator/EmailValidator/Exception/ExpectingATEXT.php';

// do not block style tags
define('NOSCANPOSTFORINJECTION', 1);
define('NOSTYLECHECK', 1);

// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("other");
$langs->load("dolimail@dolimail");
$langs->load("agenda");

// Load traductions files for GED
$langs->load("ecm");
$langs->load("companies");
$langs->load("other");
$langs->load("users");
$langs->load("orders");
$langs->load("propal");
$langs->load("bills");
$langs->load("contracts");


if (!function_exists('imap_timeout')) {
    print '<center class="alert" style="color:red"> les fonctions imap (php-imap) sont requise pour ce module </center>';
    exit;
}
// prepare Content
$bodyContent = ((GETPOST('bodyMessage', '', 2) != "") ? GETPOST('bodyMessage', '', 2) : "<br /><br />--&nbsp;\n<br />__SIGNATURE__");


//send email
$action = GETPOST('action', 'aZ', 2);
if ($action == '') $action = GETPOST('action', 'aZ');

$formmail = new FormMail($db);
// Get message template for $this->param["models"] into c_email_templates
$model_id = GETPOST('modelmailselected', 'int');
if ($model_id != 0) {

    $sql = "SELECT label, topic, content, content_lines, lang";
    $sql .= " FROM ".MAIN_DB_PREFIX.'c_email_templates';
    $sql .= " WHERE type_template='dolmessage'";
    $sql .= " AND entity IN (".getEntity('c_email_templates', 0).")";
    $sql .= " AND (fk_user is NULL or fk_user = 0 or fk_user = ".$user->id.")";
    $sql .= " AND active = 1";
    $sql .= " AND (lang = '".$langs->defaultlang."' OR lang IS NULL OR lang = '')";
    $sql .= " AND rowid=".$model_id;
    $sql .= $db->order("position,lang,label", "ASC");

    $resql = $db->query($sql);
    if ($resql) {
        $obj         = $db->fetch_object($resql); // Get first found
        $bodyContent = $obj->content;
    }
}

switch ($action) {

    case 'send':
        $error           = 0;
        $email_from      = GETPOST('frommail', 'alpha', 2);
        $errors_to       = $email_from;
        $sendto          = GETPOST('to', 'alpha', 2);
        $sendtocc        = GETPOST('cc', 'alpha', 2);
        $sendtoccc       = GETPOST('cci', 'alpha', 2);
        $subject         = GETPOST('subject', '', 2);
        $trackid         = GETPOST('trackid', '', 2);
        $body            = GETPOST('bodyMessage', '', 2);
        $deliveryreceipt = false;
        //Check if we have to decode HTML
        if (!empty($conf->global->FCKEDITOR_ENABLE_MAILING) && dol_textishtml(dol_html_entity_decode($body,
                    ENT_COMPAT | ENT_HTML401))) {
            $body = dol_html_entity_decode($body, ENT_COMPAT | ENT_HTML401);
        }

        // Create form object
        $formmail->trackid = $trackid;
        $attachedfiles     = $formmail->get_attached_files();
        $filepath          = $attachedfiles['paths'];
        $filename          = $attachedfiles['names'];
        $mimetype          = $attachedfiles['mimes'];

        if (empty($email_from)) {
            setEventMessage($langs->trans("ErrorFieldRequired", $langs->transnoentities("DolmessagelSender")), 'errors');
            $action = 'test';
            $error++;
        }
        if (empty($sendto)) {
            setEventMessage($langs->trans("ErrorFieldRequired", $langs->transnoentities("DolmessagelRecipiant")),
                'errors');
            $action = 'test';
            $error++;
        }
        if (!$error) {
            // Le message est-il en html
            $msgishtml = 1; // Message is Forced to HTML




            $usersignature = $user->signature;
            // For action = test or send, we ensure that content is not html, even for signature, because this we want a test with NO html.
            if ($action == 'test' || $action == 'send') {
                $usersignature = dol_string_nohtmltag($usersignature);
            }

            $substitutionarrayfortest = array(
                '__LOGIN__' => $user->login,
                '__ID__' => 'TESTIdRecord',
                '__EMAIL__' => 'TESTEMail',
                '__LASTNAME__' => 'TESTLastname',
                '__FIRSTNAME__' => 'TESTFirstname',
                '__SIGNATURE__' => (($user->signature && empty($conf->global->MAIN_MAIL_DO_NOT_USE_SIGN)) ? $usersignature
                    : ''),
                //'__PERSONALIZED__' => 'TESTPersonalized'	// Hiden because not used yet
            );
            complete_substitutions_array($substitutionarrayfortest, $langs);


            // Pratique les substitutions sur le sujet et message
            $subject = make_substitutions($subject, $substitutionarrayfortest);
            $body    = make_substitutions($body, $substitutionarrayfortest);
            if ($subject == '') {
                $subject = $langs->trans('NoSubject');
            }
            $linkedObjects = array('societe' => GETPOST('reference_fk_socid', 'int'));
            if (GETPOST('reference_type_element', 'aZ') == 'projet') {
                $linkedObjects['project'] = GETPOST('reference_rowid', 'int');
            }

            $mailfile = new dolCMailFile($linkedObjects, $subject, $sendto, $email_from, $body, $filepath, $mimetype,
                $filename, $sendtocc, $sendtoccc, $deliveryreceipt, $msgishtml, $errors_to
            );


            $result = $mailfile->sendfile();

            if ($result) {
                setEventMessage($langs->trans("MailSuccessfulySent", $mailfile->getValidAddress($email_from, 2),
                        $mailfile->getValidAddress($sendto, 2)));

                session_write_close();
                Header("location: ".dol_buildpath('/dolmessage/synchro.php', 1).'?number='.GETPOST('number').'&folder=INBOX&num_page='.GETPOST('num_page'));
            } else {
                setEventMessage($langs->trans("ResultKo").'<br>'.$mailfile->error.' '.$result, 'errors');
            }

            $action = '';
        }
        break;


    case 'reply':
    case 'replyall':
    case 'forward':
        // Get parameters
        $id  = GETPOST('id', 'int');
        $uid = GETPOST('uid', 'int');
        try {
            $dolimap = new dolimap($db, $user);
            $dolimap->SetUser($user->id, GETPOST('number'));
            $dolimap->Open(GETPOST('folder', 'chaine'));
            $Message = LoadMessage($id, $uid, $dolimap);
        } catch (Exception $ex) {
            echo $ex->getMessage();
            echo '<br><br><a href="javascript:history.go(0);">Your IMAP serveur does not answer, click here to refresh</a>';
        }
        $bodyContent .= ("<p>".$langs->trans('DolmessageOn')." ".$Message->getDate(true).", ".$Message->GetFrom()." ".$langs->trans('DolmessageHaveWrote')." :</p>"
            ."<blockquote class='dolmessage' style='padding: 0 0.4em; border-left: #1010ff 2px solid; margin: 0'>".$Message->getDefaultMsg()."</blockquote>");
        break;

    default:
}

// adjust to, cc
$to      = GETPOST('to', 'alpha');
$cc      = GETPOST('cc', 'array');
$cci     = GETPOST('cci', 'array');
$subject = GETPOST('subject', '', 2);
$trackid = GETPOST('trackid', 'aZ09');
if ($trackid == '') {
    $trackid = 'dolm'.rand(0, 100000);
}
switch ($action) {
    case 'reply':
        $to      = $Message->GetFrom(FALSE);
        $subject = $langs->trans('DolmessageReplySubject').': '.$Message->GetSubject();
        break;
    case 'replyall':
        $to      = $Message->GetFrom(FALSE);
        $subject = $langs->trans('DolmessageReplyAllSubject').': '.$Message->GetSubject();
        break;
    case 'forward':
        $subject = $langs->trans('DolmessageForwardSubject').': '.$Message->GetSubject();
        break;
}

/* * *************************************************
 * VIEW
 *
 * Put here all code to build page
 * ************************************************** */


llxHeader('', $langs->trans("DolmessagelSendEmail"), '', '', 0, 0, array('/dolmessage/js/vue.min.js','/dolmessage/js/vue-select/vue-select.js'));

dol_fiche_head(message_prepare_head(), 'dashboard', $langs->trans("Webmail"), 0, 'mailbox@dolmessage');


$knownEmails = getKnownEmails();

dol_include_once('/dolmessage/tpl/compose.tpl');


// End of page
llxFooter();
$db->close();
?>