<?php
/* Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file       htdocs/core/lib/message.lib.php
 * 	\brief      Ensemble de fonctions de base pour le module message
 * 	\ingroup    message
 */

/**
 *  Return array head with list of tabs to view object informations.
 *
 *  @param	Object	$object		Product
 *  @return	array   	        head array with tabs
 */
function message_prepare_head($object = null)
{
    global $langs, $conf, $user, $db;

    $h    = 0;
    $head = array();

    $head[$h][0] = dol_buildpath("/dolmessage/index.php", 1);
    $head[$h][1] = $langs->trans('MessageDashboard');
    $head[$h][2] = 'dashboard';
    $h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf, $langs, $object, $head, $h, 'message');


    dol_include_once('/user/class/usergroup.class.php');

    $array     = array();
    $UserGroup = new UserGroup($db);
    foreach ($UserGroup->listGroupsForUser($user->id) as $row)
        $array[]   = $row->id;
    /**
      @brief webmail associted group
     */
    $sql       = "SELECT * ";
    $sql       .= " FROM ".MAIN_DB_PREFIX."usergroupwebmail";
    $sql       .= " WHERE  1 ";
    $sql       .= " AND fk_usergroup IN (".implode(',', $array).") ";
    $resql     = $db->query($sql);
    if ($resql) {
        $num = $db->num_rows($resql);

        $i   = 0;
        $var = true;
        while ($i < $num) {
            $objp = $db->fetch_object($resql);

            $head[$h][0] = dol_buildpath("/dolmessage/synchro.php", 1).'?identifiid='.$objp->fk_usergroup.'&number='.$objp->number;
            $head[$h][1] = $objp->title;
            $head[$h][2] = 'synchro_'.(int) $objp->number.'_'.(int) $objp->fk_usergroup;
            $h++;

            $i++;
        }
    }



    /**
      @brief webmail associted user
     */
    $sql   = "SELECT * ";
    $sql   .= " FROM ".MAIN_DB_PREFIX."userwebmail";
    $sql   .= " WHERE  1 ";
    $sql   .= " AND fk_user = '".$user->id."' ";
    $resql = $db->query($sql);
    if ($resql) {
        $num = $db->num_rows($resql);

        $i   = 0;
        $var = true;
        while ($i < $num) {
            $objp = $db->fetch_object($resql);

            $head[$h][0] = dol_buildpath("/dolmessage/synchro.php", 1).'?number='.$objp->number;
            $head[$h][1] = $objp->title;
            $head[$h][2] = 'synchro_'.(int) $objp->number.'_'.(int) $objp->fk_usergroup;
            $h++;

            $i++;
        }
    }


    complete_head_from_modules($conf, $langs, $object, $head, $h, 'message', 'remove');

// 	$head[$h][0] = dol_buildpath("/dolmessage/info.php?uid=".$obj->$object ,1);
// 	$head[$h][1] = $langs->trans('MessageInfo');
// 	$head[$h][2] = 'info';
// 	$h++;
// 	
// 	$head[$h][0] = dol_buildpath("/dolmessage/attachment.php?uid=".$obj->$object ,1);
// 	$head[$h][1] = $langs->trans('MessageAttachment');
// 	$head[$h][2] = 'attachment';
// 	$h++;

    return $head;
}

/**
  @brief load message based on id or uid
  if uid  also is imap process
  if id also is local table + file
 */
function LoadMessage($id, $uid, $dolimap)
{
    global $db, $user, $conf;

    // local
    if (/* ($id > 0 && $uid <=0) || */ $id > 0) {
        $DolMsg = new dolmessage($db, $user);
        $r      = $DolMsg->fetch($id, '', true);

        $uid = $DolMsg->uid;

        $DolMsg->fetchObjectLinked($DolMsg->id, $DolMsg->element, $DolMsg->id, $DolMsg->element, 'OR');



        foreach ($DolMsg->linkedObjects as $type => $list) {
            foreach ($list as $obj) {
                if ($type == 'societe') {

                    $societe = $obj;

                    $upload_dir = $conf->societe->multidir_output[$societe->entity]."/".$societe->id;

                    if (!file_exists($upload_dir)) dol_mkdir($upload_dir);

                    $upload_dir .= '/message/';
                    if (!file_exists($upload_dir)) dol_mkdir($upload_dir);
                }
            }
        }

        $DolLocal = new dollocalmessage($uid);
        $DolLocal->LoadLocal($upload_dir, $DolMsg->message_id);

        $Message = $DolLocal;


        $Message->SetDate($DolMsg->datec);

        $Message->SetId($DolMsg->id);

        $Message->SetPath($upload_dir.$DolMsg->message_id);

        $Message->SetLinked($DolMsg->linkedObjects);
    }
    elseif ($uid > 0 /* && $id <=0 */) {
        $Message = $dolimap->GetMessage($uid);
    }

// print_r($Message);
    return $Message;
}

/**
  @brief List of mail know
 */
function getKnownEmails($onlyEmails = false)
{
    global $db, $conf;
    $sqlEmails   = "SELECT * FROM (
        SELECT `email` email,`nom` name,'company' typeAccount FROM `".MAIN_DB_PREFIX."societe` WHERE `email` != '' AND `email` IS NOT NULL AND `entity` = $conf->entity
        UNION
        SELECT sp.`email` email,CONCAT(sp.`firstname`,' ',sp.`lastname`,' (',s.nom,')') name,'contact' typeAccount
        FROM `".MAIN_DB_PREFIX."socpeople` sp
        LEFT JOIN `".MAIN_DB_PREFIX."societe` s ON sp.`fk_soc`= s.`rowid`
        WHERE sp.`email` != '' AND sp.`email` IS NOT NULL AND sp.`entity` = $conf->entity
        UNION
        SELECT `imap_login` email,`title` name,'usermailbox' typeAccount FROM `".MAIN_DB_PREFIX."userwebmail` WHERE `imap_login` != '' AND `imap_login` IS NOT NULL
        UNION
        SELECT `imap_login` email,`title` name,'groupmailbox' typeAccount FROM `".MAIN_DB_PREFIX."usergroupwebmail` WHERE `imap_login` != '' AND `imap_login` IS NOT NULL
        UNION
        SELECT `email` email,CONCAT(`firstname`,' ',`lastname`) name, 'user' typeAccount FROM `".MAIN_DB_PREFIX."user` WHERE `email` != '' AND `email` IS NOT NULL AND `entity` = $conf->entity
    ) bidon ORDER BY name";
    $knownEmails = array();
    $result      = $db->query($sqlEmails);
    if ($result) {
        while ($row = $db->fetch_object($result)) {
            if ($onlyEmails) {
                $knownEmails[] = $row->email;
            } else {
                $img = '';
                switch ($row->typeAccount) { /// add image even if not shown in dolibarr 4
                    case 'company':
                    case 'contact':
                    case 'user':
                        $img = img_object('', $row->typeAccount).' ';
                        break;

                    case 'usermailbox':
                    case 'groupmailbox':
                        $img = img_picto('', 'dolmessage.png@dolmessage', 'style="height: 14px"').' ';
                        break;

                    default:
                        break;
                }
                $knownEmails[$row->email] = $row->name;
            }
        }
    }
    return $knownEmails;
}

/**
  @brief construct list of split page for listing imap
  @param object $info
  @param int $pagination
  @param int $nbr_mess
  @return string
 */
function SplitListPage($dolimap, $folder, $identifiid, $pagination, $nbr_mess)
{

    $mbox = FALSE;
    if ($folder != '{:}') $dolimap->Open($folder);



    $mbox = $dolimap->GetImap();

    if ($mbox === FALSE) {
        $info    = FALSE;
        foreach ($dolimap->ListErrors() as $row)
            $message .= $row."<br>";
    } else {
        $info = $dolimap->Check();


        if (FALSE !== $info) {

            $option = 0;
            if (GETPOST('search') && GETPOST('search') != '') $option = $dolimap->search(GETPOST('search'));

            $mails = $dolimap->ListMessage(GETPOST('num_page'), $pagination, $identifiid, $option);
        }
    }

    $s               = '<table id="tabledolmess" style="width:100%;">';
    $s               .= '    <tr>';
    $s               .= '      <th style="text-align:right;">';
    $page_precedente = GETPOST("num_page") - 1;
    $page_suivante   = GETPOST("num_page") + 1;
    if ($page_precedente > 0)
            $s               .= '<a href="'.dol_buildpath('/dolmessage/synchro.php', 1).'?number='.GETPOST('number').'&folder='.GETPOST('folder').'&identifiid='.GETPOST('identifiid').'&num_page='.$page_precedente.'">Precedente</a> ';

    for ($num_page = 1; $num_page <= ceil($info->Nmsgs / $pagination); $num_page++) {
        if ($num_page != GETPOST("num_page"))
                $s .= '<a href="'.dol_buildpath('/dolmessage/synchro.php', 1).'?number='.GETPOST('number').'&folder='.GETPOST('folder').'&identifiid='.GETPOST('identifiid').'&num_page='.$num_page.'">'.$num_page.'</a> ';
        else $s .= $num_page;

        if ($num_page < ceil($nbr_mess / $pagination)) $s .= ', ';
    }

    if ($page_suivante < ceil($nbr_mess / $pagination))
            $s .= '<a href="'.dol_buildpath('/dolmessage/synchro.php', 1).'?number='.GETPOST('number').'&folder='.GETPOST('folder').'&num_page='.$page_suivante.'">Suivante</a> ';
    $s .= '      </th>';
    $s .= '    </tr>';
    $s .= '</table>';


    return $s;
}

function ReplaceImap($txt)
{
    $trad1 = array(
        "=\r\n" => "");
    $trad2 = array();
    // source: http://www.utf8-chartable.de/unicode-utf8-table.pl
    for ($i = 194; $i < 224; $i++) {
        for ($j = 128; $j < 192; $j++) {
            $trad2['='.strtoupper(dechex($i)).'='.strtoupper(dechex($j))] = mb_convert_encoding('&#'.intval(($i - 194) * 64
                    + $j).';', 'UTF-8', 'HTML-ENTITIES');
        }
    }
    $trad3 = array("=20" => "&nbsp;"
        , "=21" => "!"
        , "=22" => "\""
        , " = 23" => "#"
        , "=24" => "$"
        , "=25" => "%"
        , "=26" => "&"
        , "=27" => "'"
        , "=28" => "("
        , "=29" => ")"
        , "=2A" => "*"
        , "=2B" => "+"
        , "=2C" => ","
        , "=2D" => "-"
        , "=2E" => "."
        , "=2F" => "/"
        , "=30" => "0"
        , "=31" => "1"
        , "=32" => "2"
        , "=33" => "3"
        , "=34" => "4"
        , "=35" => "5"
        , "=36" => "6"
        , "=37" => "7"
        , "=38" => "8"
        , "=39" => "9"
        , "=3A" => ":"
        , "=3B" => ";"
        , "=3C" => "<"
        , "=3E" => ">"
        , "=3F" => "?"
        , "=40" => "@"
        , "=41" => "A"
        , "=42" => "B"
        , "=43" => "C"
        , "=44" => "D"
        , "=45" => "E"
        , "=46" => "F"
        , "=47" => "G"
        , "=48" => "H"
        , "=49" => "I"
        , "=4A" => "J"
        , "=4B" => "K"
        , "=4C" => "L"
        , "=4D" => "M"
        , "=4E" => "N"
        , "=4F" => "O"
        , "=50" => "P"
        , "=51" => "Q"
        , "=52" => "R"
        , "=53" => "S"
        , "=54" => "T"
        , "=55" => "U"
        , "=56" => "V"
        , "=57" => "W"
        , "=58" => "X"
        , "=59" => "Y"
        , "=5A" => "Z"
        , "=5B" => "["
        , "=5C" => "\\"
        , "=5D" => "]"
        , "=5E" => "^"
        , "=5F" => "_"
        , "=60" => "`"
        , "=61" => "a"
        , "=62" => "b"
        , "=63" => "c"
        , "=64" => "d"
        , "=65" => "e"
        , "=66" => "f"
        , "=67" => "g"
        , "=68" => "h"
        , "=69" => "i"
        , "=6A" => "j"
        , "=6B" => "k"
        , "=6C" => "l"
        , "=6D" => "m"
        , "=6E" => "n"
        , "=6F" => "o"
        , "=70" => "p"
        , "=71" => "q"
        , "=72" => "r"
        , "=73" => "s"
        , "=74" => "t"
        , "=75" => "u"
        , "=76" => "v"
        , "=77" => "w"
        , "=78" => "x"
        , "=79" => "y"
        , "=7A" => "z"
        , "=7B" => "{"
        , "=7C" => "|"
        , "=7D" => "}"
        , "=7E" => "~"
        , "=7F" => ""
        , "=E0" => "à"
        , "=92" => "'"
        , "=9C" => "oe"
        , "=3D" => "=" // bien en dernier !!!
    );

    $trad    = $trad1 + $trad2 + $trad3;
    $carimap = array_keys($trad);
    $carhtml = array_values($trad);
    return str_replace($carimap, $carhtml, $txt);
}
