<?php
/* Copyright (C) 2017 	oscss-shop 					<support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/**
 *	\file       htdocs/dolmessage/core/tabs/thirdparty.tabs.class.php
 *	\ingroup    dolmessage
 *	\brief      Fiche d'information sur une proposition commerciale
 */


use \Form;
use \Formother;
use \FormFile;
use \FormQualityReport;
use \UserGroup;
use \User;
use \ExtraFields;

use \CORE\FRAMEWORK\Societe as Societe;
use \CORE\FRAMEWORK\AutoTabs as AutoTabs;
use \CORE\FRAMEWORK\AutoTabsRequired as AutoTabsRequired;



require_once(DOL_DOCUMENT_ROOT . "/user/class/usergroup.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/lib/date.lib.php");
if ($conf->projet->enabled)
    require_once(DOL_DOCUMENT_ROOT . "/core/lib/project.lib.php");
require_once(DOL_DOCUMENT_ROOT . "/contact/class/contact.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/lib/contact.lib.php");
require_once(DOL_DOCUMENT_ROOT . "/core/lib/functions2.lib.php");
require_once(DOL_DOCUMENT_ROOT . "/core/lib/company.lib.php");

require_once(DOL_DOCUMENT_ROOT . "/core/lib/agenda.lib.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/cactioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/actioncomm.class.php");


dol_include_once('dolmessage/class/connector/dolimap.class.php');
dol_include_once('dolmessage/class/connector/dollocalmessage.class.php');
dol_include_once('dolmessage/class/user.mailconfig.class.php');
dol_include_once('dolmessage/core/lib/message.lib.php');




$langs->load('propal');
$langs->load('compta');
$langs->load('bills');
$langs->load("companies");
$langs->load("dolmessage@dolmessage");

/**
	@class TabsThirdparty
	
*/
Class TabsThirdparty
	extends AutoTabs
	implements 
		AutoTabsRequired
	{
	
	public 
		/**
			@var 
		*/
			$name

		, 
		/**
			@var array 
		*/
			$refparam = array(
							'socid'=>'int'
						, 'ref'=>'alpha'
						, 'action'=>'alpha'
						, 'mod'=>'alpha'
						, 'tab'=>'alpha'
					)
		; 

	/**
		@fn Init()
		@brief 
		@param
		@return  treu/ false/ 2 
			if return false: error 
			if return true;
			if return 2,  No AutoTabs load class by type
	*/
	public function _Init(){
		global $langs; 
		
		$file = basename(__FILE__); 
		
		$this->type = substr($file , 0, strpos($file, '.' ) ); 
		
		$class = $this->FV->GetClassByType($this->type); 
		if(empty($class))
			return false; 
			
		
		// load Specific context 
		$class.= 'Edi'; 
		if( !class_exists($class) )
			return 2; 
			
		$this->object = new $class($this->db);

		$this->TitlePage = $langs->trans("DolmessageCompanyTabTitle");
		$this->TitleTab = $langs->trans("DolmessageCompanyTabName");
		
		return true; 
	}

	
	
	/**
		@fn Init()
		@brief 
		@param
		@return 
	*/
	public function _Process(){
		$this->object = new Societe($this->db); 
	
		if($this->GetParams('socid') != null || $this->GetParams('ref') != null) {
		
			$this->object->fetch($this->GetParams('socid'), $this->GetParams('ref'));
			$this->object->fetch_thirdparty();
// 			$this->societe = new Societe($this->db);
// 			$this->societe->fetch($this->object->socid);
		}

		return true; 
	}
	
	/**
		@fn Display()
		@brief 
		@param
		@return 
	*/
	public function _Display(){
		global $langs, $conf, $user; 
		
			global $formfile; 
			
			$db =$this->db; 
// 			$formfile = new FormFile($this->db);
		$limit = $conf->liste_limit;
		
			print '<div class="fichecenter">';
			print '<div class="underbanner clearboth"></div>';


if ($msg)
    print '<div class="error">' . $msg . '</div>';

$sql = "SELECT m.rowid, message_id, message_uid, m.datec, m.recent, m.unseen, m.flagged, m.answered, m.joint , fk_source as socid, user_id , usergroup_id, ug.nom as groupnom,  ua.login as loginauthor  ";
$sql.= " FROM " . MAIN_DB_PREFIX . "message m";
$sql.= " LEFT JOIN " . MAIN_DB_PREFIX . "user as ua ON( m.user_id = ua.rowid) ";
$sql.= " LEFT JOIN " . MAIN_DB_PREFIX . "usergroup as ug ON( m.usergroup_id = ug.rowid) ";
$sql.= " JOIN  " . MAIN_DB_PREFIX . "element_element ee ON(targettype = 'dolmessage' AND fk_target = m.rowid AND sourcetype='societe' AND fk_source ='" . $this->GetParams('socid') . "' )  ";

$sql.= " WHERE  1 ";

$sql.= $db->order($sortfield, $sortorder);
$sql.= $db->plimit($limit + 1, $offset);


echo '<table width="100%" class="listingEmail">';

// Lignes des titres
print "<thead><tr class=\"liste_titre\">";
// print_liste_field_titre($langs->trans("Ref"), $_SERVER["PHP_SELF"], "p.ref",$param,"","",$sortfield,$sortorder);
print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"], "datec", $param, "", "", $sortfield, $sortorder);
print_liste_field_titre($langs->trans("Subject"), $_SERVER["PHP_SELF"], "p.ref", $param, "", "", $sortfield, $sortorder);
print_liste_field_titre($langs->trans("Tiers"), $_SERVER["PHP_SELF"], "p.ref", $param, "", "", $sortfield, $sortorder);
print_liste_field_titre($langs->trans("User"), $_SERVER["PHP_SELF"], "p.ref", $param, "", "", $sortfield, $sortorder);
print_liste_field_titre($langs->trans("Group"), $_SERVER["PHP_SELF"], "p.ref", $param, "", "", $sortfield, $sortorder);

print "</thead></tr>\n<tbody>";


$resql = $db->query($sql);
if ($resql) {
    $num = $db->num_rows($resql);

    $i = 0;
    $var = true;
    while ($i < min($num, $limit)) {
        $objp = $db->fetch_object($resql);

        $Mess = LoadMessage($objp->rowid, $objp->message_uid, $dolimap);

        if ($i % 2 == 0)
            print '<tr class="pair">';
        else
            print '<tr class="impair">';

        if (date('d/m/Y') == date("d/m/Y", strtotime($objp->datec))) { /* only hours if day is the same */
            $shortDate = date("H:i", strtotime($objp->datec));
        } elseif (date('Y') != date("Y", strtotime($objp->datec))) { /* if not this year */
            $shortDate = date("d M. Y", strtotime($objp->datec));
        } else { /* if year is implicite */
            $shortDate = date("d M.", strtotime($objp->datec));
        }

        echo '<td class="hiddenInfo"><span>'.date("d/m/Y H:i", strtotime($objp->datec)).'</span>' . $shortDate. '</td>';
        echo '<td><a class="linkSubject" href="' . dol_buildpath('/dolmessage/fiche.php', 1) . '?id=' . $Mess->GetId() . '" >' . $Mess->GetSubject() . '</a></td>';
        echo '<td>';
        foreach ($Mess->GetLinked() as $type => $list)
            foreach ($list as $obj)
                if ($type == 'societe')
                    print $obj->getNomUrl(1, '', 16);
        echo '</td>';



        echo '<td>';
        $userstatic = new User($db);
        $userstatic->id = $objp->user_id;
        $userstatic->login = $objp->loginauthor;
		  if($objp->user_id > 0 ) 
			echo  $userstatic->getLoginUrl(1) ;
		  else 
			echo '&nbsp;'; 
			
		echo '</td>';

        echo '<td>';

        
        
		  if($objp->usergroup_id > 0 ){
			if(version_compare($conf->global->MAIN_VERSION_LAST_INSTALL , '3.6', '>=') )
			  echo  '<a href="'.DOL_URL_ROOT.'/user/group/fiche.php?id='.$objp->usergroup_id.'" >'.img_object($langs->trans("ShowGroup"),"group").' '.$objp->groupnom .'</a>';
			if(version_compare($conf->global->MAIN_VERSION_LAST_INSTALL , '3.7', '>=') )
			  echo  '<a href="'.DOL_URL_ROOT.'/user/group/card.php'.$objp->usergroup_id.'" >'.img_object($langs->trans("ShowGroup"),"group").' '.$objp->groupnom .'</a>';
			
		  }
		  else 
			echo '&nbsp;'; 
			
		echo '</td>';
		
        echo '</tr>';
        $i++;
    }
}

// $db->close();

			print '</div>';
		return false; 
	}
	
	
	
	
}


