<?php
/* Copyright (C) 2017 	oscss-shop 					<support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * 	\file       htdocs/dolmessage/core/tabs/user.tabs.class.php
 * 	\ingroup    dolmessage
 * 	\brief      card / tabs for configure mailbox in user card

  @remarks Greffon :: Not required but recommended
  - dmmultibox
  - dmadvancedconfig
 */
loadClass("Form", 'html.form');

use \Form as Form;
use \Formother as Formother;
use \FormFile as FormFile;
use \FormQualityReport as FormQualityReport;
use \UserGroup as UserGroup;
use \User as User;
use \ExtraFields as ExtraFields;
use \CORE\FRAMEWORK\Societe as Societe;
use \CORE\FRAMEWORK\AutoTabs as AutoTabs;
use \CORE\FRAMEWORK\AutoTabsRequired as AutoTabsRequired;

require_once(DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php');
require_once(DOL_DOCUMENT_ROOT.'/user/class/user.class.php');


dol_include_once('/dolmessage/class/user.mailconfig.class.php');
dol_include_once('/framework/core/lib/greffon.lib.php');

$langs->load('propal');
$langs->load('compta');
$langs->load('bills');
$langs->load("companies");

$langs->load("framework@framework");
$langs->load("dolmessage@dolmessage");

/**
  @class TabsUser

 */
Class TabsUser extends AutoTabs implements
AutoTabsRequired
{
    public
    /**
      @var
     */
        $name
        ,
        /**
          @var array
         */
        $refparam = array(
            'id' => 'int'
            , 'ref' => 'alpha'
            , 'action' => 'alpha'
            , 'mod' => 'alpha'
            , 'tab' => 'alpha'
            )

    ;

    /**
      @fn Init()
      @brief
      @param
      @return  treu/ false/ 2
      if return false: error
      if return true;
      if return 2,  No AutoTabs load class by type
     */
    public function _Init()
    {
        global $langs;

        $file = basename(__FILE__);

        $this->type = substr($file, 0, strpos($file, '.'));

        $class = $this->FV->GetClassByType($this->type);
        if (empty($class)) return false;


        // load Specific context
        $class .= 'Edi';
        if (!class_exists($class)) return 2;

        $this->object = new $class($this->db);

        $this->TitlePage = $langs->trans("DolmessageUserTabTitle");
        $this->TitleTab  = $langs->trans("DolmessageUserTabName");

        return true;
    }

    /**
      @fn Init()
      @brief
      @param
      @return
     */
    public function _Process()
    {
        global $user, $langs, $conf, $hookmanager;

        if ($this->GetParams('id') != null) {
            $this->object->fetch($this->GetParams('id'));
        }

        $db = $this->db;

        $hookmanager->initHooks(array('dolmessage', 'greffon'));


        // If user is not user read and no permission to read other users, we stop
        if (($this->object->id != $user->id) && (!$user->rights->user->user->lire)) accessforbidden();


        if ($this->GetParams('id') > 0)
                if (($this->object->id != $user->id) && (!$user->rights->dolmessage->user->modifier || !$user->admin ))
                    accessforbidden();



        $parameters = array('Tabs' => $this);
        $reshook    = $hookmanager->executeHooks('doActions', $parameters, $this->object, $this->GetParams('action'));    // Note that $action and $object may have been modified by hook


        if (!$reshook) {
            switch ($this->GetParams('action')) {
                case 'update':
                    $db->begin();

                    foreach (GETPOST('title') as $key => $row) {
                        $Usermail = new Usermailconfig($db);
                        if (!empty($row)) {
                            $key2 = (($key < 1) ? 1 : ((int) $key + 1) ); // config start at 1
                            $Usermail->fetch_from_user($this->object->id, $key2);

                            $mailboxuserid = GETPOST("mailboxuserid");

                            $title                    = $row;
                            $imap_id                  = GETPOST("mailboxnumber");
                            $imap_login               = GETPOST("imap_login");
                            $imap_password            = GETPOST("imap_password");
                            $imap_host                = GETPOST("imap_host");
                            $imap_port                = GETPOST("imap_port");
                            $imap_ssl                 = GETPOST("imap_ssl");
                            $imap_ssl_novalidate_cert = GETPOST("imap_ssl_novalidate_cert");


                            $Usermail->number                   = $imap_id[$key];
                            $Usermail->title                    = $title;
                            $Usermail->fk_user                  = $this->object->id;
                            $Usermail->imap_login               = $imap_login[$key];
                            $Usermail->imap_password            = $imap_password[$key];
                            $Usermail->imap_host                = $imap_host[$key];
                            $Usermail->imap_port                = $imap_port[$key];
                            $Usermail->imap_ssl                 = $imap_ssl[$key];
                            $Usermail->imap_ssl_novalidate_cert = $imap_ssl_novalidate_cert[$key];


                            if ($conf->dmsmtpconfig && $conf->dmsmtpconfig->enabled) {
                                $smtp_server    = GETPOST("smtp_server");
                                $smtp_port      = GETPOST("smtp_port");
                                $smtps_id       = GETPOST("smtps_id");
                                $smtps_pw       = GETPOST("smtps_pw");
                                $email_tls      = GETPOST("email_tls");
                                $email_starttls = GETPOST("email_starttls");
                                $smtp_from      = GETPOST("smtp_from");

                                $Usermail->smtp_server    = $smtp_server[$key];
                                $Usermail->smtp_port      = $smtp_port[$key];
                                $Usermail->smtps_id       = $smtps_id[$key];
                                $Usermail->smtps_pw       = $smtps_pw[$key];
                                $Usermail->email_tls      = $email_tls[$key];
                                $Usermail->email_starttls = $email_starttls[$key];
                                $Usermail->smtp_from      = $smtp_from[$key];
                            }

                            if ($Usermail->id > 0) {
                                $res = $Usermail->update($user);
                            } else {
                                $res = $Usermail->create($user);
                            }

                            if ($res < 0) {
                                // 						$mesg = '<div class="error">' . $Usermail->error . '</div>';
                                $db->rollback();
                            } else {
                                $db->commit();
                            }
                        }
                    }


                    Header("location: ".dol_buildpath('/framework/tabs/generic.php', 1).'?mod=dolmessage&tab=user&id='.$this->object->id);
                    exit;
                    break;

                case 'delete':

                    $Usermail     = new Usermailconfig($db);
                    $userbox      = GETPOST('userbox');
                    $Usermail->id = $userbox;
                    $Usermail->delete($user);
                    Header("location: ".dol_buildpath('/framework/tabs/generic.php', 1).'?mod=dolmessage&tab=user&id='.$this->object->id);
                    exit;

                    break;

                case 'validate':
                default:
                    $this->listing = array();
                    $sql           = "SELECT *, fk_user as user_id ";
                    $sql           .= " FROM ".MAIN_DB_PREFIX."userwebmail";
                    $sql           .= " WHERE  1 ";
                    $sql           .= " AND fk_user = '".$this->object->id."' ORDER BY number ASC";
                    // echo $sql;
                    $resql         = $db->query($sql);
                    if ($resql) {
                        $num = $db->num_rows($resql);

                        $i   = 0;
                        $var = true;
                        while ($i < $num) {
                            $objp              = $db->fetch_object($resql);
                            $objp->data_number = $objp->number;
                            $i++;
                            if ($this->GetParams('action') == 'edit') {

                                $objp->number        = $objp->number.'<input type="hidden" name="mailboxnumber[]" value="'.$objp->number.'">';
                                $objp->title         = '<input size="30" type="text" class="flat" name="title[]" value="'.$objp->title.'">';
                                $objp->imap_login    = '<input size="30" type="text" class="flat" name="imap_login[]" value="'.$objp->imap_login.'">';
                                $objp->imap_password = '<input size="30" maxlength="32" type="password" class="w" name="imap_password[]" value="'.$objp->imap_password.'" >';
                                $objp->imap_host     = '<input size="30" type="text" class="flat" name="imap_host[]" value="'.$objp->imap_host.'">';
                                $objp->imap_port     = '<input size="30" type="number" class="flat" name="imap_port[]" value="'.$objp->imap_port.'">';

                                $tmp            = '<select name="imap_ssl[]" >';
                                $tmp            .= '<option value="1" '.( ($objp->imap_ssl) ? 'selected ' : '' ).'>'.$langs->trans('Oui').'</option>';
                                $tmp            .= '<option value="0" '.( (!$objp->imap_ssl) ? 'selected ' : '' ).'>'.$langs->trans('Non').'</option>';
                                $tmp            .= '</select>';
                                $objp->imap_ssl = $tmp;

                                $tmp                            = '<select name="imap_ssl_novalidate_cert[]" >';
                                $tmp                            .= '<option value="1" '.( ($objp->imap_ssl_novalidate_cert)
                                        ? 'selected ' : '' ).'>'.$langs->trans('Oui').'</option>';
                                $tmp                            .= '<option value="0" '.( (!$objp->imap_ssl_novalidate_cert)
                                        ? 'selected ' : '' ).'>'.$langs->trans('Non').'</option>';
                                $tmp                            .= '</select>';
                                $objp->imap_ssl_novalidate_cert = $tmp;

                                if ($conf->dmsmtpconfig && $conf->dmsmtpconfig->enabled) {
                                    $objp->smtp_server    = '<input size="30" type="text" class="flat" name="smtp_server[]" value="'.$objp->smtp_server.'">';
                                    $objp->smtp_port      = '<input size="30" type="number" class="flat" name="smtp_port[]" value="'.$objp->smtp_port.'">';
                                    $objp->smtps_id       = '<input size="30" type="text" class="flat" name="smtps_id[]" value="'.$objp->smtps_id.'">';
                                    $objp->smtps_pw       = '<input size="30" type="password" class="flat" name="smtps_pw[]" value="'.$objp->smtps_pw.'">';
                                    $tmp                  = '<select name="email_tls[]" >';
                                    $tmp                  .= '<option value="1" '.( ($objp->email_tls) ? 'selected ' : '' ).'>'.$langs->trans('Oui').'</option>';
                                    $tmp                  .= '<option value="0" '.( (!$objp->email_tls) ? 'selected ' : '' ).'>'.$langs->trans('Non').'</option>';
                                    $tmp                  .= '</select>';
                                    $objp->email_tls      = $tmp;
                                    $tmp                  = '<select name="email_starttls[]" >';
                                    $tmp                  .= '<option value="1" '.( ($objp->email_starttls) ? 'selected '
                                            : '' ).'>'.$langs->trans('Oui').'</option>';
                                    $tmp                  .= '<option value="0" '.( (!$objp->email_starttls) ? 'selected '
                                            : '' ).'>'.$langs->trans('Non').'</option>';
                                    $tmp                  .= '</select>';
                                    $objp->email_starttls = $tmp;
                                    $objp->smtp_from      = '<input size="30" type="text" class="flat" name="smtp_from[]" value="'.$objp->smtp_from.'">';
                                }
                            } else {
                                $objp->imap_password            = ( ($objp->imap_password) ? preg_replace('/./i', '*',
                                        $objp->imap_password) : '************' );
                                $objp->imap_ssl                 = ( ($objp->imap_ssl) ? $langs->trans('Oui') : $langs->trans('Non') );
                                $objp->imap_ssl_novalidate_cert = ( ($objp->imap_ssl_novalidate_cert) ? $langs->trans('Oui')
                                        : $langs->trans('Non') );

                                if ($conf->dmsmtpconfig && $conf->dmsmtpconfig->enabled) {
                                    $objp->smtps_pw       = ( ($objp->smtps_pw) ? preg_replace('/./i', '*',
                                            $objp->smtps_pw) : '************' );
                                    $objp->email_tls      = ( ($objp->email_tls) ? $langs->trans('Oui') : $langs->trans('Non') );
                                    $objp->email_starttls = ( ($objp->email_starttls) ? $langs->trans('Oui') : $langs->trans('Non') );
                                }
                            }

                            $this->listing[] = $objp;
                        }
                    }
                    //
// 		print_r($conf->dmmultibox);
// 		exit;

                    if ($this->GetParams('action') == 'edit') {
                        if (CheckStateMod('dmmultibox') || $i == 0) {
                            $objp                = new stdClass;
                            $i++;
                            $objp->data_number   = $i;
                            $objp->number        = $i.'<input type="hidden" name="mailboxnumber[]" value="'.$i.'">';
                            $objp->title         = '<input size="30" type="text" class="flat" name="title[]" value="">';
                            $objp->imap_login    = '<input size="30" type="text" class="flat" name="imap_login[]" value="">';
                            $objp->imap_password = '<input size="30" maxlength="32" type="password" class="flat" name="imap_password[]" value="" >';
                            $objp->imap_host     = '<input size="30" type="text" class="flat" name="imap_host[]" value="">';
                            $objp->imap_port     = '<input size="30" type="number" class="flat" name="imap_port[]" value="">';
                            $tmp                 = '<select name="imap_ssl[]" >';
                            $tmp                 .= '<option value="1">'.$langs->trans('Oui').'</option>';
                            $tmp                 .= '<option value="0">'.$langs->trans('Non').'</option>';
                            $tmp                 .= '</select>';
                            $objp->imap_ssl      = $tmp;

                            $tmp                            = '<select name="imap_ssl_novalidate_cert[]" >';
                            $tmp                            .= '<option value="1">'.$langs->trans('Oui').'</option>';
                            $tmp                            .= '<option value="0">'.$langs->trans('Non').'</option>';
                            $tmp                            .= '</select>';
                            $objp->imap_ssl_novalidate_cert = $tmp;

                            if ($conf->dmsmtpconfig && $conf->dmsmtpconfig->enabled) {
                                $objp->smtp_server    = '<input size="30" type="text" class="flat" name="smtp_server[]" value="">';
                                $objp->smtp_port      = '<input size="30" type="number" class="flat" name="smtp_port[]" value="">';
                                $objp->smtps_id       = '<input size="30" type="text" class="flat" name="smtps_id[]" value="">';
                                $objp->smtps_pw       = '<input size="30" type="password" class="flat" name="smtps_pw[]" value="">';
                                $tmp                  = '<select name="email_tls[]" >';
                                $tmp                  .= '<option value="1">'.$langs->trans('Oui').'</option>';
                                $tmp                  .= '<option value="0">'.$langs->trans('Non').'</option>';
                                $tmp                  .= '</select>';
                                $objp->email_tls      = $tmp;
                                $tmp                  = '<select name="email_starttls[]" >';
                                $tmp                  .= '<option value="1">'.$langs->trans('Oui').'</option>';
                                $tmp                  .= '<option value="0">'.$langs->trans('Non').'</option>';
                                $tmp                  .= '</select>';
                                $objp->email_starttls = $tmp;
                                $objp->smtp_from      = '<input size="30" type="text" class="flat" name="smtp_from[]" value="">';
                            }
                            $this->listing[] = $objp;
                        }
                    } elseif ($this->listing === array()) {
                        Header("location: ".dol_buildpath('/framework/tabs/generic.php', 1).'?mod=dolmessage&tab=user&id='.$this->object->id.'&action=edit');
                        exit;
                    }
            }
        }

        return 1;
    }

    /**
      @fn Display()
      @brief
      @param
      @return
     */
    public function _PrevBanner()
    {

        global $langs, $conf, $user, $hookmanager;

        global $formfile, $form;


        $db     = $this->db;
        $object = $this->object;

        if ($this->GetParams('action') == 'alertgreffon') print FormAlertGreffon(GETPOST('greffon'), 'dolmessage');
    }

    /**
      @fn Display()
      @brief
      @param
      @return
     */
    public function _Display()
    {
        global $langs, $conf, $user, $hookmanager;
        global $formfile, $form;




        $user = new User($user->id);

        $db     = $this->db;
        $object = $this->object;

        if ($msg) print '<div class="error">'.$msg.'</div>';

        print '<form method="post" action="'.dol_buildpath('/framework/tabs/generic.php', 1).'?mod=dolmessage&tab=user'.'">';
        print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
        print '<input type="hidden" name="id" value="'.$this->object->id.'">';
        print '<input type="hidden" name="mailboxuserid" value="'.$this->object->id.'">';
        print '<input type="hidden" name="action" value="update">';




        foreach ($this->listing as $objp) {

            $object->number                   = $objp->number;
            $object->title                    = $objp->title;
            $object->imap_login               = $objp->imap_login;
            $object->imap_password            = $objp->imap_password;
            $object->imap_host                = $objp->imap_host;
            $object->imap_port                = $objp->imap_port;
            $object->imap_ssl                 = $objp->imap_ssl;
            $object->imap_ssl_novalidate_cert = $objp->imap_ssl_novalidate_cert;

            if ($conf->dmsmtpconfig && $conf->dmsmtpconfig->enabled) {
                $object->smtp_server    = $objp->smtp_server;
                $object->smtp_port      = $objp->smtp_port;
                $object->smtps_id       = $objp->smtps_id;
                $object->smtps_pw       = $objp->smtps_pw;
                $object->email_tls      = $objp->email_tls;
                $object->email_starttls = $objp->email_starttls;
                $object->smtp_from      = $objp->smtp_from;
            }


            print '<table class="border" width="100%">';


            print '<tr><td>'.$langs->trans("DolMessageUserMailBoxNumber").'</td><td class="valeur" colspan="3">'.$object->number.'</td>';


            if (isset($objp->rowid)) {
                print '<td rowspan="8"  width="20%" align="center">';
                $buttons = array(
                    'validate' => array(
                        'print' => '<a class="butAction" href="'.GetLinkExtendsGreffon('mod='.GETPOST('mod').'&tab='.GETPOST('tab').'&id='.$this->object->id.'&greffon=dmadvancedconfig').'">'.$langs->trans('ValidateMailbox').'</a><br /><br />'
                    )
                    , 'avancedsetups' => array(
                        'print' => '<a class="butAction" href="javascript:alert(\'Available soon\');"><strike>'.$langs->trans('AvancedSetups').'</strike></a><br /><br />'
                    )
                    , 'delete' => array(
                        'print' => '<a class="butActionDelete" href="'.dol_buildpath('/framework/tabs/generic.php', 1).'?mod=dolmessage&tab=user&action=delete&id='.$this->object->id.'&userbox='.$objp->rowid.'">'.$langs->trans('DeleteThisMailBox').'</a>'
                    )
                );



                $parameters = array('buttons' => $buttons, 'objp' => $objp);
                $reshook    = $hookmanager->executeHooks('addMoreActionsButtons', $parameters, $this->object);    // Note that $action and $object may have been modified by hook
                if ($reshook || version_compare($conf->global->MAIN_VERSION_LAST_INSTALL, '5.0', '<='))
                        print $hookmanager->resPrint;
                else foreach ($buttons as $k => $v)
                        echo $v['print'];

                print '</td>';
            }
            print '</tr>';


            print '<tr><td width="25%">'.$langs->trans("DolMessageUserMailBoxName").'</td><td class="valeur" colspan="3">';
            print $object->title.'&nbsp;';
            print '</td></tr>';

            print '<tr><td></td><td class="valeur" colspan="3"></td></tr>';

            print '<tr><td>'.$langs->trans("IMAP_Login").'</td><td class="valeur" colspan="3">';
            print $object->imap_login.'&nbsp;';
            print '</td></tr>';
            print '<tr><td>'.$langs->trans("IMAP_Password").'</td><td class="valeur" colspan="3">';
            print $object->imap_password;
            print '</td></tr>';
            print '<tr><td>'.$langs->trans("IMAP_Server").'</td><td class="valeur" colspan="3">';
            print $object->imap_host.'&nbsp;';
            print '</td></tr>';
            print '<tr><td>'.$langs->trans("IMAP_Port").'</td><td class="valeur" colspan="3">';
            print $object->imap_port.'&nbsp;';
            print '</td></tr>';
            print '<tr><td>'.$langs->trans("IMAP_SSL").'</td><td class="valeur" colspan="3">';
            echo $object->imap_ssl;
            print '</td></tr>';
            print '<tr><td>'.$langs->trans("IMAP_SSL_NOVALIDATE_CERT").'</td><td class="valeur" colspan="3">';
            echo $object->imap_ssl_novalidate_cert;
            print '</td></tr>';
            if ($conf->dmsmtpconfig && $conf->dmsmtpconfig->enabled) {
                print '<tr><td></td><td class="valeur" colspan="3"></td></tr>';

                print '<tr><td>'.$langs->trans("SMTP_Server").'</td><td class="valeur" colspan="3">';
                echo $object->smtp_server;
                print '</td></tr>';

                print '<tr><td>'.$langs->trans("SMTP_Port").'</td><td class="valeur" colspan="3">';
                echo $object->smtp_port;
                print '</td></tr>';

                print '<tr><td>'.$langs->trans("SMTP_User").'</td><td class="valeur" colspan="3">';
                echo $object->smtps_id;
                print '</td></tr>';

                print '<tr><td>'.$langs->trans("SMTP_Paswword").'</td><td class="valeur" colspan="3">';
                echo $object->smtps_pw;
                print '</td></tr>';

                print '<tr><td>'.$langs->trans("Email_TLS").'</td><td class="valeur" colspan="3">';
                echo $object->email_tls;
                print '</td></tr>';

                print '<tr><td>'.$langs->trans("Email_StartTLS").'</td><td class="valeur" colspan="3">';
                echo $object->email_starttls;
                print '</td></tr>';

                print '<tr><td>'.$langs->trans("SMTP_From").'</td><td class="valeur" colspan="3">';
                echo $object->smtp_from;
                print '</td></tr>';
            }
            print '</table><hr style="margin:20px 0">';


            $i++;
        }

        if (!CheckStateMod('dmmultibox') || $i >= 1)
                print '<a class="butAction" href="'.GetLinkExtendsGreffon('mod='.GETPOST('mod').'&tab='.GETPOST('tab').'&id='.$this->object->id.'&greffon=dmmultibox').'">'.$langs->trans('AddOtherMailBox').'</a><br /><br />';



        if ($this->GetParams('action') == 'edit') {
            print '<div class="tabsAction">';
            print '<input type="submit" class="butAction" name="update" value="'.$langs->trans("Save").'">';
            print '&nbsp; &nbsp;';
            print '<input type="submit" class="butAction" name="cancel" value="'.$langs->trans("Cancel").'">';
            print "</div>";
        }

        print "</form>\n";


        /*
         * Actions
         */
        print '</div>';
        print '<div class="tabsAction">';

        if (/* ($user->rights->configuration->modifier || $user->admin) && */ $this->GetParams('action') != 'edit') {
            print "<a class=\"butAction\" href=\"".dol_buildpath('/framework/tabs/generic.php', 1)."?mod=dolmessage&tab=user&id=".$this->object->id."&amp;action=edit\">".$langs->trans('Modify')."</a>";
        }

        print "</div>";


        return false;
    }
}