<?php
/* Copyright (C) 2014 Oscim 	<support@oscim.fr>
 * Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       dev/skeletons/skeleton_page.php
 * 		\ingroup    mymodule othermodule1 othermodule2
 * 		\brief      This file is an example of a php page
 * 					Put here some comments
 */

namespace CORE;

// Change this following line to use the correct relative path (../, ../../, etc)
$res = 0;
if (!$res && file_exists("../main.inc.php")) $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php")) $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php")) $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php")) $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
        $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res) die("Include of main fails");

/**
  @brief Call Specific Class provider for OScssShop Exts
  This class garanted process for dolibarr evolution
 */
dol_include_once('/framework/main.inc.php');
dol_include_once('/framework/core/lib/framework.lib.php');


loadClass("Societe");
loadClass("Form", 'html.form');

namespace CORE\DOLMESSAGE;

use \CORE\FRAMEWORK\Societe as Societe;
use \CORE\FRAMEWORK\Form as Form;
use \Dolimap;
use \dolmessage;
use \ActionCommDolMessage;

require_once(DOL_DOCUMENT_ROOT."/core/lib/agenda.lib.php");

dol_include_once('dolmessage/class/connector/dolimap.class.php');
dol_include_once('dolmessage/class/connector/dollocalmessage.class.php');
dol_include_once('dolmessage/class/actioncomm.dolmessage.class.php');
dol_include_once('dolmessage/core/lib/message.lib.php');


// Required
// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("other");
$langs->load("dolmessage@dolmessage");
$langs->load("agenda");

global $conf;
// if ($conf->global->PAGINATION_WEBMAIL) 
if (empty($conf->global->DOLMESSAGE_DISPLAYINLISTING)) $pagination = 25; // $conf->global->PAGINATION_WEBMAIL;
else $pagination = 10;



// set default folder 
if (GETPOST('folder') == '') {
    Header("location: ".dol_buildpath('/dolmessage/synchro.php', 1).'?number='.GETPOST('number').'&folder=INBOX&num_page='.GETPOST('num_page').'&identifiid='.GETPOST('identifiid').'&search='.GETPOST('search'));
}

$num_page   = GETPOST('num_page');
if (empty($num_page)) $num_page   = 1;
// Get parameters
$id         = GETPOST('id', 'int');
$uid        = GETPOST('uid', 'int');
$number     = GETPOST('number', 'int');
$action     = GETPOST('action', 'alpha');
$folder     = addslashes(urldecode(GETPOST('folder', 'alpha')));
$identifiid = (int) GETPOST('identifiid', 'int');
$massaction = GETPOST('massaction');

// Protection if external user
if ($user->societe_id > 0) {
    //accessforbidden();
}
$hookmanager->initHooks(array('dolmessage', 'greffon'));



$object  = $dolimap = new dolimap($db, $user);
if (empty($identifiid)) $dolimap->SetUser($user->id, $number);
elseif (!empty($identifiid)) $dolimap->SetUserGroup($identifiid, $number);

$form = new Form($db);




// Definition of fields for list
$arrayfields = $sort        = array();
foreach ($dolimap->fields as $key => $val) {
    // If $val['visible']==0, then we never show the field
    if (!empty($val['visible'])) {
        $arrayfields[$key]        = array(
            'label' => $langs->trans($val['label'])
            , 'checked' => (($val['visible'] < 0) ? 0 : 1)
            , 'enabled' => $val['enabled']
            , 'grp' => $val['grp']
        );
        $sort[$val['position']][] = $key;
    }
}
// Extra fields
// if (is_array($extrafields->attribute_label) && count($extrafields->attribute_label))
// {
//     foreach($extrafields->attribute_label as $key => $val)
//     {
//         $arrayfields["ef.".$key]=array('label'=>$extrafields->attribute_label[$key], 'checked'=>$extrafields->attribute_list[$key], 'position'=>$extrafields->attribute_pos[$key], 'enabled'=>$extrafields->attribute_perms[$key]);
//     }
// }
$parameters = array('arrayfields' => $arrayfields);
$reshook    = $hookmanager->executeHooks('addArrayFields', $parameters);    // Note that $action and $object may have been modified by hook



foreach ($hookmanager->resArray as $k => $val)
    if (!empty($val['visible'])) {
        $arrayfields[$k]          = array(
            'label' => $langs->trans($val['label'])
            , 'checked' => (($val['visible'] < 0) ? 0 : 1)
            , 'enabled' => $val['enabled']
            , 'grp' => $val['grp']
            , 'css' => $val['css']
        );
        $sort[$val['position']][] = $k;
    }


$arrayfieldsold  = $arrayfields;
$arrayfields     = array();
// sort array 
foreach ($sort as $g => $s)
    foreach ($s as $p => $k)
        $arrayfields[$k] = $arrayfieldsold[$k];



// Selection of new fields
include DOL_DOCUMENT_ROOT.'/core/actions_changeselectedfields.inc.php';

$message = '';

$lbl_folder = array_reverse(explode('/', $folder));
$lbl_folder = str_replace($user->imap_ref, '', str_replace('INBOX.', '', $lbl_folder[0]));




if (!empty($massaction)) {


    switch ($massaction) {
        case 'delete':

            $dolimap->Open();
            $mbox = $dolimap->GetImap();

            if ($mbox === false) {
                foreach ($dolimap->ListErrors() as $row)
                    $err .= $row;
            }

            foreach ($_POST['toselect'] as $k => $uid) {

                $Message = LoadMessage(@$id, $uid, $dolimap);

                if (get_class($Message) == 'dollocalmessage') {
                    $r = $Message->delete(GETPOST('identifiid'), $number, $Message);
                } elseif (get_class($Message) == 'dolimapmessage') {
                    $r = $Message->delete($Message, $number, $dolimap);
                }
            }

            break;
    }
} elseif (GETPOST('reference_mail_uid') && GETPOST('reference_rowid') && GETPOST('reference_type_element')) {


    $type_element = GETPOST('reference_type_element');

    $uid          = GETPOST('reference_mail_uid');
    $linkedobject = array();
    $dolimap->Open(GETPOST('folder'));
    $mbox         = $dolimap->GetImap();



    if (FALSE === $mbox) {
        foreach ($dolimap->ListErrors() as $row)
            $err .= $row;
    } else {
        $Message = $dolimap->GetMessage($uid);
    }


//             $header = $Message->GetHeader();
    $message_id = $Message->GetMessageId();

    if (GETPOST('reference_fk_socid', 'int') > 0) {
        $societe = new Societe($db);

        $societe->fetch(GETPOST('reference_fk_socid', 'int'));

        $upload_dir = $conf->societe->multidir_output[$societe->entity]."/".$societe->id;

        if (!file_exists($upload_dir)) dol_mkdir($upload_dir);


        $upload_dir .= '/message/';

        if (!file_exists($upload_dir)) dol_mkdir($upload_dir);


        $linkedobject['societe'] = $societe->id;
    }

// var_dump($Message->GetUid()); 
// exit; 
    $DolMessage = $Message->CopyMessage($db, $mbox, $uid, $message_id, $upload_dir, $linkedobject, $number, $identifiid);

// print_r($_POST); 
// // var_dump($DolMessage); 
// exit; 

    if (!empty($type_element)) {
        $upload_dir = $conf->$type_element->dir_output."/".GETPOST('reference');
        if ($type_element != 'societe') {
            // rattrapage nom
            $type_element = ($type_element == 'projet') ? 'project' : $type_element;
            $db->query("INSERT INTO `".MAIN_DB_PREFIX."element_element` ( `fk_source`, `sourcetype`, `fk_target`, `targettype`) VALUES ( '".GETPOST('reference_rowid')."', '$type_element', '".$DolMessage->id."', 'dolmessage')");
        }
        if (!file_exists($upload_dir)) dol_mkdir($upload_dir);


        $upload_dir .= '/message/';
        if (!file_exists($upload_dir)) dol_mkdir($upload_dir);
        $Message->CopyFile($mbox, $uid, $message_id, $upload_dir);
    }


    if (GETPOST('addincal', 'int') > 0) {
        $ActionCommDolMessage = new ActionCommDolMessage($db);
        $ActionCommDolMessage->SetEvent($user, $societe, $DolMessage, $Message);
    }

    if (GETPOST('addintaskin', 'int') > 0) {

    }

    $action     = 'linkto';
    $parameters = array('mail' => $Message);
    $reshook    = $hookmanager->executeHooks('doActions', $parameters);    // Note that $action and $object may have been modified by hook
// 		if($reshook && version_compare(DOL_VERSION , '5.0', '>=')){
// 
// 				$output['result'] = $hookmanager->resArray;
// 		}
// 		else 
// 				$output['result'] = $ligne;
// 					



    if (GETPOST('ajax', 'int') > 0) {

        $Message = LoadMessage($id, $uid, $dolimap);
//             if($group_id > 0 && $dolmess->fetch(0, $mail->message_id, false, $this->user->number, $group_id) == false) {
//                 $dolmess->specimen();
//                 $dolmess->uid = $mails[$i]->uid;
//             }
//             elseif ( $group_id ==  0 && $dolmess->fetch(0, $mail->message_id, false, $this->user->number) == false) {
//                 $dolmess->specimen();
//                 $dolmess->uid = $mails[$i]->uid;
//             }
// 
//             $mails[$i]->id = $dolmess->id;
//             $mails[$i]->uid = $dolmess->uid;
//             $mails[$i]->linkedObjects = $dolmess->linkedObjects;




        $ligne['position'] = GETPOST('position', 'int'); //($pagination * ( $num_page - 1 ) ) + ($pagination - $nbr_mess);
        $ligne['seen']     = (!$Message->GetUnseen() ? 'seen ' : 'unseen ');

        $ligne['linked'] = ( (count($Message->GetLinked()) > 0) ? img_picto('sync', 'sync@dolmessage') : '&nbsp;' );



        $ligne['answered'] = ( ($Message->GetAnswered()) ? img_picto('answered', 'answered@dolmessage') : '&nbsp;' );


        $from           = '';
        $certifiedEmail = in_array($Message->GetFromMail(), $knownEmails) ? ' '.img_object($langs->trans('KnownEmail'),
                'opensurvey', ' style="vertical-align:middle"') : '';
        if (count($Message->GetLinked()) > 0) {
            $from .= '<span>';
            $base = $Message->GetLinked();

            foreach ($base as $type => $list)
                foreach ($list as $obj)
                    if (in_array($type, array('societe'))) {
                        $from .= $obj->getNomUrl(1, '', 16);
                    } elseif (in_array($type, array(/* 'societe', */'contact'))) {
                        dol_include_once('/'.$type.'/class/'.$type.'.class.php');
                        $class  = ucwords($type);
                        $subobj = new Contact($db);
                        $subobj->fetch(GETPOST('reference_rowid', 'int'));
                        $from   .= $obj->getNomUrl(1, '', 16);
                    }
            $from .= '</span>'.$Message->GetFromName().' &lt;'.$Message->GetFromMail().'&gt;'.$certifiedEmail;
        } else { // from imap
            $from .= '<span>'.$Message->GetFromMail().$certifiedEmail.'</span>'.$Message->GetFromName();
        }

        $ligne['to'] = $from.$certifiedEmail;



        $ligne['object'] = $Message->getNomUrl(0, 'dolmessage', 0,
            'number='.GETPOST('number').'&identifiid='.GETPOST('identifiid').'&folder='.urlencode(GETPOST('folder')));

        $ligne['date']  = '<span>'.dol_print_date(strtotime($Message->GetDate()), 'dayhoursec').'</span>'.$Message->GetDate(true);
        $ligne['heure'] = dol_print_date(strtotime($Message->GetDate()), 'dayhoursec');

        $ligne['size'] = $Message->GetSize(true);

        $ligne['flagged'] = ( ($Message->GetFlagged()) ? img_picto('flagged', 'flagged@dolmessage') : img_picto('unflagged',
                'unflagged@dolmessage') );



        $out  = '';
        $form = '';

        $form .= '<form class="attachlink" name="link_'.$i.'" method="POST">';

        $form .= '<table class="linkTable"><tr><td>';
        $form .= '<span class="expend"><span class="ui-icon ui-icon-triangle-1-s"></span></span>';

        $form .= '<div class="listopt">';
        // mets ici tes champs de recherche
        $form .= $langs->trans('DolmessageAddInCal').'<input name="addincal" type="checkbox"  placeholder="'.$langs->trans('Sender').'" value="1" checked="checked"  /><br /><br />';
        $form .= '</div>';
        $form .= '</td><td>';
// 								if ($conf->use_javascript_ajax)
        $out  .= ajax_multiautocompleter('reference_'.$i,
                array('reference_folder_'.$i, 'reference_rowid_'.$i, 'reference_type_element_'.$i, 'reference_fk_socid_'.$i),
                dol_buildpath('/dolmessage/core/ajax/ajax.php', 1), 'num_ligne='.$i.'&action=ownerlink')."\n";

        $out  .= '<input id="reference_'.$i.'" type="text" name="reference" value="';
        $form .= $out.'">'."\n";
        $form .= '<input class="reference_rowid" id="reference_rowid_'.$i.'" type="hidden" name="reference_rowid" value="'.'">'."\n";
        $form .= '<input id="reference_type_element_'.$i.'" type="hidden" name="reference_type_element" value="'.'">'."\n";
        $form .= '<input id="reference_fk_socid_'.$i.'" type="hidden" name="reference_fk_socid" value="'.'">'."\n";
        $form .= '<input id="reference_mail_uid_'.$i.'" type="hidden" name="reference_mail_uid" value="'.$Message->GetUid().'">'."\n";
        $form .= '<input id="reference_folder_'.$i.'" type="hidden" name="reference_folder" value="'.GETPOST('folder').'">'."\n";

        if (GETPOST('identifiid') > 0)
                $form .= '<input  type="hidden" name="identifiid" value="'.GETPOST('identifiid').'">'."\n";

        $form .= '<input  type="hidden" name="folder" value="'.GETPOST('folder').'">'."\n";
        $form .= '<input  type="hidden" name="num_page" value="'.GETPOST('num_page').'">'."\n";
        $form .= '<input  type="hidden" name="number" value="'.GETPOST('number').'">'."\n";
        $form .= '</td><td>';
        $form .= '<a class="linktobt" href="javascript:ProcessForm('.$i.');" onclick="ProcessForm('.$i.'); ">';
        $form .= img_picto('attacher', 'lock');
        $form .= '</a>';
        $form .= '</td></tr></table>';
        $form .= '</form>';

        $ligne['form'] = $form;




        $parameters = array('mail' => $Message, 'ligne' => $ligne);
        $reshook    = $hookmanager->executeHooks('printFieldListValue', $parameters);    // Note that $action and $object may have been modified by hook


        if ($reshook && version_compare(DOL_VERSION, '5.0', '>=')) {

            $output['result'] = $hookmanager->resArray;
        } else $output['result'] = $ligne;


        header('Content-Type: application/json');
        print json_encode($output);
    } else
            Header("location: ".dol_buildpath('/dolmessage/synchro.php', 1).'?number='.GETPOST('number').'&folder='.GETPOST('folder').'&num_page='.GETPOST('num_page').'&identifiid='.GETPOST('identifiid'));


    exit;
}



/* * *************************************************
 * VIEW
 *
 * Put here all code to build page
 * ************************************************** */


$s = "var DOLMESSAGE_DISPLAYSPLITPAGE ='".(int) $conf->global->DOLMESSAGE_DISPLAYSPLITPAGE."';";
$s .= "var pagination = '".(int) $pagination."'; ";
$s .= "var DOLMESSAGE_LINKTOBYAJAX = '".(int) $conf->global->DOLMESSAGE_LINKTOBYAJAX."'; ";
$s .= "var DOLMESSAGE_DISPLAYINLISTING = '".(int) $conf->global->DOLMESSAGE_DISPLAYINLISTING."'; ";
$s .= "var PHP_SELF = '".$_SERVER["PHP_SELF"]."'; ";
$s .= "var ajaxpath = '".dol_buildPath('/dolmessage/core/ajax/ajax.php?number='.$number.'&folder='.$folder.'&identifiid='.$identifiid,
        2)."'; ";
$s .= "var loadingGif = '".img_picto('Loading', 'loading.gif@dolmessage')."'; ";
$s .= "var num_page = '".$num_page."'; ";
$s .= "var action= 'listimap'; ";


$morejs = array("/dolmessage/core/js/dolmessage.js", "/dolmessage/core/js/dolmessage.config.js.php");

llxHeader(
    '',
    iconv(iconv_get_encoding($langs->trans($lbl_folder)), $character_set_client."//TRANSLIT",
        $langs->trans(preg_replace('/\\{.*\\}/', '', utf8_encode($lbl_folder)))), '', '', '', '',
    $morejs
);
?>
<script type="text/javascript">
<?php echo $s ?>
</script>
<?php
dol_fiche_head(
    message_prepare_head(), 'synchro_'.(int) GETPOST('number').'_'.(int) $identifiid, $langs->trans("Dolmessage"), 0,
    'mailbox@dolmessage'
);


dol_include_once('/dolmessage/tpl/synchro2.list.tpl');


$dolimap->Close();
?>
<script type="text/javascript">

    // construct ligne of data in table
    function ProcessLigne(item, parity) {
        if (parity) {
            parityClass = 'pair';
        } else {
            parityClass = 'impair';
        }


        var row = '<tr class="messages inload ' + parityClass + ' ' + item.seen + '" id="' + item.position + '">'
                + '<td align="center"><table><tr>'

<?php if (!empty($arrayfields['linked']['checked'])): ?>
            + '<td align="center" width="16">' + item.linked + '</td>'
<?php endif; ?>
<?php if (!empty($arrayfields['answered']['checked'])): ?>
            + '<td align="center" width="16">' + item.answered + '</td>'
<?php endif; ?>
<?php if (!empty($arrayfields['flagged']['checked'])): ?>
            + '<td align="center" width="16">' + item.flagged + '</td>'
<?php endif; ?>
<?php if (!empty($arrayfields['cacheattachments']['checked'])): ?>
            + '<td align="center" width="16">' + item.cacheattachments + '</td>'
<?php endif; ?>

        + '</tr></table></td>';

<?php foreach ($arrayfields as $k => $data): ?>
    <?php if (!empty($arrayfields[$k]['checked']) && empty($arrayfields[$k]['grp']) && $k == 'object' && (int) $conf->global->DOLMESSAGE_DISPLAYINLISTING
        == 1): ?>
                var tmphref = $(item.<?php echo $k ?>).attr('href');
                row += '<td class="col<?php
        echo $k.' ';
        if (in_array($k, array('to', 'date'))) echo 'hiddenInfo'
            ?>" <?php if (!empty($data['css'])) echo 'style="'.$data['css'].'"' ?> ><a href="' + tmphref + '" target="_blank" style="float:left;height: 35px;line-height: 35px;"><?php echo img_picto($langs->trans('ShowFullScreen'),
            'uparrow'); ?>&nbsp;</a>' + item.<?= $k ?> + '</td>'
    <?php elseif (!empty($arrayfields[$k]['checked']) && empty($arrayfields[$k]['grp'])): ?>
                row += '<td class="col<?php
        echo $k.' ';
        if (in_array($k, array('to', 'date'))) echo 'hiddenInfo'
            ?>" <?php if (!empty($data['css'])) echo 'style="'.$data['css'].'"' ?> >' + item.<?= $k ?> + '</td>'
    <?php endif; ?>
<?php endforeach; ?>


        row += '<td><input id="cb' + item.uid + '" class="flat checkforselect" type="checkbox" name="toselect[]" value="' + item.uid + '" ></td>'
                + '</tr>';


        return row;
    }


    $(document).ready(function () {

        $('#dolmess_search').Loader();


        $('#FolderList').ListFolder(ajaxpath);

    });

</script>
<?php
$parameters = array('arrayfields' => $arrayfields, 'sql' => $sql);
$reshook    = $hookmanager->executeHooks('printFieldListFooter', $parameters);    // Note that $action and $object may have been modified by hook
print $hookmanager->resPrint;
// End of page
llxFooter();

$db->close();
