<?php
/* Copyright (C) 2014 Oscim 	<support@oscim.fr>
 * Copyright (C) 2015 Oscss-Shop Team <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
global $form, $db, $knownEmails, $bodyContent, $to, $to2, $cc, $cci, $subject, $trackid, $formmail, $hookmanager;
$hookmanager->initHooks(array('dolmessage', 'greffon'));
?>
<form method="POST" id="mailform">
    <input type="hidden" name="trackid" id="trackid" value="<?php echo $trackid ?>" />
    <?php
    if (GETPOST('action') == 'reply') print '<input type="hidden" name="replyto" value="'.GETPOST('uid').'" />';

    $formmail->fetchAllEMailTemplate('dolmessage', $user, $langs);
    $modelmail_array = array();
    foreach ($formmail->lines_model as $line) {
        $modelmail_array[$line->id] = $line->label." ($line->topic)";
    }
    $out = '';
    // Zone to select its email template
    if (count($modelmail_array) > 0) {
        $out .= '<div class="center" style="padding: 0px 0 12px 0">'."\n";
        $out .= $langs->trans('SelectMailModel').': '.$formmail->selectarray('modelmailselected', $modelmail_array, 0, 1);
        if ($user->admin) $out .= info_admin($langs->trans("YouCanChangeValuesForThisListFrom", $langs->transnoentitiesnoconv('Setup').' - '.$langs->transnoentitiesnoconv('EMails')), 1);
        $out .= ' &nbsp; ';
        $out .= '<input class="button" type="submit" value="'.$langs->trans('Apply').'" name="modelselected" id="modelselected">';
        $out .= ' &nbsp; ';
        $out .= '</div>';
    }
    else {
        $out .= '<div class="center" style="padding: 0px 0 12px 0">'."\n";
        $out .= $langs->trans('SelectMailModel').': <select name="modelmailselected" disabled="disabled"><option value="none">'.$langs->trans("NoTemplateDefined").'</option></select>';    // Do not put disabled on option, it is already on select and it makes chrome crazy.
        if ($user->admin) $out .= info_admin($langs->trans("YouCanChangeValuesForThisListFrom", $langs->transnoentitiesnoconv('Setup').' - '.$langs->transnoentitiesnoconv('EMails')), 1);
        $out .= ' &nbsp; ';
        $out .= '<input class="button" type="submit" value="'.$langs->trans('Apply').'" name="modelselected" disabled="disabled" id="modelselected">';
        $out .= ' &nbsp; ';
        $out .= '</div>';
    }
    print $out;
    ?>
    <script>
        $(document).ready(function () {
            Vue.component("v-select", VueSelect.VueSelect);

            new Vue({
                el: "#app",
                data: {
                    to: [],
                    cc: [],
                    cci: [],
                    options: [<?php
    foreach ($knownEmails as $key => $value) {
        echo "{email: '".dol_escape_js($key)."', thirdparty: '".dol_escape_js($value)." <".dol_escape_js($key).">'},";
    }
    ?>
                    ]
                },
                methods: {
                    saveTo: function (z) {
                        $('#to').val(this.to.map(function (a) {
                            return a.email;
                        }).join(','));
                    },
                    saveCc: function (z) {
                        $('#cc').val(this.cc.map(function (a) {
                            return a.email;
                        }).join(','));
                    },
                    saveCci: function (z) {
                        $('#cci').val(this.cci.map(function (a) {
                            return a.email;
                        }).join(','));
                    }
                }
            });
        });
    </script>
    <table id="app" class="border" width="100%">
        <tr>
            <td width="320px" class="text-right"><?= $langs->trans("DolmessagelSender") ?></td>
            <td colspan="2"><select name="frommail"  readonly="readonly" class="fullInputs">
                    <?php
                    if (($user->email) != '') {
                        $emailSender = (($user->firstname) ? $user->firstname.' ' : '').$user->lastname.'<'.($user->email).'>';
                        ?>
                        <option value="<?= $emailSender ?>"><?= htmlentities($emailSender) ?></option>
                        <?php
                    }
                    $emailSender = (($user->firstname) ? $user->firstname.' ' : '').$user->lastname.'<'.(!empty($conf->global->MAIN_MAIL_EMAIL_FROM) ? $conf->global->MAIN_MAIL_EMAIL_FROM : $langs->trans("NoEmailInSetup")).'>'
                    ?>
                    <option value="<?= $emailSender ?>"><?= htmlentities($emailSender) ?></option>
                </select></td>
        </tr>
        <tr>
            <td class="text-right"><strong><?= $langs->trans("DolmessagelRecipiant") ?></strong></td>
            <td colspan="2"><?php
//                print $form->multiselectarray('to', $knownEmails, $to, 1, 0, '', 0, '100%',
//                        'placeholder="'.$langs->trans('ChooseEmailInDolibarr').'" size="1"');
                ?>


        <v-select placeholder="Choisir un email ou saisissez le" v-model="to" @input="saveTo" class="fullInputs" style="width:100%" label="thirdparty" :options="options" taggable multiple ></v-select>
        <input type="hidden" id="to" name="to" value="" />
        </td>
        </tr>
        <tr>
            <td class="infoMessage"><?= $langs->trans("DolmessagelCopyRecipiant") ?></td>
            <td colspan="2"><?php
//                print $form->multiselectarray('cc', $knownEmails, $cc, 1, 0, '', 0, '100%',
//                        'placeholder="'.$langs->trans('ChooseEmailInDolibarr').'" size="1"');
                ?>
        <v-select placeholder="Choisir un email ou saisissez le" v-model="cc" @input="saveCc" class="fullInputs" style="width:100%" label="thirdparty" :options="options" taggable multiple ></v-select>
        <input type="hidden" id="cc" name="cc" value="" />
        </tr>
        <tr>
            <td class="infoMessage"><?= $langs->trans("DolmessagelCopyHydden") ?></td>
            <td colspan="2"><?php
//                print $form->multiselectarray('cci', $knownEmails, $cci, 1, 0, '', 0, '100%',
//                        'placeholder="'.$langs->trans('ChooseEmailInDolibarr').'" size="1"');
                ?>
        <v-select placeholder="Choisir un email ou saisissez le" v-model="cci" @input="saveCci" class="fullInputs" style="width:100%" label="thirdparty" :options="options" taggable multiple ></v-select>
        <input type="hidden" id="cci" name="cci" value="" />
        </td>
        </tr>
        <tr>
            <td class="text-right"><strong><?= $langs->trans("DolmessagelLinked") ?></strong></td>
            <td colspan="2"><?php
                $form        = '';

                $out = ajax_multiautocompleter('reference_0', array('reference_folder_0', 'reference_rowid_0', 'reference_type_element_0', 'reference_fk_socid_0'),
                        dol_buildpath('/dolmessage/core/ajax/ajax.php', 1), 'num_ligne=0&action=ownerlink')."\n";

                $out        .= '<input id="reference_0" type="text" name="reference" value="';
                $form       .= $out.'">'."\n";
                $form       .= '<input id="reference_rowid_0" type="hidden" name="reference_rowid" value="'.'">'."\n";
                $form       .= '<input id="reference_type_element_0" type="hidden" name="reference_type_element" value="'.'">'."\n";
                $form       .= '<input id="reference_fk_socid_0" type="hidden" name="reference_fk_socid" value="'.'">'."\n";
                echo $form;
                ?></td>
        </tr>
        <tr>
            <td class="text-right"><strong><?= $langs->trans("DolmessagelSubject") ?></strong></td>
            <td colspan="2"><input name="subject" class="fullInputs" value="<?= $subject ?>" /></td>
        </tr>

        <tr>
            <td class="text-right"><?= $langs->trans("VotreMessage") ?>
            </td>
            <td colspan="2"><?php
                $doleditor  = new DolEditor('bodyMessage', $bodyContent, '100%', 400, 'full', '', true, true, $conf->global->FCKEDITOR_ENABLE_SOCIETE, 10, 80);
                $doleditor->Create();
                ?>
            </td>
            <!-- td>
                <select id="substit" name="substit">
                    <option value="">__FACREF__</option>
                </select>
                <script>
    
                </script>
            </td -->
        </tr>
        <?php
        $parameters = array();
        $reshook    = $hookmanager->executeHooks('printGreffonGED', $parameters);    // Note that $action and $object may have been modified by hook
        if ($reshook) {
            print $hookmanager->resPrint;
        }
        ?>
        <tr>
            <td></td>
            <td colspan="2"><button type="submit" name="action" class="butAction" value="send" ><?= $langs->trans("DolmessagelSendEmail") ?></button></td>
        </tr>
    </table>
</form>