<?php
/* References letters
 * Copyright (C) 2014  HENRY Florian  florian.henry@open-concept.pro
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *	\file		index.php
 *	\ingroup	referenceletters
 *	\brief		index page
 */

// Load environment
$res = 0;
if (! $res && file_exists("../main.inc.php")) {
	$res = @include("../main.inc.php");
}
if (! $res && file_exists("../../main.inc.php")) {
	$res = @include("../../main.inc.php");
}
if (! $res && file_exists("../../../main.inc.php")) {
	$res = @include("../../../main.inc.php");
}
if (! $res) {
	die("Main include failed");
}

dol_include_once('/referenceletters/core/boxes/box_referenceletter_models.php');
dol_include_once('/referenceletters/core/boxes/box_referenceletter_models_archive.php');
dol_include_once('/referenceletters/core/boxes/box_referenceletter_elements.php');

// Access control
// Restrict access to users with invoice reading permissions
restrictedArea($user, 'referenceletters');
if ($user->societe_id > 0) {
	accessforbidden();
}


// Load translation files required by the page
$langs->load("referenceletters@referenceletters");


/*
 * VIEW
*/
$title = $langs->trans('Module103258Name');

llxHeader('',$title);

$box = new box_referenceletter_models($db);

$box->loadBox();
$box->showBox();

$box = new box_referenceletter_elements($db);

$box->loadBox();
$box->showBox();

$box = new box_referenceletter_models_archive($db);

$box->loadBox();
$box->showBox();

// Page end
llxFooter();
$db->close();