<?php
	/************************************************
	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspackplus/admin/extrafields.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup extrafields for the module InfraS
	************************************************/

	// Dolibarr environment *************************
	require '../config.php';

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
	include_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	dol_include_once('/infraspackplus/core/lib/infraspackplus.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load('infraspackplus@infraspackplus');

	// Access control *******************************
	$accesright																			= 0;
	if (! empty($user->admin) || ! empty($user->rights->infraspackplus->paramExtraFields))	$accesright	= 1;
	if (empty($accesright))																accessforbidden();

	// Actions **************************************
	$formother					= new FormOther($db);
	$action						= GETPOST('action', 'alpha');
	$result						= '';

	if ($action == 'setexfd')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_D", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfc')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_C", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfct')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_CT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexffi')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_FI", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfe')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_E", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexff')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_F", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfdf')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_DF", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfcf')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_CF", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfff')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_FF", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	$list						= array('INFRASPLUS_PDF_EXF_PRE');
	if ($action == 'update')
	{
		$error		= 0;
		$rgbtext	= implode(', ', colorStringToArray(GETPOST('INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR', 'alpha')));
		$result		= dolibarr_set_const($db, "INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR", $rgbtext, 'chaine', 0, '', $conf->entity);
		foreach ($list as $constname)
		{
			$constvalue	= GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list as $constname)
	}	// if ($action == 'update')

	if ($action == 'setexfld')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_D", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexflc')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_C", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexflct')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_CT", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexflfi')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_FI", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfle')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_E", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexflf')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_F", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexfldf')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_DF", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexflcf')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_CF", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setexflff')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_FF", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	$list2						= array('INFRASPLUS_PDF_EXFL_PRE');
	if ($action == 'update2')
	{
		$error		= 0;
		$rgbtext	= implode(', ', colorStringToArray(GETPOST('INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR', 'alpha')));
		$result		= dolibarr_set_const($db, "INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR", $rgbtext, 'chaine', 0, '', $conf->entity);
		foreach ($list2 as $constname)
		{
			$constvalue	= GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list2 as $constname)
	}	// if ($action == 'update2')

	if ($result == 1)	setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	if ($result == -1)	setEventMessages($langs->trans("Error"), null, 'errors');

	// View *****************************************
	$page_name					= $langs->trans("infrasplussetup") ." - ". $langs->trans("InfraSPlusParamsExtraFields");
	llxHeader('', $page_name);
	if (! empty($user->admin))	$linkback	= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	else						$linkback	= '';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	
	// Configuration header *************************
	$head				= infraspackplus_admin_prepare_head();
	$picto				= 'infraspackplus@infraspackplus';
	dol_fiche_head($head, 'extrafields', $langs->trans("modcomnamePackPlus"), 0, $picto);

	// setup page goes here *************************
	print '		<form action="'.$_SERVER["PHP_SELF"].'" method = "post">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">';
	print load_fiche_titre($langs->trans("InfraSPlusParamExtraFieldsSetup"), '', dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1);
	print '			<table class="noborder" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "130px">
							<col width = "120px">
						</colgroup>
						<tr class = "liste_titre">
								<td align = "center">'.$langs->trans('Description').'</td>
								<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
								<td>&nbsp;</td>
						</tr>';
	print '				<tr>
							<td colspan = "2" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "12" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "update" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
	if (! empty($accesright))
	{
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFValueTextColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR').'</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFprefix").'</td>
							<td align="center"><input type = "text" size = "6" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_EXF_PRE" name = "INFRASPLUS_PDF_EXF_PRE" value = "'.$conf->global->INFRASPLUS_PDF_EXF_PRE.'"></td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFD").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_D))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfd&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfd&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFC").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_C))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfc&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfc&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFCT").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_CT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfct&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfct&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFFI").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_FI))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexffi&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexffi&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFE").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_E))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfe&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfe&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_F))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexff&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexff&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFDF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_DF))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfdf&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfdf&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFCF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_CF))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfcf&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfcf&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFFF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXF_FF))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfff&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfff&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '	</form>';
		print '			<tr><td colspan = "4" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '	<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">';
		print '			<tr>
							<td colspan = "2" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "12" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "update2" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
		$txtcolor	= colorArrayToHex(explode(',', $conf->global->INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR));
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLValueTextColor")." ".$langs->trans("InfraSPlusParamActualRVB", $conf->global->INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR).'</td>
							<td align="center">'.$formother->selectColor($txtcolor, 'INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR').'</td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLprefix").'</td>
							<td align="center"><input type = "text" size = "6" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_EXFL_PRE" name = "INFRASPLUS_PDF_EXFL_PRE" value = "'.$conf->global->INFRASPLUS_PDF_EXFL_PRE.'"></td>
						</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLD").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_D))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfld&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfld&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLC").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_C))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflc&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflc&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLCT").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_CT))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflct&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflct&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLFI").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_FI))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflfi&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflfi&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLE").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_E))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfle&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfle&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_F))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflf&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflf&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLDF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_DF))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfldf&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexfldf&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLCF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_CF))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflcf&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflcf&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamEXFLFF").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_EXFL_FF))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflff&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setexflff&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" style = "line-height: 1px;">&nbsp;</td></tr>';
	}	// if (! empty($accesright))
	print '			</table>
				</form>';
	dol_fiche_end();
	llxFooter();
?>