<?php
	/************************************************
	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspackplus/admin/images.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup pictures for the module InfraS
	************************************************/

	// Dolibarr environment *************************
	require '../config.php';

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
	dol_include_once('/infraspackplus/core/lib/infraspackplus.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load('companies');
	$langs->load('errors');
	$langs->load('infraspackplus@infraspackplus');

	// Access control *******************************
	$accesright																		= 0;
	if (! empty($user->admin) || ! empty($user->rights->infraspackplus->paramImages))	$accesright	= 1;
	if (empty($accesright))															accessforbidden();

	// Actions **************************************
	$form				= new Form($db);
	$formfile			= new FormFile($db);
	$confirm_mesg		= '';
	$action				= GETPOST('action', 'alpha');
	$confirm			= GETPOST('confirm', 'alpha');
	$urlfile			= GETPOST('urlfile', 'alpha');
	$result				= '';
	$use_iso_location	= isset($conf->global->MAIN_PDF_USE_ISO_LOCATION) ? $conf->global->MAIN_PDF_USE_ISO_LOCATION : 0;
	$hlogo				= isset($conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT) ? $conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT : 10;
	$maxhlogo			= ($use_iso_location ? 28 : 50);
	$hlogo				= ($hlogo > $maxhlogo ? $maxhlogo : $hlogo);
	dolibarr_set_const($db, "MAIN_DOCUMENTS_LOGO_HEIGHT", $hlogo, 'chaine', 0, '', $conf->entity);

	if($action == 'add')
	{
		$extension	= pathinfo($_FILES['InfraSPlusParamLogoFile']['name'], PATHINFO_EXTENSION);
		$dest_file	= GETPOST('InfraSPlusParamLogoName', 'alpha').'.'.$extension;
		$dest_path	= $conf->mycompany->dir_output.'/logos/';
		$moved		= dol_move_uploaded_file($_FILES['InfraSPlusParamLogoFile']['tmp_name'], $dest_path.$dest_file, 1, 0, $_FILES['InfraSPlusParamLogoFile']['error']);
		if ($moved > 0)
		{
			if ($isimage = image_format_supported($dest_file) === 1)
			{
				$imgThumbSmall	= vignette($dest_path.$dest_file, $maxwidthsmall, $maxheightsmall, '_mini', $quality);
				$imgThumbSmall	= vignette($dest_path.$dest_file, $maxwidthsmall, $maxheightsmall, '_small', $quality);
			}	// if ($isimage = image_format_supported($dest_file) === 1)
			if (strtoupper(substr(PHP_OS, 0, 3)) != 'WIN')	$resultChmod	= infraspackplus_chmod_r($dest_path, '0755', '0755', 'www-data', 'www-data');
			else											$resultChmod	= 1;
			if ($resultChmod)								setEventMessages($dest_file.' : '.$langs->trans("FileSaved"), null, 'mesgs');
			else											setEventMessages($dest_file.' : '.$langs->trans("FileSaved").' - CHMOD !', null, 'warnings');
		}	// if ($moved > 0)
		else if ($moved !== 1)	// errors
		{
			if ($moved < 0)	setEventMessages('UknownFileUploadError', null, 'errors');	// API documented error
			else			setEventMessages($moved, null, 'errors');	// We got an error string /o\
		}	// else if ($moved !== 1)
	}	// if($action == 'add')
	if ($action == 'defaultP')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_IMAGE_FOOT", GETPOST('defaultpied'), 'chaine', 0, '', $conf->entity);
	if ($action == 'defaultW')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_IMAGE_WATERMARK", GETPOST('defaultwatermark'), 'chaine', 0, '', $conf->entity);
	if ($action == 'delete')	$confirm_mesg	= $form->formconfirm($_SERVER["PHP_SELF"].'?urlfile='.$urlfile, $langs->trans("InfraSPlusParamDeleteAFile"), $langs->trans("InfraSPlusParamConfirmDeleteAFile").' '.$urlfile.' ?', 'delete_ok', '', 1, (int) $conf->use_javascript_ajax);
	if ($action == 'delete_ok' && $confirm == 'yes')
	{
		$urlfile_dirname	= pathinfo($urlfile, PATHINFO_DIRNAME);
		$urlfile_filename	= pathinfo($urlfile, PATHINFO_FILENAME);
		$urlfile_ext		= pathinfo($urlfile, PATHINFO_EXTENSION);
		$urlfile_small		= $urlfile_dirname.$urlfile_filename.'_small.'.$urlfile_ext;
		$urlfile_mini		= $urlfile_dirname.$urlfile_filename.'_mini.'.$urlfile_ext;
		$a					= dol_delete_file($conf->mycompany->dir_output.'/logos'.$urlfile, 1);
		$b					= dol_delete_file($conf->mycompany->dir_output.'/logos/thumbs'.$urlfile_small, 1);
		$c					= dol_delete_file($conf->mycompany->dir_output.'/logos/thumbs'.$urlfile_mini, 1);
		if ($a && $b && $c)	setEventMessages($urlfile_filename.'.'.$urlfile_ext.' '.$langs->trans("Deleted"), null, 'mesgs');
		else				setEventMessages($langs->trans("ErrorFailToDeleteFile", $urlfile), null, 'errors');
	}	// if ($action == 'delete_ok' && $confirm == 'yes')
	if ($action == 'setlogoemettiers')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SET_LOGO_EMET_TIERS", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpicture')		$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_PICTURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpicturesachat')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SUPPLIER_ORDER_WITH_PICTURE", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setoldpath')		$result	= dolibarr_set_const($db, "PRODUCT_USE_OLD_PATH_FOR_PHOTO", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'sethighqual')		$result	= dolibarr_set_const($db, "CAT_HIGH_QUALITY_IMAGES", GETPOST('value'), 'chaine', 0, '', $conf->entity);
	$list								= array ('MAIN_DOCUMENTS_LOGO_HEIGHT', 'INFRASPLUS_PDF_PICTURE_FOOT_WIDTH', 'INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT', 
													'INFRASPLUS_PDF_LINK_PICTURE_URL', 'INFRASPLUS_PDF_PICTURE_WIDTH', 'INFRASPLUS_PDF_PICTURE_HEIGHT', 
													'INFRASPLUS_PDF_T_WATERMARK_OPACITY', 'INFRASPLUS_PDF_I_WATERMARK_OPACITY');
	if ($action == 'update')
	{
		$error	= 0;
		foreach ($list as $constname)
		{
			$constvalue					= GETPOST($constname, 'alpha');
			$result						= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list as $constname)
	}	// if ($action == 'update')

	if ($result == 1)					setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	if ($result == -1)					setEventMessages($langs->trans("Error"), null, 'errors');

	// init variables *******************************
	$noMyLogo			= isset($conf->global->PDF_DISABLE_MYCOMPANY_LOGO)	? $conf->global->PDF_DISABLE_MYCOMPANY_LOGO : 0;
	$disabledLogoHeight	= empty($noMyLogo) ? '' : 'disabled';
	$rowSpan			= $conf->global->INFRASPLUS_PDF_WITH_PICTURE ? 14 : 13;

	// View *****************************************
	$page_name					= $langs->trans("infrasplussetup") ." - ". $langs->trans("InfraSPlusParamsImages");
	llxHeader('', $page_name);
	echo $confirm_mesg;
	if (! empty($user->admin))	$linkback	= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	else						$linkback	= '';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	$titleoption				= img_picto($langs->trans('Setup'), 'setup', 'style="vertical-align: bottom; height: 20px;"');

	// Configuration header *************************
	$head						= infraspackplus_admin_prepare_head();
	$picto						= 'infraspackplus@infraspackplus';
	dol_fiche_head($head, 'images', $langs->trans("modcomnamePackPlus"), 0, $picto);

	// setup page goes here *************************
	if ($conf->use_javascript_ajax)
	{
		print '	<script type = "text/javascript">
					$(document).ready(function(){
						$(".toggle_bloc").hide();
					});
					$(function ()
					{
						$(".foldable .toggle_bloc_title").click(function ()
						{
							$(".toggle_bloc").hide();
							$(this).siblings().toggle();
						});
					});
				</script>';
	}	// if ($conf->use_javascript_ajax)
	print '		<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
					<div class = "foldable">';
	print load_fiche_titre($langs->trans("InfraSPlusParamGestionLogos"), $titleoption, dol_buildpath('/infraspackplus/img/Tools.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
	print '				<table class = "noborder toggle_bloc" width = "100%">
							<colgroup>
								<col width = "*">
								<col width = "650px">
								<col width = "120px">
							</colgroup>
							<tr class = "liste_titre">
								<td colspan = "3" align="center">'.$langs->trans('InfraSPlusParamNewLogo').'</td>
							</tr>';
	if (! empty($accesright))
	{
		print '				<tr class="oddeven">
								<td>
									'.fieldLabel('InfraSPlusParamLogoFile', 'InfraSPlusParamLogoFile').'
									<input type = "file" id = "InfraSPlusParamLogoFile" name = "InfraSPlusParamLogoFile" accept="image/*" style = "margin: 0; padding: 0;">
								</td>
								<td width = "40%" align = "right">
									'.fieldLabel('InfraSPlusParamLogoName', 'InfraSPlusParamLogoName').'
									<input type = "text" size = "30" id = "InfraSPlusParamLogoName" name = "InfraSPlusParamLogoName" style = "margin: 0; padding: 0;">
								</td>
								<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "add" name = "action">'.$langs->trans("Add").'</button></td>
							</tr>';
		$logos																							= array();
		foreach (glob($conf->mycompany->dir_output.'/logos/{*.jpg,*.gif,*.png}', GLOB_BRACE) as $file)	$logos[]	= dol_basename($file);
		print '				<tr class="oddeven">
								<td colspan = "2">
									'.fieldLabel(''.$langs->trans("InfraSPlusParamDefaultImageFooter").'', 'defaultpied').'
									<select name = "defaultpied" style = "margin: 0; padding: 0; cursor: pointer;">
										<option name = "defaultpied" value = "">'.$langs->trans('InfraSPlusParamNoPied').'</option>';
		$selected_logo	= $conf->global->INFRASPLUS_PDF_IMAGE_FOOT;
		for ($i = 0; $i < count($logos); $i++)
		{
			print '						<option name = "defaultpied" value = "'.$logos[$i].'"';
			if ($selected_logo === $logos[$i])	print ' selected';
			print '						>'.$logos[$i].'</option>';
		}	// for ($i = 0; $i < count($logos); $i++)
		print '						</select>
								</td>
								<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "defaultP" name = "action">'.$langs->trans("Validate").'</button></td>
							</tr>';
		print '				<tr class="oddeven">
								<td colspan = "2">
									'.fieldLabel(''.$langs->trans("InfraSPlusParamDefaultWatermarkImage").'', 'defaultwatermark').'
									<select name = "defaultwatermark" style = "margin: 0; padding: 0; cursor: pointer;">
										<option name = "defaultwatermark" value = "">'.$langs->trans('InfraSPlusParamNoWatermarkImage').'</option>';
		$selected_logo	= $conf->global->INFRASPLUS_PDF_IMAGE_WATERMARK;
		for ($i = 0; $i < count($logos); $i++)
		{
			if ($logos[$i] === 'thumbs' || $logos[$i][0] === '.')	continue;	// Choose to ignore field which isn't image
			print '					<option name = "defaultwatermark" value = "'.$logos[$i].'"';
			if ($selected_logo === $logos[$i])	print ' selected';
			print '					>'.$logos[$i].'</option>';
		}	// for ($i = 0; $i < count($logos); $i++)
		print '						</select>
								</td>
								<td align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "defaultW" name = "action">'.$langs->trans("Validate").'</button></td>
							</tr>';
		print '				<tr><td colspan = "3" style = "line-height: 1px;">&nbsp;</td></tr>';
	}	// if (! empty($accesright))
	print '				</table>
					</div>
				</form>';	
	$logo_files	= dol_dir_list($conf->mycompany->dir_output.'/logos/', 'files', 0, '',  '', null, null, 1);
	print '		<div class = "foldable">';
	print load_fiche_titre($langs->trans("InfraSPlusParamListLogos"), $titleoption, dol_buildpath('/infraspackplus/img/list.png', 1), 1, '', 'NoBCollapse toggle_bloc_title cursorpointer');
	print '			<div class = "toggle_bloc">';
	$formfile->list_of_documents($logo_files, null, 'companylogo', '', 1, '', 1, 0, $langs->trans("NoLogo"), 0, 'none');
	print '			</div>
				</div>';
	print '		<form action="'.$_SERVER["PHP_SELF"].'" method = "post">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">
					<div class = "foldable">';
	print load_fiche_titre($langs->trans("InfraSPlusParamImagesSetup"), $titleoption, dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1, '', 'toggle_bloc_title cursorpointer');
	print '				<table class="noborder toggle_bloc" width="100%">
							<colgroup>
								<col width = "*">
								<col width = "130px">
								<col width = "120px">
							</colgroup>
							<tr class="liste_titre">
								<td align = "center">'.$langs->trans('Description').'</td>
								<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
								<td>&nbsp;</td>
							</tr>';
	if (! empty($accesright))
	{
		print '				<tr>
								<td colspan="2" align="center">'.$langs->trans('InfraSPlusParamAvertissementCalculImage').'</td>';
		print '					<td rowspan = "'.$rowSpan.'" align="center"><button class = "button" style = "width: 110px;" type = "submit" value = "update" name = "action">'.$langs->trans("Modify").'</button></td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamLogoHeight", $maxhlogo).'</td>
								<td align="center">
									<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "MAIN_DOCUMENTS_LOGO_HEIGHT" name = "MAIN_DOCUMENTS_LOGO_HEIGHT" min = "5" max = "'.$maxhlogo.'" value = "'.$conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT.'" '.$disabledLogoHeight.'>&nbsp;pt
								</td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamPictureFootWidth").'</td>
								<td align="center">
									<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_PICTURE_FOOT_WIDTH" name = "INFRASPLUS_PDF_PICTURE_FOOT_WIDTH" min = "20" max = "190" value = "'.$conf->global->INFRASPLUS_PDF_PICTURE_FOOT_WIDTH.'">&nbsp;pt
								</td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamPictureFootHeight").'</td>
								<td align="center">
									<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT" name = "INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT" min = "4" max = "30" value = "'.$conf->global->INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT.'">&nbsp;pt
								</td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamSetLogoEmetTiers").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SET_LOGO_EMET_TIERS))
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlogoemettiers&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setlogoemettiers&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamWithPicture").' '.$langs->trans("GenModif").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_PICTURE))
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicture&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicture&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>
							</tr>';
		if (! empty($conf->global->INFRASPLUS_PDF_WITH_PICTURE))
		{
			print '			<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamLinkPictureUrl").'</td>
								<td align="center"><input type = "text" size = "6" style = "text-align: center; margin: 0; padding: 0;" id = "INFRASPLUS_PDF_LINK_PICTURE_URL" name = "INFRASPLUS_PDF_LINK_PICTURE_URL" value = "'.$conf->global->INFRASPLUS_PDF_LINK_PICTURE_URL.'"></td>
							</tr>';
		}	// if (! empty($conf->global->INFRASPLUS_PDF_WITH_PICTURE))
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamSupplierOrderWithPicture").' '.$langs->trans("GenModif").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_SUPPLIER_ORDER_WITH_PICTURE))
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicturesachat&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpicturesachat&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamPictureWidth").'</td>
								<td align="center">
									<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_PICTURE_WIDTH" name = "INFRASPLUS_PDF_PICTURE_WIDTH" min = "16" max = "160" value = "'.$conf->global->INFRASPLUS_PDF_PICTURE_WIDTH.'">&nbsp;pt
								</td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamPictureHeight").'</td>
								<td align="center">
									<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_PICTURE_HEIGHT" name = "INFRASPLUS_PDF_PICTURE_HEIGHT" min = "32" max = "320" value = "'.$conf->global->INFRASPLUS_PDF_PICTURE_HEIGHT.'">&nbsp;pt
								</td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamOldPathPhoto").'</td>';
		if (! empty($conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO))
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoldpath&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setoldpath&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '				</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamHQPicture").'</td>';
		if (! empty($conf->global->CAT_HIGH_QUALITY_IMAGES))
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethighqual&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '				<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=sethighqual&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '				</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamWatermarkTOpacity").'</td>
								<td align="center">
									<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_T_WATERMARK_OPACITY" name = "INFRASPLUS_PDF_T_WATERMARK_OPACITY" min = "1" max = "100" value = "'.$conf->global->INFRASPLUS_PDF_T_WATERMARK_OPACITY.'">&nbsp;%
								</td>
							</tr>';
		print '				<tr class="oddeven">
								<td>'.$langs->trans("InfraSPlusParamWatermarkIOpacity").'</td>
								<td align="center">
									<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "INFRASPLUS_PDF_I_WATERMARK_OPACITY" name = "INFRASPLUS_PDF_I_WATERMARK_OPACITY" min = "1" max = "100" value = "'.$conf->global->INFRASPLUS_PDF_I_WATERMARK_OPACITY.'">&nbsp;%
								</td>
							</tr>';
		print '				<tr><td colspan = "3" style = "line-height: 1px;">&nbsp;</td></tr>';
	}	// if (! empty($accesright))
	print '				</table>
					</div>
				</form>';
	
	dol_fiche_end();
	llxFooter();
	$db->close();
?>