<?php
	/************************************************
	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspackplus/core/modules/expedition/doc/pdf_InfraSPlus_BL.modules.php
	* 	\ingroup	InfraS
	* 	\brief		Class file for InfraS PDF expedition
	************************************************/

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/modules/expedition/modules_expedition.php';
	require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
	require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
	dol_include_once('/infraspackplus/core/lib/infraspackplus.pdf.lib.php');

	/************************************************
	*	Class to generate PDF proposal InfraS
	************************************************/
	class pdf_InfraSPlus_BL extends ModelePdfExpedition
	{
		public $db;
		public $name;
		public $description;
		public $update_main_doc_field;	// Save the name of generated file as the main doc when generating a doc with this template
		public $type;
		public $phpmin	= array(5, 5);
		public $version	= 'dolibarr';
		public $page_largeur;
		public $page_hauteur;
		public $format;
		public $marge_gauche;
		public $marge_droite;
		public $marge_haute;
		public $marge_basse;
		public $emetteur;

		/********************************************
		*	Constructor
		*
		*	@param		DoliDB		$db      Database handler
		********************************************/
		public function __construct($db)
		{
			global $conf, $langs, $mysoc;

			$langs->load('main');
			$langs->load('dict');
			$langs->load('bills');
			$langs->load('products');
			$langs->load('companies');
			$langs->load('propal');
			$langs->load('orders');
			$langs->load('contracts');
			$langs->load('interventions');
			$langs->load('deliveries');
			$langs->load('sendings');
			$langs->load('projects');
			$langs->load("productbatch");
			$langs->load('infraspackplus@infraspackplus');
			
			$this->name									= $langs->trans('PDFInfraSPlusExpeditionName');
			$this->description							= $langs->trans('PDFInfraSPlusExpeditionDescription');
			$this->emetteur								= $mysoc;
			if (empty($this->emetteur->country_code))	$this->emetteur->country_code										= substr($langs->defaultlang, -2);
			$this->type									= 'pdf';
			$this->defaulttemplate						= isset($conf->global->EXPEDITION_ADDON_PDF)						? $conf->global->EXPEDITION_ADDON_PDF : '';
			$this->multilangs							= isset($conf->global->MAIN_MULTILANGS)								? $conf->global->MAIN_MULTILANGS : 0;
			$this->use_fpdf								= isset($conf->global->MAIN_USE_FPDF)								? $conf->global->MAIN_USE_FPDF : 0;
			$this->main_umask							= isset($conf->global->MAIN_UMASK)									? $conf->global->MAIN_UMASK : '0755';
			$formatarray								= pdf_InfraSPlus_getFormat();
			$this->page_largeur							= $formatarray['width'];
			$this->page_hauteur							= $formatarray['height'];
			$this->format								= array($this->page_largeur, $this->page_hauteur);
			$this->marge_gauche							= isset($conf->global->MAIN_PDF_MARGIN_LEFT)						? $conf->global->MAIN_PDF_MARGIN_LEFT : 10;
			$this->marge_haute							= isset($conf->global->MAIN_PDF_MARGIN_TOP)							? $conf->global->MAIN_PDF_MARGIN_TOP : 10;
			$this->marge_droite							= isset($conf->global->MAIN_PDF_MARGIN_RIGHT)						? $conf->global->MAIN_PDF_MARGIN_RIGHT : 10;
			$this->marge_basse							= isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)						? $conf->global->MAIN_PDF_MARGIN_BOTTOM : 10;
			$this->formatpage							= array('largeur'=>$this->page_largeur, 'hauteur'=>$this->page_hauteur, 'mgauche'=>$this->marge_gauche, 
																'mdroite'=>$this->marge_droite, 'mhaute'=>$this->marge_haute, 'mbasse'=>$this->marge_basse);
			$this->use_iso_location						= isset($conf->global->MAIN_PDF_USE_ISO_LOCATION)					? $conf->global->MAIN_PDF_USE_ISO_LOCATION : 0;
			$this->dash_between_line					= isset($conf->global->MAIN_PDF_DASH_BETWEEN_LINES)					? $conf->global->MAIN_PDF_DASH_BETWEEN_LINES : 1;
			$this->product_use_unit						= isset($conf->global->PRODUCT_USE_UNITS)							? $conf->global->PRODUCT_USE_UNITS : 0;
			$this->hide_pay_term_cond					= isset($conf->global->PROPALE_PDF_HIDE_PAYMENTTERMCOND)			? $conf->global->PROPALE_PDF_HIDE_PAYMENTTERMCOND : 0;
			$this->chq_num								= isset($conf->global->FACTURE_CHQ_NUMBER)							? $conf->global->FACTURE_CHQ_NUMBER : 0;
			$this->diffsize_title						= isset($conf->global->PDF_DIFFSIZE_TITLE)							? $conf->global->PDF_DIFFSIZE_TITLE : 0;
			$this->hidechq_address						= isset($conf->global->MAIN_PDF_HIDE_CHQ_ADDRESS)					? $conf->global->MAIN_PDF_HIDE_CHQ_ADDRESS : 0;
			$this->rib_num								= isset($conf->global->FACTURE_RIB_NUMBER)							? $conf->global->FACTURE_RIB_NUMBER : 0;
			$this->draft_watermark						= isset($conf->global->SHIPPING_DRAFT_WATERMARK)					? $conf->global->SHIPPING_DRAFT_WATERMARK : '';
			$this->multi_files							= isset($conf->global->INFRASPLUS_PDF_MULTI_FILES)					? $conf->global->INFRASPLUS_PDF_MULTI_FILES : 0;
			$this->font									= isset($conf->global->INFRASPLUS_PDF_FONT)							? $conf->global->INFRASPLUS_PDF_FONT : 'Helvetica';
			$this->headertxtcolor						= isset($conf->global->INFRASPLUS_PDF_HEADER_TEXT_COLOR)			? $conf->global->INFRASPLUS_PDF_HEADER_TEXT_COLOR : 0;
			$this->headertxtcolor						= explode(',', $this->headertxtcolor);
			$this->bodytxtcolor							= isset($conf->global->INFRASPLUS_PDF_BODY_TEXT_COLOR)				? $conf->global->INFRASPLUS_PDF_BODY_TEXT_COLOR : 0;
			$this->bodytxtcolor							= explode(',', $this->bodytxtcolor);
			$this->datesbold							= isset($conf->global->INFRASPLUS_PDF_DATES_BOLD)					? $conf->global->INFRASPLUS_PDF_DATES_BOLD : 0;
			$this->small_head2							= isset($conf->global->INFRASPLUS_PDF_SMALL_HEAD_2)					? $conf->global->INFRASPLUS_PDF_SMALL_HEAD_2 : 0;
			$this->title_size							= isset($conf->global->INFRASPLUS_PDF_TITLE_SIZE)					? $conf->global->INFRASPLUS_PDF_TITLE_SIZE : 2;
			$this->height_top_table						= isset($conf->global->INFRASPLUS_PDF_HEIGHT_TOP_TABLE)				? $conf->global->INFRASPLUS_PDF_HEIGHT_TOP_TABLE : 4;
			$this->hide_top_table						= isset($conf->global->INFRASPLUS_PDF_HIDE_TOP_TABLE)				? $conf->global->INFRASPLUS_PDF_HIDE_TOP_TABLE : 0;
			$this->Rounded_rect							= isset($conf->global->INFRASPLUS_PDF_ROUNDED_REC)					? $conf->global->INFRASPLUS_PDF_ROUNDED_REC : 0;
			$this->bg_color								= isset($conf->global->INFRASPLUS_PDF_BACKGROUND_COLOR)				? $conf->global->INFRASPLUS_PDF_BACKGROUND_COLOR : '';
			$this->txtcolor								= explode(',', pdf_InfraSPlus_txt_color($this->bg_color));
			$this->bg_color								= explode(',', $this->bg_color);
			$this->title_bg								= isset($conf->global->INFRASPLUS_PDF_TITLE_BG)						? $conf->global->INFRASPLUS_PDF_TITLE_BG : 0;
			$this->header_align_left					= isset($conf->global->INFRASPLUS_PDF_HEADER_ALIGN_LEFT)			? $conf->global->INFRASPLUS_PDF_HEADER_ALIGN_LEFT : 0;
			$this->fold_mark							= isset($conf->global->INFRASPLUS_PDF_FOLD_MARK)					? $conf->global->INFRASPLUS_PDF_FOLD_MARK : 0;
			$this->tblLineW								= isset($conf->global->INFRASPLUS_PDF_TBL_LINE_WIDTH)				? $conf->global->INFRASPLUS_PDF_TBL_LINE_WIDTH : 0.2;
			$this->tblLineDash							= isset($conf->global->INFRASPLUS_PDF_TBL_LINE_DASH)				? $conf->global->INFRASPLUS_PDF_TBL_LINE_DASH : '0';
			$this->tblLineColor							= isset($conf->global->INFRASPLUS_PDF_TBL_LINE_COLOR)				? $conf->global->INFRASPLUS_PDF_TBL_LINE_COLOR : '';
			$this->showtblline							= $this->tblLineColor == '255, 255, 255' ? 0 : 1;
			$this->tblLineColor							= explode(',', $this->tblLineColor);
			$this->horLineColor							= isset($conf->global->INFRASPLUS_PDF_HOR_LINE_COLOR)				? $conf->global->INFRASPLUS_PDF_HOR_LINE_COLOR : '';
			$this->horLineColor							= explode(',', $this->horLineColor);
			$this->hBC									= isset($conf->global->INFRASPLUS_PDF_HT_BC)						? $conf->global->INFRASPLUS_PDF_HT_BC : 12;
			$this->wBC									= isset($conf->global->INFRASPLUS_PDF_LARG_BC)						? $conf->global->INFRASPLUS_PDF_LARG_BC : 35;
			$this->dimC2D								= isset($conf->global->INFRASPLUS_PDF_DIM_C2D)						? $conf->global->INFRASPLUS_PDF_DIM_C2D : 15;
			$this->lineSep_hight						= isset($conf->global->INFRASPLUS_PDF_LINESEP_HIGHT)				? $conf->global->INFRASPLUS_PDF_LINESEP_HIGHT : 4;
			$this->show_ref_col							= isset($conf->global->INFRASPLUS_PDF_WITH_REF_COLUMN)				? $conf->global->INFRASPLUS_PDF_WITH_REF_COLUMN : 0;
			$this->show_bc_col							= isset($conf->global->INFRASPLUS_PDF_BL_WITH_BC_COLUMN)			? $conf->global->INFRASPLUS_PDF_BL_WITH_BC_COLUMN : 0;
			$this->hide_weight_vol						= isset($conf->global->SHIPPING_PDF_HIDE_WEIGHT_AND_VOLUME)			? $conf->global->SHIPPING_PDF_HIDE_WEIGHT_AND_VOLUME : 0;
			$this->hide_ordered							= isset($conf->global->INFRASPLUS_PDF_HIDE_ORDERED)					? $conf->global->INFRASPLUS_PDF_HIDE_ORDERED : 0;
			$this->larg_ref								= isset($conf->global->INFRASPLUS_PDF_LARGCOL_REF)					? $conf->global->INFRASPLUS_PDF_LARGCOL_REF : 28;
			$this->larg_unit							= isset($conf->global->INFRASPLUS_PDF_LARGCOL_UNIT)					? $conf->global->INFRASPLUS_PDF_LARGCOL_UNIT : 10;
			$this->ht_signarea							= isset($conf->global->INFRASPLUS_PDF_HT_SIGN_AREA)					? $conf->global->INFRASPLUS_PDF_HT_SIGN_AREA : 24;
			$this->signLineW							= isset($conf->global->INFRASPLUS_PDF_SIGN_LINE_WIDTH)				? $conf->global->INFRASPLUS_PDF_SIGN_LINE_WIDTH : 0.2;
			$this->signLineDash							= isset($conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH)				? $conf->global->INFRASPLUS_PDF_SIGN_LINE_DASH : '0';
			$this->signLineColor						= isset($conf->global->INFRASPLUS_PDF_SIGN_LINE_COLOR)				? $conf->global->INFRASPLUS_PDF_SIGN_LINE_COLOR : '';
			$this->signLineColor						= explode(',', $this->signLineColor);
			$this->show_sign_area						= isset($conf->global->INFRASPLUS_PDF_EXPEDITION_SHOW_SIGNATURE)	? $conf->global->INFRASPLUS_PDF_EXPEDITION_SHOW_SIGNATURE : 1;
			$this->free_text_end						= isset($conf->global->INFRASPLUS_PDF_FREETEXTEND)					? $conf->global->INFRASPLUS_PDF_FREETEXTEND : 0;
			$this->type_foot							= isset($conf->global->INFRASPLUS_PDF_TYPE_FOOT)					? $conf->global->INFRASPLUS_PDF_TYPE_FOOT : '0000';
			$this->hidepagenum							= isset($conf->global->INFRASPLUS_PDF_HIDE_PAGE_NUM)				? $conf->global->INFRASPLUS_PDF_HIDE_PAGE_NUM : 0;
			$this->wpicturefoot							= isset($conf->global->INFRASPLUS_PDF_PICTURE_FOOT_WIDTH)			? $conf->global->INFRASPLUS_PDF_PICTURE_FOOT_WIDTH : 188;
			$this->hpicturefoot							= isset($conf->global->INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT)			? $conf->global->INFRASPLUS_PDF_PICTURE_FOOT_HEIGHT : 12;
			$this->maxsizeimgfoot						= array('largeur'=>$this->wpicturefoot, 'hauteur'=>$this->hpicturefoot);
			$this->linkpictureurl						= isset($conf->global->INFRASPLUS_PDF_LINK_PICTURE_URL)				? $conf->global->INFRASPLUS_PDF_LINK_PICTURE_URL : '';
			$this->wpicture								= isset($conf->global->INFRASPLUS_PDF_PICTURE_WIDTH)				? $conf->global->INFRASPLUS_PDF_PICTURE_WIDTH : 20;
			$this->hpicture								= isset($conf->global->INFRASPLUS_PDF_PICTURE_HEIGHT)				? $conf->global->INFRASPLUS_PDF_PICTURE_HEIGHT : 32;
			$this->old_path_photo						= isset($conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO)				? $conf->global->PRODUCT_USE_OLD_PATH_FOR_PHOTO : 0;
			$this->cat_hq_image							= isset($conf->global->CAT_HIGH_QUALITY_IMAGES)						? $conf->global->CAT_HIGH_QUALITY_IMAGES : 0;
			$this->alpha								= 0.2;
			$this->exftxtcolor							= isset($conf->global->INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR)			? $conf->global->INFRASPLUS_PDF_EXF_VALUE_TEXT_COLOR : 0;
			$this->exftxtcolor							= explode(',', $this->exftxtcolor);
			$this->show_ExtraFieldsLines				= isset($conf->global->INFRASPLUS_PDF_EXFL_E)						? $conf->global->INFRASPLUS_PDF_EXFL_E : 0;
			$this->exfltxtcolor							= isset($conf->global->INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR)		? $conf->global->INFRASPLUS_PDF_EXFL_VALUE_TEXT_COLOR : 0;
			$this->exfltxtcolor							= explode(',', $this->exfltxtcolor);
			$this->option_logo							= 1;	// Display logo
			$this->option_tva							= 0;	// Manage the vat option FACTURE_TVAOPTION
			$this->option_modereg						= 0;	// Display payment mode
			$this->option_condreg						= 0;	// Display payment terms
			$this->option_codeproduitservice			= 1;	// Display product-service code
			$this->option_multilang						= 1;	// Available in several languages
			$this->option_escompte						= 0;	// Displays if there has been a discount
			$this->option_credit_note					= 0;	// Support credit notes
			$this->option_freetext						= 1;	// Support add of a personalised text
			$this->option_draft_watermark				= 1;	// Support add of a watermark on drafts
		}	// public function __construct($db)

		/********************************************
		*	Function to build pdf onto disk
		*
		*	@param		Object		$object				Object to generate
		*	@param		Translate	$outputlangs		Lang output object
		*	@param		string		$srctemplatepath	Full path of source filename for generator using a template file
		*	@param		int			$hidedetails		Do not show line details (inutilisée ! laissé pour la compatibilité)
		*	@param		int			$hidedesc			Do not show desc
		*	@param		int			$hideref			Do not show ref
		*	@return     int             				1=OK, 0=KO
		********************************************/
		public function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)
		{
			global $user, $langs, $conf, $db, $hookmanager;

			if (! is_object($outputlangs))	$outputlangs					= $langs;			
			$outputlangs->load('main');
			$outputlangs->load('dict');
			$outputlangs->load('bills');
			$outputlangs->load('products');
			$outputlangs->load('companies');
			$outputlangs->load('propal');
			$outputlangs->load('orders');
			$outputlangs->load('contracts');
			$outputlangs->load('interventions');
			$outputlangs->load('deliveries');
			$outputlangs->load('sendings');
			$outputlangs->load('projects');
			$outputlangs->load("productbatch");
			$outputlangs->load('infraspackplus@infraspackplus');

			// For backward compatibility with FPDF, force output charset to ISO, because FPDF expect text to be encoded in ISO
			if (! empty($this->use_fpdf))	$outputlangs->charset_output	= 'ISO-8859-1';
			$filesufixe						= ! $this->multi_files || ($this->defaulttemplate && $this->defaulttemplate == 'InfraSPlus_BL') ? '' : '_BL';
			
			if ($conf->expedition->dir_output)
			{
				if (! empty($this->show_ExtraFieldsLines))
				{
					$extrafieldsline	= new ExtraFields($db);
					$extralabelsline	= $extrafieldsline->fetch_name_optionals_label($object->table_element_line);
				}	// if (! empty($this->show_ExtraFieldsLines))
				// Definition of $dir and $file
				if ($object->specimen)
				{
					$this->show_ExtraFieldsLines	= '';
					$dir							= $conf->expedition->dir_output.'/sending';
					$file							= $dir.'/SPECIMEN.pdf';
				}	// if ($object->specimen)
				else
				{
					$objectref	= dol_sanitizeFileName($object->ref);
					$dir		= $conf->expedition->dir_output.'/sending/'.$objectref;
					$file		= $dir.'/'.$objectref.$filesufixe.'.pdf';
				}	// else	// if ($object->specimen)
				if (! file_exists($dir))
				{
					if (dol_mkdir($dir) < 0)
					{
						$this->error=$outputlangs->transnoentities("ErrorCanNotCreateDir", $dir);
						return 0;
					}	// if (dol_mkdir($dir) < 0)
				}	// if (! file_exists($dir))
				if (file_exists($dir))
				{
					if (! is_object($hookmanager))	// Add pdfgeneration hook
					{
						include_once DOL_DOCUMENT_ROOT.'/core/class/hookmanager.class.php';
						$hookmanager					= new HookManager($db);
					}	// if (! is_object($hookmanager))
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters							= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook							= $hookmanager->executeHooks('beforePDFCreation', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
					$this->logo							= $hookmanager->resArray['logo'];
					$this->adr							= $hookmanager->resArray['adr'];
					$this->adrlivr						= $hookmanager->resArray['adrlivr'];
					$this->listfreet					= $hookmanager->resArray['listfreet'];
					$this->listnotep					= $hookmanager->resArray['listnotep'];
					$this->pied							= $hookmanager->resArray['pied'];
					$this->files						= $hookmanager->resArray['filesArray'];
					$this->with_picture					= $hookmanager->resArray['hidepict'];
					$hidedesc							= $hookmanager->resArray['hidedesc'];
					$this->showwvccchk					= $hookmanager->resArray['showwvccchk'];
					$this->signvalue					= $hookmanager->resArray['signvalue'];
					$nblignes							= count($object->lines);	// Set nblignes with the new facture lines content after hook
					if (! empty($this->show_bc_col))	$this->show_ref_col	= 0;	// Comme on affiche une colonne 'Code barre' on désactive la colonne 'Référence' qu'elle remplace
					if (! empty($this->show_ref_col))	$hideref = 1;	// Comme on affiche une colonne 'Référence' on s'assure de ne pas répéter l'information
					// Create pdf instance
					$pdf								= pdf_getInstance($this->format);
					$default_font_size					= pdf_getPDFFontSize($outputlangs);																								// Must be after pdf_getInstance
					$pdf->SetAutoPageBreak(1, 0);
					if (class_exists('TCPDF'))
					{
						$pdf->setPrintHeader(false);
						$pdf->setPrintFooter(false);
					}	// if (class_exists('TCPDF'))
					$pdf->SetFont($this->font);
					// reduce the top margin before ol / il tag
					$tagvs					= array('p' => array(1 => array('h' => 0.0001, 'n' => 1)), 'ul' => array(0 => array('h' => 0.0001, 'n' => 1)));
					$pdf->setHtmlVSpace($tagvs);
					$pdf->Open();
					$pdf->SetTitle($outputlangs->convToOutputCharset($object->ref).$filesufixe);
					$pdf->SetSubject($outputlangs->transnoentities("Shipment"));
					$pdf->SetCreator("Dolibarr ".DOL_VERSION);
					$pdf->SetAuthor($outputlangs->convToOutputCharset($user->getFullName($outputlangs)));
					$pdf->SetKeyWords($outputlangs->convToOutputCharset($object->ref)." ".$outputlangs->transnoentities("Shipment"));
					$pdf->SetMargins($this->marge_gauche, $this->marge_haute, $this->marge_droite);   // Left, Top, Right
					// New page
					$pdf->AddPage();
					pdf_InfraSPlus_bg_watermark($pdf, $this->formatpage);	// Show Watermarks
					$pagenb					= 1;
					// Default PDF parameters
					$this->stdLineW			= 0.2; // épaisseur par défaut dans TCPDF = 0.2
					$this->stdLineDash		= '0';	// 0 = continue ; w = discontinue espace et tiret identiques ; w,x = tiret,espace ; w,x,y,z = tiret long,espace,tiret court,espace
					$this->stdLineCap		= 'butt';	// fin de trait : butt = rectangle/lg->Dash ; round = rond/lg->Dash + width : square = rectangle/lg->Dash + width
					$this->stdLineColor		= array(128, 128, 128);
					$this->stdLineStyle		= array('width'=>$this->stdLineW, 'dash'=>$this->stdLineDash, 'cap'=>$this->stdLineCap, 'color'=>$this->stdLineColor);
					$this->bgLineW			= $this->tblLineW; // épaisseur par défaut dans TCPDF = 0.2
					$this->bgLineDash		= '0';	// 0 = continue ; w = discontinue espace et tiret identiques ; w,x = tiret,espace ; w,x,y,z = tiret long,espace,tiret court,espace
					$this->bgLineCap		= 'butt';	// fin de trait : butt = rectangle/lg->Dash ; round = rond/lg->Dash + width : square = rectangle/lg->Dash + width
					$this->bgLineColor		= $this->bg_color;
					$this->bgLineStyle		= array('width'=>$this->bgLineW, 'dash'=>$this->bgLineDash, 'cap'=>$this->bgLineCap, 'color'=>$this->bgLineColor);
					$this->tblLineCap		= 'butt';	// fin de trait : butt = rectangle/lg->Dash ; round = rond/lg->Dash + width : square = rectangle/lg->Dash + width
					$this->tblLineStyle		= array('width'=>$this->tblLineW, 'dash'=>$this->tblLineDash, 'cap'=>$this->tblLineCap, 'color'=>(! empty($this->title_bg) && ! $this->showtblline ? $this->bg_color : $this->tblLineColor));
					$this->horLineStyle		= array('width'=>$this->tblLineW, 'dash'=>$this->tblLineDash, 'cap'=>$this->tblLineCap, 'color'=>$this->horLineColor);
					$this->signLineCap		= 'butt';	// fin de trait : butt = rectangle/lg->Dash ; round = rond/lg->Dash + width : square = rectangle/lg->Dash + width
					$this->signLineStyle	= array('width'=>$this->signLineW, 'dash'=>$this->signLineDash, 'cap'=>$this->signLineCap, 'color'=>$this->signLineColor);
					$pdf->MultiCell(0, 3, '');		// Set interline to 3
					$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
					$pdf->SetFont('', '', $default_font_size - 1);
					// First loop on each lines to prepare calculs and variables
					$realpatharray			= array();
					$objphoto				= new Product($db);
					for ($i = 0 ; $i < $nblignes ; $i++)
					{
						// detect if there is at least one image to show
						if (! empty($this->with_picture))
						{
							if (empty($object->lines[$i]->fk_product)) continue;
							$objphoto->fetch($object->lines[$i]->fk_product);
							if (! empty($this->old_path_photo))
							{
								$pdir[0] = get_exdir($objphoto->id, 2, 0, 0, $objphoto, 'product').$objphoto->id ."/photos/";
								$pdir[1] = get_exdir(0, 0, 0, 0, $objphoto, 'product').dol_sanitizeFileName($objphoto->ref).'/';
							}	// if (! empty($this->old_path_photo))
							else
							{
								$pdir[0] = get_exdir(0, 0, 0, 0, $objphoto, 'product').dol_sanitizeFileName($objphoto->ref).'/';	// default
								$pdir[1] = get_exdir($objphoto->id, 2, 0, 0, $objphoto, 'product').$objphoto->id ."/photos/";		// alternative
							}	// else	// if (! empty($this->old_path_photo))
							$arephoto = false;
							foreach ($pdir as $midir)
							{
								if (! $arephoto)
								{
									$dir = $conf->product->dir_output.'/'.$midir;
									foreach ($objphoto->liste_photos($dir, 1) as $key => $obj)
									{
										if (empty($this->cat_hq_image))		// If CAT_HIGH_QUALITY_IMAGES not defined, we use thumb if defined and then original photo
										{
											if ($obj['photo_vignette'])	$filename	= $obj['photo_vignette'];
											else						$filename	= $obj['photo'];
										}	// if (empty($this->cat_hq_image))
										else		$filename	= $obj['photo'];
										$realpath	= $dir.$filename;
										$arephoto	= true;
									}	// foreach ($objphoto->liste_photos($dir,1) as $key => $obj)
								}	// if (! $arephoto)
							}	// foreach ($pdir as $midir)
							if ($realpath && $arephoto) $realpatharray[$i]	= $realpath;
						}	// if (! empty($this->with_picture))
					}	// for ($i = 0 ; $i < $nblignes ; $i++)
					// Define width and position of notes frames
					$this->larg_util_txt	= $this->page_largeur - ($this->marge_gauche + $this->marge_droite + ($this->Rounded_rect * 2) + 2);
					$this->larg_util_cadre	= $this->page_largeur - ($this->marge_gauche + $this->marge_droite);
					$this->posx_G_txt		= $this->marge_gauche + $this->Rounded_rect + 1;
					// Define width and position of main table columns
					$this->larg_qtytoship	= 21;
					$this->larg_qtyordered	= $this->hide_ordered ? 0 : 21;
					$this->larg_weightvol	= $this->hide_weight_vol ? 0 : 30;
					$this->larg_ref			= !empty($this->show_bc_col) ? $this->wBC : (empty($this->show_ref_col) ? 0 : $this->larg_ref);
					$this->larg_unit		= ! $this->product_use_unit ? 0 : $this->larg_unit;
					$this->posxqtytoship	= $this->page_largeur - $this->marge_droite - $this->larg_qtytoship;
					$this->posxqtyordered	= $this->posxqtytoship - $this->larg_qtyordered;
					$this->posxunit			= $this->posxqtyordered - $this->larg_unit;
					$this->posxweightvol	= $this->posxunit - $this->larg_weightvol;
					$this->posxref			= $this->marge_gauche + 1;
					$this->posxdesc			= $this->marge_gauche + $this->larg_ref + 1;
					$this->larg_desc		= $this->posxweightvol - $this->posxdesc; // Largeur variable suivant la place restante
					// Define width and position of secondary tables columns
					$this->larg_tabtotal	= $this->larg_weightvol + $this->larg_unit + $this->larg_qtyordered + $this->larg_qtytoship + 15;
					$this->larg_tabinfo		= $this->page_largeur - $this->marge_gauche - $this->marge_droite - $this->larg_tabtotal;
					$this->posxtabtotal		= $this->page_largeur - $this->marge_droite - $this->larg_tabtotal;
					// Calculs de positions
					$this->tab_hl			= 4;
					$this->decal_round		= $this->Rounded_rect > 0.001 ? $this->Rounded_rect : 0;
					$head					= $this->_pagehead($pdf, $object, 1, $outputlangs);
					$hauteurhead			= $head['totalhead'];
					$hauteurcadre			= $head['hauteurcadre'];
					$tab_top				= $hauteurhead + 5;
					$tab_top_newpage		= (empty($this->small_head2) ? $hauteurhead - $hauteurcadre : 17);
					$this->ht_top_table		= ($this->Rounded_rect * 2 > $this->height_top_table ? $this->Rounded_rect * 2 : $this->height_top_table) + $this->tab_hl * 0.5;
					$ht_colinfo				= $this->_tableau_info($pdf, $object, $this->marge_haute, $outputlangs, 1);
					$ht_coltotal			= $this->_tableau_tot($pdf, $object, $this->marge_haute, $outputlangs, 1);
					$ht2_coltotal			= ! $this->free_text_end ? pdf_InfraSPlus_free_text($pdf, $object, $this->formatpage, $this->posxtabtotal, $this->marge_haute, $outputlangs, $this->emetteur, $this->listfreet, 1, 1, $this->horLineStyle) : 0;
					if ($this->show_sign_area)
					{
						if ($ht2_coltotal > 3)	$ht_coltotal	+= $this->_signature_area($pdf, $object, $this->marge_haute, $outputlangs, 1, 1);
						else					$ht_coltotal	+= $this->_signature_area($pdf, $object, $this->marge_haute, $outputlangs, 1, 0);
					}	// if ($this->show_sign_area)
					$ht_coltotal		+= $ht2_coltotal;
					$heightforinfotot	= $ht_colinfo > $ht_coltotal ? $ht_colinfo : $ht_coltotal;
					$heightforinfotot	+= $this->free_text_end ? pdf_InfraSPlus_free_text($pdf, $object, $this->formatpage, $this->marge_gauche, $this->marge_haute, $outputlangs, $this->emetteur, $this->listfreet, 0, 1, $this->horLineStyle) : 0;
					$heightforfooter	= $this->_pagefoot($pdf, $object, $outputlangs, 1);
					// Incoterm
					$height_incoterms	= 0;
					if ($conf->incoterm->enabled)
					{
						$desc_incoterms	= $object->getIncotermsForPDF();
						if ($desc_incoterms)
						{
							$pdf->SetFont('', '', $default_font_size - 1);
							$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($desc_incoterms), 0, 1);
							$nexY					= $pdf->GetY();
							$height_incoterms		= $this->Rounded_rect * 2 > $nexY - $tab_top ? $this->Rounded_rect * 2 : $nexY - $tab_top;
							if ($this->showtblline)	$pdf->RoundedRect($this->marge_gauche, $tab_top - 1, $this->larg_util_cadre, $height_incoterms + 1, $this->Rounded_rect, '1111', null, $this->tblLineStyle);
							$height_incoterms		+= $this->tab_hl;
						}	// if ($desc_incoterms)
					}	// if ($conf->incoterm->enabled)
					$tab_top	+= $height_incoterms;
					// Livraison
					$height_livr	= 0;
					if ($head['livrshow'])
					{
						$pdf->SetFont('', 'B', $default_font_size + 2);
						$pdf->writeHTMLCell($this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $tab_top, dol_htmlentitiesbr($outputlangs->transnoentities("PDFInfraSPlusLivr")), 0, 1);
						$xlivr	= $pdf->GetX() + $pdf->GetStringWidth($outputlangs->transnoentities("PDFInfraSPlusLivr"), '', 'B', $default_font_size + 2) + 5;
						if ($this->adrlivr->name != '')
						{
							$pdf->SetFont('', 'B', $default_font_size);
							$pdf->writeHTMLCell($this->larg_util_txt - $xlivr - 3, $this->tab_hl, $xlivr, $tab_top + 0.6, dol_htmlentitiesbr($this->adrlivr->name), 0, 1);
							$nexY	= $pdf->GetY();
						}	// if ($this->adrlivr->name)
						else					$nexY	= $tab_top + 0.6;
						$pdf->SetFont('', '', $default_font_size - 1);
						$pdf->writeHTMLCell($this->larg_util_txt - $xlivr - 3, $this->tab_hl, $xlivr, $nexY, dol_htmlentitiesbr($head['livrshow']), 0, 1);
						$nexY					= $pdf->GetY();
						$height_livr			= $this->Rounded_rect * 2 > $nexY - $tab_top ? $this->Rounded_rect * 2 : $nexY - $tab_top;
						if ($this->showtblline)	$pdf->RoundedRect($this->marge_gauche, $tab_top - 1, $this->larg_util_cadre, $height_livr + 2, $this->Rounded_rect, '1111', null, $this->tblLineStyle);
						$height_livr			+= $this->tab_hl;
					}	// if ($head['livrshow'])
					$tab_top	+= $height_livr;
					// Affiche représentant, notes, Attributs supplémentaires et n° de série
					$tab_top	+= 	pdf_InfraSPlus_Notes($pdf, $object, $this->listnotep, $outputlangs, $this->exftxtcolor, $default_font_size, $tab_top, $this->larg_util_txt, $this->tab_hl, $this->posx_G_txt, $this->horLineStyle, $this->ht_top_table + $this->decal_round + $heightforfooter, $this->page_hauteur, $this->Rounded_rect, $this->showtblline, $this->marge_gauche, $this->larg_util_cadre, $this->tblLineStyle, -1);
					$nexY		= $tab_top + $this->ht_top_table + ($this->decal_round > 0 ? $this->decal_round : $this->tab_hl * 0.5);
					// Loop on each lines
					for ($i = 0 ; $i < $nblignes ; $i++)
					{
						$curY								= $nexY;
						$pdf->SetFont('', '', $default_font_size - 1);   // Into loop to work with multipage
						$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
						if (empty($this->hide_top_table))	$pdf->setTopMargin($tab_top_newpage + $this->ht_top_table + $this->decal_round);
						else								$pdf->setTopMargin($tab_top_newpage);
						$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
						$pageposbefore						= $pdf->getPage();
						$showpricebeforepagebreak			= 1;
						// We start with Photo of product line
						if (! empty($this->with_picture))
						{
							// Define size of image if we need it
							if ($this->larg_desc - 2 < $this->wpicture)	$this->wpicture	= $this->larg_desc - 2;	// corrige la largeur maximal de l'image pour être au plus égale à la largeur colonne
							$imglinesize						= array();
							if (! empty($realpatharray[$i]))	$imglinesize	= pdf_InfraSPlus_getSizeForImage($realpatharray[$i], $this->wpicture, $this->hpicture);
							if (isset($imglinesize['width']) && isset($imglinesize['height']))
							{
								if (($curY + $imglinesize['height']) > ($this->page_hauteur - ($heightforfooter)))	// If photo too high, we moved completely on new page
								{
									$pdf->AddPage('', '', true);
									pdf_InfraSPlus_bg_watermark($pdf, $this->formatpage);	// Show Watermarks
									$pdf->setPage($pageposbefore + 1);
									$curY						= $tab_top_newpage + ($this->hide_top_table ? $this->decal_round : $this->ht_top_table + $this->decal_round);
									$showpricebeforepagebreak	= 1;
								}	// if (($curY + $imglinesize['height']) > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
								$posxpicture	= ($this->posxdesc - 1) + (($this->larg_desc - 2 - $imglinesize['width']) / 2);	// centre l'image dans la colonne
								$pdf->Image($realpatharray[$i], $posxpicture, $curY, $imglinesize['width'], $imglinesize['height']);	// Use 300 dpi
								if (! empty($this->linkpictureurl))
								{
									$lineurl		= pdf_InfraSPlus_getlineurl($object, $i);
									if ($lineurl != '')
									{
										$txturl	= '<a href = "'.$lineurl.'" target = "_blank">'.$this->linkpictureurl.'</a>';
										$pdf->writeHTMLCell(0, $this->tab_hl, $posxpicture + $imglinesize['width'], $curY + ($imglinesize['height'] / 2), dol_htmlentitiesbr($txturl), 0, 1);
									}	// if ($object->lines[$i]->url)
								}	// if (! empty($this->linkpictureurl))
								$curY			+= $imglinesize['height'];	// $pdf->Image does not increase value return by getY, so we save it manually
							}	// if (isset($imglinesize['width']) && isset($imglinesize['height']))
							elseif (! empty($this->linkpictureurl))
							{
								$lineurl		= pdf_InfraSPlus_getlineurl($object, $i);
								if ($lineurl != '')
								{
									if (($curY + $this->tab_hl) > ($this->page_hauteur - ($heightforfooter)))	// If url link too high, we moved completely on new page
									{
										$pdf->AddPage('', '', true);
										pdf_InfraSPlus_bg_watermark($pdf, $this->formatpage);	// Show Watermarks
										$pdf->setPage($pageposbefore + 1);
										$curY						= $tab_top_newpage + ($this->hide_top_table ? $this->decal_round : $this->ht_top_table + $this->decal_round);
										$showpricebeforepagebreak	= 1;
									}	// if (($curY + $this->tab_hl) > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
									$txturl	= '<a href = "'.$lineurl.'" target = "_blank">'.pdf_InfraSPlus_formatNotes($object, $outputlangs, $this->linkpictureurl).'</a>';
									$pdf->writeHTMLCell(0, $this->tab_hl, $posxpicture, $curY, dol_htmlentitiesbr($txturl), 0, 1);
								}	// if ($object->lines[$i]->url)
								$curY	+= $this->tab_hl;
							}	// elseif (! empty($this->linkpictureurl))
						}	// if (! empty($this->with_picture))
						// Hauteur de la référence
						$this->heightline	= $this->tab_hl;
						// Hauteur du code barre
						if (!empty($this->show_bc_col))
						{
							$pdf->startTransaction();
							$BC					= pdf_InfraSPlus_writelineBC($pdf, $object, $i, $this->bodytxtcolor, $this->posxref, $curY, $this->wBC, $this->hBC);
							$this->heightline	= $BC < 1 ? $this->tab_hl : ($BC == 2 ? $this->dimC2D : $this->hBC);
							$pdf->rollbackTransaction(true);						
						}	// if (!empty($this->show_bc_col))
						// Hauteur de la Reference
						if (! empty($this->show_ref_col))
						{
							$pdf->startTransaction();
							$startline			= $pdf->GetY();
							$ref				= pdf_getlineref($object, $i, $outputlangs, $hidedetails);
							$pdf->MultiCell($this->larg_ref, $this->heightline, $ref, '', 'L', 0, 1, $this->posxref, $startline, true, 0, 0, false, 0, 'M', false);
							$endline			= $pdf->GetY();
							$this->heightline	= (ceil($endline) - ceil($startline)) > $this->tab_hl ? (ceil($endline) - ceil($startline)) : $this->tab_hl;
							$pdf->rollbackTransaction(true);
						}	// if (! empty($this->show_ref_col))
						// Extra fields & custom informations
						$pdf->SetLineStyle($this->horLineStyle);
						$extraDet									= '';
						// Ajout du numéro de série, s'il existe...
						$serialEquip								= '';
						$serialEquip								= pdf_InfraSPlus_getEquipementSerialDesc($object, $outputlangs, $i, 'expedition');
						$extraDet									.= empty($serialEquip) ? '' : (empty($extraDet) ? '<hr style = "width: 80%;">' : '').$serialEquip.'<hr style = "width: 80%;">';
						// extrafieldsline
						$extrafieldslines							= '';
						if (! empty($this->show_ExtraFieldsLines))	$extrafieldslines	.= pdf_InfraSPlus_ExtraFieldsLines($object->lines[$i], $extrafieldsline, $extralabelsline, $this->exfltxtcolor);
						$extraDet									.= empty($extrafieldslines) ? '' : (empty($extraDet) ? '<hr style = "width: 80%;">' : '').$extrafieldslines.'<hr style = "width: 80%;">';
						// Custom values (weight, volume and code
						$WVCC										= '';
						if ($this->showwvccchk)	$WVCC				= pdf_InfraSPlus_getlinewvdcc($object, $i, $outputlangs);
						$extraDet									.= empty($WVCC) ? '' : (empty($extraDet) ? '<hr style = "width: 80%;">' : '').$WVCC.'<hr style = "width: 80%;">';
						// Description of product line
						$pdf->startTransaction();
						pdf_InfraSPlus_writelinedesc($pdf, $object, $i, $outputlangs, $this->larg_desc, $this->heightline, $this->posxdesc, $curY, $hideref, $hidedesc, 0, $extraDet);
						$pageposafter								= $pdf->getPage();
						$pageposdesc								= $pdf->getPage();
						$posyafter									= $pdf->GetY();
						if ($pageposafter > $pageposbefore)	// There is a pagebreak
						{
							$pdf->rollbackTransaction(true);
							$pageposafter	= $pageposbefore;
							$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
							$pageposdesc	= $pdf->getPage();
							pdf_InfraSPlus_writelinedesc($pdf, $object, $i, $outputlangs, $this->larg_desc, $this->heightline, $this->posxdesc, $curY, $hideref, $hidedesc, 0, $extraDet);
							$pageposafter	= $pdf->getPage();
							$posyafter		= $pdf->GetY();
							if ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))	// There is no space left for total+free text
							{
								if ($i == ($nblignes - 1))	// No more lines, and no space left to show total, so we create a new page
								{
									$pdf->AddPage('', '', true);
									pdf_InfraSPlus_bg_watermark($pdf, $this->formatpage);	// Show Watermarks
									$pdf->setPage($pageposafter + 1);
								}	// if ($i == ($nblignes - 1))
							}	// if ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
							else	$showpricebeforepagebreak	= 0;
						}	// if ($pageposafter > $pageposbefore)
						elseif ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
						{
							$pdf->rollbackTransaction(true);
							$pageposafter	= $pageposbefore;
							$pdf->setPageOrientation('', 1, $heightforfooter);	// The only function to edit the bottom margin of current page to set it.
							$pageposdesc	= $pdf->getPage();
							pdf_InfraSPlus_writelinedesc($pdf, $object, $i, $outputlangs, $this->larg_desc, $this->heightline, $this->posxdesc, $curY, $hideref, $hidedesc, 0, $extraDet);
							$pageposafter	= $pdf->getPage();
							$posyafter		= $pdf->GetY();
							if ($i == ($nblignes - 1))	// No more lines, and no space left to show total, so we create a new page
							{
								$pdf->AddPage('', '', true);
								pdf_InfraSPlus_bg_watermark($pdf, $this->formatpage);	// Show Watermarks
								$pdf->setPage($pageposafter + 1);
							}	// if ($i == ($nblignes - 1))
						}	// elseif ($posyafter > ($this->page_hauteur - ($heightforfooter + $heightforinfotot)))
						else	$pdf->commitTransaction();	// No pagebreak
						$nexY			= $pdf->GetY();
						$pageposafter	= $pdf->getPage();
						$pdf->setPage($pageposbefore);
						$pdf->setTopMargin($this->marge_haute);
						$pdf->setPageOrientation('', 1, 0);	// The only function to edit the bottom margin of current page to set it.
						if ($pageposafter > $pageposbefore && empty($showpricebeforepagebreak))
						{
							if ($curY > ($this->page_hauteur - $heightforfooter - $this->tab_hl))
							{
								$pdf->setPage($pageposafter);
								$curY		= $tab_top_newpage + ($this->hide_top_table ? $this->decal_round : $this->ht_top_table + $this->decal_round);
							}	// if ($curY > ($this->page_hauteur - $heightforfooter - $this->tab_hl))
							else	$pdf->setPage($pageposdesc);
						}	// if ($pageposafter > $pageposbefore && empty($showpricebeforepagebreak))
						$pdf->SetFont('', '', $default_font_size - 1);   // On repositionne la police par defaut
						// Bar code or ref
						if (!empty($this->show_bc_col))	pdf_InfraSPlus_writelineBC($pdf, $object, $i, $this->bodytxtcolor, $this->posxref, $curY, $this->wBC, $this->hBC);
						if (! empty($this->show_ref_col))
						{
							$ref	= pdf_getlineref($object, $i, $outputlangs, $hidedetails);
							$pdf->MultiCell($this->larg_ref, $this->heightline, $ref, '', 'L', 0, 1, $this->posxref, $curY, true, 0, 0, false, 0, 'M', false);
						}	// if (! empty($this->show_ref_col))
						// volume & weight
						if (empty($this->hide_weight_vol))
						{
							$weighttxt	= '';
							$voltxt		= '';
							if ($object->lines[$i]->fk_product_type == 0)
							{
								if ($object->lines[$i]->weight)	$weighttxt	= round($object->lines[$i]->weight * $object->lines[$i]->qty_shipped, 2).' '.measuring_units_string($object->lines[$i]->weight_units, "weight");
								if ($object->lines[$i]->volume)	$voltxt		= round($object->lines[$i]->volume * $object->lines[$i]->qty_shipped, 2).' '.measuring_units_string($object->lines[$i]->volume_units ? $object->lines[$i]->volume_units : 0, "volume");
							}	//if ($object->lines[$i]->fk_product_type == 0)
							$pdf->writeHTMLCell($this->larg_weightvol, $this->heightline, $this->posxweightvol, $curY, $weighttxt.(($weighttxt && $voltxt) ? '<br>' : '').$voltxt, 0, 0, false, true, 'C');
						}	// if (empty($this->hide_weight_vol))
						// Unit
						if ($this->product_use_unit)
						{
							$originLine	= new OrderLine($db);
							$originLine->fetch($object->lines[$i]->fk_origin_line);
							$unit		= $outputlangs->trans($originLine->getLabelOfUnit());
							$pdf->MultiCell($this->larg_unit, $this->heightline, $unit, '', 'L', 0, 1, $this->posxunit, $curY, true, 0, 0, false, 0, 'M', false);
						}	// if ($this->product_use_unit)
						// Qty ordered
						if (empty($this->hide_ordered))	$pdf->MultiCell($this->larg_qtyordered, $this->heightline, $object->lines[$i]->qty_asked, '', 'C', 0, 1, $this->posxqtyordered, $curY, true, 0, 0, false, 0, 'M', false);
						// Qty to ship
						$pdf->MultiCell($this->larg_qtytoship, $this->heightline, $object->lines[$i]->qty_shipped, '', 'C', 0, 1, $this->posxqtytoship, $curY, true, 0, 0, false, 0, 'M', false);
						// Add dash or space between line
						if ($this->dash_between_line && $i < ($nblignes - 1))
						{
							$pdf->setPage($pageposafter);
							$pdf->line($this->marge_gauche, $nexY + 1, $this->page_largeur - $this->marge_droite, $nexY + 1, $this->horLineStyle);
							$nexY	+= 2;
						}	// if ($this->dash_between_line && $i < ($nblignes - 1))
						else	$nexY	+= $this->lineSep_hight;
						// Detect if some page were added automatically and output _tableau for past pages
						while ($pagenb < $pageposafter)
						{
							$pdf->setPage($pagenb);
							$heightforfooter				= $this->_pagefoot($pdf, $object, $outputlangs, 0);
							if ($pagenb == 1)				$this->_tableau($pdf, $object, $tab_top, $this->page_hauteur - $tab_top - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							else							$this->_tableau($pdf, $object, $tab_top_newpage, $this->page_hauteur - $tab_top_newpage - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							$pagenb++;
							$pdf->setPage($pagenb);
							$pdf->setPageOrientation('', 1, 0);	// The only function to edit the bottom margin of current page to set it.
							pdf_InfraSPlus_bg_watermark($pdf, $this->formatpage);	// Show Watermarks
							if (empty($this->small_head2))	$this->_pagehead($pdf, $object, 0, $outputlangs);
							else							$this->_pagesmallhead($pdf, $object, 0, $outputlangs);
						}	// while ($pagenb < $pageposafter)
						if (isset($object->lines[$i + 1]->pagebreak) && $object->lines[$i + 1]->pagebreak)
						{
							$heightforfooter				= $this->_pagefoot($pdf, $object, $outputlangs, 0);
							if ($pagenb == 1)				$this->_tableau($pdf, $object, $tab_top, $this->page_hauteur - $tab_top - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							else							$this->_tableau($pdf, $object, $tab_top_newpage, $this->page_hauteur - $tab_top_newpage - $heightforfooter, $outputlangs, $this->hide_top_table, 1, $pagenb);
							// New page
							$pdf->AddPage();
							pdf_InfraSPlus_bg_watermark($pdf, $this->formatpage);	// Show Watermarks
							$pagenb++;
							if (empty($this->small_head2))	$this->_pagehead($pdf, $object, 0, $outputlangs);
							else							$this->_pagesmallhead($pdf, $object, 0, $outputlangs);
							$nexY							= $tab_top_newpage + ($this->hide_top_table ? $this->decal_round : $this->ht_top_table + $this->decal_round);
						}	// if (isset($object->lines[$i + 1]->pagebreak) && $object->lines[$i + 1]->pagebreak)
					}	// for ($i = 0 ; $i < $nblignes ; $i++)
					$bottomlasttab		= $this->page_hauteur - $heightforinfotot - $heightforfooter - 1;
					if ($pagenb == 1)	$this->_tableau($pdf, $object, $tab_top, $bottomlasttab - $tab_top, $outputlangs, $this->hide_top_table, 1, $pagenb);
					else				$this->_tableau($pdf, $object, $tab_top_newpage, $bottomlasttab - $tab_top_newpage, $outputlangs, $this->hide_top_table, 0, $pagenb);
					$posyinfo			= $this->_tableau_info($pdf, $object, $bottomlasttab, $outputlangs, 0);
					$posytot			= $this->_tableau_tot($pdf, $object, $bottomlasttab, $outputlangs, 0);
					$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
					$posyfreetext		= ! $this->free_text_end ? pdf_InfraSPlus_free_text($pdf, $object, $this->formatpage, $this->posxtabtotal, $posytot, $outputlangs, $this->emetteur, $this->listfreet, 1, 0, $this->horLineStyle) : $posytot;
					if ($this->show_sign_area)
					{
						if ($ht2_coltotal > 3)	$posysignarea	= $this->_signature_area($pdf, $object, $posyfreetext, $outputlangs, 0, 1);
						else					$posysignarea	= $this->_signature_area($pdf, $object, $posyfreetext, $outputlangs, 0, 0);
					}	// if ($this->show_sign_area)
					else										$posysignarea	= $posyfreetext;
					$posy										= $posyinfo > $posysignarea ? $posyinfo : $posysignarea;
					$posy										= $this->free_text_end ? pdf_InfraSPlus_free_text($pdf, $object, $this->formatpage, $this->marge_gauche, $posy, $outputlangs, $this->emetteur, $this->listfreet, 0, 0, $this->horLineStyle) : $posy;					
					$this->_pagefoot($pdf, $object, $outputlangs, 0);
					if (method_exists($pdf, 'AliasNbPages'))	$pdf->AliasNbPages();
					// if merge files is active
					if (!empty($this->files))					pdf_InfraSPlus_files($pdf, $this->files, $this->hidepagenum, $object, $outputlangs, $this->formatpage);
					$pdf->Close();
					$pdf->Output($file, 'F');
					// Add pdfgeneration hook
					$hookmanager->initHooks(array('pdfgeneration'));
					$parameters									= array('file'=>$file, 'object'=>$object, 'outputlangs'=>$outputlangs);
					global $action;
					$reshook									= $hookmanager->executeHooks('afterPDFCreation',$parameters,$this,$action);    // Note that $action and $object may have been modified by some hooks
					if ($reshook < 0)
					{
						$this->error	= $hookmanager->error;
						$this->errors	= $hookmanager->errors;
					}	// if ($reshook < 0)
					if (! empty($this->main_umask))	@chmod($file, octdec($this->main_umask));
					$this->result					= array('fullpath' => $file);
					return 1;   // Pas d'erreur
				}	// if (file_exists($dir))
				else
				{
					$this->error=$outputlangs->trans("ErrorCanNotCreateDir",$dir);
					return 0;
				}	// else	// if (file_exists($dir))
			}	// if ($conf->expedition->dir_output)
			else
			{
				$this->error=$outputlangs->trans("ErrorConstantNotDefined","EXP_OUTPUTDIR");
				return 0;
			}	// else	// if ($conf->expedition->dir_output)
		}	// public function write_file($object, $outputlangs, $srctemplatepath = '', $hidedetails = 0, $hidedesc = 0, $hideref = 0)

		/********************************************
		*	Show top header of page.
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object     	Object to show
		*	@param		int	    	$showaddress    0=no, 1=yes
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		string		$titlekey		Translation key to show as title of document
		*	@return		array		$hauteurhead	'totalhead'		= hight of header
		*											'hauteurcadre	= hight of frame
		********************************************/
		protected function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PDFInfraSPlusExpeditionTitle")
		{
			global $conf, $hookmanager;

			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$pdf->SetTextColor($this->headertxtcolor[0], $this->headertxtcolor[1], $this->headertxtcolor[2]);
			$pdf->SetFont('', 'B', $default_font_size + 3);
			$dimCadres		= array ('S' => 92, 'R' => 92);
			$w				= $this->header_align_left ? $dimCadres['R'] - $this->decal_round : 100;
			$align			= $this->header_align_left ? 'L' : 'R';
			$posy			= $this->marge_haute;
			$posx			= $this->page_largeur - $this->marge_droite - $w;
			// Logo
			$heightLogo		= pdf_InfraSPlus_logo($pdf, $outputlangs, $posy, $w, $this->logo, $this->emetteur, $this->marge_gauche, $this->tab_hl, $this->headertxtcolor);
			$heightLogo		+= $posy + $this->tab_hl;
			$pdf->SetFont('', 'B', $default_font_size * $this->title_size);
			$title			= $outputlangs->transnoentities($titlekey);
			$pdf->MultiCell($w, $this->tab_hl * 2, $title, '', 'R', 0, 1, $posx, $posy, true, 0, 0, false, 0, 'M', false);
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$posy			+= $this->tab_hl * 2;
			$txtref			= $outputlangs->transnoentities("RefSending")." : ".$outputlangs->convToOutputCharset($object->ref);
			if ($object->statut == 0)
			{
				$pdf->SetTextColor(128, 0, 0);
				$txtref .= ' - '.$outputlangs->transnoentities("NotValidated");
			}	// if ($object->statut == 0)
			$pdf->MultiCell($w, $this->tab_hl, $txtref, '', $align, 0, 1, $posx, $posy, true, 0, 0, false, 0, 'M', false);
			$pdf->SetTextColor($this->headertxtcolor[0], $this->headertxtcolor[1], $this->headertxtcolor[2]);
			$pdf->SetFont('', ($this->datesbold ? 'B' : ''), $default_font_size - 2);
			if ($object->date_delivery)
			{
				$posy		+= $this->tab_hl;
				$txtdt		= $outputlangs->transnoentities("DateDeliveryPlanned")." : ".dol_print_date($object->date_delivery, "dayhour", false, $outputlangs, true);
				$pdf->MultiCell($w, $this->tab_hl, $txtdt, '', $align, 0, 1, $posx, $posy, true, 0, 0, false, 0, 'M', false);
			}	// if ($object->date_delivery)
			$pdf->SetFont('', '', $default_font_size - 2);
			if ($object->ref_customer)
			{
				$posy	+= $this->tab_hl - 0.5;
				$txtcc	= '';
				$txtcc	.= $outputlangs->transnoentities("RefCustomer")." : ".$outputlangs->convToOutputCharset($object->ref_customer);
				$pdf->MultiCell($w, $this->tab_hl, $txtcc, '', $align, 0, 1, $posx, $posy, true, 0, 0, false, 0, 'M', false);
			}	// if ($object->ref_customer)			
			// Show list of linked objects
			$posy			= pdf_InfraSPlus_writeLinkedObjects($pdf, $object, $outputlangs, $posx, $posy, $w, $this->tab_hl, $align, '');
			$posy			+= 0.5;
			$dimCadres['Y']	= ($this->use_iso_location && $posy <= 40 ? 40 : ($heightLogo > $posy + $this->tab_hl ? $heightLogo : $posy + $this->tab_hl));
			if ($showaddress)
			{
				$arrayidcontact	= array('I' => $object->getIdContact('internal', 'SALESREPFOLL'),
										'E' => $object->getIdContact('external', 'SHIPPING')
										);
				$addresses		= array();
				$addresses		= pdf_InfraSPlus_getAddresses($object, $outputlangs, $arrayidcontact, $this->adr, $this->adrlivr, $this->emetteur);
				$hauteurcadre	= pdf_InfraSPlus_writeAddresses($pdf, $object, $outputlangs, $this->formatpage, $dimCadres, $this->tab_hl, $this->emetteur, $addresses, $this->Rounded_rect);
			}	// if ($showaddress)
			$hauteurhead	= array('totalhead'		=> $dimCadres['Y'] + $hauteurcadre,
									'hauteurcadre'	=> $hauteurcadre,
									'livrshow'		=> $addresses['livrshow']
									);
			return $hauteurhead;
		}	// protected function _pagehead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PDFInfraSPlusExpeditionTitle")

		/********************************************
		*	Show top small header of page.
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object     	Object to show
		*	@param		int	    	$showaddress    0=no, 1=yes
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		string		$titlekey		Translation key to show as title of document
		*	@return		void
		********************************************/
		protected function _pagesmallhead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PDFInfraSPlusExpeditionTitle")
		{
			global $conf, $hookmanager;
			
			$fromcompany	= $this->emetteur;
			$title			= $outputlangs->transnoentities($titlekey);
			pdf_InfraSPlus_pagesmallhead($pdf, $object, $showaddress, $outputlangs, $title, $fromcompany, $this->formatpage, $this->decal_round, $this->logo, $this->headertxtcolor);
		}	// protected function _pagesmallhead(&$pdf, $object, $showaddress, $outputlangs, $titlekey = "PDFInfraSPlusExpeditionTitle")

		/********************************************
		*   Show table for lines
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param  	Object		$object     	Object to show
		*	@param		float		$tab_top		Top position of table
		*	@param		float		$tab_height		Height of table (rectangle)
		*	@param		Translate	$outputlangs	Langs object
		*	@param		int			$hidetop		1=Hide top bar of array and title, 0=Hide nothing, -1=Hide only title
		*	@param		int			$hidebottom		Hide bottom bar of array
		*	@return		void
		********************************************/
		protected function _tableau(&$pdf, $object, $tab_top, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)
		{
			global $conf;

			// Force to disable hidetop and hidebottom
			$hidebottom			= 0;
			if ($hidetop)		$hidetop	= -1;
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			$pdf->SetFont('', '', $default_font_size - 2);
			// Output Rounded Rectangle
			if (empty($hidetop) || $pagenb == 1)
			{
				if (! empty($this->title_bg))	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111', 'DF', $this->tblLineStyle, $this->bg_color);
				else if ($this->showtblline)	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $this->ht_top_table, $this->Rounded_rect, '1111', null, $this->tblLineStyle);
				if ($this->showtblline)			$pdf->RoundedRect($this->marge_gauche, $tab_top + $this->ht_top_table + $this->bgLineW, $this->larg_util_cadre, $tab_height - ($this->ht_top_table + $this->bgLineW), $this->Rounded_rect, '1111', null, $this->tblLineStyle);
				else							$pdf->line($this->marge_gauche, $tab_top + $tab_height, $this->marge_gauche + $this->larg_util_cadre, $tab_top + $tab_height, $this->horLineStyle);
			}	// if (empty($hidetop) || $pagenb == 1)
			else
				if ($this->showtblline)	$pdf->RoundedRect($this->marge_gauche, $tab_top, $this->larg_util_cadre, $tab_height, $this->Rounded_rect, '1111', null, $this->tblLineStyle);
			if ($object->statut == 0 && (! empty($this->draft_watermark)))
			{
				if (empty($hidetop))	pdf_InfraSPlus_watermark($pdf, $outputlangs, $this->draft_watermark, $tab_top + $this->ht_top_table + ($tab_height / 2), $this->larg_util_cadre, $this->page_hauteur, 'mm');
				else					pdf_InfraSPlus_watermark($pdf, $outputlangs, $this->draft_watermark, $tab_top + ($tab_height / 2), $this->larg_util_cadre, $this->page_hauteur, 'mm');
				$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			}	// if ($object->statut == 0 && (! empty($this->draft_watermark)))
			// Show Folder mark
			if (! empty($this->fold_mark))
			{
				$pdf->Line(0, ($this->page_hauteur)/3, $this->fold_mark, ($this->page_hauteur)/3, $this->stdLineStyle);
				$pdf->Line($this->page_largeur - $this->fold_mark, ($this->page_hauteur)/3, $this->page_largeur, ($this->page_hauteur)/3, $this->stdLineStyle);
			}	// if (! empty($this->fold_mark))
			// Colonnes
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$this->title_bg ? $pdf->SetTextColor($this->txtcolor[0], $this->txtcolor[1], $this->txtcolor[2]) : $pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			if ($this->showtblline)
			{
				if (! empty($this->show_ref_col) || !empty($this->show_bc_col))	$pdf->line($this->posxdesc, $tab_top, $this->posxdesc, $tab_top + $tab_height, $this->tblLineStyle);
				if (empty($this->hide_weight_vol))								$pdf->line($this->posxweightvol, $tab_top, $this->posxweightvol, $tab_top + $tab_height, $this->tblLineStyle);
				if ($this->product_use_unit)									$pdf->line($this->posxunit, $tab_top, $this->posxunit, $tab_top + $tab_height, $this->tblLineStyle);
				if (empty($this->hide_ordered))									$pdf->line($this->posxqtyordered, $tab_top, $this->posxqtyordered, $tab_top + $tab_height, $this->tblLineStyle);
				$pdf->line($this->posxqtytoship, $tab_top, $this->posxqtytoship, $tab_top + $tab_height, $this->tblLineStyle);
			}	// if ($this->showtblline)
			// En-têtes
			if (empty($hidetop) || $pagenb == 1)
			{
				if (!empty($this->show_bc_col))		$pdf->MultiCell($this->larg_ref, $this->ht_top_table, $outputlangs->transnoentities("PDFInfraSPlusCB"), '', 'C', 0, 1, $this->posxref, $tab_top, true, 0, false, true, $this->ht_top_table, 'M', false);
				if (! empty($this->show_ref_col))	$pdf->MultiCell($this->larg_ref, $this->ht_top_table, $outputlangs->transnoentities("PDFInfraSPlusRef"), '', 'C', 0, 1, $this->posxref, $tab_top, true, 0, false, true, $this->ht_top_table, 'M', false);
				$pdf->MultiCell($this->larg_desc, $this->ht_top_table, $outputlangs->transnoentities("Designation"), '', 'C', 0, 1, $this->posxdesc, $tab_top, true, 0, 0, true, $this->ht_top_table, 'M', false);
				if (empty($this->hide_weight_vol))	$pdf->MultiCell($this->larg_weightvol, $this->ht_top_table, $outputlangs->transnoentities("WeightVolShort"), '', 'C', 0, 1, $this->posxweightvol, $tab_top, true, 0, false, true, $this->ht_top_table, 'M', false);
				if ($this->product_use_unit)		$pdf->MultiCell($this->larg_unit, $this->ht_top_table, $outputlangs->transnoentities("Unit"), '', 'C', 0, 1, $this->posxunit, $tab_top, true, 0, false, true, $this->ht_top_table, 'M', false);
				if (empty($this->hide_ordered))		$pdf->MultiCell($this->larg_qtyordered, $this->ht_top_table, $outputlangs->transnoentities("PDFInfraSPlusExpeditionOrdered"), '', 'C', 0, 1, $this->posxqtyordered, $tab_top, true, 0, false, true, $this->ht_top_table, 'M', false);
				$pdf->MultiCell($this->larg_qtytoship, $this->ht_top_table, $outputlangs->transnoentities("PDFInfraSPlusExpeditionShipped"), '', 'C', 0, 1, $this->posxqtytoship, $tab_top, true, 0, false, true, $this->ht_top_table, 'M', false);
			}	// if (empty($hidetop) || $pagenb == 1)
		}	// protected function _tableau(&$pdf, $object, $tab_top, $tab_height, $outputlangs, $hidetop = 0, $hidebottom = 0, $pagenb)

		/********************************************
		*	Show miscellaneous information (payment mode, payment term, ...)
		*
		*	@param		PDF			$pdf     		Object PDF
		*	@param		Object		$object			Object to show
		*	@param		int			$posy			Y
		*	@param		Translate	$outputlangs	Langs object
		*	@return		int			$posy			Position pour suite
		********************************************/
		protected function _tableau_info(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)
		{
			global $conf, $db;
			
			$pdf->startTransaction();
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$posytabinfo		= $posy + 1;
			$tabinfo_hl			= $this->tab_hl;
			$pdf->SetFont('', '', $default_font_size - 1);
			$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			$larg_tabinfo		= $this->larg_tabinfo;
			$larg_col1info		= 47;
			$larg_col2info		= $larg_tabinfo - $larg_col1info;
			$posxtabinfo		= $this->marge_gauche;
			$posxcol2info		= $posxtabinfo + $larg_col1info;
			if ($object->shipping_method_id > 0)
			{
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$titre			= $outputlangs->transnoentities("SendingMethod").' : ';
				$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, '', 'L', 0, 1, $posxtabinfo, $posytabinfo, true, 0, 0, false, 0, 'M', false);
				$pdf->SetFont('', '', $default_font_size - 2);
				$label			= '';
				$code			= $outputlangs->getLabelFromKey($db, $object->shipping_method_id, 'c_shipment_mode', 'rowid', 'code');	// Get code using getLabelFromKey
				$label			.= $outputlangs->trans("SendingMethod".strtoupper($code));
				$pdf->MultiCell($larg_col2info, $tabinfo_hl, $label, '', 'L', 0, 1, $posxcol2info, $posytabinfo, true, 0, 0, false, 0, 'M', false);
				$posytabinfo	= $pdf->GetY() + 1;
			}	//if ($object->shipping_method_id > 0)
			if (! empty($object->tracking_number))
			{
				$object->GetUrlTrackingStatus($object->tracking_number);
				$pdf->SetFont('', 'B', $default_font_size - 2);
				$titre			= $outputlangs->transnoentities("TrackingNumber").' : ';
				$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, '', 'L', 0, 1, $posxtabinfo, $posytabinfo, true, 0, 0, false, 0, 'M', false);
				$pdf->SetFont('', '', $default_font_size - 2);
				$pdf->MultiCell($larg_col2info, $tabinfo_hl, $object->tracking_number, '', 'L', 0, 1, $posxcol2info, $posytabinfo, true, 0, 0, false, 0, 'M', false);
				$posytabinfo	= $pdf->GetY() + 1;
				if (! empty($object->tracking_url) && $object->tracking_url != $object->tracking_number)
				{
					$pdf->SetFont('', 'B', $default_font_size - 2);
					$titre			= $outputlangs->transnoentities("LinkToTrackYourPackage").' : ';
					$pdf->MultiCell($larg_col1info, $tabinfo_hl, $titre, '', 'L', 0, 1, $posxtabinfo, $posytabinfo, true, 0, 0, false, 0, 'M', false);
					$pdf->SetFont('', '', $default_font_size - 2);
					$pdf->writeHTMLCell($larg_col2info, $tabinfo_hl, $posxcol2info, $posytabinfo, $object->tracking_url, 0, 1, false, true, 'L');
					$posytabinfo	= $pdf->GetY() + 1;
				}	// if (! empty($object->tracking_url) && $object->tracking_url != $object->tracking_number)
			}	// if (! empty($object->tracking_number))
			if ($calculseul)
			{
				$heightforinfo							= $posytabinfo - $posy;
				$pdf->rollbackTransaction(true);
				return $heightforinfo;
			}	// if ($calculseul)
			else
			{
				$pdf->commitTransaction();
				return $posytabinfo;
			}	// else // if ($calculseul)
		}	// protected function _tableau_info(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)

		/********************************************
		*	Show total to pay
		*
		*	@param		PDF			$pdf            Object PDF
		*	@param		Facture		$object         Object invoice
		*	@param		int			$posy			y
		*	@param		Translate	$outputlangs	Objet langs
		*	@return		int							Position pour suite
		********************************************/
		protected function _tableau_tot(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)
		{
			global $conf;
			
			$pdf->startTransaction();
			$default_font_size	= pdf_getPDFFontSize($outputlangs);
			$posytabtot			= $posy + 1;
			$tabtot_hl			= $this->tab_hl;
			$pdf->SetFont('', '', $default_font_size - 1);
			$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			// Tableau total
			$larg_tabtotal		= $this->larg_tabtotal;
			$larg_col4total		= $this->larg_qtytoship;
			$larg_col3total		= $this->larg_qtyordered;
			$larg_col2total		= $this->larg_weightvol;
			$larg_col1total		= $larg_tabtotal - $larg_col4total - $larg_col3total - $larg_col2total;
			$posxtabtotal		= $this->posxtabtotal;
			$posxcol4total		= $this->posxqtytoship;
			$posxcol3total		= $this->posxqtyordered;
			$posxcol2total		= $this->posxweightvol;
			$index				= 0;
			$totalWeighttoshow	= '';
			$totalVolumetoshow	= '';
			// Load dim data
			$tmparray			= $object->getTotalWeightVolume();
			$totalWeight		= round($tmparray['weight'], 2);
			$totalVolume		= $tmparray['volume'];
			$totalOrdered		= $tmparray['ordered'];
			$totalToShip		= $tmparray['toship'];
			// Set true Volume and volume_units not currently stored into database
			if ($object->trueWidth && $object->trueHeight && $object->trueDepth)
			{
				$object->trueVolume		= price(($object->trueWidth * $object->trueHeight * $object->trueDepth), 0, $outputlangs, 0, 0);
				$object->volume_units	= $object->size_units * 3;
			}	// if ($object->trueWidth && $object->trueHeight && $object->trueDepth)
			if ($totalWeight != '')		$totalWeighttoshow	= showDimensionInBestUnit($totalWeight, 0, "weight", $outputlangs);
			if ($totalVolume != '')		$totalVolumetoshow	= showDimensionInBestUnit($totalVolume, 0, "volume", $outputlangs);
			if ($object->trueWeight)	$totalWeighttoshow	= showDimensionInBestUnit($object->trueWeight, $object->weight_units, "weight", $outputlangs);
			if ($object->trueVolume)	$totalVolumetoshow	= showDimensionInBestUnit($object->trueVolume, $object->volume_units, "volume", $outputlangs);
			// Totaux
			$pdf->RoundedRect($posxtabtotal, $posytabtot, $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF', $this->bgLineStyle, $this->bg_color);
			$pdf->SetFont('', 'B', $default_font_size - 1);
			$this->title_bg ? $pdf->SetTextColor($this->txtcolor[0], $this->txtcolor[1], $this->txtcolor[2]) : $pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			$pdf->MultiCell($larg_col1total, $tabtot_hl, $outputlangs->transnoentities("Total"), '', 'L', 0, 1, $posxtabtotal, $posytabtot + ($tabtot_hl * $index), true, 0, 0, false, 0, 'M', false);
			// Total to ship
			$pdf->MultiCell($larg_col4total, $tabtot_hl, $totalToShip, '', 'C', 0, 1, $posxcol4total, $posytabtot + ($tabtot_hl * $index), true, 0, 0, false, 0, 'M', false);
			// Total ordered
			if (empty($this->hide_ordered))	$pdf->MultiCell($larg_col3total, $tabtot_hl, $totalOrdered, '', 'C', 0, 1, $posxcol3total, $posytabtot + ($tabtot_hl * $index), true, 0, 0, false, 0, 'M', false);
			// Total weight
			if (empty($this->hide_weight_vol))
			{
				if ($totalWeighttoshow)
				{
					$pdf->MultiCell($larg_col2total, $tabtot_hl, $totalWeighttoshow, '', 'C', 0, 1, $posxcol2total, $posytabtot + ($tabtot_hl * $index), true, 0, 0, false, 0, 'M', false);
					$index++;
				}	// if ($totalWeighttoshow)
				// Total volume
				if ($totalVolumetoshow)
				{
					$pdf->RoundedRect($posxtabtotal, $posytabtot + (($tabtot_hl + $this->bgLineW) * $index), $larg_tabtotal, $tabtot_hl, $this->Rounded_rect > $tabtot_hl / 2 ? $tabtot_hl / 2 : $this->Rounded_rect, '1111', 'DF', $this->bgLineStyle, $this->bg_color);
					$pdf->MultiCell($larg_col2total, $tabtot_hl, $totalVolumetoshow, '', 'C', 0, 1, $posxcol2total, $posytabtot + ($tabtot_hl * $index), true, 0, 0, false, 0, 'M', false);
					$index++;
				}	// if ($totalVolumetoshow)
			}	// if (empty($this->hide_weight_vol))
			$pdf->SetFont('', '', $default_font_size - 1);
			$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			$posytabtot	= $pdf->GetY() + 1;
			if ($calculseul)
			{
				$heightfortot	= $posytabtot - $posy;
				$pdf->rollbackTransaction(true);
				return $heightfortot;
			}	// if ($calculseul)
			else
			{
				$pdf->commitTransaction();
				return $posytabtot;
			}	// else // if ($calculseul)
		}	// protected function _tableau_tot(&$pdf, $object, $posy, $outputlangs, $calculseul = 0)

		/********************************************
		*	Show area for the customer to sign
		*
		*	@param		PDF			$pdf            Object PDF
		*	@param		Facture		$object         Object invoice
		*	@param		int			$posy			y
		*	@param		Translate	$outputlangs	Objet langs
		*	@return		int							Position pour suite
		********************************************/
		protected function _signature_area(&$pdf, $object, $posy, $outputlangs, $calculseul = 0, $freetext = 0)
		{
			$pdf->startTransaction();
			$default_font_size		= pdf_getPDFFontSize($outputlangs);
			$signarea_top			= $posy + 1;
			$signarea_hl			= $this->tab_hl;
			$pdf->SetFont('', '', $default_font_size - 2);
			$pdf->SetTextColor($this->bodytxtcolor[0], $this->bodytxtcolor[1], $this->bodytxtcolor[2]);
			$larg_signarea			= $this->larg_tabtotal;
			$posxsignarea			= $this->posxtabtotal;
			if ($freetext)			$pdf->Line($posxsignarea, $posy, $this->page_largeur - $this->marge_droite, $posy, $this->horLineStyle);
			$pdf->MultiCell($larg_signarea, $signarea_hl, $outputlangs->transnoentities("PDFInfraSPlusExpeditionCustomerSignature"), '', 'L', 0, 1, $posxsignarea + $this->decal_round, $signarea_top, true, 0, 0, false, 0, 'M', false);
			$pdf->RoundedRect($posxsignarea, $signarea_top + $signarea_hl, $larg_signarea, $this->ht_signarea, $this->Rounded_rect, '1111', null, $this->signLineStyle);
			if ($this->signvalue)	pdf_InfraSPlus_Client_Sign($pdf, $this->signvalue, $larg_signarea, $this->ht_signarea, $posxsignarea, $signarea_top + $signarea_hl);
			if ($calculseul)
			{
				$heightforarea	= ($signarea_top + $signarea_hl + $this->ht_signarea + 1) - $posy;
				$pdf->rollbackTransaction(true);
				return $heightforarea;
			}	// if ($calculseul)
			else
			{
				$pdf->commitTransaction();
				return $signarea_top + $signarea_hl + $this->ht_signarea + 1;
			}	// else // if ($calculseul)
		}	// protected function _signature_area(&$pdf, $object, $posy, $outputlangs, $calculseul = 0, $freetext = 0)

		/********************************************
		*	Show footer of page. Need this->emetteur object
		*
		*	@param		PDF			$pdf     		The PDF factory
		*	@param		Translate	$outputlangs	Object lang for output
		*	@param		Societe		$fromcompany	Object company
		*	@param		int			$marge_basse	Margin bottom we use for the autobreak
		*	@param		int			$marge_gauche	Margin left
		*	@param		int			$page_hauteur	Page height
		*	@param		Object		$object			Object shown in PDF
		*	@param		int			$showdetails	Show company details into footer
		*	@param		int			$hidesupline	Completly hide the line up to footer (for some edition with only table)
		*	@param		int			$calculseul		Arrête la fonction au calcul de hauteur nécessaire
		*	@return		int							Return height of bottom margin including footer text
		********************************************/
		protected function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)
		{
			global $conf;
			
			$showdetails				= $this->type_foot;
			if (! empty($this->pied))	$showdetails	.= 1;
			else						$showdetails	.= 0;
			return pdf_InfraSPlus_pagefoot($pdf, $outputlangs, $this->emetteur, $this->formatpage, $showdetails, 0, $calculseul, $this->pied, $this->maxsizeimgfoot, $this->hidepagenum, $this->bodytxtcolor, $this->stdLineStyle);
		}	// protected function _pagefoot(&$pdf, $object, $outputlangs, $calculseul)

	}	// class pdf_InfraSPlus_EX extends ModelePdfExpedition
?>
