--	/************************************************
--	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
--	*
--	* This program is free software: you can redistribute it and/or modify
--	* it under the terms of the GNU General Public License as published by
--	* the Free Software Foundation, either version 3 of the License, or
--	* (at your option) any later version.
--	*
--	* This program is distributed in the hope that it will be useful,
--	* but WITHOUT ANY WARRANTY; without even the implied warranty of
--	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--	* GNU General Public License for more details.
--	*
--	* You should have received a copy of the GNU General Public License
--	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
--	************************************************/

--	/************************************************
--	* 	\file		../infraspackplus/sql/llx_c_infraspackplus_note.sql
--	* 	\ingroup	InfraS
--	* 	\brief		Create SQL table for module InfraS
--	************************************************/

CREATE TABLE IF NOT EXISTS llx_c_infraspackplus_note
(
  rowid			integer AUTO_INCREMENT	PRIMARY KEY,
  code			varchar(32)				NOT NULL,
  entity		integer	DEFAULT 1		NOT NULL,		-- multi company id
  pos			varchar(32)				NOT NULL,
  libelle		varchar(128)			NOT NULL,
  active		integer DEFAULT 1
)ENGINE = innodb;

SELECT @tname1 := TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME LIKE '%const';
SELECT @tname2 := TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME LIKE '%c_infraspackplus_note';
SELECT @cola := COLLATION_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = @tname1 AND COLUMN_NAME = 'name';
SELECT @cha := CHARACTER_SET_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME =@tname1 AND COLUMN_NAME = 'name';

SET @req = CONCAT('ALTER TABLE ',@tname2,' CONVERT TO CHARACTER SET ',@cha,' COLLATE ',@cola,';');

PREPARE stmt FROM @req;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;