<?php
	/************************************************
	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspackplus/admin/generalpdf.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup the module InfraS
	************************************************/

	// Dolibarr environment *************************
	require '../config.php';

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formadmin.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	dol_include_once('/infraspackplus/core/lib/infraspackplus.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load("companies");
	$langs->load('infraspackplus@infraspackplus');

	// Access control *******************************
	$accesright																			= 0;
	if (! empty($user->admin) || ! empty($user->rights->infraspackplus->paramDolibarr))	$accesright	= 1;
	if (empty($accesright))																accessforbidden();

	// Actions **************************************
	$formadmin	= new FormAdmin($db);
	$action		= GETPOST('action','alpha');
	$result		= '';
	$list		= array ('MAIN_PDF_MARGIN_LEFT', 'MAIN_PDF_MARGIN_TOP', 'MAIN_PDF_MARGIN_RIGHT', 'MAIN_PDF_MARGIN_BOTTOM', 'MAIN_PDF_FORMAT', 
							'PDF_HIDE_PRODUCT_REF_IN_SUPPLIER_LINES');
	if ($action == 'update')
	{
		$error	= 0;
		foreach ($list as $constname)
		{
			$constvalue	= GETPOST($constname, 'alpha');
			$result		= dolibarr_set_const($db, $constname, $constvalue, 'chaine', 0, '', $conf->entity);
		}	// foreach ($list as $constname)
	}	// if ($action == 'update')
	if ($action == 'setnomylogo')	$result	= dolibarr_set_const($db, "PDF_DISABLE_MYCOMPANY_LOGO",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setinvertsr')	$result	= dolibarr_set_const($db, "MAIN_INVERT_SENDER_RECIPIENT",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setalias')		$result	= dolibarr_set_const($db, "PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setsoccontact')	$result	= dolibarr_set_const($db, "MAIN_USE_COMPANY_NAME_OF_CONTACT",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setisoloc')		$result	= dolibarr_set_const($db, "MAIN_PDF_USE_ISO_LOCATION",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'settvaintra')	$result	= dolibarr_set_const($db, "MAIN_TVAINTRA_NOT_IN_ADDRESS",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid1')		$result	= dolibarr_set_const($db, "MAIN_PROFID1_IN_ADDRESS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid2')		$result	= dolibarr_set_const($db, "MAIN_PROFID2_IN_ADDRESS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid3')		$result	= dolibarr_set_const($db, "MAIN_PROFID3_IN_ADDRESS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid4')		$result	= dolibarr_set_const($db, "MAIN_PROFID4_IN_ADDRESS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setid5')		$result	= dolibarr_set_const($db, "MAIN_PROFID5_IN_ADDRESS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdash')		$result	= dolibarr_set_const($db, "MAIN_PDF_DASH_BETWEEN_LINES",			GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setref')
	{
		$result	= dolibarr_set_const($db, "MAIN_GENERATE_DOCUMENTS_HIDE_REF", GETPOST('value'), 'chaine', 0, '', $conf->entity);
		if (empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_REF))
		{
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_REF_COLUMN",	0, 'chaine', 0, '', $conf->entity);
			$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_WITH_SUPPLIER_REF_COLUMN", 0, 'chaine', 0, '', $conf->entity);
		}	// if (empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_REF))
	}	// if ($action == 'setref')
	if ($action == 'setdesc')		$result	= dolibarr_set_const($db, "MAIN_GENERATE_DOCUMENTS_HIDE_DESC",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdescfirst')	$result	= dolibarr_set_const($db, "MAIN_DOCUMENTS_DESCRIPTION_FIRST",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setweightvol')	$result	= dolibarr_set_const($db, "SHIPPING_PDF_HIDE_WEIGHT_AND_VOLUME",	GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setunit')		$result	= dolibarr_set_const($db, "PRODUCT_USE_UNITS",						GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setprodmerge')	$result	= dolibarr_set_const($db, "PRODUIT_PDF_MERGE_PROPAL",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setdepositpay')	$result	= dolibarr_set_const($db, "FACTURE_DEPOSITS_ARE_JUST_PAYMENTS",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpaycond')	$result	= dolibarr_set_const($db, "PROPALE_PDF_HIDE_PAYMENTTERMCOND",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpaymode')	$result	= dolibarr_set_const($db, "PROPALE_PDF_HIDE_PAYMENTTERMMOD",		GETPOST('value'), 'chaine', 0, '', $conf->entity);
	if ($action == 'setpaydetinv')	$result	= dolibarr_set_const($db, "INVOICE_NO_PAYMENT_DETAILS",				GETPOST('value'), 'chaine', 0, '', $conf->entity);
	// Retour => message Ok ou Ko
	if ($result == 1)	setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	if ($result == -1)	setEventMessages($langs->trans("Error"), null, 'errors');

	// init variables *******************************
	$selected		= isset($conf->global->MAIN_PDF_FORMAT)	? $conf->global->MAIN_PDF_FORMAT : dol_getDefaultFormat();
	$noCountryCode	= (empty($mysoc->country_code) ? true : false);
	if (! $noCountryCode)
	{
		$pid1				= $langs->transcountry("ProfId1",$mysoc->country_code);
		if ($pid1 == '-')	$pid1	= false;
		$pid2				= $langs->transcountry("ProfId2",$mysoc->country_code);
		if ($pid2 == '-')	$pid2	= false;
		$pid3				= $langs->transcountry("ProfId3",$mysoc->country_code);
		if ($pid3 == '-')	$pid3	= false;
		$pid4				= $langs->transcountry("ProfId4",$mysoc->country_code);
		if ($pid4 == '-')	$pid4	= false;
		$pid5				= $langs->transcountry("ProfId5",$mysoc->country_code);
		if ($pid5 == '-')	$pid5	= false;
	}	// if (! $noCountryCode)
	else
	{
		$pid1	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid2	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid3	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid4	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
		$pid5	= img_warning().' <font class = "error">'.$langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("CompanyCountry")).'</font>';
	}	// else // if (! $noCountryCode)
	$rowSpan	= $conf->global->INFRASPLUS_PDF_HIDE_LABEL	? 23	: 24;

	// View *****************************************
	$page_name					= $langs->trans("infrasplussetup") ." - ". $langs->trans("InfraSPlusParamsGeneralPDF");
	llxHeader('', $page_name);
	if (! empty($user->admin))	$linkback	= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	else						$linkback	= '';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	
	// Configuration header *************************
	$head	= infraspackplus_admin_prepare_head();
	$picto	= 'infraspackplus@infraspackplus';
	dol_fiche_head($head, 'generalpdf', $langs->trans("modcomnamePackPlus"), 0, $picto);

	// setup page goes here *************************
	print '		<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">';
	print load_fiche_titre($langs->trans("GeneralDol"), '', dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1);
	print '			<table class = "noborder" width = "100%">
						<colgroup>
							<col width = "*">
							<col width = "156px">
							<col width = "120px">
						</colgroup>
						<tr class = "liste_titre">
							<td align = "center">'.$langs->trans('Description').'</td>
							<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
							<td>&nbsp;</td>
						</tr>';
	print '				<tr>
							<td colspan = "2" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "'.$rowSpan.'" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "update" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
	if (! empty($accesright))
	{
		print '			<tr class = "oddeven">
							<td colspan = "2">
								<table width = "100%">
									<tr>
										<td width = "250px" style = "margin: 0; padding: 0; border: none;">'.$langs->trans("PDFParamMargin").'</td>
										<td style = "margin: 0; padding: 0; border: none;">
											<table>
												<tr>
													<td align = "center" style = "margin: 0; padding: 0; border: none;">
														'.$langs->trans("PDFParamMarginTop").'<br><input type = "number" size = "10" style = "text-align: center; margin: 0; padding: 0; border: none;" dir="rtl" id = "MAIN_PDF_MARGIN_TOP" name = "MAIN_PDF_MARGIN_TOP" min = "3" max = "20" value = "'.$conf->global->MAIN_PDF_MARGIN_TOP.'">
													</td>
												</tr>
												<tr>
													<td align = "center" style = "margin: 0; padding: 0; border: none;">
														'.$langs->trans("PDFParamMarginLeft").'&nbsp;<input type = "number" size = "10" style = "text-align: left; margin: 0; padding: 0; border: none;" id = "MAIN_PDF_MARGIN_LEFT" name = "MAIN_PDF_MARGIN_LEFT" min = "3" max = "20" value = "'.$conf->global->MAIN_PDF_MARGIN_LEFT.'">
														&nbsp;&nbsp;&nbsp;<input type = "number" size = "10" style = "text-align: right; margin: 0; padding: 0; border: none;" dir="rtl" id = "MAIN_PDF_MARGIN_RIGHT" name = "MAIN_PDF_MARGIN_RIGHT" min = "3" max = "20" value = "'.$conf->global->MAIN_PDF_MARGIN_RIGHT.'">&nbsp;'.$langs->trans("PDFParamMarginRight").'
													</td>
												</tr>
												<tr>
													<td align = "center" style = "margin: 0; padding: 0; border: none;">
														<input type = "number" size = "10" style = "text-align: center; margin: 0; padding: 0; border: none;" dir="rtl" id = "MAIN_PDF_MARGIN_BOTTOM" name = "MAIN_PDF_MARGIN_BOTTOM" min = "3" max = "20" value = "'.$conf->global->MAIN_PDF_MARGIN_BOTTOM.'"><br>'.$langs->trans("PDFParamMarginBottom").'
													</td>
												</tr>
											</table>
										</td>
										<td align = "right" style = "margin: 0; padding: 0; border: none;">'.$langs->trans("DictionaryPaperFormat").' : '.$formadmin->select_paper_format($selected,'MAIN_PDF_FORMAT').'</td>
									</tr>
								</table>
							</td>
						</tr>';
		print '			<tr><td colspan = "2" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamNoMyLogo").'</td>';
		if (! empty($conf->global->PDF_DISABLE_MYCOMPANY_LOGO))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnomylogo&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setnomylogo&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("InvertSenderRecipient").'</td>';
		if (! empty($conf->global->MAIN_INVERT_SENDER_RECIPIENT))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setinvertsr&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setinvertsr&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamAliasIn3rdName").'</td>';
		if (! empty($conf->global->PDF_INCLUDE_ALIAS_IN_THIRDPARTY_NAME))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setalias&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setalias&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamSocNameContact").'</td>';
		if (! empty($conf->global->MAIN_USE_COMPANY_NAME_OF_CONTACT))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsoccontact&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setsoccontact&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("PlaceCustomerAddressToIsoLocation").'</td>';
		if (! empty($conf->global->MAIN_PDF_USE_ISO_LOCATION))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setisoloc&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setisoloc&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
								<td>'.$langs->trans("PDFParamHideVATIntraInAddress").'</td>';
		if (! empty($conf->global->MAIN_TVAINTRA_NOT_IN_ADDRESS))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=settvaintra&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=settvaintra&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if ($pid1)
		{
				print '		<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamShowProfIdInAddress").' - '.$pid1.'</td>';
			if (! empty($conf->global->MAIN_PROFID1_IN_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid1&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid1&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '	</tr>';
		}	// if ($pid1)
		if ($pid2)
		{
				print '		<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamShowProfIdInAddress").' - '.$pid2.'</td>';
			if (! empty($conf->global->MAIN_PROFID2_IN_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid2&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid2&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($pid2)
		if ($pid3)
		{
				print '		<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamShowProfIdInAddress").' - '.$pid3.'</td>';
			if (! empty($conf->global->MAIN_PROFID3_IN_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid3&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid3&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($pid3)
		if ($pid4)
		{
				print '		<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamShowProfIdInAddress").' - '.$pid4.'</td>';
			if (! empty($conf->global->MAIN_PROFID4_IN_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid4&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid4&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '	</tr>';
		}	// if ($pid4)
		if ($pid5)
		{
				print '		<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamShowProfIdInAddress").' - '.$pid5.'</td>';
			if (! empty($conf->global->MAIN_PROFID5_IN_ADDRESS))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid5&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setid5&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '	</tr>';
		}	// if ($pid5)
		print '			<tr><td colspan = "2" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("ShowDashOnPDF").'</td>';
		if (! empty($conf->global->MAIN_PDF_DASH_BETWEEN_LINES))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdash&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdash&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("HideRefOnPDF").'</td>';
		if (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_REF))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setref&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setref&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		if (empty($conf->global->INFRASPLUS_PDF_HIDE_LABEL))
		{
			print '		<tr class = "oddeven">
							<td>'.$langs->trans("HideDescOnPDF").' '.$langs->trans("GenModif").'</td>';
			if (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_DESC))
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdesc&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdesc&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if (empty($conf->global->INFRASPLUS_PDF_HIDE_LABEL))
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamDescFirst").'</td>';
		if (! empty($conf->global->MAIN_DOCUMENTS_DESCRIPTION_FIRST))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescfirst&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdescfirst&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("PDFParamHideWaightAndVolumeOnPDF").' '.$langs->trans("GenModif").'</td>';
		if (! empty($conf->global->SHIPPING_PDF_HIDE_WEIGHT_AND_VOLUME))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setweightvol&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setweightvol&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("ProdUseUnit").'</td>';
		if (! empty($conf->global->PRODUCT_USE_UNITS))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setunit&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setunit&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("MergeProductPDF").'</td>';
		if (! empty($conf->global->PRODUIT_PDF_MERGE_PROPAL))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setprodmerge&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setprodmerge&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("InfraSPlusParamRefInSupplierLine").'</td>
							<td align = "center">
								<input type = "number" size = "4" style = "text-align: right; margin: 0; padding: 0;" dir="rtl" id = "PDF_HIDE_PRODUCT_REF_IN_SUPPLIER_LINES" name = "PDF_HIDE_PRODUCT_REF_IN_SUPPLIER_LINES" min = "0" max = "2" value = "'.$conf->global->PDF_HIDE_PRODUCT_REF_IN_SUPPLIER_LINES.'">
							</td>
						</tr>';
		print '			<tr><td colspan = "2" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("FactureDepositAsPayments").'</td>';
		if (! empty($conf->global->FACTURE_DEPOSITS_ARE_JUST_PAYMENTS))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdepositpay&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setdepositpay&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("HidePayCond").'</td>';
		if (! empty($conf->global->PROPALE_PDF_HIDE_PAYMENTTERMCOND))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpaycond&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpaycond&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("HidePayMode").'</td>';
		if (! empty($conf->global->PROPALE_PDF_HIDE_PAYMENTTERMMOD))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpaymode&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpaymode&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr class = "oddeven">
							<td>'.$langs->trans("NoPayDetInv").'</td>';
		if (! empty($conf->global->INVOICE_NO_PAYMENT_DETAILS))
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpaydetinv&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align = "center"><a href="'.$_SERVER['PHP_SELF'].'?action=setpaydetinv&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';
		print '			<tr><td colspan = "3" style = "line-height: 1px;">&nbsp;</td></tr>';
	}	// if (! empty($accesright))
	print '			</table>';
	if (! empty($user->admin))
	{
		print '		<table width = "100%">
						<tr>
							<td align = "center"><a href="'.DOL_URL_ROOT.'/admin/pdf.php">'.$langs->trans("BackToPDFConf").'</a></td>
						</tr>';
	}	// if (! empty($user->admin))
	print '			</table>
					<br>';
	dol_fiche_end();
	llxFooter();
	$db->close();
?>