<?php
	/************************************************
	* Copyright (C) 2016-2019	Sylvain Legrand - <contact@infras.fr>	InfraS - <https://www.infras.fr>
	*
	* This program is free software: you can redistribute it and/or modify
	* it under the terms of the GNU General Public License as published by
	* the Free Software Foundation, either version 3 of the License, or
	* (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program.  If not, see <http://www.gnu.org/licenses/>.
	************************************************/

	/************************************************
	* 	\file		../infraspackplus/admin/mentions.php
	* 	\ingroup	InfraS
	* 	\brief		Page to setup Additional informations for the module InfraS
	************************************************/

	// Dolibarr environment *************************
	require '../config.php';

	// Libraries ************************************
	require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
	include_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
	include_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
	dol_include_once('/infraspackplus/core/lib/infraspackplus.lib.php');

	// Translations *********************************
	$langs->load("admin");
	$langs->load('infraspackplus@infraspackplus');

	// Access control *******************************
	$accesright																			= 0;
	if (! empty($user->admin) || ! empty($user->rights->infraspackplus->paramMentions))	$accesright	= 1;
	if (empty($accesright))																accessforbidden();

	// Actions **************************************
	$action							= GETPOST('action', 'alpha');
	$labelmention					= GETPOST('selmentions', 'alpha') ? GETPOST('selmentions', 'alpha') : 'BASE';
	$selmodule						= GETPOST('selmodules', 'alpha') ? GETPOST('selmodules', 'alpha') : 'PROPOSAL_FREE_TEXT';
	$variablename					= $labelmention == 'BASE' ? $selmodule : $selmodule.'_'.$labelmention;
	$result							= '';

	if ($action == 'update')		$result	= dolibarr_set_const($db, $variablename,								GETPOST($variablename),	'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefDev')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_DEV",		GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefCom')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_COM",		GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefCT')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_CT",			GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefExp')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_EXP",		GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefFI')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FI",			GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefFac')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FAC",		GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefDFou')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_DEV_FOU",	GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setMCdefFou')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FOU",		GETPOST('value'),		'chaine', 0, '', $conf->entity);
	if ($action == 'setfreeTend')	$result	= dolibarr_set_const($db, "INFRASPLUS_PDF_FREETEXTEND",					GETPOST('value'),		'chaine', 0, '', $conf->entity);

	if ($result == 1)				setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	if ($result == -1)				setEventMessages($langs->trans("Error"), null, 'errors');

	// init variables *******************************
	$listModules	= array (	array ('MAIN_MODULE_PROPALE', 'PROPOSAL_FREE_TEXT'),
								array ('MAIN_MODULE_COMMANDE', 'ORDER_FREE_TEXT'),
								array ('MAIN_MODULE_CONTRAT', 'CONTRACT_FREE_TEXT'),
								array ('MAIN_MODULE_EXPEDITION', 'SHIPPING_FREE_TEXT'),
								array ('MAIN_MODULE_FICHEINTER', 'FICHINTER_FREE_TEXT'),
								array ('MAIN_MODULE_FACTURE', 'INVOICE_FREE_TEXT'),
								array ('MAIN_MODULE_SUPPLIERPROPOSAL', 'SUPPLIER_PROPOSAL_FREE_TEXT'),
								array ('MAIN_MODULE_FOURNISSEUR', 'SUPPLIER_ORDER_FREE_TEXT'),
								array ('MAIN_MODULE_PRODUCT', 'PRODUCT_FREE_TEXT'),
								array ('MAIN_MODULE_EXPENSEREPORT', 'EXPENSEREPORT_FREE_TEXT')
							);
	$optionsSelect	= '';
	foreach ($listModules as $module)
	{
		$constModuleName	= $module[0];
		if ($conf->global->$constModuleName)
		{
			$optionsSelect	.= '<option name = "selmodules" value = "'.$module[1].'"';
			$optionsSelect	.= $module[1] == $selmodule ? ' selected' : '';
			$optionsSelect	.= '>'.$langs->trans('InfraSPlusParam_'.$module[0]).'</option>';
		}	// if ($conf->global->$constModuleName)
	}	// foreach ($listModules as $module)

	// View *****************************************
	$page_name					= $langs->trans("infrasplussetup") ." - ". $langs->trans("InfraSPlusParamsMentions");
	llxHeader('', $page_name);
	if (! empty($user->admin))	$linkback	= '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	else						$linkback	= '';
	print_fiche_titre($page_name, $linkback, 'title_setup');
	
	// Configuration header *************************
	$head				= infraspackplus_admin_prepare_head();
	$picto				= 'infraspackplus@infraspackplus';
	dol_fiche_head($head, 'mentions', $langs->trans("modcomnamePackPlus"), 0, $picto);

	// setup page goes here *************************
	if ($conf->use_javascript_ajax)
	{
		print '	<script type = "text/javascript" language = "javascript">
					function doReloadFreeT(){
						document.frm1.submit();
					}
				</script>';
	}	// if ($conf->use_javascript_ajax)
	print '		<form name="frm1" id="frm1" action="'.$_SERVER["PHP_SELF"].'" method = "post">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">';
	print load_fiche_titre($langs->trans("InfraSPlusParamGestionMentions"), '', dol_buildpath('/infraspackplus/img/option_tool.png', 1), 1);
	print '			<table class="noborder" width="100%">
						<colgroup>
							<col width = "*">
							<col width = "130px">
							<col width = "120px">
						</colgroup>
						<tr class = "liste_titre">
							<td colspan = "3" align = "center">'.$langs->trans('InfraSPlusParamNewMention').'</td>						
						</tr>';
	print '				<tr>
							<td colspan = "2" align = "center">'.$langs->trans('InfraSPlusParamCautionSave').'</td>
							<td rowspan = "3" align = "center"><button class = "button" style = "width: 110px;" type = "submit" value = "update" name = "action">'.$langs->trans("Modify").'</button></td>
						</tr>';
	if (! empty($accesright))
	{
		print '			<tr class="oddeven">
							<td colspan = "2">';
		print $form->textwithpicto($langs->trans("InfraSPlusParamMention1"), $langs->trans("AddCRIfTooLong").'<br><br>'.$htmltext, 1, 'help', '', 0, 2, 'freetexttooltip').'&nbsp;';
		print fieldLabel(''.$langs->trans("InfraSPlusParamMention2").'', 'selmodules').' '.'
								<select class = "flat" name = "selmodules" style = "margin: 0; padding: 0; cursor: pointer;" onchange = "doReloadFreeT();">
									'.$optionsSelect.'
								</select>';
		print select_infraspackplus_dict('c_infraspackplus_mention', $labelmention, 'selmentions', 0, 'doReloadFreeT()');
		print info_admin($langs->trans("YouCanChangeValuesForThisListFromDictionarySetup"), 1, 1, 0);
		print '				</td>
						</tr>';
		print '			<tr>
							<td colspan = "2">';
		if (empty($conf->global->PDF_ALLOW_HTML_FOR_FREE_TEXT))	print '<textarea name="'.$variablename.'" class = "flat" cols = "120">'.$conf->global->$variablename.'</textarea>';
		else
		{
			$doleditor	= new DolEditor($variablename, $conf->global->$variablename, '', 80, 'dolibarr_notes');
			print $doleditor->Create();
		}
		print '				</td>
						</tr>';
		print '			<tr><td colspan = "3" style = "line-height: 1px;">&nbsp;</td></tr>';
	}	// if (! empty($accesright))
	print '			</table>
				</form>
				<form action="'.$_SERVER["PHP_SELF"].'" method = "post" enctype="multipart/form-data">
					<input type = "hidden" name = "token" value = "'.$_SESSION['newtoken'].'">';
	print load_fiche_titre($langs->trans("InfraSPlusParamMentionsSetup"), '', dol_buildpath('/infraspackplus/img/list.png', 1), 1);
	print '			<table class = "noborder" width = "100%">
						<colgroup>
							<col width = "*">
							<col width = "130px">
						</colgroup>
						<tr class = "liste_titre">
								<td align = "center">'.$langs->trans('Description').'</td>
								<td align = "center">'.$langs->trans('Status').' / '.$langs->trans('Value').'</td>
						</tr>';
	if (! empty($accesright))
	{
		if ($conf->global->MAIN_MODULE_PROPALE)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_PROPALE")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_DEV))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefDev&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefDev&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_PROPALE)
		if ($conf->global->MAIN_MODULE_COMMANDE)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_COMMANDE")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_COM))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefCom&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefCom&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_COMMANDE)
		if ($conf->global->MAIN_MODULE_CONTRAT)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_CONTRAT")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_CT))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefCT&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefCT&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_CONTRAT)
		if ($conf->global->MAIN_MODULE_EXPEDITION)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_EXPEDITION")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_EXP))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefExp&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefExp&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_EXPEDITION)
		if ($conf->global->MAIN_MODULE_FICHEINTER)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_FICHEINTER")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FI))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefFI&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefFI&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_FICHEINTER)
		if ($conf->global->MAIN_MODULE_FACTURE)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_FACTURE")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FAC))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefFac&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefFac&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_FACTURE)
		if ($conf->global->MAIN_MODULE_SUPPLIERPROPOSAL)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_SUPPLIERPROPOSAL")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_DEV_FOU))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefDFou&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefDFou&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_SUPPLIERPROPOSAL)
		if ($conf->global->MAIN_MODULE_FOURNISSEUR)
		{
			print '		<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamMCBaseDef", $langs->trans("InfraSPlusParam_MAIN_MODULE_FOURNISSEUR")).'</td>';
			if (! empty($conf->global->INFRASPLUS_PDF_SHOW_SYS_MC_BASE_FOU))
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefFou&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
			else
				print '		<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setMCdefFou&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
			print '		</tr>';
		}	// if ($conf->global->MAIN_MODULE_FOURNISSEUR)
		print '			<tr><td colspan = "2" align = "center" style = "padding: 0;"><hr></td></tr>';
		print '			<tr class="oddeven">
							<td>'.$langs->trans("InfraSPlusParamFreeTextEnd").'</td>';
		if (! empty($conf->global->INFRASPLUS_PDF_FREETEXTEND))
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfreeTend&value=0">'.img_picto($langs->trans("Activated"), 'switch_on').'</a></td>';
		else
			print '			<td align="center"><a href="'.$_SERVER['PHP_SELF'].'?action=setfreeTend&value=1">'.img_picto($langs->trans("Disabled"), 'switch_off').'</a></td>';
		print '			</tr>';						
		print '			<tr><td colspan = "2" style = "line-height: 1px;">&nbsp;</td></tr>';
	}	// if (! empty($accesright))
	print '			</table>
				</form>';
	dol_fiche_end();
	llxFooter();
?>