<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/achat/btp_sales/class/BtpSales.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/achat/btp_sales_products/class/BtpSalesProducts.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$langs->load('btp');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();
$now 	= new DateTime('now');
$error 	= false;
$forms=new Form($db);
if ($action == 'update' && $request_method === 'POST') {
    $saleproduct_id = (int) GETPOST('$saleproduct_id', 'int');
    if (!$saleproduct_id || $saleproduct_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $saleproduct = new BtpSalesProducts($db);
    $saleproduct->fetch($saleproduct_id);
    $canedit = true ; 
    // If this is the requestor or has read/write rights
    if ($canedit) {
        $vente   = trim(GETPOST('ventes'));
        $prds     =trim(GETPOST('prds'));
		// Update
         $vid="";
        $vid .= (GETPOST('prds') != 0) ? "": "erreur";
        $vid .= (GETPOST('qty') != 0) ? "": "erreur";
        $vid .= (GETPOST('ventes') != 0) ? "": "erreur";
        $data = array(
            'fk_sale'=>trim(GETPOST('ventes')),
            'fk_product'=>trim(GETPOST('prds')),
            'qty'=>trim((int)GETPOST('qty')),
            'discount'=>trim((int)GETPOST('rms')),
         );
        echo $vid;
                if($vid==""){
        $getMarcheID = $saleproduct->update($saleproduct_id, $data);
    }
    else{
        $getMarcheID =-1;
        }
 
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$saleproduct_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
           header('Location: ./card.php?id='. $saleproduct_id .'&action=edit&msg=\'erreur durant la modification\'');
        
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$saleproduct  = new BtpSalesProducts($db);
	 $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $saleproduct->fetch($id);
		$saleproduct->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}
	if (!$error) {
			header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */
$form           = new Form($db);
$saleproduct     = new BtpSalesProducts($db);
//insertion 
if ($action == 'create' && $request_method === 'GET') {
    
$datep=GETPOST("sdate");
  $vid="";
        $saleproduct->fk_createdby      = $user->id;
        $saleproduct->fk_sale           =(int)GETPOST("vente");
        $saleproduct->fk_product        =(int)GETPOST("prd");;
        $saleproduct->qty               = (int)GETPOST("qts");
        $saleproduct->discount          = (int)GETPOST("rms");
    $vid .= ($saleproduct->fk_product  != 0) ? "": "erreur";
    $vid.=($saleproduct->qty != 0) ? "": "erreur";
    $vid.=( $saleproduct->fk_sale  != 0) ? "": "erreur";
        if($vid==""){
              $getMarcheID = $saleproduct->create();
  
          }else{
             $getMarcheID=-1;
          }     if ($getMarcheID > 0) {
          header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
          header("Location:card.php?action=request&error=SQL_Create&msg=veuillez renseigner tous les champs");
          exit(); 
        }
}
?>
<style type="text/css">
    .fiche>table:first-child td, .fiche>table[summary] td{vertical-align: middle !important;}
</style>
<?php
llxHeader(array(), $langs->trans('ListOfproductsale'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire 
        print_fiche_titre($langs->trans('ajt'));
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="GET" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        // Name
         print '<tr><td class="fieldrequired">'.$langs->trans("Sale").'</td><td class="fieldrequired">';
           print '<select name="vente" required="required"     id="nomer"/>';
      
         $saleproduct   = new BtpSales($db);
        $saleproduct->fetchall();  print '<option></option>';
        if (count($saleproduct->rows)) {
      
        foreach($saleproduct->rows as $line) {
       print '<option  value="'.$line->rowid.'">'.$line->quote_num.'</option>';
      
        }
    }
   print '</select>';  print '</td></tr>';

         print '<tr><td class="fieldrequired">'.$langs->trans("Product").'</td><td class="fieldrequired">';
        print $forms->select_produits('', "prd");
   
         print '</td></tr>';
           print '<tr><td class="fieldrequired">'.$langs->trans("Quantite").'</td><td class="fieldrequired">';
             print '<input type=text name="qts"  required="required">';
        
        print '</td></tr>';
     print '<tr><td class="fieldrequired">'.$langs->trans("discount").'</td><td class="fieldrequired">';
         print '<input type=text name="rms"   required="required">'.'%';
         print '</td></tr>';
         print '</tbody>';
         print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("create_produit_sale") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    print_barre_liste($langs->trans("det_sale_prod"), '', '', '', '', '', "", "", "", DOL_MAIN_URL_ROOT.'/btp/img/folder_icon.png',1);
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $saleproduct->fetch($id);
			      // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }
            // On vérifie si l'utilisateur à le droit de lire cette demande
                if ($action == 'delete') {
          dol_fiche_head('', 'ListOfproductsale', $langs->trans("ListOfproductsale"), 0, '');
     print_barre_liste($langs->trans("det_sale_prod"), '', '', '', '', '', "", "", "", 'title_project.png');
  
    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeletesup"),$langs->trans("ConfirmDeletesup"),"confirm_delete", '', 0, 1);
    print '<table class="border" width="100%">';
    // Ref
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
    print '<td colspan="2">'. $saleproduct->rowid .'</td></tr>';
    //Vente
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("sale").'</td>';
    $use_u   = new BtpSales($db);
       $use_u->fetch($saleproduct->fk_sale);     

    print '<td colspan="2">'.$use_u->quote_num.'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("product").'</td>';
    // Produit
            
      $pre  = new Product($db);
      $pre->fetch($saleproduct->fk_product);
        print '<td colspan="2">'. $pre->label.'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Quantity").'</td>';
    //Quantité
    print '<td colspan="2">'.$saleproduct->qty.'</td></tr>';   
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("discount").'</td>';
    //Remise
    print '<td colspan="2">'.$saleproduct->discount.'%</td></tr>'; 
     print '</td>';   
    print '</table>';
                }
                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="$saleproduct_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("Sale").'</td><td>';
                    print '<select name="ventes"   required="required"   id="nomer"/>';
               $evt   = new BtpSales($db);
               $evt->fetchAll(); 
           if (count($evt->rows)) {
           $p="";  print '<option><option>';
              foreach($evt->rows as $line) {
                   if ($saleproduct->fk_sale==$line->rowid) {
                    $p="selected='selected'";  
                   }
         print '<option  value="'.$line->rowid.'" '.$p.'>'.$line->quote_num.'</option>';
         $p="";
        }
    }
       print '</select>';
       print '</td></tr>';
       print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("product").'</td><td>';
       print $forms->select_produits($saleproduct->fk_product, "prds");
       print '</td></tr>' ; 
       print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
       print '<input name="qty"  type=text value="'.$saleproduct->qty.'"   required="required"></td></tr>';
       print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("discount").'</td><td>';
       print '<input name="rms"  type=text value="'.$saleproduct->discount.'"   required="required">%</td></tr>'; 
 print '</tbody>';
                    print '</table>';
 print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }
                dol_fiche_end();
                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    // If draft
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    print '</div>'; }
        } else { 
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $saleproduct  = new BtpSalesProducts($db);
    $canedit = true;
    // Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
    if ($canedit) {
        $saleproduct->fetch($id);
        $saleproduct->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
        header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=btp_sales_products');
        exit;
    }
}
// End of page
llxFooter();llxFooter();

$db->close();


?>