<?php

header("Content-Type: application/json");

require_once('../../main.inc.php');
require_once DOL_DOCUMENT_ROOT.'/btp/market/executions/class/execution.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

$object  = new Executions($db);

// calculate end date, days based
if (isset($_POST['start_date']) && !empty($_POST['start_date']) && !empty($_POST['months'])) {
	$days 	 =  isset($_POST['days']) ? (int) trim($_POST['days']) : 0;
	$months  =  (int) trim($_POST['months']);
	$mid 	 =  (int) trim($_POST['mid']);
	$exec_id =  (int) trim($_POST['exec_id']);

	if (!$mid)
		return;

	$start_date = Tools::getEndDatFromDays(trim($_POST['start_date']), $months, $days);
	
	list($d,$m,$y) = explode("/", $_POST['start_date']);
	$start_date_db = $y.'-'.$m.'-'.$d;

	$getExec = $object->fetch(0, $mid);
	$opera = '';
	$getId = 0;

	if ($getExec) {
		if (!$exec_id)
			return false;

		// update
		$opera = 'update';
		$data  = array(
			'start_date' => $start_date_db,
			'months'	 => $months,
			'days' 		 => $days
		);
		$object->update($exec_id, $data);
		$getId = $exec_id;
	} else {
		// persist
		$opera = 'persist';
		$object->fk_created_by  = $user->id;
		$object->fk_marche 		= $mid;
		$object->months			= $months;
		$object->days			= $days;
		$object->start_date		= $start_date_db;
		$getId = $object->create();
	}

	echo json_encode(array(
		'end_date'  => $start_date->format('d/m/Y'),
		'operation' => $opera,
		'last_id'   => $getId
	));
	die();
}

if ((isset($_POST['rg_section']) && $_POST['rg_section'] == true) && !empty($_POST['mid']) && (isset($_POST['ref']) && !empty($_POST['ref']))) {
	$ref 	= trim($_POST['ref']);
	$amount = (float) trim($_POST['amount']);
	$bank 	= (int) trim($_POST['bank']);
	$mid 	= (int) trim($_POST['mid']);
	$execution_id = (int) trim($_POST['execution_id']);

	if (!$mid || empty($ref))
		return false;

	$getExec = $object->fetch(0, $mid);
	$opera = '';
	$getId = 0;
	$account_url = '';

	$sig_date 	  = trim($_POST['sig_date']);
	$deposit_date = trim($_POST['deposit_date']);
	
	if (isset($sig_date) && !empty($sig_date)) {
		list($d,$m,$y) = explode("/", $sig_date);
		$sig_date = $y.'-'.$m.'-'.$d;
	}

	if (isset($deposit_date) && !empty($deposit_date)) {
		list($d,$m,$y) = explode("/", $deposit_date);
		$deposit_date = $y.'-'.$m.'-'.$d;
	}

	if ($getExec) {
		if (!$execution_id)
			return false;

		// update
		$opera = 'update';
		$data  = array(
			'fk_bank' 		=> $bank,
			'ref'	 		=> $ref,
			'amount' 		=> $amount,
			'sig_date' 	   	=> $sig_date,
			'deposit_date' 	=> $deposit_date,
			'statut' 		=> 2
		);
		$object->update($execution_id, $data);
	} else {
		// persist
		$opera = 'persist';
		$object->fk_created_by  = $user->id;
		$object->fk_marche 		= $mid;
		$object->fk_bank 		= $bank;
		$object->ref			= $ref;
		$object->amount			= $amount;
		$object->sig_date		= $sig_date;
		$object->deposit_date	= $deposit_date;
		$object->statut			= 2;
		$getId = $object->create();
	}

	if ($bank) {
		$account= new Account($db);
		$account->fetch($bank);
		$account_url = $account->getNomUrl(1); /*. ($account->number ? " <span class='bank_number'>&nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )</span>" : "<span class='bank_number'></span>")*/
	}

	echo json_encode(array(
		'ref' 	  => $ref,
		'amount'  => number_format($amount, 2),
		'account' => $bank,
		'last_id' => $getId,
		'account_url' => $account_url
	));
	die();
}

// update status 
if (isset($_POST['exec_id']) && !empty($_POST['exec_id']) && $_POST['action'] == "updateStatus") {
	$exec_id =  (int) trim($_POST['exec_id']);
	$status  =  (int) trim($_POST['status']);

	if (!$exec_id)
		return;
	
	$data  = array(
		'statut' => $status,
	);
	
	$updated = $object->update($exec_id, $data);
	$statut = false;

	if ($updated > 0)
		$statut = true;

	echo json_encode(array(
		'statut' => $statut
	));
	die();
}