$(function(){
	$('#addCerts').on('click', function() {
		var certs_container = $('#social_charges_wrapper'),
		addBtn = $('.sub_cert'), cs = $('#chargesociales_list');

		if (cs.val() == 0)
			return;

		$.post(main_dir+'/btp/ajax/chargesociales.php', {'chargesociales': cs.val(), 'mid':$(this).attr('data-mid')}, function(response) {
			var status = response.status;
			var lines = response.lines;
			var html   = '';
		// console.log(response);

			if (status == 200 && lines.length) {
				for (var i = 0; i < lines.length; i++) {
					var classe = i % 2 == 0 ? 'pair' : 'impair'; 	
					html += "<tr class='"+ classe +"'>"+
						"<td align='center'>"+ lines[i].ref +"</td>"+
						"<td align='center'>"+ lines[i].lib +"</td>"+
						"<td align='center'>"+ lines[i].periode +"</td>"+
						"<td align='center'>"+ lines[i].amount +"</td>"+
						"<td align='center'>"+ lines[i].date_ech +"</td>"+
						"<td align='center'><input class='sc_checks' type='checkbox' name='cs[]' value='"+ parseInt(lines[i].id) +"' /></td>"+
					"</tr>";
				}
			}

			certs_container.append(html).fadeIn('slow');
			addBtn.parent().fadeIn('slow');

		}, 'json');

		$('#chargesociales_list option:selected').remove();
	});

	$(document).on('click', '.sub_cert', function(e) {
		e.preventDefault();
		var isOneChecked = false;

		$('.sc_checks').each(function(index) {
			if ($(this).is(':checked'))
				isOneChecked = true;
		});

		if (!isOneChecked) {
			alert('Veuillez cocher au moins une ligne!');
			return false;
		} else {
			$('#cs-form').submit();
		}
	});

});

function calculateTva(amount) {
	return parseFloat((amount*20)/100);
}