<?php
/* Copyright (C) 2016 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         marches
 *  @return array           		head
 */

function groupement_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/index.php?id='.$object->id;
    $head[$h][1] = $langs->trans("groupementFile");
    $head[$h][2] = 'contractFile';
    $h++;

	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/contrat.php?id='.$object->id;
	$head[$h][1] = $langs->trans('BordreCont');
	$head[$h][2] = 'bordreCont';
	$h++;

	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/demandes/index.php?gid='.$object->id;
	$head[$h][1] = $langs->trans('demandes');
	$head[$h][2] = 'demandes';
	$h++;
	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/paymentmanagement/index.php?gid='.$object->id;
	$head[$h][1] = $langs->trans('PaymentManagement');
	$head[$h][2] = 'paymentmanagement';
	$h++;


	

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}


function groupement_demandes_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/demandes/index.php?type=1&gid='.$object->id;
	$head[$h][1] = $langs->trans('provisional');
	$head[$h][2] = 'provisional';
	$h++;
	
	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/demandes/index.php?type=2&gid='.$object->id;
	$head[$h][1] = $langs->trans('final');
	$head[$h][2] = 'final';
	$h++;

	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/demandes/index.php?type=3&gid='.$object->id;
	$head[$h][1] = $langs->trans('backGrante');
	$head[$h][2] = 'backGrante';
	$h++;

	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/demandes/engagement/index.php?gid='.$object->id;
	$head[$h][1] = $langs->trans('engagement');
	$head[$h][2] = 'engagement';
	$h++;

	$head[$h][0] = DOL_URL_ROOT.'/btp/market/groupement/demandes/couverture/index.php?gid='.$object->id;
	$head[$h][1] = $langs->trans('couverture');
	$head[$h][2] = 'couverture';
	$h++;
    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}