<?php
/* Copyright (C) 2016 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         marches
 *  @return array           		head
 */

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function t_prepare_head($obj)
{
	global $langs, $conf, $user;
	$h = 0;
	$head = array();



	$head[$h][0] = DOL_URL_ROOT.'/btp/market/works/index.php?mid='.$obj;
	$head[$h][1] = $langs->trans("Taches/Travaux");
	$head[$h][2] = 'releases';
	$h++;
	$head[$h][0] = DOL_URL_ROOT.'/btp/market/works/avancement.php?mid='.$obj;
	$head[$h][1] = $langs->trans("Avanacement/Travaux");
	$head[$h][2] = 'tender';
	$h++;


	complete_head_from_modules($conf,$langs,$object,$head,$h,'tender');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'tender','remove');
	
	return $head;
}
