<?php
/* Copyright (C) 2004-2007 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005      Simon Tosser         <simon@kornog-computing.com>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 * Copyright (C) 2010      Pierre Morin         <pierre.morin@auguria.net>
 * Copyright (C) 2013      Marcos García        <marcosgdf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       htdocs/core/ajax/ajaxdirpreview.php
 *  \brief      Service to return a HTML preview of a directory
 *              Call of this service is made with URL:
 *              ajaxdirpreview.php?mode=nojs&action=preview&module=ecm&section=0&file=xxx
 */

if (! defined('NOTOKENRENEWAL')) define('NOTOKENRENEWAL',1); // Disables token renewal
if (! defined('NOREQUIREMENU')) define('NOREQUIREMENU','1');
if (! defined('NOREQUIREHTML')) define('NOREQUIREHTML','1');
if (! defined('NOREQUIREAJAX')) define('NOREQUIREAJAX','1');

// Load traductions files
$langs->load("ecm");
$langs->load("marches");
$langs->load("other");

// Security check
if ($user->societe_id > 0) $socid = $user->societe_id;

/*
 * Action
 */

// None

/*
 * View
 */

$type   = 'directory';
$param  = ($sortfield?'&sortfield='.$sortfield:'').($sortorder?'&sortorder='.$sortorder:'');
$url    = DOL_URL_ROOT.'/btp/market/documentmanagement/index.php';

// Dir scan
if ($type == 'directory') {
    $formfile = new FormFileChild($db);

    $maxlengthname=40;
    $excludefiles = array('^SPECIMEN\.pdf$','^\.','(\.meta|_preview\.png)$','^temp$','^payments$','^CVS$','^thumbs$');
    $sorting = (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC);

    // create a authorised modules
    $automodules = array('technical_memory', 'pv_implantation', 'os', 'pv_site_monitoring', 'report_end_work', 'daily_report', 'casing_certificates', 'certificate_of_origin', 'purchase_invoices', 'tc_piezometer', 'tc_wells', 'tc_reconnaissance_survey');
    $main_dir    = $conf->btp->dir_output .'/';

    // Auto area for suppliers invoices
    if ($module == 'technical_memory') {
        $main_dir .= $document_dirs[1];
    } else if ($module == 'pv_implantation') {
        $main_dir .= $document_dirs[0];
    } else if ($module == 'os') {
        $main_dir .= $document_dirs[2];
    } else if ($module == 'pv_site_monitoring') {
        $main_dir .= $document_dirs[3];
    } else if ($module == 'report_end_work') {
        $main_dir .= $document_dirs[4];
    } else if ($module == 'daily_report') {
        $main_dir .= $document_dirs[5];
    } else if ($module == 'casing_certificates') {
        $main_dir .= $document_dirs[6];
    } else if ($module == 'certificate_of_origin') {
        $main_dir .= $document_dirs[7];
    } else if ($module == 'purchase_invoices') {
        $main_dir .= $document_dirs[8];
    } else if ($module == 'tc_piezometer') {
        $main_dir .= $document_dirs[9];
    } else if ($module == 'tc_wells') {
        $main_dir .= $document_dirs[10];
    } else if ($module == 'tc_reconnaissance_survey') {
        $main_dir .= $document_dirs[11];
    }

    $upload_dir = $main_dir .'/'. $mid;

    if (in_array($module, $automodules)) {
        $param      .= '&module='.$module.'&mid='.$mid;
        $textifempty = ($showonrightsize=='featurenotyetavailable'?$langs->trans("FeatureNotYetAvailable"):$langs->trans("NoFileFound"));

        $filearray=dol_dir_list($upload_dir,"files",1,'', $excludefiles, $sortfield, $sorting,1);
        
        $formfile->list_of_market_documents($upload_dir,$filearray,$module,$param,1,'',$user->rights->ecm->upload,1,$textifempty,$maxlengthname,$url);
    }
}
