<?php

/**
* A collection of Tools to be used throughout the app
* @author Yassine Belkaid <y.belkaid@nextconcept.ma>
*/
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
class Tools
{
	
	/**
     * Calculate TVA
     *
     * @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     * @return array
     */
    public static function getTva($ht, $percentage = 20)
    {
    	$tva = ($ht*$percentage)/100;
    	
    	return array(
    		'tva' 		 => (float) $tva,
    		'amount_ttc' => (float) ($ht+$tva)
    	);
    }

    /**
     * Fetch total days from given start date
     */
    public static function getTotalDaysTillEnd($execution_start_date, $end_date = null)
    {
    	if (!$execution_start_date)
    		return;

    	if (false !== strpos($execution_start_date, "/")) {
    		list($d, $m, $y) = explode("/", $execution_start_date);
    		$execution_start_date = $y.'-'.$m.'-'.$d;
    	}

    	$now       = new \DateTime("now");
    	$startDate = new \DateTime($execution_start_date);

    	if (null !== $end_date) {
    		$endDate = new \DateTime($end_date);
    		if ( self::checkEndDateExceeding($endDate, $now) )
    			$now = $endDate;
    	}

    	$getDays = self::getDiffOfDates($startDate, $now);

    	return $getDays;
    }

    /**
     * Get date difference
     */
    public static function getDiffOfDates($start_date, $end_date, $type = 'days')
    {
    	if (!($start_date instanceof DateTime))
    		$start_date = new \DateTime($start_date);

    	if (!($end_date instanceof DateTime))
    		$end_date = new \DateTime($end_date);

    	$diff = '';
    	
    	switch ($type) {
    		case 'days':
    			$diff = $start_date->diff($end_date)->days;
    			break;
    		default:
    			$diff = $start_date->diff($end_date)->days;
    			break;
    	}

    	return $diff;
    }
    /**
     * Check if end date exceeds the start date
     */
    public static function checkEndDateExceeding($start_date, $end_date)
    {
    	if (!($start_date instanceof DateTime))
    		$start_date = new \DateTime($start_date);

    	if (!($end_date instanceof DateTime))
    		$end_date = new \DateTime($end_date);

    	if ($end_date->getTimeStamp() > $start_date->getTimeStamp())
    		return true;
    	return false;
    }

    /**
     * Get period days if the given date is exceeding now
     */
    public static function checkPeriodExceeding($checked_date, $end_date = null)
    {
        if (null === $end_date) {
            $now = new \DateTime("now");
        } else {
            $now = new \DateTime($end_date);
        }
    	
    	if (!($checked_date instanceof DateTime))
    		$checked_date = new \DateTime($checked_date);

    	if ( self::checkEndDateExceeding($checked_date, $now) ) {
    		$getDiff = self::getDiffOfDates($checked_date, $now);
    		
    		return $getDiff;
    	}

    	return false;
    }

    public static function getEndDatFromDays($start_date, $months, $days)
    {
    	if (empty($start_date))
    		return;

    	if(false !== strpos($start_date, "/")) {
    		list($d, $m, $y) = explode("/", $start_date);
			$start_date = new \DateTime($y.'-'.$m.'-'.$d);
    	} else {
			$start_date = new \DateTime($start_date);
    	}

		$start_date->modify('+ '.$months.' months');
    
		if ($days)
			$start_date->modify('+ '.$days.' days');
    	
    	return $start_date;
    }

    public static function calculateRemainedAmountInPercentage($total, $sub_amount)
    {
    	return ((100*$sub_amount)/$total);
    }

    public static function convertDateTo($date, $format = 'fr')
    {
        $convertedDate = '';

        if (isset($date) && !empty($date)) {
            if ($format == 'sql') {
                list($d, $m, $y) = explode("/", trim($date));
                $convertedDate = $y.'-'.$m.'-'.$d;
            } else if ($format == 'fr') {
                list($y, $m, $d) = explode("-", trim($date));
                $convertedDate = $d .'/'. $m .'/'. $y;
            }
        }

        return $convertedDate;
    }

    public function trunc_words($string, $max = 5, $separator = '...')
    {
        $getStringAsArray = explode(" ", $string);

        if (count($getStringAsArray) <= $max)
            return $string;

        return implode(" ", array_slice($getStringAsArray, 0, $max)). $separator;
    }

      function chifre_en_lettre($montant, $devise1='', $devise2='')
{
    // if(empty($devise1)) $dev1='DIRHAMS';
    if(empty($devise1)) $dev1=currency_name($conf->currency,1);
    else $dev1=$devise1;
    // if(empty($devise2)) $dev2='CTS';
    if(empty($devise2)) $dev2=' ';
    else $dev2=$devise2;
    $valeur_entiere=intval($montant);
    $valeur_decimal=intval(round($montant-intval($montant), 2)*100);
    $dix_c=intval($valeur_decimal%100/10);
    $cent_c=intval($valeur_decimal%1000/100);
    $unite_c = intval($valeur_decimal%10);
    $unite[1]=$valeur_entiere%10;
    $dix[1]=intval($valeur_entiere%100/10);
    $cent[1]=intval($valeur_entiere%1000/100);
    $unite[2]=intval($valeur_entiere%10000/1000);
    $dix[2]=intval($valeur_entiere%100000/10000);
    $cent[2]=intval($valeur_entiere%1000000/100000);
    $unite[3]=intval($valeur_entiere%10000000/1000000);
    $dix[3]=intval($valeur_entiere%100000000/10000000);
    $cent[3]=intval($valeur_entiere%1000000000/100000000);
    $chif=array('', 'un', 'deux', 'trois', 'quatre', 'cinq', 'six', 'sept', 'huit', 'neuf', 'dix', 'onze', 'douze', 'treize', 'quatorze', 'quinze', 'seize', 'dix sept', 'dix huit', 'dix neuf');
        $secon_c='';
        $trio_c='';
    for($i=1; $i<=3; $i++){
        $prim[$i]='';
        $secon[$i]='';
        $trio[$i]='';
        if($dix[$i]==0){
            $secon[$i]='';
            $prim[$i]=$chif[$unite[$i]];
        }
        else if($dix[$i]==1){
            $secon[$i]='';
            $prim[$i]=$chif[($unite[$i]+10)];
        }
        else if($dix[$i]==2){
            if($unite[$i]==1){
            $secon[$i]='vingt et';
            $prim[$i]=$chif[$unite[$i]];
            }
            else {
            $secon[$i]='vingt';
            $prim[$i]=$chif[$unite[$i]];
            }
        }
        else if($dix[$i]==3){
            if($unite[$i]==1){
            $secon[$i]='trente et';
            $prim[$i]=$chif[$unite[$i]];
            }
            else {
            $secon[$i]='trente';
            $prim[$i]=$chif[$unite[$i]];
            }
        }
        else if($dix[$i]==4){
            if($unite[$i]==1){
            $secon[$i]='quarante et';
            $prim[$i]=$chif[$unite[$i]];
            }
            else {
            $secon[$i]='quarante';
            $prim[$i]=$chif[$unite[$i]];
            }
        }
        else if($dix[$i]==5){
            if($unite[$i]==1){
            $secon[$i]='cinquante et';
            $prim[$i]=$chif[$unite[$i]];
            }
            else {
            $secon[$i]='cinquante';
            $prim[$i]=$chif[$unite[$i]];
            }
        }
        else if($dix[$i]==6){
            if($unite[$i]==1){
            $secon[$i]='soixante et';
            $prim[$i]=$chif[$unite[$i]];
            }
            else {
            $secon[$i]='soixante';
            $prim[$i]=$chif[$unite[$i]];
            }
        }
        else if($dix[$i]==7){
            if($unite[$i]==1){
            $secon[$i]='soixante et';
            $prim[$i]=$chif[$unite[$i]+10];
            }
            else {
            $secon[$i]='soixante';
            $prim[$i]=$chif[$unite[$i]+10];
            }
        }
        else if($dix[$i]==8){
            if($unite[$i]==1){
            $secon[$i]='quatre-vingts et';
            $prim[$i]=$chif[$unite[$i]];
            }
            else {
            $secon[$i]='quatre-vingt';
            $prim[$i]=$chif[$unite[$i]];
            }
        }
        else if($dix[$i]==9){
            if($unite[$i]==1){
            $secon[$i]='quatre-vingts et';
            $prim[$i]=$chif[$unite[$i]+10];
            }
            else {
            $secon[$i]='quatre-vingts';
            $prim[$i]=$chif[$unite[$i]+10];
            }
        }
        if($cent[$i]==1) $trio[$i]='cent';
        else if($cent[$i]!=0 || $cent[$i]!='') $trio[$i]=$chif[$cent[$i]] .' cents';
    }
     
     $result ='';
$chif2=array('', 'dix', 'vingt', 'trente', 'quarante', 'cinquante', 'soixante', 'soixante-dix', 'quatre-vingts', 'quatre-vingts dix');
    $secon_c=$chif2[$dix_c];
    if($cent_c==1) $trio_c='cent';
    else if($cent_c!=0 || $cent_c!='') $trio_c=$chif[$cent_c] .' cents';
     
    if(($cent[3]==0 || $cent[3]=='') && ($dix[3]==0 || $dix[3]=='') && ($unite[3]==1))
        $result .= $trio[3]. '  ' .$secon[3]. ' ' . $prim[3]. ' million ';
    else if(($cent[3]!=0 && $cent[3]!='') || ($dix[3]!=0 && $dix[3]!='') || ($unite[3]!=0 && $unite[3]!=''))
        $result .= $trio[3]. ' ' .$secon[3]. ' ' . $prim[3]. ' millions ';
    else
        $result .= $trio[3]. ' ' .$secon[3]. ' ' . $prim[3];
     
    if(($cent[2]==0 || $cent[2]=='') && ($dix[2]==0 || $dix[2]=='') && ($unite[2]==1))
        $result .= ' mille ';
    else if(($cent[2]!=0 && $cent[2]!='') || ($dix[2]!=0 && $dix[2]!='') || ($unite[2]!=0 && $unite[2]!=''))
        $result .= $trio[2]. ' ' .$secon[2]. ' ' . $prim[2]. ' milles ';
    else
        $result .= $trio[2]. ' ' .$secon[2]. ' ' . $prim[2];
     
    $result .= $trio[1]. ' ' .$secon[1]. ' ' . $prim[1];
     
    $result .= ' '. $dev1 .' ' ;
     
    if(($cent_c=='0' || $cent_c=='') && ($dix_c=='0' || $dix_c==''))
        $result .= ' et 00 '. $dev2;
    else{
         if($unite_c==1){
            $x=$chif[$unite_c];
            $unite_c=' et '.$x;
            }
            else {
           $unite_c =$chif[$unite_c];
            }
        $result .= $trio_c. ' ' .$secon_c. ' '.$unite_c.' '. $dev2;
    }
    
    $result = strtoupper($result);
    return $result;
}
    
    function number2string($number=0,$local="fr",$unit="Dhs",$sub_unit=""){
        // $three = "";
        // $number = 252.900;
        $exp = explode(".",$number);
        if(substr($exp[1], 1, 1) == "0"){
            $number = number_format($number,1,".","");
        }else{
            $number = number_format($number,2,".","");
        }

        $NF = new NumberFormatter($local, NumberFormatter::SPELLOUT);

        $explode = explode(".",$number);

        $tot_character1 = ucfirst($NF->format($explode[0]));
        $tot_character2 = $NF->format($explode[1]);

        $string = $tot_character1." <b>".$unit."</b>";

        if ($explode[1] > 0){
            $zero2 = "";
            $and = ($local == "fr") ? "virgule" : "and";
            $zero = ($local == "fr") ? "zéro-" : "zero ";
            $zero = (substr($explode[1], 0, 1) == "0") ? $zero : "";
            if (!empty($three)) {
                $zero2 = (substr($explode[1], 1, 1) == "0") ? $zero : "";
            }
            $tot_character2 = $zero.$zero2."".$tot_character2;

            $string .= " ".$and." ".$tot_character2." <b>".$sub_unit."</b>";
        }

        return strtoupper($string);
    }

    public function ConvNumberLetter($Nombre, $Devise=1, $Langue=0) {
        $dblEnt=''; $byDec='';
        $bNegatif='';
        $strDev = '';
            $strCentimes = '';

        if( $Nombre < 0 ) {
            $bNegatif = true;
            $Nombre = abs($Nombre);

        }
        $dblEnt = intval($Nombre) ;
            $byDec = round(($Nombre - $dblEnt) * 100) ;
        if( $byDec == 0 ) {
            if ($dblEnt > 999999999999999) {
                return "#TropGrand" ;
            }
            }
        else {
            if ($dblEnt > 9999999999999.99) {
                return "#TropGrand" ;
            }
            }
            switch($Devise) {
            case 0 :
                if ($byDec > 0) $strDev = " virgule" ;
                            break;
            case 1 :
                $strDev = " DIRHAMS" ;
                // if ($byDec > 0) $strCentimes = $strCentimes . " CTS" ;
                if ($byDec > 0) $strCentimes = $strCentimes . " " ;
                            break;
            case 2 :
                $strDev = " Dollar" ;
                if ($byDec > 0) $strCentimes = $strCentimes . " Cent" ;
                            break;
            } 
            $strDev = "";
        //if (($dblEnt > 1) && ($Devise != 0)) $strDev = $strDev . "s" ;
            $NumberLetter ='';
            if ($byDec > 0)
            $NumberLetter = self::ConvNumEnt(floatval($dblEnt), $Langue) . $strDev .' et '. self::ConvNumDizaine($byDec, $Langue) . $strCentimes ;
            else
            $NumberLetter = self::ConvNumEnt(floatval($dblEnt), $Langue) . $strDev ;
            
            $NumberLetter = self::number2string($Nombre);
            return strtoupper($NumberLetter);
    }

    public function ConvNumEnt($Nombre, $Langue) {
       $byNum=$iTmp=$dblReste='' ;
       $StrTmp = '';
       $NumEnt='' ;
        $iTmp = $Nombre - (intval($Nombre / 1000) * 1000) ;
        $NumEnt = self::ConvNumCent(intval($iTmp), $Langue) ;
        $dblReste = intval($Nombre / 1000) ;
        $iTmp = $dblReste - (intval($dblReste / 1000) * 1000) ;
        $StrTmp = self::ConvNumCent(intval($iTmp), $Langue) ;
        switch($iTmp) {
            case 0 :
                            break;
            case 1 :
                $StrTmp = "mille " ;
                            break;
            default :
                $StrTmp = $StrTmp . " mille " ;
        }
        $NumEnt = $StrTmp . $NumEnt ;
        $dblReste = intval($dblReste / 1000) ;
        $iTmp = $dblReste - (intval($dblReste / 1000) * 1000) ;
        $StrTmp = self::ConvNumCent(intval($iTmp), $Langue) ;
        switch($iTmp) {
            case 0 :
                            break;
            case 1 :
                $StrTmp = $StrTmp . " million " ;
                            break;
            default :
                $StrTmp = $StrTmp . " millions " ;
        }
        $NumEnt = $StrTmp . $NumEnt ;
        $dblReste = intval($dblReste / 1000) ;
        $iTmp = $dblReste - (intval($dblReste / 1000) * 1000) ;
        $StrTmp = self::ConvNumCent(intval($iTmp), $Langue) ;
            switch($iTmp) {
            case 0 :
                            break;
            case 1 :
                $StrTmp = $StrTmp . " milliard " ;
                            break;
            default :
                $StrTmp = $StrTmp . " milliards " ;
        }
        $NumEnt = $StrTmp . $NumEnt ;
        $dblReste = intval($dblReste / 1000) ;
        $iTmp = $dblReste - (intval($dblReste / 1000) * 1000) ;
        $StrTmp = self::ConvNumCent(intval($iTmp), $Langue) ;
            switch($iTmp) {
            case 0 :
                            break;
            case 1 :
                $StrTmp = $StrTmp . " billion " ;
                            break;
            default :
                $StrTmp = $StrTmp . " billions " ;
        }
        $NumEnt = $StrTmp . $NumEnt ;
        return $NumEnt;
    }

    public function ConvNumDizaine($Nombre, $Langue) {
        $TabUnit=$TabDiz='';
        $byUnit=$byDiz='' ;
        $strLiaison = '' ;

        $TabUnit = array("", "un", "deux", "trois", "quatre", "cinq", "six", "sept",
            "huit", "neuf", "dix", "onze", "douze", "treize", "quatorze", "quinze",
            "seize", "dix-sept", "dix-huit", "dix-neuf") ;
        $TabDiz = array("", "", "vingt", "trente", "quarante", "cinquante",
            "soixante", "soixante", "quatre-vingt", "quatre-vingt") ;
        if ($Langue == 1) {
            $TabDiz[7] = "septante" ;
            $TabDiz[9] = "nonante" ;
            }
        else if ($Langue == 2) {
            $TabDiz[7] = "septante" ;
            $TabDiz[8] = "huitante" ;
            $TabDiz[9] = "nonante" ;
        }
        $byDiz = intval($Nombre / 10) ;
        $byUnit = $Nombre - ($byDiz * 10) ;
        $strLiaison = "-" ;
        if ($byUnit == 1) $strLiaison = " et " ;
        switch($byDiz) {
            case 0 :
                $strLiaison = "" ;
                            break;
            case 1 :
                $byUnit = $byUnit + 10 ;
                $strLiaison = "" ;
                            break;
            case 7 :
                if ($Langue == 0) $byUnit = $byUnit + 10 ;
                            break;
            case 8 :
                if ($Langue != 2) $strLiaison = "-" ;
                            break;
            case 9 :
                if ($Langue == 0) {
                    $byUnit = $byUnit + 10 ;
                    $strLiaison = "-" ;
                }
                            break;
        }
        $NumDizaine = $TabDiz[$byDiz] ;
        if ($byDiz == 8 && $Langue != 2 && $byUnit == 0) $NumDizaine = $NumDizaine . "s" ;
        if ($TabUnit[$byUnit] != "") {
            $NumDizaine = $NumDizaine . $strLiaison . $TabUnit[$byUnit] ;
            }
        else {
            $NumDizaine = $NumDizaine ;
        }
        return $NumDizaine;
    }

    public function ConvNumCent($Nombre, $Langue) {
        $TabUnit='' ;
        $byCent=$byReste='' ;
        $strReste = '' ;
        $NumCent='';
        $TabUnit = array("", "un", "deux", "trois", "quatre", "cinq", "six", "sept","huit", "neuf", "dix") ;

        $byCent = intval($Nombre / 100) ;
        $byReste = $Nombre - ($byCent * 100) ;
        $strReste = self::ConvNumDizaine($byReste, $Langue);
        switch($byCent) {
            case 0 :
                $NumCent = $strReste ;
                            break;
            case 1 :
                if ($byReste == 0)
                    $NumCent = "" ;
                else
                    $NumCent = "cent " . $strReste ;
                break;
            default :
                if ($byReste == 0)
                    $NumCent = $TabUnit[$byCent] . "" ;
                else
                    $NumCent = $TabUnit[$byCent] . " cent " . $strReste ;
            }
        
            return $NumCent;
    }
}