<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_supplies/index.php
 * \ingroup    list
 * \brief      List of work_supplies
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/attachments/class/attachments.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/count_advance/class/count_advance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_metres/class/work_metres.class.php';

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";
$fuser 	 = new User($db);

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$metre_id 	  = GETPOST('metre_id','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$metre_id)
	die("ID de metre n'existe pas!");

$search_ref       		 = GETPOST('search_ref');
$search_refs       		 = GETPOST('search_refs');
$search_date 		 = GETPOST('search_date');
$search_qty      = GETPOST('search_qty');
$search_count		 = GETPOST('search_count');
 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_refs   	 	= "";
	$search_ref   	 	= "";
	$search_count   = "";
    $search_qty = "";
	$search_date	= "";
}
$metre  = new MarketWorkMetres($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$object  = new Attachments($db);
llxHeader(array(), $langs->trans('Attachments'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (isset($search_qty) && !empty($search_qty)) ? " AND qty = ". $db->escape((int)$search_qty) : '';
$filter .= isset($search_count) && !empty($search_count) ? " AND fk_count = '". $db->escape($search_count) ."'" : '';
$filter .= (!empty($search_refs) && $search_refs != -1) ? " AND  ref= ". $db->escape((int)$search_refs) : "";
if (isset($search_date) && !empty($search_date))
	$filter .=  " AND  attach_date = '". $db->escape(Tools::convertDateTo($search_date, 'sql'))  ."'";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getattach = $object->fetchAll($metre_id, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getattach == '-1') {
    print_fiche_titre($langs->trans('Metres'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

if ($id > 0) {
	$object->fetch($id);
	$metre->fetch($metre_id);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);

	print_barre_liste($langs->trans("Attachments"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
	
	$attach  = market_works_metre_prepare_head($metre);
	dol_fiche_head($attach,'attachments', $langs->trans("Attachments"), 0, 'submunu1');

	$attach_Head  = market_works_metre_attachment_prepare_head($object);

	dol_fiche_head($attach_Head,'', $langs->trans("Headers"), 0, 'submunu2');
	
	// echo $market->getMarketHeader($wid);

	$qty 	= $object->qty ? $object->qty : '';
	//$charge_supplment= $object->charges_supplement ? number_format($object->charges_supplement, 2) : '';
	$refs		= $object->ref ? $object->ref : '';
	$count		= $object->fk_count ? $object->fk_count : '';
	$mdate = $object->attach_date ? dol_print_date($object->attach_date, 'day'): '';
		 $counte=new CountAdvance($db);

	$counte->fetch($count);
		
	// Numero
		print '<table class="border" width="100%">';
	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'.$refs.'</td></tr>';
    print '<tr><td class="">'.$langs->trans("DCount").'/'.$langs->trans("
Advance").'</td>';
    print '<td colspan="2">'. $counte->getNomUrl(1, $count, $works->fk_market, $counte->num) .'</td></tr>';
	// quantity
	print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
	print '<td colspan="2">'. $qty .'</td></tr>';

	
	// date
	print '<tr><td class="">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'. $mdate .'</td></tr>';


	// ChargesMetres
	

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?metre_id='. $metre_id .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&metre_id='. $metre_id .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&metre_id='. $metre_id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
		
            print $form->formconfirm("./card.php?metre_id=".$metre_id."&id=".$id, $langs->trans("TitleDeleteAttachment"), $langs->trans("ConfirmDeleteAttachment"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
					
	$metre->fetch($metre_id);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);

	print_barre_liste($langs->trans("Attachments"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
	
	$work_Head  = market_works_metre_prepare_head($metre);
		dol_fiche_head($work_Head,'attachments', $langs->trans("Attachments"), 0, 'submunu1');
	
	// echo $market->getMarketHeader($wid);

	$moreparam = '&metre_id='.$metre_id;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="metre_id" value="'. $metre_id .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], 'ref', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	
	print_liste_field_titre($langs->trans("DCount/Advance"),$_SERVER["PHP_SELF"], "fk_count", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Quantity"), $_SERVER["PHP_SELF"], 'qty', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"],'attach_date','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
		print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_refs" value="'.$search_refs.'" />';
	print '</td>';

	print '<td class="liste_titre" align="center">';

		 print '<select name="search_count"   width="20px"  id="nomer"/>';
      $pselect="";
      $cht=new CountAdvance($db);
      $arr=array();
      $arr=$cht->getCountsAdv($works->fk_market);

      print '<option value=""></option>';
        if (count($arr)) {
         foreach($arr as $key => $row) {
        	if($search_count){
            	if($key==$search_count){
       		   $pselect="selected=selected";
            	}
           }
       print '<option  value="'.$key.'" '.$pselect.'>'.$row.'</option>';
      $pselect="";
        }
    }
    print '</select>';
	print '</td>';
 

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_qty" value="'.$search_qty.'"></td>';



	
print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="20" name="search_date" value="'. $search_date .'"></td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines

	if (count($object->lines)) {
			$count=new CountAdvance($db);

		foreach ($object->lines as $line) {
			$var = !$var;
			$qty= $line->qty ? $line->qty: '';
		
			$count->fetch($line->fk_count);
		
			$mdate = $line->attach_date ? dol_print_date($line->attach_date, 'day'): '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $object->getNomUrl(1,  $line->id, $line->fk_metre,$line->ref);
			print '</td>';
			print '<td align="center">'.$count->getNomUrl(1, $line->fk_count, $works->fk_market, $count->num) .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $mdate .'</td>';
	
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&metre_id='. $metre_id .'" class="butAction">'.$langs->trans('AddAttachment').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>