<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       btp/bail/card.php
 *		\ingroup    bail
 *		\brief      Gestion des bail
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/bail/class/bail.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marché n\'existe pas!');

$error 	= false;
$object = new Bail($db);
$market = new Market($db);
$account= new Account($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action='request';
    // If no right to create a request
   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	   	$market_id 	= (int)trim(GETPOST('mid', 'int'));
	    $bank 	  	= (int) GETPOST('bank_', 'int');
	    $ref 		= trim($_POST['ref']);
	    $amount   	= (float)trim(GETPOST('amount'));
	    $bail_date 	= trim(GETPOST('bail_date'));
	    $delivery_date= trim($_POST['delivery_date']);
	    $recovery_date= trim($_POST['recovery_date']);
	    $type 		 = trim($_POST['type']);
	    $description = trim($_POST['description']);

	    if (!$market_id || !$bank || !$ref || !$amount || !$bail_date) {
	    	header("Location: ./card.php?action=create&mid=".$mid);
	    	die();
	    }

	    $object->fk_createdby 	= $user->id;
	    $object->fk_market 	 	= $market_id;
	    $object->fk_bank 	 	= $bank;
		$object->date_bail 	 	= Tools::convertDateTo($bail_date, 'sql');
		$object->date_delivery 	= $delivery_date ? Tools::convertDateTo($delivery_date, 'sql') : '';
		$object->date_recovery 	= $recovery_date ? Tools::convertDateTo($recovery_date, 'sql') : '';
		$object->amount 	 	= $amount;
	    $object->ref 			= $ref;
	    $object->type 			= $type;
	    $object->description	= $description;
		
		$getBailId = $object->create();

	    // If no SQL error we redirect to the request card
	    header('Location: ./index.php?mid='.$market_id.'&id='.$getBailId);
	    die();
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] && $_POST['mid'] && $request_method === 'POST') {
    $action = 'edit';
	// If no right to create a request
   /* if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	   	$id 		= (int)trim(GETPOST('id', 'int'));
	   	$market_id 	= (int)trim(GETPOST('mid', 'int'));
	    $bank 	  	= (int) GETPOST('bank_', 'int');
	    $ref 		= trim($_POST['ref']);
	    $amount   	= (float)trim(GETPOST('amount'));
	    $bail_date 	= trim(GETPOST('bail_date'));
	    $delivery_date= trim($_POST['delivery_date']);
	    $recovery_date= trim($_POST['recovery_date']);
	    $type 		 = trim($_POST['type']);
	    $description = trim($_POST['description']);

	    if ((!$market_id || !$id) || !$bank || !$ref || !$amount || !$bail_date) {
	    	header("Location: ./index.php?mid=".$mid);
	    	die();
	    }

	    $data = array(
		    'fk_bank' 	 	=> $bank,
			'date_bail' 	=> Tools::convertDateTo($bail_date, 'sql'),
			'date_delivery' => $delivery_date ? Tools::convertDateTo($delivery_date, 'sql') : '',
			'date_recovery' => $recovery_date ? Tools::convertDateTo($recovery_date, 'sql') : '',
			'amount' 	 	=> $amount,
		    'ref' 			=> $ref,
		    'type' 			=> $type,
		    'description'	=> $description,
		);

		$object->update($id, $data);

    	header('Location: ./index.php?mid='.$market_id.'&id='.$id);
        die();
	// }
}

$form 	 = new Form($db);

llxHeader(array(), $langs->trans('bail'),'','','','',array("/btp/js/btp.js"),array(),0,0);
$def = $langs->trans("Definit");

if (!empty($mid) && ($action == 'add' || $action == 'request' || $action == 'create')) {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreate');
    } else {*/
        // Formulaire de concurrents
		$market->fetch($mid);
		// $head = market_prepare_head($market);
		
		// dol_fiche_head($head, 'notifications', $langs->trans('NotificationsPhase'), 0, '');

		$head_btm = market_prepare_head($market);
		dol_fiche_head($head_btm, 'bail',$langs->trans('DefinitiveBail'), 0, '');
		echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
        print $form->select_comptes((GETPOST('bank_') ? GETPOST('bank_') : ''), 'bank_',0,'',1,'required="required"') ."<span class='bank_number'></span>";
        print'</td></tr>';

        print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Ref").'</td><td><input type="text" class="ref" value="" name="ref" required="required" /></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalBailAmount").' '. $def.' HT</td><td><input type="text" class="amount" value="" name="amount" required="required" /> '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("BailDate").' '. $def.'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="bail_date" required="required" /></td></tr>';
        print '<tr><td class="">'.$langs->trans("DeliveryDate").'</td><td><input type="text" class="datepicker" autocomplete="off"  value="" name="delivery_date" /></td></tr>';
		print '<tr><td class="">'.$langs->trans("RecoveryDate").'</td><td><input type="text" class="datepicker" autocomplete="off"  value="" name="recovery_date" /></td></tr>';

		print '<tr><td>'.$langs->trans("Type").'</td><td>';
        print '<input type="text" class="flat" value="" name="type" /></td></tr>';

        print '<tr><td valign="top">'.$langs->trans("Description").'</td><td>';
        print '<textarea cols="60" class="flat" rows="10" name="description"></textarea></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateBail") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id && $mid) {
		$object->fetch($id, $mid);
		$market->fetch($mid);
		$head  = market_prepare_head($market);
		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                die("Can not delete this bail");
            }

			if ($action == 'edit') {
				dol_fiche_head($head, 'bail',$langs->trans('DefinitiveBail'), 0, '');
				echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$account->fetch($object->fk_bank);
				$amount 	= $object->amount ?: '';
				$ref	  	= $object->ref ? $object->ref : '';
				$date_bail	= $object->date_bail ? dol_print_date($object->date_bail, 'day') : '';
				$date_delivery= $object->date_delivery ? dol_print_date($object->date_delivery, 'day') : '';
				$date_recovery= $object->date_recovery ? dol_print_date($object->date_recovery, 'day') : '';
				$type 		 = $object->type ? $object->type : '';
				$description = $object->description ? $object->description : '';
				$number = '';

                if ($account->number) {
                    $number = "<span class='bank_number'> &nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )</span>";
                }

                print '<table class="border" width="100%">';
        		print '<tbody>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
		        print $form->select_comptes((GETPOST('bank_') ? GETPOST('bank_') : $object->fk_bank), 'bank_',0,'',1,'required="required"') .' '. $number;
		        print'</td></tr>';

		        print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Ref").'</td><td><input type="text" class="ref" value="'. $ref .'" name="ref" required="required" /></td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalBailAmount").' '. $def.' HT</td><td><input type="text" class="amount" value="'. $amount .'" name="amount" required="required" /> '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("BailDate").' '. $def.'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_bail .'" name="bail_date" required="required" /></td></tr>';
		        print '<tr><td class="">'.$langs->trans("DeliveryDate").'</td><td><input type="text" class="datepicker" autocomplete="off"  value="'. $date_delivery .'" name="delivery_date" /></td></tr>';
				print '<tr><td class="">'.$langs->trans("RecoveryDate").'</td><td><input type="text" class="datepicker" autocomplete="off"  value="'. $date_recovery .'" name="recovery_date" /></td></tr>';

				print '<tr><td>'.$langs->trans("Type").'</td><td>';
		        print '<input type="text" class="flat" value="'. $type .'" name="type" /></td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("Description").'</td><td>';
		        print '<textarea cols="60" class="flat" rows="10" name="description">'. $description .'</textarea></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}



llxFooter();

$db->close();

?>