<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/bail/index.php
 * \ingroup    list
 * \brief      List of bails related to given mid
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/bail/class/bail.class.php';

$langs->load('users');

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$mid)
	die('ID marché n\'existe pas!');

$object = new Bail($db);
$market = new Market($db);
$account= new Account($db);
$form   = new FormChild($db);

if ($mid) {
	$object->fetch($id);
		
	if (!$object->id)
		$object->fetch(0, $mid);
    $param 		= '&mid='. $mid;
	$upload_dir = $conf->btp->dir_output.'/bail/'.$object->id;
	$modulepart = 'btp';

	$filearray = array();
	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_pre_headers.tpl.php';
}

/**
 * Actions
 */

// None

/**
 * View
 */

llxHeader(array(), $langs->trans('Bails'),'','','','',array('/btp/js/btp.js'));

// Récupération de l'ID de l'utilisateur
$getBails = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, '');

// Si erreur SQL
if ($getBails == '-1') {
    print_fiche_titre($langs->trans('DefinitiveBail'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

if (($id || $mid) && $getBails) {
	$object->fetch($id);
		
	if (!$object->id)
		$object->fetch(0, $mid);

	print_barre_liste($langs->trans("DefinitiveBail"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$mid = $mid ?: $object->fk_market;
	$market->fetch($mid);
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'bail', $langs->trans("DefinitiveBail"), 0, '');

	echo $market->getMarketHeader();

	$user->fetch($object->fk_createdby);
	$account->fetch($object->fk_bank);

	$amount 	= $object->amount ? number_format($object->amount, 2) : '';
	$ref	  	= $object->ref ? $object->ref : '';
	$date_bail	= $object->date_bail ? dol_print_date($object->date_bail, 'day') : '';
	$date_delivery	= $object->date_delivery ? dol_print_date($object->date_delivery, 'day') : '';
	$date_recovery 	= $object->date_recovery ? dol_print_date($object->date_recovery, 'day') : '';
	$type 			= $object->type ? $object->type : '';
	$description	= $object->description ? $object->description : '';
	$def = $langs->trans("Definit");

	print '<table class="border" width="100%">';
        print '<tbody>';
        print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td><td>'. $user->getNomUrl(1) .'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>'. $account->getNomUrl(1) . ($account->number ? " &nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )" : "") .'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Ref").'</td><td>'. $ref .'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalBailAmount").' '. $def.' HT</td><td>' . $amount .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("BailDate").' '. $def.'</td><td>' . $date_bail .'</td></tr>';
        print '<tr><td class="">'.$langs->trans("DeliveryDate").'</td><td>' . $date_delivery .'</td></tr>';
        print '<tr><td class="">'.$langs->trans("RecoveryDate").'</td><td>' . $date_recovery .'</td></tr>';
        print '<tr><td class="">'.$langs->trans("Type").'</td><td>' . $type .'</td></tr>';
        print '<tr><td class="">'.$langs->trans("Description").'</td><td>' . $description .'</td></tr>';
     	print '</tbody>';
	print '</table><br />';

	if ($user->id /*&& $user->rights->btp->write_all*/) {
		print '<div class="tabsAction">';
        // Boutons d'actions
		print '<a href="./card.php?action=edit&mid='. $mid .'&id='. $object->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        print '</div>';
	}

	$modulepart = 'btp';
    $permission = $user->rights->btp->write;
    $param 		= '&mid='. $mid;
    $relativepathwithnofile = '/bail/'.$object->id.'/';

    include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_post_headers.tpl.php';
}

if ($user->id/* && $user->rights->btp->write*/ && !$getBails) {
	$market->fetch($mid);
	$title = $langs->trans("Bails");
	$head  = market_prepare_head($market);

	print_barre_liste($langs->trans("DefinitiveBail"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	dol_fiche_head($head, 'bail', $langs->trans('Bails'), 0, '');

	echo $market->getMarketHeader();
	
	print '<br>';
	print '<div style="text-align: center; margin-top: 8px;">';
	print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddBail').'</a>';
	print '</div>';
}

llxFooter();

$db->close();

?>