<?php
require_once DOL_DOCUMENT_ROOT .'/btp/db/nxdb.class.php';

class bon_avance extends NXdb{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
 /**
	 * @var string Id to identify managed objects
	 */
	public $element = 'bon_avance';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'bon_avance';
	
	  
	public $pu ;
	public $montant ;
	public $libelle ;
	public $qty ;
	public $fk_createdby;
	public $date_bonde_id;
	public $rows = array();
	public $lines = array();
	public $now;
    public $rowid;
    public $id;
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

	public function create()
	{
		global $conf;
 		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape($this->fk_createdby): null;
		$this->date_bonde_id 			    = $this->date_bonde_id ? $this->db->escape($this->date_bonde_id): null;
		$this->libelle			    = $this->libelle ? $this->db->escape($this->libelle): null;
		$this->qty			    = $this->qty ? $this->db->escape($this->qty): null;
		$this->montant			    = $this->montant ? $this->db->escape($this->montant): null;
		$this->pu			    = $this->pu ? $this->db->escape($this->pu): null;
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element .'(pu,montant,qty,libelle,date_bonde_id,created_by,entity,created_at,updated_at) VALUES (';
		$sql .= ''.$this->pu.','.$this->montant.','.$this->qty.',"'.$this->libelle.'",'.$this->date_bonde_id.','.$this->fk_createdby.','.$conf->entity.',"'.$this->now.'","'.$this->now.'")';
        
		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			return -1;
		} else {
			$this->db->commit();
	return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			    = $this->db->fetch_object($resql);
				$this->rowid 		= $obj->rowid;
				$this->fk_createdby = $obj->fk_createdby;
				$this->pu= $obj->pu;
				$this->qty= $obj->qty;
				$this->montant= $obj->montant;
				$this->date_bonde_id= $obj->date_bonde_id;
				$this->libelle = $obj->libelle ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,$bonde = null,$dated=null,$ref=null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/bon_avance/card_bon.php?date_bon='. $dated.'&id_bond='.$bonde.'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }
	
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element  .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element  . ' SET ';
		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  rowid = ' . $id;
        echo $sql;
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function fetchAll($mid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $exculded_id = null, $ignore_id = false)
	{
		global $conf;

		dol_syslog(__METHOD__, LOG_DEBUG);
		$count = 0;

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'bon_avance';

		if (null !== $mid) {
			$sql .=  ' WHERE date_bonde_id = '. (int)$mid . $filter;
			$count++;
		} elseif (!empty($filter)) {
			$sql .= ' WHERE '. ltrim($filter, ' AND');
			$count++;
		}
		
		if (null !== $exculded_id) {
			$sql .= ($count ? ' AND ' : ' WHERE ') . " rowid <> ". (int)$exculded_id;
			$count++;
		}

		$sql .= ($count ? ' AND ' : ' WHERE ') . ' entity = '. $conf->entity;

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			$sql .= $this->db->plimit($limit);
		}
        
		$this->rows = array();
		$resql 		= $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				 	 $line->rowid 			= $obj->rowid;
					 $line->pu 	        = $obj->pu ;
				 	 $line->montant 			= $obj->montant ;
				  	$line->libelle         	= $obj->libelle ;
				  	$line->qty 	    = $obj->qty ;
				 	 $line->date_bonde_id	    = $obj->date_bonde_id ;
				 	$line->created_by 	= $obj->created_by ;
				 	 $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('advance_user');
    	$object->url 	= DOL_URL_ROOT.'/btp/rh/advance_user/index.php';

    	return $object;
    }

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
    public function load_board()
    {
        global $conf, $user, $langs;

		require_once DOL_DOCUMENT_ROOT . '/btp/rh/integration/class/integration.class.php';

		$integration = new Integration($this->db);

        return array($this->getStatData(), $integration->getStatData());
    }







public function fetchdec($id, $ref = null,$date='',$libelle='')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'bon_entrees';

	if (!empty($id)) {
			$sql .= ' WHERE entree_id = ' . '\'' . $id . '\'';
		} 
		if (!empty($date)) {
			$sql .= ' and dated = ' . '\'' . $date. '\'';
		} 
		if (!empty($libelle)) {
			$sql .= ' and bonde = ' . '\'' . $libelle . '\'';
		} 
	$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
					$line->montant 			 = $obj->montant;
					$line->qty 			 = $obj->qty;
					$line->pu 			 = $obj->pu;
					$line->libelle 		 = $obj->libelle;
					$this->lines[] = $line;
				}
				return $this->lines;
			}
			return false;
		}
		return false;
	}


















}
