<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/documentmanagement/class/documentmanagement.class.php
 * \ingroup documentmanagement
 * \brief   This file is documentmanagement CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class marches
 *
 * Contract Management class
 */
class documentprix extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'documentprix';
	/**
	 * @var string Name of table without pref_marcheix where object is stored
	 */
	public $table_element 	 = 'documentprix';

	/**
	 * @var int ID
	 */
	public $rowid;
	public $id;
  	public $date_prix;
  	public $montant;
	public $fk_created_by;
	public $market;
	public $doc_date;
	public $subject;
	public $entity;
	public $created_at;
	public $updated_at;
	public $fk_soustrai;
	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */













	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_created_by= $this->db->escape($this->fk_created_by);
		$this->market 	= $this->db->escape($this->market);
		$this->fk_soustrai 	= $this->db->escape($this->fk_soustrai);
		$this->montant		= $this->db->escape($this->montant);
		$this->subject 			= $this->db->escape($this->subject);
		$this->doc_date		= $this->db->escape($this->doc_date);
		$this->date_prix		= $this->db->escape($this->date_prix);
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_soustrai,subject, fk_created_by, market, montant, created_at, updated_at, doc_date, date_prix) VALUES (';
		$sql .= ''. $this->fk_soustrai .',"'. $this->subject .'",'.$this->fk_created_by.', "'.$this->market.'", '.$this->montant.', "'.$this->created_at.'", "'.$this->updated_at .'", "'.$this->doc_date.'", "'. $this->date_prix .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error documentmanagement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_soustrai = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $fk_soustrai) {
			$sql .= ' WHERE fk_soustrai = ' . $fk_soustrai;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->rowid 			 = $obj->rowid;
				$this->fk_created_by = $obj->fk_created_by;
				$this->market 	 = $obj->market;
				$this->fk_soustrai 	 = $obj->fk_soustrai;
				$this->subject 	 		 = $obj->subject;
				$this->doc_date  	 = $this->db->jdate($obj->doc_date);
				$this->date_prix  	 = $this->db->jdate($obj->date_prix);
				$this->montant 	 = $obj->montant;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($fk_soustrai, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_soustrai = '. $fk_soustrai ;
		} else {
			$sql .= ' WHERE fk_soustrai = '. $fk_soustrai ;
		}

		

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->rowid 			 = $obj->rowid;
				$line->fk_created_by = $obj->fk_created_by;
				$line->market 	 = $obj->market;
				$line->fk_soustrai 	 = $obj->fk_soustrai;
				$line->subject 	 		 = $obj->subject;
				$line->doc_date  	 = $this->db->jdate($obj->doc_date);
				$line->date_prix  	 = $this->db->jdate($obj->date_prix);
				$line->subject 	 = $obj->subject;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $type, $ref = null, $mid = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $ref 	= (null !== $ref) ? $ref : $langs->trans("Show").': '. $id;
        $id  	= ($id  ?: '');

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/bordereau_prix/index.php?id='. $id .'" class="classfortooltip" title="'. $ref .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($ref, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$ref.$linkend;
        return $result;
    }

    /**
     * Get list of types
     */
    public function getDocumentTypes()
    {
    	global $langs;

    	return array(
    		1 => $langs->trans('PvImplantation'),
    		2 => $langs->trans('TechnicalMemory'),
    		3 => $langs->trans('OS'),
    		4 => $langs->trans('PvSiteMonitoring'),
    		5 => $langs->trans('ReportEndWork'),
    		6 => $langs->trans('DailyReport'),
    		7 => $langs->trans('CasingCertificates'),
    		8 => $langs->trans('CertificateOfOrigin'),
    		9 => $langs->trans('PurchaseInvoices'),
    		10 => $langs->trans('Piezometer'),
    		11 => $langs->trans('Wells'),
    		12 => $langs->trans('ReconnaissancesSurvey'),
    		13 => $langs->trans('MarektSlip'),
    	);
    }

    /**
     * Get type by id
     */
    public function getDocumentTypeById($id)
    {
    	global $langs;
    	$type = '';

    	switch ((int)$id) {
    		case 1:
    			$type = $langs->trans('PvImplantation'); break;
    		case 2:
    			$type = $langs->trans('TechnicalMemory'); break;
    		case 3:
    			$type = $langs->trans('OS'); break;
    		case 4:
    			$type = $langs->trans('PvSiteMonitoring'); break;
    		case 5:
    			$type = $langs->trans('ReportEndWork'); break;
    		case 6:
    			$type = $langs->trans('DailyReport'); break;
    		case 7:
    			$type = $langs->trans('CasingCertificates'); break;
    		case 8:
    			$type = $langs->trans('CertificateOfOrigin'); break;
    		case 9:
    			$type = $langs->trans('PurchaseInvoices'); break;
    		case 10:
    			$type = $langs->trans('Piezometer'); break;
    		case 11:
    			$type = $langs->trans('Wells'); break;
    		case 12:
    			$type = $langs->trans('ReconnaissancesSurvey'); break;
    		case 13:
    			$type = $langs->trans('MarektSlip'); break;
    	}

    	return $type;
    }

    public function getDocumentTypesDir()
    {
    	return array(
    		'pv_implantation',
    		'technical_memory',
    		'os',
    		'pv_site_monitoring',
    		'report_end_work',
    		'daily_report',
    		'casing_certificates',
    		'certificate_of_origin',
    		'purchase_invoices',
    		'tc_piezometer',
    		'tc_wells',
    		'tc_reconnaissance_survey',
    		'market_slip',
    	);
    }

    public function getTechnicalDocumentTypes()
    {
    	global $langs;

    	return array(
    		10 => $langs->trans('Piezometer'),
    		11 => $langs->trans('Wells'),
    		12 => $langs->trans('ReconnaissancesSurvey')
    	);
    }

    public function fetchAllStat($mid, $type, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;


         
		if($mid){
		 $mark=' where fk_marche = '. $mid . $sqlType;
		}else{
		$mark='';}
		$sql.=$mark;

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_created_by = $obj->fk_created_by;
				$line->fk_marche 	 = $obj->fk_marche;
				$line->type_id 		 = $obj->type_id;
				$line->ref 	 		 = $obj->ref;
				$line->doc_date  	 = $this->db->jdate($obj->doc_date);
				$line->observes 	 = $obj->observes;
				$line->statut 		 = $obj->statut;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
     public function getStatData($market_id = false)
    {
    	global $langs;
    
    	$this->fetchAllStat($market_id ? : null,null);

    	$object 		= new stdClass();
    	$object->number = count($this->lines);
    	$object->cost 	= false;
    	$object->label 	= $langs->trans('MarketDocuments');
    	$object->url 	= (int)$market_id ? DOL_URL_ROOT.'/btp/market/documentmanagement/index.php?mid='.(int)$market_id : '';

    	return $object;
    }
}
/*$count = 0;

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'construction_site ';

		if (null !== $mid) {
			$sql .= 'WHERE market_id = '. (int)$mid . $filter;
			$count++;
		} elseif (!empty($filter)) {
			$sql .= 'WHERE '. ltrim($filter, ' AND');
			$count++;
		}
		
		if (null !== $exculded_id) {
			$sql .= ($count ? ' AND ' : ' WHERE ') . " rowid <> ". (int)$exculded_id;
			$count++;
		}

		$sql .= ($count ? ' AND ' : ' WHERE ') . ' entity = '. $conf->entity;
*/