<?php
/* Copyright (C) 2016   Yassine Belkaid <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches//bails/index.php
 * \ingroup    list
 * \brief      List of bails related to given mid
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
//require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/bordereau_prix/class/documentprix.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/sous_traitance/class/sous_traitance.class.php';
$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page      = GETPOST("page",'int');
$page      = is_numeric($page) ? $page : 0;
$page      = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$soustr_id     = GETPOST('soustr_id', 'int');
$id      = GETPOST('id', 'int');
$action   = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$soustr_id)
    die('ID sous-traitance n\'existe pas!');

$object = new documentprix($db);
$sous_traitance = new sous_traitance($db);
$account= new Account($db);
$form   = new FormChild($db);

if ($soustr_id > 0) {
    $object->fetch($id);
        
    if (!$object->rowid)
        $object->fetch(0, $soustr_id);
    $param      = '&soustr_id='. $soustr_id;
    $upload_dir = $conf->btp->dir_output.'/bordereau_prix/'.$object->rowid;
    $modulepart = 'btp';

    $filearray = array();
    // Construit liste des fichiers
    $filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
    $totalsize=0;
    foreach($filearray as $key => $file) {
        $totalsize+=$file['size'];
    }

    include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_pre_headers.tpl.php';
}

/**
 * Actions
 */

// None

/**
 * View
 */

llxHeader(array(), $langs->trans('PriceDocuments'));

// Récupération de l'ID de l'utilisateur
$getDocument = $object->fetchAll($soustr_id, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, '');

// Si erreur SQL
if ($getDocument == '-1') {
    print_fiche_titre($langs->trans('PriceDocuments'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

if (($id > 0 || $soustr_id > 0) && $getDocument > 0) {
    $object->fetch($id);
        
    if (!$object->rowid)
        $object->fetch(0, $soustr_id);

    //ECHO $object->rowid;
    $sous_traitance->fetch($soustr_id);
    $title = $langs->trans("PriceDocuments");
     print_fiche_titre($title, '', 'title_project.png');
    
    $head  = soustraitance_prepare_head($sous_traitance);
    dol_fiche_head($head, 'priceDocuments', $langs->trans('PriceDocuments'), 0, '');
    
    echo $sous_traitance->getTraitanceHeader($sous_traitance);

    $user->fetch($object->fk_created_by);
   
    $amount     = $object->montant ? number_format($object->montant, 2) : '';

    $subject        = $object->subject ? $object->subject : '';
    $date_prix  = $object->date_prix ? dol_print_date($object->date_prix, 'day') : '';
    $mark=$object->market ? $object->market : '';
 

   

    print '<table class="border" width="100%">';
        print '<tbody>';
        print '<tr><td class="fieldrequired">'.$langs->trans("SubjectBDPE").' '. $def .'</td><td>'. $subject .'</td></tr>';
         print '<tr><td class="fieldrequired">'.$langs->trans("DateBDPE").' '. $def.'</td><td>' . $date_prix .'</td></tr>';
        print '<tr><td class="">'.$langs->trans("marketNum").'</td><td>' . $mark .'</td></tr>';
       
        print '<tr><td class="fieldrequired">'.$langs->trans("AmountTTC").'</td><td>' . $amount.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
   
        
        print '</tbody>';
    print '</table><br />';

    if ($user->id /*&& $user->rights->marches->write_all*/) {
        print '<div class="tabsAction">';
        // Boutons d'actions
        print '<a href="./card.php?action=edit&soustr_id='. $soustr_id .'&id='. $object->rowid .'" class="butAction">'.$langs->trans('Modify').'</a>';
        print '</div>';
    }


    $modulepart = 'btp';
    $permission = $user->rights->btp->write;
   $param       = '&soustr_id='. $soustr_id;
  
    $relativepathwithnofile = '/bordereau_prix/'.$object->id.'/';
    include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_post_headers.tpl.php';
  
}
    

  

    


if ($user->id /*&& $user->rights->marches->write*/ && $getDocument <= 0) {
   $sous_traitance->fetch($soustr_id);
    $title = $langs->trans("PriceDocuments");
     print_fiche_titre($title, '', 'title_project.png');
    $head  = soustraitance_prepare_head($sous_traitance);
    dol_fiche_head($head, 'priceDocuments', $langs->trans('PriceDocuments'), 0, '');

    echo $sous_traitance->getTraitanceHeader($sous_traitance);

  
    print '<br>';
    print '<div style="text-align: center; margin-top: 8px;">';
    print '<a href="./card.php?action=add&soustr_id='. $soustr_id .'" class="butAction">'.$langs->trans('AddBordereau').'</a>';
    print '</div>';
}

llxFooter();

$db->close();

?>