<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/marekt/construction_site/construction_site.class.php
 * \ingroup btp
 * \brief   This file is construction_site CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

class ConstructionSite extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

	public $name;
	public $adress;
	public $amount;
	public $nmbrjourchantier;
	public $couthorairechantier;
	public $nmbrkmentrechantierdepot;
	public $tel;
	public $market_id;
	public $head_site_id;
	public $pointer_id;
	public $created_by;
	public $created_at;
	public $updated_at;
	public $rows = array();
	public $now;

	public $table_element = 'construction_site';
	public $element = 'construction_site';

	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d');
		$this->updated_at = $this->now;
		return 1;
	}

	public function getSommeQtyFourniturs($chantier_id)
	{
		$somqty = 0;
		$sql = 'SELECT SUM(qty) as somqty ';
		$sql.= ' FROM '. MAIN_DB_PREFIX .'consumptions_supplies';
		if ($chantier_id > 0)
			$sql.= ' WHERE const_site_id = ' . $chantier_id;
			

		// die($sql);
		$result = array();
		$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$somqty	= $obj->somqty;
			}

			$this->db->free($resql);
		}
		return $somqty;
	}
	
	function liste_chantier_array($market_id='')
    {
        global $conf;

        $projects = array();

        $sql = "SELECT rowid, name";
        $sql.= " FROM " . MAIN_DB_PREFIX .$this->table_element;
        if (! empty($market_id)) $sql.= " WHERE market_id = " . $market_id;

        // echo $sql;
        // die();
        $resql = $this->db->query($sql);
        if ($resql)
        {
            $nump = $this->db->num_rows($resql);

            if ($nump)
            {
                $i = 0;
                while ($i < $nump)
                {
                    $obj = $this->db->fetch_object($resql);

                    $projects[$obj->rowid] = $obj->name;
                    $i++;
                }
            }
            return $projects;
        }
        else
        {
            print $this->db->lasterror();
        }
    }

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0, $id, $ref, $mid)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/construction_site/index.php?id='. $id .'&mid='. $mid .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip nowrap_cls">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->name= $this->name ? $this->db->escape($this->name): null;
	  $this->adress = $this->adress ? $this->db->escape($this->adress): null;
	  $this->amount = $this->amount ? $this->db->escape($this->amount): null;
	  $this->nmbrjourchantier = $this->nmbrjourchantier ? $this->db->escape($this->nmbrjourchantier): null;
	  $this->couthorairechantier = $this->couthorairechantier ? $this->db->escape($this->couthorairechantier): null;
	  $this->nmbrkmentrechantierdepot = $this->nmbrkmentrechantierdepot ? $this->db->escape($this->nmbrkmentrechantierdepot): null;
	  $this->tel = $this->tel ? $this->db->escape($this->tel): null;
	  $this->market_id = $this->market_id ? $this->db->escape($this->market_id): null;
	  $this->head_site_id	= $this->head_site_id ? $this->db->escape($this->head_site_id): null;
	  $this->pointer_id	= $this->pointer_id ? $this->db->escape($this->pointer_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'construction_site' . ' (name,adress,amount,nmbrjourchantier,couthorairechantier, nmbrkmentrechantierdepot,tel,';
	$sql .= 'market_id,head_site_id,pointer_id,created_by,created_at,updated_at) ';
	$sql .= 'VALUES ("'.$this->name.'", "'.$this->adress.'",'.$this->amount.','.$this->nmbrjourchantier.','.$this->couthorairechantier.','.$this->nmbrkmentrechantierdepot.', "'.$this->tel.'", ';
	$sql .=	 $this->market_id.', '.$this->head_site_id.','.$this->pointer_id.', '.$this->created_by.',"'.$this->created_at.'","'. $this->updated_at .'")';

	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error construction_site ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $market_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'construction_site';
		
		if (null !== $market_id) {
			$sql .= ' WHERE market_id = '. (int)$market_id;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid;
			  $this->name 			= $obj->name;
			  $this->adress 	    = $obj->adress;
			  $this->amount 	    = $obj->amount;
			  $this->nmbrjourchantier 	    = $obj->nmbrjourchantier;
			  $this->couthorairechantier 	    = $obj->couthorairechantier;
			  $this->nmbrkmentrechantierdepot 	    = $obj->nmbrkmentrechantierdepot;
			  $this->tel 	        = $obj->tel;
			  $this->market_id 	    = $obj->market_id;
			  $this->head_site_id	= $obj->head_site_id;
			  $this->pointer_id	    = $obj->pointer_id;
			  $this->created_by 	= $obj->created_by;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $exculded_id = null, $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'construction_site ';

		// if (null !== $mid) {
		// 	$sql .= 'WHERE market_id = '. (int)$mid;
		// }

		// if (!empty($filter)) {
		// 	$sql .= 'WHERE '. $filter;
		// }
		
		if (null !== $mid) {
			$sql .= 'WHERE market_id = '. (int)$mid;
			if (!empty($filter))
				$sql .= " ".$filter;
		}else{
			if(!empty($filter))
				$sql .= ' WHERE '. $filter;
		}
		
		if (null !== $exculded_id) {
			$sql .= " AND rowid <> ". (int)$exculded_id;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		 if(!empty($limit)){
         $sql.= " limit  ".$limit ;
		}
		
		$this->rows = array();
		$resql 		= $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->name 			= $obj->name ;
				  $line->adress 	        = $obj->adress ;
				  $line->amount 			= $obj->amount ;
				  $line->nmbrjourchantier 			= $obj->nmbrjourchantier ;
				  $line->couthorairechantier 			= $obj->couthorairechantier ;
				  $line->nmbrkmentrechantierdepot 			= $obj->nmbrkmentrechantierdepot ;
				  $line->tel         	= $obj->tel ;
				  $line->market_id 	    = $obj->market_id ;
				  $line->head_site_id	= $obj->head_site_id ;
				  $line->pointer_id	    = $obj->pointer_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'construction_site' . ' SET updated_at = "'. $this->now .'",';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'construction_site' .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getNames($mid = null, $exculded_id = null)
    {
    	$this->fetchAll($mid, '', '', 0, 0, '', $exculded_id);
    	$names = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$names[$line->id] = $line->name;    		
    	}

    	return $names;
    }

    public function getStatData($market_id = false)
    {
    	global $langs;
    	$this->fetchAll(($market_id ?: null), '', '', 0, 0, '', null, ($market_id ? false : true));
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('ConstructionSites');
    	$object->url 	= (int)$market_id ? DOL_URL_ROOT.'/btp/market/construction_site/index.php?mid='.(int)$market_id : '';

    	return $object;
    }

    /**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
    public function load_board($const_id = false, $market_id = 0)
    {
        global $conf, $user, $langs;

		require_once DOL_DOCUMENT_ROOT . '/btp/market/construction_site_arrangement/class/construction_site_arrangement.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/work_advancement_noslip/class/work_advancement_noslip.class.php';
		require_once DOL_DOCUMENT_ROOT . '/btp/market/consumptions_supplies/class/consumptions_supplies.class.php';

        $constructionSiteArrangement = new ConstructionSiteArrangement($this->db);
        $consumptionsSupplies 		 = new ConsumptionsSupplies($this->db);
        $workAdvancementNoSlip		 = new WorkAdvancementNoSlip($this->db);

        if ($const_id) {
        	$this->fetch($const_id);
        	$market_id = $this->market_id;
        }

        return array($constructionSiteArrangement->getStatData($const_id, $market_id), $consumptionsSupplies->getStatData($const_id, $market_id), $workAdvancementNoSlip->getStatData($const_id, $market_id));
    }



    public function createdate()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);


		// Clean parameters
		$this->datec 				= $this->datec ? $this->db->escape($this->datec): null;
	
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'date' . ' (datec) VALUES (';
		
		$sql .= '"'.$this->datec.'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error  ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}
public function createdatedetail()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->engin 				= $this->engin ? $this->db->escape($this->engin): null;
		$this->chantier				= $this->chantier ? $this->db->escape($this->chantier): null;
		$this->nombreheur 				= $this->nombreheur ? $this->db->escape($this->nombreheur): null;
	$this->rendement1 				= $this->rendement1 ? $this->db->escape($this->rendement1): null;
		$this->rendement2				= $this->rendement2 ? $this->db->escape($this->rendement2): null;
		$this->observation 				= $this->observation ? $this->db->escape($this->observation): null;
			$this->fk_iddate 				= $this->fk_iddate ? $this->db->escape($this->fk_iddate): null;


		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'datedetail' . ' (engin,chantier,nombreheur,rendement1,rendement2,observation,fk_iddate) VALUES (';
		
		$sql .= '"'.$this->engin.'", "'.$this->chantier.'", "'.$this->nombreheur.'", "'.$this->rendement1.'", "'.$this->rendement2.'", "'.$this->observation.'", "'.$this->fk_iddate.'")';
//die($sql);
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error  ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}
	public function updatedate($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		
		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'date' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  id = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

public function updatedatdetail($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		
		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'datedetail' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  id = ' . $id;
die($sql);
		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function deletedate($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'date' .' WHERE id = ' . $id;
	$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

		public function deletedatedetail($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'datedetail' .' WHERE fk_iddate = ' . $id;
	$resql 	= $this->db->query($sql);
	
		if (!$resql) {

			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {

			$this->db->commit();
			//die($sql);
			//$this->deletedecopmte($id);
			return 1;
		}
	}

public function findAll()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

$sql = 'SELECT id , datec';


$sql.= ' FROM '. MAIN_DB_PREFIX .'date' ;


	$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
					$line->id 				 = $obj->id;
					$line->datec 			 = $obj->datec;
				
					$this->rows[] = $line;
				}
				return $this->rows;
			}
			return false;
		}
		return false;
	}

public function fetchdatedetail($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'datedetail';
		
			$sql .= ' WHERE id = ' . $id;
		

		$resql = $this->db->query($sql);
		//die($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->id 				 = $obj->id;
				$this->engin			 = $obj->engin;
				$this->chantier 			 = $obj->chantier;
				$this->nombreheur 		 	 = $obj->nombreheur;
				$this->rendement1			 = $obj->rendement1;
				$this->rendement2 			 = $obj->rendement2;
				$this->observation 		 	 = $obj->observation;
				$this->fk_iddate 		 	 = $obj->fk_iddate;

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
public function fetchdat($id, $ref = null){

$sql = 'SELECT  d.id as id  ,d.datec , de.engin, de.chantier, de.rendement1, de.rendement2 ,de.observation,de.fk_iddate ,de.id as iddatedetail';

$sql.= ' FROM '. MAIN_DB_PREFIX .'date as d, ' . MAIN_DB_PREFIX .'datedetail as de ' ;


	if (null !== $ref) {
			$sql .= '  WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE d.id = ' . $id;
		}
$sql.= ' AND  de.fk_iddate  = d.id ';



	$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
					$line->iddatedetail 				 = $obj->iddatedetail;
					$line->id 				 = $obj->id;
					$line->datec 				 = $obj->datec;
					$line->engin 			 = $obj->engin;
					$line->chantier 			 = $obj->chantier;
					$line->rendement1 		 = $obj->rendement1;
					$line->datec 				 = $obj->rendement2;
					$line->engin 			 = $obj->observation;
				
					$this->rows[] = $line;
				}
				return $this->rows;
			}
			return false;
		}
		return false;
	}

   public function datenull($date)
{
	  if ($date=="" ) {

		        	$this->error 	= 'Error ' . "Saisir la Date  ";
					return $this->error; 
     
              

		                } 
       
}


	public function fetchiddate($datec)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

	
		$sql = 'SELECT id FROM ' . MAIN_DB_PREFIX . 'date';
			$sql .= ' WHERE datec = ' . $datec;


		//die($sql);
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
		$this->id 				 = $obj->id;
						
	


			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

public function findNomconstruction($id)
{
$sql = 'SELECT name ,rowid ';
$sql.= ' FROM '. MAIN_DB_PREFIX .'construction_site' ;
$sql.= ' WHERE market_id = ' . $id;
$result = array();
$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$result[$obj->rowid] = $obj->name;
				}
				
			}
		}
		return $result;
}
public function findNumconstruct($id)
{
$sql = 'SELECT name ,rowid ';
$sql.= ' FROM '. MAIN_DB_PREFIX .'construction_site' ;
$sql.= ' WHERE market_id = ' . $id;

$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
									$line->id 			 = $obj->rowid;

					$line->name 			 = $obj->name;
				


					$this->rows[] = $line;
				}
				return $this->rows;
			}
			return false;
		}
		return false;
}




}

?>