<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/construction_site_arrangement/index.php
 * \ingroup    list
 * \brief      List of construction site arrangement
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site_arrangement/class/construction_site_arrangement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

$var 	= false;
$filter = '';
$types_const_site_diposalss = array(1 => 'Entree', 2 =>'Sortie');
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action	  	 = GETPOST('action');
$id 	  	 = GETPOST('id','int');
$cid 	  	 = GETPOST('cid','int');

if (!$cid)
	die('ID chantier n\'existe pas!');

$form 				 		 = new Form($db);
$constructionSiteArrangement = new ConstructionSiteArrangement($db);
$constructionSite   		 = new ConstructionSite($db);
$market   		 			 = new Market($db);
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_num  				= GETPOST('search_num');
$search_const_site_destin   = GETPOST('search_const_site_destin');
$search_const_site_sender   = GETPOST('search_const_site_sender');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_num      		  = '';
	$search_datec      		  = '';
	$search_const_site_destin = '';
	$search_const_site_sender = '';
}

/*if (isset($_POST['search_datec']) && !empty($_POST['search_datec'])) {
    $search_datec = Tools::convertDateTo(trim($_POST['search_datec']), 'sql');
	$filter .= " AND datec = '". $db->escape($search_datec)."'";
}*/
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = ".$db->escape($search_num):"";
$filter .= (!empty($search_const_site_destin) && $search_const_site_destin != -1) ? " AND const_site_destin_id = ".$db->escape($search_const_site_destin) : "";
$filter .= (!empty($search_const_site_sender) && $search_const_site_destin != -1) ? " AND const_site_sender_id = ".$db->escape($search_const_site_sender) : "";

$getconst_site_diposalss = $constructionSiteArrangement->fetchAll($cid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconst_site_diposalss == '-1') {
    print_fiche_titre($langs->trans('ListOfconst_site_diposals'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$constructionSiteArrangement->error);
    exit();
}

// Both test are required to be compatible with all browsers
$morejs  = array("/btp/js/btp.js");
$morecss = array();
llxHeader('', $langs->trans('const_site_diposals'),'','','','',$morejs,$morecss,0,0);

// Fetch both market and construction site
$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);

if ($id > 0) {
	$constructionSiteArrangement->fetch($id);
	
	print_barre_liste($langs->trans("const_site_diposals"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu');

	$head = market_construction_site_arrangement_prepare_head($constructionSiteArrangement);
	dol_fiche_head($head, '', $langs->trans("ListOfconst_diposals_affect"), 0, 'submunu1');

	$constructionSite->fetch($constructionSiteArrangement->const_site_destin_id);

	print '<table class="border" width="100%">';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
	print '<td colspan="2">'. $constructionSiteArrangement->num .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($constructionSiteArrangement->datec,'day') .'</td></tr>';
	// chantier destinataire
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_destin").'</td>';
	print '<td colspan="2">'. $constructionSite->getNomUrl(1, $constructionSiteArrangement->const_site_destin_id, $constructionSite->name, $market->id) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?action=delete&cid='. $cid .'&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
	print '<a href="./index.php?cid='. $cid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?cid='. $cid .'&action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '</div>';

	if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&cid=".$cid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("const_site_diposals"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head = market_prepare_head($market);
	dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

	$head = market_construction_site_prepare_head($constructionSite);
	dol_fiche_head($head, 'construction_site_arrangement', $langs->trans("const_site_diposals"), 0, 'submunu2');

	$moreparam = '&cid='.$cid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="cid" value="'. $cid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("num"),$_SERVER["PHP_SELF"],"num", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("const_site_destin"), $_SERVER["PHP_SELF"], 'const_site_destin_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_num" value="'.$search_num.'">';
	print '</td>';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec" readonly="readonly" /> ';
    print '</td>';
	// const_site_destin
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site_destin', $constructionSite->getNames($constructionSite->market_id, $cid), $search_const_site_destin, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($constructionSiteArrangement->rows)) {
		$constructionSiteStratic = new ConstructionSite($db);
		
		foreach($constructionSiteArrangement->rows as $obj) {
  		    $num			= $obj->num ;
  		    $datec 			= dol_print_date($obj->datec,'day') ;
  		    $const_site_id 	= $obj->const_site_destin_id;
  		    $constructionSiteStratic->fetch($const_site_id);

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $constructionSiteArrangement->getNomUrl(1,  $obj->id, $num, $cid);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $constructionSiteStratic->getNomUrl(1, $const_site_id, $constructionSiteStratic->name, $constructionSiteStratic->market_id) .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			// print '<a href="./card.php?action=delete&id='. $obj->id .'">'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=add&cid='. $cid .'" class="butAction">'.$langs->trans('Addconst_site_diposals').'</a>';
	print '</div>';
}

llxFooter();

$db->close();


?>