<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches//index.php
 * \ingroup    list
 * \brief      List of delays
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/delaymanagement/class/delaymanagement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/delaymanagement/class/exceedingdelay.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/executions/class/execution.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) $socid=$user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$mid)
	die("ID marche n'existe pas!");

$search_ref      			= GETPOST('search_ref');
$search_created_by      	= (int) GETPOST('search_created_by');
$search_start_date    		= GETPOST('search_start_date');
$search_resumption_date		= GETPOST('search_resumption_date');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   			= "";
	$search_created_by 		= "";
    $search_start_date  	= "";
	$search_resumption_date	= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new DelayManagement($db);
$fuser 	 = new User($db);
$marche  = new Market($db);

if ($id) {
	$object->fetch($id);
    $param 		= '&mid='. $mid;
	$upload_dir = $conf->btp->dir_output.'/delaymanagement/'.$object->id;
	$modulepart = 'btp';
	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_pre_headers.tpl.php';
}

llxHeader(array(), $langs->trans('DelayManagement'), '', '', '', '', array('/btp/js/marches.js','/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref) ."'" : "";

if (isset($search_start_date) && !empty($search_start_date)) {
	list($sd, $sm, $sy)  = explode("/", $search_start_date);
	$filter .=  " AND start_date = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}
if (isset($search_resumption_date) && !empty($search_resumption_date)) {
	list($ed, $em, $ey)  = explode("/", $search_resumption_date);
	$filter .=  " AND resumption_date = '". $db->escape($ey.'-'.$em.'-'.$ed) ."'";
}

$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ". $db->escape($search_created_by) : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getDelayManagement = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getDelayManagement == '-1') {
    print_fiche_titre($langs->trans('DelayManagement'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);
$marche->fetch($mid);
print_fiche_titre($langs->trans('DelayManagementDetail'), '', 'title_project.png'); 

if ($id > 0) {
	$object->fetch($id);
	$title = $langs->trans("ExecutionFile");
	$head  = market_prepare_head($marche);
	dol_fiche_head($head, 'execution', $title, 0, '');

	$head_btm = phase_execution_prepare_head($marche);
	dol_fiche_head($head_btm, 'delaymanagement', $langs->trans("DelayManagementDetail"), 0, 'submunu1');
	echo $marche->getMarketHeader($mid, true);

	$fuser->fetch($object->fk_created_by);

	$ref				= $object->ref ?: '';
	$start_date			= $object->start_date ? dol_print_date($object->start_date,'day') : '';
	$resumption_date	= $object->resumption_date ? dol_print_date($object->resumption_date,'day') : '';
	$created_at 		= $object->created_at ? dol_print_date($object->created_at,'dayhoursec') : '';

	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. $created_at .'</td></tr>';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'. $ref .'</td></tr>';
	// Start date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("StoppedDate").'</td>';
	print '<td colspan="2">'. $start_date .'</td></tr>';
	// End date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ResumptionDate").'</td>';
	print '<td colspan="2">'. $resumption_date .'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	//if ($user->id && $user->rights->marches->write_all) {
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
	//}
	print '</div>';
	$modulepart = 'btp';
    $permission = $user->rights->marches->write;
    $param 		            = '&mid='. $mid;
    $relativepathwithnofile = '/delaymanagement/'.$object->id.'/';

    include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_post_headers.tpl.php';
}
else {
	$head  = market_prepare_head($marche);
	dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

	$head_btm = phase_execution_prepare_head($marche);
	dol_fiche_head($head_btm, 'delaymanagement', $langs->trans("DelayManagementDetail"), 0, 'submunu1');
	echo $marche->getMarketHeader($mid, true);
	$moreparam = '&mid='.$mid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "id", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("StoppedDate"), $_SERVER["PHP_SELF"], 'start_date', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ResumptionDate"),$_SERVER["PHP_SELF"], 'resumption_date', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("totalDays"), '','','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("AttachedFile"), '','','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center" width="50">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

	// UTILISATEUR
	/*if ($user->rights->marches->write_all) {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
	    print '</td>';
	}
	//else {*/
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($user->id,"search_created_by",1,"",1,'','',0,32);
	    print '</td>';
	//}

	// Start Date
	print '<td class="liste_titre" align="center"><input class="datepicker" autocomplete="off"  type="text" size="14" name="search_start_date" value="'.$search_start_date.'"></td>';
	// Resumption Date
	print '<td class="liste_titre" align="center"><input class="datepicker" autocomplete="off"  type="text" size="14" name="search_resumption_date" value="'.$search_resumption_date.'"></td>';
	// Statut
	print '<td class="liste_titre" align="center">&nbsp;</td>';
	print '<td class="liste_titre" align="center">&nbsp;</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		$totalDaysTillNow   = 0;
		$totalDelays 	    = 0;
		$totalMarketDays    = 0;
		$totalExceedingDays = 0;
		$execution = new Executions($db);
		$execution->fetch(0, $mid);
		$finisheMarketdate = $marche->finished_date ? dol_print_date($marche->finished_date, 'dayrfc') : null;
		
		if ($execution->id && $execution->start_date && $execution->months) {
			$execution_end_date = Tools::getEndDatFromDays(dol_print_date($execution->start_date, 'dayrfc'), $execution->months, $execution->days);
			if ($execution_end_date) {
				$totalMarketDays = Tools::getDiffOfDates(dol_print_date($execution->start_date, 'dayrfc'), $execution_end_date->format('Y-m-d'));
			}
			$totalDaysTillNow   = Tools::getTotalDaysTillEnd(dol_print_date($execution->start_date, 'dayrfc'), $execution_end_date->format('Y-m-d'));

			$totalExceedingDays = Tools::checkPeriodExceeding($execution_end_date, $finisheMarketdate);
			if (false === $totalExceedingDays)
				$totalExceedingDays = 0;
		}

		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_created_by));
			$ref 			= $line->ref;
			$start_date		= $line->start_date ? dol_print_date($line->start_date,'day') : '';
			$resumption_date= $line->resumption_date ? dol_print_date($line->resumption_date,'day') : '';
			$created_at 	= $line->created_at ? dol_print_date($line->created_at,'dayhoursec') : 0;
			$totalDaysSpent =  Tools::getDiffOfDates(dol_print_date($line->start_date, 'dayrfc'), dol_print_date($line->resumption_date, 'dayrfc'));
			$hasFiles 		= count($object->getDelayFilesById($line->id)) ? $langs->trans('Yes') : $langs->trans('No');

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $object->getNomUrl(1,  $line->id, $line->ref, $mid);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl('1') .'</td>';
			print '<td align="center">'. $start_date .'</td>';
			print '<td align="center">'. $resumption_date .'</td>';
			print '<td align="center">'.  $totalDaysSpent .' '. $langs->trans('Days') .'</td>';
			print '<td align="center">'. $hasFiles .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
			$totalDelays += $totalDaysSpent;
		}

		$elapsed = ($totalDaysTillNow-$totalDelays);

		print '<tr><td colspan="6">&nbsp;</td></tr>';
		print '<tr><td colspan="6">&nbsp;</td></tr>';
		print '<tr '.$bc[false].'>';
		print '<td align="left" width="25%">'. $langs->trans('RealEndDate') .':</td>';
		print '<td colspan="5">'. ($marche->finished_date ? dol_print_date($marche->finished_date, 'day') : '') .'</td>';
		print '</tr>';
		print '<tr '.$bc[false].'>';
		print '<td align="left" width="25%">'. $langs->trans('TotalMarkeyPeriod') .':</td>';
		print '<td colspan="5">'. $totalMarketDays .' '. $langs->trans('Days') .'</td>';
		print '</tr>';
		print '<tr '.$bc[false].'>';
		print '<td align="left">'. $langs->trans('TotalDelay') .':</td>';
		print '<td colspan="5">'. $elapsed .' '. $langs->trans('Days') .'</td>';
		print '</tr>';
		print '<tr '.$bc[false].'>';
		print '<td align="left">'. $langs->trans('NumOfStopDays') .':</td>';
		print '<td colspan="5">'. $totalDelays .' '. $langs->trans('Days') .'</td>';
		print '</tr>';
		print '<tr '.$bc[true].'>';
		print '<td align="left">'. $langs->trans('TotalDelayRemained') .':</td>';
		print '<td colspan="5">'. ($totalMarketDays-$elapsed) .' '. $langs->trans('Days') .'</td>';
		print '</tr>';
		print '<tr '.$bc[false].'>';
		print '<td align="left">'. $langs->trans('TotalDelayOver') .':</td>';
		print '<td colspan="5">'. $totalExceedingDays .' '. $langs->trans('Days') .'</td>';
		print '</tr>';
	} else {
		print '<tr>';
	    print '<td colspan="6" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	if ($user->id /*&& $user->rights->marches->write*/) {
		$exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<br>';
		print '<div style="float: left; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('Add').'</a>';
		print '- Dépassement délai du marché: <span class="'. $exceedingCls .'">'. ($totalExceedingDays ? $langs->trans('Yes') : $langs->trans('No')) .'</span>';
	
		if ($totalExceedingDays) {
			$exceedindDelay = new ExceedingDelay($db);
			$exceedindDelay->fetch(0, $mid);

			if ($exid = $exceedindDelay->id) {
				// add link to view exceeding delay info
				print '<a href="./exceedingdelay.php?mid='. $mid .'&id='. $exid .'" class="butAction">'.$langs->trans('ExceedingFile').'</a>';
			} else {
				print '<a href="./exceedingdelay.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('CreateExceedingFile').'</a>';
			}
		}
		print '</div>';
	}

}

llxFooter();

$db->close();

?>