<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       tools/index.php
 * \ingroup    list
 * \brief      List of tools
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/sous_traitance/class/sous_traitance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/devisfacture/class/devisfacture.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/bon_avance/class/bon_avance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/bon_avance/class/date_bonde_avance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/sous_traitance/class/sous_traitance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

$form 		= new Form($db);
$object 	  = new devisfacture($db);
$formChild      = new Form($db);
$sous_traitance=new sous_traitance($db);
// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action   = GETPOST('action','alpha');
$soustr_id 	  = GETPOST('soustr_id','int');
$id	  = GETPOST('id','int');

$search_ref = GETPOST('search_ref');
$serch_montant = GETPOST('serch_montant');
$serch_num = GETPOST('serch_num');
$search_stdate = GETPOST('search_stdate');



 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
		$search_ref= "";
		$serch_montant = "";
		$serch_num= "";
		$search_stdate= "";
}
$sous_traitance->fetch($soustr_id);
$filter='';
if($search_stdate){
list($etdd, $etmm, $etyy) = explode("/", $search_stdate);

$search_stdate=$etyy.'-'.$etmm.'-'.$etdd ;    
}
$filter="";

$filter.= (!empty($search_stdate) && $search_stdate!=-1)?" and datec= '".$db->escape($search_stdate)."'":"";


$filter.= (!empty($serch_montant) && $serch_montant!=-1)?" and montant ='".$db->escape($serch_montant)."'":"";

$filter.= (!empty($serch_num) && $serch_num!=-1)?" and numero ='".$db->escape($serch_num)."'":"";
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";

$object->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $soustr_id);


if ($id) {
	$object->fetch($id);
    $param 		            = '&soustr_id='. $soustr_id;
	$upload_dir = $conf->btp->dir_output.'/devisfacture/'.$id;
	$modulepart = 'btp';

	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_pre_headers.tpl.php';
}
llxHeader(array(),'','','','','',array('/btp/js/btp.js'));
print_barre_liste($langs->trans("DF"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
$head  = soustraitance_prepare_head($sous_traitance);
dol_fiche_head($head, 'devis', $langs->trans("DF"), 0, '');
echo $sous_traitance->getTraitanceHeader($soustr_id);

if ($id > 0 && $soustr_id>0 ) {
//$object 	  = new devisfacture($db);

 $object->fetch($id);
   print_barre_liste($langs->trans("infoDF"), '', '', '', '', '', "", "", "", '');  
	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Numéro").'</td>';
	print '<td colspan="2">'.$object->numero .'</td></tr>';
	// Created By
	print '<tr><td width="" class="fieldrequired">'.$langs->trans("Montant").'</td>';
	print '<td colspan="2">'.$object->montant .'</td></tr>';
	// Created By
	print '<tr><td width="" class="fieldrequired">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'.dol_print_date($object->datec,'day').'</td></tr>';

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?soustr_id='. $soustr_id .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	//if ($user->id && $user->rights->groupements->write_all) {
		print '<a href="./card.php?action=edit&id='. $id .'&soustr_id='. $soustr_id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	//}
	print '</div>';

	$modulepart = 'btp';
    $permission = $user->rights->btp->write;
    $param 		            = '&soustr_id='. $soustr_id;


    $relativepathwithnofile = '/devisfacture/'.$id.'/';

    include_once DOL_DOCUMENT_ROOT . '/btp/core/tpl/document_actions_post_headers.tpl.php';

}


else {
   print_barre_liste($langs->trans("infoDF"), '', '', '', '', '', "", "", "", '');  

    $moreparam = '&soustr_id='.$soustr_id;
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Numéro"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Montant"),$_SERVER["PHP_SELF"],"datev", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Date"),$_SERVER["PHP_SELF"],"designation", '',$moreparam,'align="center"',$sortfield,$sortorder);

	print_liste_field_titre('',$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	// print_liste_field_titre('',$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);


	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" >';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '<input class="flat" size="14" type="hidden" name="soustr_id" value="'.$soustr_id.'">';
	print '</td>';
	print '<td class="liste_titre" align="left" >';
    print '<input class="flat" type="text" size="14" name="serch_num" value="'.$serch_num.'">';
	print '</td>';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	   print '<input class="flat" type="text" size="14" name="serch_montant" value="'.$serch_montant.'">';
	print '</td>';
	print '<td class="liste_titre" colspan="1"  align="center">';
	print '<input class="flat datepicker" autocomplete="off"  type="text"  name="search_stdate" value="'.$search_stdate.'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";
	// Lines
	if (count($object->rows)) {
			foreach($object->rows as $line) {
			$var = !$var;

			$rowid 				= $line->id;
			$numero 		        = $line->numero;
			$montant 		        = $line->montant;

			$date=dol_print_date($line->datec,'day');
		
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
			
				print $object->getNomUrl(1,  $line->id,$soustr_id, $rowid);
			print '</td>';
			//date
			print '<td align="center">'. $numero .'</td>';
			
		
			print '<td align="center">'. $montant .'</td>';	
			print '<td align="center">'. $date .'</td>';
			print '<td align="center"></td>';
			
         print '</tr>'."\n";
		}
		

	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
		print '<br>';
		$ab="jk";
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&soustr_id='.$soustr_id.'" class="butAction">'.$langs->trans('AddDF').'</a>';
		print '</div>';
}
llxFooter();

$db->close();


?>
