<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/demandes/index.php
 * \ingroup    list
 * \brief      List of delays
 */
require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');

require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/groupement/demandes/class/demandes.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/groupement/class/groupement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btpgroupement.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT .'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) $socid=$user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$type 	  = GETPOST('type','int');
$gid 	  = GETPOST('gid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$types	=[1=>'provisional',2=>'final',3=>'backGrante'];
/*
$confirm  = GETPOST('confirm', 'alpha');*/

/*if (!$gid)
	die("ID marche n'existe pas!");*/

if (empty($type)) {
	        $type = 1;
	    }
$search_ref      	= GETPOST('search_ref');
$search_created_for  = (int) GETPOST('search_created_for');
$search_datec   = GETPOST('search_datec');
$search_dates   = GETPOST('search_dates');
$search_amount		= GETPOST('search_amount');
$search_compte   = GETPOST('search_compte');


 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   		= "";
	$search_created_for 	= "";
    $search_datec  	= "";
	$search_amount		= "";
	$search_dates  	= "";
	$search_compte  	= "";
	
}

$object  = new Demande($db);
$socstatic 	= new Societe($db);
$fuser 	 = new User($db);
$groupement 	 = new groupement($db);
$marche  = new Market($db);
$form 	 = new FormChild($db);
$account = new Account($db);
$groupement->fetchgroup($gid);
$marche->fetch($groupement->idmarche);

// Filter
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND rowid = '". $db->escape($search_ref) ."'\n" : "";
$filter .= (!empty($search_amount)) ? " AND amount = '". $db->escape($search_amount) ."'\n" : "";
$filter .= (!empty($search_compte) && $search_compte != -1) ? " AND compte_id = '". $db->escape($search_compte) ."'\n" : "";

if (isset($search_datec) && !empty($search_datec)) {
	list($sd, $sm, $sy)  = explode("/", $search_datec);
	$filter .=  " AND datec = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}
if (isset($search_dates) && !empty($search_dates)) {
	list($sd, $sm, $sy)  = explode("/", $search_dates);
	$filter .=  " AND dates = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}

$filter .= (!empty($search_created_for) && $search_created_for != -1) ? " AND fk_created_for = ". $db->escape($search_created_for) : "";
$filter .=' AND type ='.$type;
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id = $user->id;
$getdemandes = $object->fetchAll($gid, 'ASC', 'rowid', $conf->liste_limit + 1, $offset, $filter);

if ($action == 'pdf' && $gid && $id) {
	
	ob_get_clean();
	$object->fetch($id);
	$title = 'Demande de caution '.$langs->trans($types[$type]);
	require_once DOL_DOCUMENT_ROOT.'/btp/market/pdf/pdf-no-header.lib.php';
	$pdf->SetFont('times', '', 11, '', true);
	$pdf->AddPage();

	require_once dirname(__FILE__) ."/tpl/".$types[$type].".tpl.php";

	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
	$sit_file = 'Demande de caution '.$langs->trans($types[$type]).$marche->code.'-'. $marche->id .'.pdf';
	ob_end_clean();
	$pdf->Output($sit_file, 'I');
	die();
}


llxHeader(array(), $langs->trans('demandes'), '', '', '', '', array('/btp/js/marches.js', '/btp/js/payment.js'));
print_fiche_titre($langs->trans('demandes'), '', 'title_project.png'); 


// Si erreur SQL
if ($getdemandes == '-1') {
    print_fiche_titre($langs->trans('demandes'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);

if ($id > 0) {
	$object->fetch($id);
	$head  = groupement_prepare_head($groupement);
	dol_fiche_head($head, 'demandes', $langs->trans("demandes"), 0, '');

	$head_demande = groupement_demandes_prepare_head($groupement);
	dol_fiche_head($head_demande, $types[$type], $langs->trans($types[$type]), 0, '');

	//echo $marche->getMarketHeader($gid, true);

	$fuser->fetch($object->fk_created_by);
	$datec	 = $object->datec ? dol_print_date($object->datec,'day') : '';
	$ref		 = $object->ref ? $object->ref : '';
	$amount		 = $object->amount ? $object->amount : '';
	$created_at  = $object->created_at ? dol_print_date($object->created_at,'dayhoursec') : '';
	$dates= $object->dates ? dol_print_date($object->dates,'day') : '';
	
	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';
	// Created By
	print '<tr><td width="">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. $created_at .'</td></tr>';
	// Start date
	print '<tr><td width="" class="fieldrequired">'.$langs->trans("dateta").'</td>';
	print '<td colspan="2">'. $datec .'</td></tr>';
	// End date
	print '<tr><td width="" class="fieldrequired">'.$langs->trans("Amount").' (HT)</td>';
	print '<td colspan="2">'. $amount.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	
	
	if($type == 3)
        print '<tr><td class="fieldrequired">'.$langs->trans("dateBackGrante").'</td><td>';
        else
        print '<tr><td class="fieldrequired">'.$langs->trans("dates").'</td><td>';
    print ''.$dates .'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?gid='. $gid .'&type='. $type .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	//if ($user->id && $user->rights->marches->write_all) {
		print '<a href="./card.php?action=edit&id='. $id .'&gid='. $gid .'&type='. $type .'" class="butAction">'.$langs->trans('Modify').'</a>';
		//if ($user->rights->marches->delete)	{
    	print '<a href="./card.php?id='.$id.'&action=delete&gid='. $gid .'&type='. $type .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    //}
	//}
	print '</div>';

}
else {
	$head  = groupement_prepare_head($groupement);
	dol_fiche_head($head, 'demandes', $langs->trans("demandes"), 0, '');

	$head_demande = groupement_demandes_prepare_head($groupement);
	dol_fiche_head($head_demande, $types[$type], $langs->trans($types[$type]), 0, '');
	//echo $marche->getMarketHeader($gid, true);

	

   	$moreparam = 'gid='.$gid;
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="gid" value="'. $gid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	$display_non = 'style="display:none;"';
	print_liste_field_titre($langs->trans("Num"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("dateta"), $_SERVER["PHP_SELF"], 'datec', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("AmountHT"),$_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_ht_col ');
	if($type == 3)
	print_liste_field_titre($langs->trans("dateBackGrante"),$_SERVER["PHP_SELF"], 'dates', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_ttc_col ');
	else
	print_liste_field_titre($langs->trans("dates"),$_SERVER["PHP_SELF"], 'dates', '', $moreparam, 'align="center"', $sortfield, $sortorder, 'amount_ttc_col ');

	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center"></td>';

	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_datec" value="'.$search_datec.'" /></td>';

	
	print '<td class="liste_titre amount_ht_col" align="center"><input class="flat center" type="number" min="1" step="0.01" name="search_amount" value="'.$search_amount.'" /></td>';
	

	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_dates" value="'.$search_dates.'" /></td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {


		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_created_by));
			$datec		= $line->datec ? dol_print_date($line->datec,'day') : '';
			$dates		= $line->dates ? dol_print_date($line->dates,'day') : '';
			$amount 		= $line->amount;
			$tva 			= Tools::getTva($amount,$marche->tva);
			$amount_ttc 	= $tva['amount_ttc'];
			
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="170px">';
			print $object->getNomUrl(1,  $line->id, $line->id, $gid,$type);
			print '</td>';
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center" class="amount_ht_col">'. number_format($amount, 2).' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td align="center">'. $dates .'</td>';
			print '<td align="right" width="70px">';
			print '<a target="_blank" href="./index.php?action=pdf&gid='. $gid .'&type='. $type .'&id='.$line->id.'" >'. img_mime('test.pdf').'</a>';
			print '</td>';
			print '</tr>'."\n";
			$entrance++;
		}
	} else {
		print '<tr>';
	    print '<td colspan="5" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	if ($user->id /*&& $user->rights->marches->write*/) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&gid='. $gid .'&type='. $type .'" class="butAction">'.$langs->trans('Add').'</a>';
		print '</div>';
	}
}

llxFooter();

$db->close();

?>