<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/paymentmanagement/index.php
 * \ingroup    paymentmanagement
 * \brief      List of paymentmanagement
 */
require_once('../../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/groupement/paymentmanagement/class/paymentmanagement.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/groupement/class/groupement.class.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btpgroupement.lib.php';

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$gid 	 = GETPOST('gid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$groupement  = new groupement($db);

$groupement->fetchgroup($gid);

if (!$gid && $request_method !== 'POST')
	die('ID groupement n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new PaymentManagement($db);
$marche = new Market($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $billing_date= '';
	    $paid_date	= trim($_POST['paid_date']);
	    $ref 		= trim($_POST['ref']);
	    $amount 	= trim($_POST['amount']);
	    $pen_amount	= trim($_POST['pen_amount']);
	    $rev_amount	= trim($_POST['rev_amount']);
	    $rg_amount	= trim($_POST['rg_amount']);
	    $billing_num= trim($_POST['billing_num']);
	    $gid 		= trim(GETPOST('gid', 'int'));

	    if (!$gid || !$paid_date || !$amount)
			return;

		if (isset($paid_date) && !empty($paid_date)) {
	        list($etd, $etm, $ety) = explode("/", $paid_date);
	        $paid_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['billing_date']) && !empty($_POST['billing_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['billing_date']);
	        $billing_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $object->fk_created_by 	= $user->id;
	    $object->fk_groupement  	= $gid;
	    $object->ref 			= $ref;
	    $object->paid_date 		= $paid_date;
	    $object->amount 		= $amount;
	    $object->pen_amount		= $pen_amount;
	    $object->rev_amount		= $rev_amount;
	    $object->rg_amount		= $rg_amount;
	    $object->billing_num	= $billing_num;
	    $object->billing_date	= $billing_date;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&gid='.$gid);
		    die();
		} else {
			header('Location: ./index.php?gid='.$gid);
		    die();
		}
    //}
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['gid'] > 0 && $request_method === 'POST') {

	/* if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {*/
	    $billing_date= '';
	    $paid_date	= trim($_POST['paid_date']);
	    $ref 		= trim($_POST['ref']);
	    $amount 	= trim($_POST['amount']);
	    $pen_amount	= trim($_POST['pen_amount']);
	    $rev_amount	= trim($_POST['rev_amount']);
	    $rg_amount	= trim($_POST['rg_amount']);
	    $gid 		= trim(GETPOST('gid', 'int'));
	    $id 		= trim(GETPOST('id', 'int'));
	    $billing_num= trim($_POST['billing_num']);

	    if (!$gid || !$id || !$paid_date || !$amount)
			return;

		if (isset($paid_date) && !empty($paid_date)) {
	        list($etd, $etm, $ety) = explode("/", $paid_date);
	        $paid_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['billing_date']) && !empty($_POST['billing_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['billing_date']);
	        $billing_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
	    	'paid_date'  => $paid_date,
	    	'amount' 	 => $amount,
		    'ref' 		 => $ref,
		    'pen_amount' => $pen_amount,
		    'rev_amount' => $rev_amount,
		    'rg_amount' => $rg_amount,
		    'billing_num' => $billing_num,
		    'billing_date' => $billing_date
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&gid='.$gid);
	    die();
	//}

	$action = "edit";
}


$form = new Form($db);

llxHeader(array(), $langs->trans('PaymentManagement'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);
$marche->fetch($gid);
print_fiche_titre($langs->trans('PaymentManagement'), '', 'title_project.png'); 

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	/*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {*/
	
	/*	$head  = market_prepare_head($marche);
		dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

		$head_btm = phase_execution_prepare_head($marche);
		dol_fiche_head($head_btm, 'paymentmanagement', $langs->trans("PaymentManagementDetail"), 0, '');

		echo $marche->getMarketHeader();*/
$head  = groupement_prepare_head($groupement);
  dol_fiche_head($head, 'paymentmanagement', $langs->trans("PaymentManagement"), 0, '');

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="gid" value="'. $gid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("AttachNum").'</td><td>';
        print '<input type="text" class="" value="" name="ref" required="required" /></td></tr>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Date").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="paid_date" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("AttachAmount").' (HT)</td><td>';
        print '<input type="text" class="" value="" name="amount" required="required" /></td></tr>';

        print '<tr><td>'.$langs->trans("AmountPenalty").'</td><td>';
        print '<input type="text" class="" value="" name="pen_amount" /></td></tr>';

        print '<tr><td>'.$langs->trans("AmountRevision").'</td><td>';
        print '<input type="text" class="" value="" name="rev_amount" /></td></tr>';

        print '<tr><td>'.$langs->trans("rg_amount").'</td><td>';
        print '<input type="text" class="" value="" name="rg_amount" /></td></tr>';

        print '<tr><td>'.$langs->trans("BillingNum").'</td><td>';
        print '<input type="text" class="" value="" name="billing_num" /></td></tr>';

        print '<tr><td>'.$langs->trans("BillingDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="billing_date" /></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreatePayment") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    //}
} else {
	if ($id > 0 && $gid > 0) {
		$object->fetch($id);


		/*$head  = market_prepare_head($marche);
		dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

		$head_btm = phase_execution_prepare_head($marche);*/
		
		$canedit = true;/*($user->rights->marches->delete || $user->rights->marches->write_all);*/

		if ($canedit) {
            if ($action == 'delete') {
                //if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?gid=".$gid."&id=".$id, $langs->trans("TitleDeletePayementM"),$langs->trans("ConfirmDeletePayementM"),"confirm_delete", '', 0, 1);
                //}
            }

			if ($action == 'edit' || $action == 'delete') {
				//echo $marche->getMarketHeader();
                 $head  = groupement_prepare_head($groupement);
 
dol_fiche_head($head, 'paymentmanagement', $langs->trans("PaymentManagementDetail"), 0, '');

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="gid" value="'. $gid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$paid_date	 = $object->paid_date ? dol_print_date($object->paid_date,'day') : '';
				$ref		 = $object->ref ? $object->ref : '';
				$amount		 = $object->amount ? $object->amount : '';
				$pen_amount  = $object->pen_amount ? $object->pen_amount : '';
				$rev_amount	 = $object->rev_amount ? $object->rev_amount : '';
				$rg_amount	 = $object->rg_amount ? $object->rg_amount : '';
				$billing_num = $object->billing_num ? $object->billing_num : '';
				$billing_date= $object->billing_date ? dol_print_date($object->billing_date,'day') : '';
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

			   	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("AttachNum").'</td><td>';
		        print '<input type="text" class="" value="'. $ref .'" name="ref" required="required" /></td></tr>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Date").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $paid_date .'" name="paid_date" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("AttachAmount").' (HT)</td><td>';
		        print '<input type="text" class="" value="'. $amount .'" name="amount" required="required" /></td></tr>';

		        print '<tr><td>'.$langs->trans("AmountPenalty").'</td><td>';
		        print '<input type="text" class="" value="'. $pen_amount .'" name="pen_amount" /></td></tr>';

		        print '<tr><td>'.$langs->trans("AmountRevision").'</td><td>';
		        print '<input type="text" class="" value="'. $rev_amount .'" name="rev_amount" /></td></tr>';

		        print '<tr><td>'.$langs->trans("AmountRevision").'</td><td>';
		        print '<input type="text" class="" value="'. $rg_amount .'" name="rg_amount" /></td></tr>';

		        print '<tr><td>'.$langs->trans("BillingNum").'</td><td>';
		        print '<input type="text" class="" value="'. $billing_num .'" name="billing_num" /></td></tr>';

		        print '<tr><td>'.$langs->trans("BillingDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $billing_date .'" name="billing_date" /></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    //if ($user->rights->marches->delete)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete&gid='. $gid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    //}
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
