
<?php
/* Copyright (C) 2005		Rodolphe Quiedeville 	<rodolphe@quiedeville.org>
 * Copyright (C) 2004-2013	Laurent Destailleur  	<eldy@users.sourceforge.net>
 * Copyright (C) 2005-2010	Regis Houssin        	<regis.houssin@capnetworks.com>
 * Copyright (C) 2010     	François Legastelois 	<flegastelois@teclib.com>
 * Copyright (C) 2014-2015	charlie BENKE			<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file       /management/projet/listtime.php
 *	\ingroup    projet
 *	\brief      List activities of tasks
 */

$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/project.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/imputationchantier/class/imputationchantier.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/management/core/lib/management.lib.php';


require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';

// load css theme.css ici 
$langs->load('btp@btp');

$langs->load('management@management');
$action=GETPOST('action');
$mode=GETPOST("mode");
$id=GETPOST('id','int');
$mid 	 = GETPOST('mid', 'int');
$periodyears=GETPOST('periodyears','int');
if (!$periodyears)
	$periodyears=date('Y');

$periodmonths=GETPOST('periodmonths','int');
if (!$periodmonths)
	$periodmonths=date('m');

	
// récupération du nombre de jour dans le mois
$time = mktime(0, 0, 0, $periodmonths+1, 1, $periodyears); // premier jour du mois suivant
$time--; // Recule d'une seconde
$nbdaymonth=date('d', $time); // on récupère le dernier jour

$form=new Form($db);
$formother = new FormOther($db);
$imputationchantier= new imputationchantier($db);
$user_array=new User($db);
// $chantier = new Project($db);


$marketBoard 	  = new Market($db);
$chantier = new ConstructionSite($db);

if (!$mid)
	$mid = $marketBoard->getLasInsrtedId();
/*
 * Actions
 */


/*
 * View
 */
$title=$langs->trans("consulte");
if (!empty($periodmonths) && !empty($periodyears) && $action == "xsl" ) {
$filename="liste_imputationchantier.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/rh/imputationchantier/tpl/imputationchantier_exl.php';
 die();
 
}
llxHeader("",$title,"");
print_barre_liste($title, $page, $_SERVER["PHP_SELF"], "", $sortfield, $sortorder, "", $num);
dol_htmloutput_mesg($mesg);
?>
<script language="javascript">
$(document).ready(function() {
	$("#srch_marche_id").select2();
	$('form select#srch_marche_id').on('change', function(){
	    $("#namemid").val($(this).val());
	    $(this).closest('form').submit();
	});	
});
$(window).on('load',function(){
var side = ($("#id-container .side-nav").width() + 3);
var all = $("#id-container").width();
// console.log(all-side);
$("#id-right").css({
    width : (all-side)+'px',
    opacity: 1
});
});
</script>
<?php
// 
print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input type="hidden" id="namemid" name="mid" value="'. $mid .'" />';
print "<div id='select_market'>&nbsp;Choisir un marché : ".$form->selectarray('srch_marche_id', $marketBoard->getNames2(true), $mid, 0, 0, 0, '')."</div><br><hr>";
print "</form>";
print '<form name="selectperiod" method="POST" action="'.$_SERVER["PHP_SELF"].'?id='.$chantier->id.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="selectperiod">';

print '<table  width="">';
print '<tr >';
print '<td>'.$langs->trans("PeriodAAAAMM").'</td>';
print '<td>'.$formother->selectyear($periodyears,'periodyears').$formother->select_month($periodmonths,'periodmonths').'</td>';
print '<td ><input type=submit align="center" name="select" value="'.$langs->trans("Select").'"></td>';
print '<td style="    min-width: 50px;"></td>';
print '<td><div id="lblBlurWeekEnd">'.$langs->trans("ShowHideWeekend").'</div></td>';
print "</tr>\n";
print '<tr >';
$showempty=0;
// attention le dernier paramétre n'est dispo que sur la 3.7 et le patch fournis
print '<td></td><td></td>';
print "</tr>\n";
print "</table>";
print '</form>';
print '<div style="float: right; margin-bottom: 6px;">';
print '<a href="./listtime.php" class="butAction">'.$langs->trans('TimeSpentPeriod').'</a>';
print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="periodyears" value="'. $periodyears .'" type="hidden" />';
print '<input name="periodmonths" value="'. $periodmonths .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
print '</form>'."\n";
print '</div>';     
print '<div style="overflow: auto; width: 100%;" class="table_temps">';
print '<br>';
print '<table class="noborder" width="100%" >';
print '<tr class="liste_titre nc_filtrage_tr">';
print '<td  align="left" >'.$langs->trans("Names").'</td>';
print '<td  align="center">'.$langs->trans("Qualif").'</td>';

print '<td colspan="32" align="right"></td>';
// print '<td  align="center">'.$langs->trans("nbjour").'</td>';
print '<td  align="center">'.$langs->trans("nbHeurseup").'</td>';
// print '<td  align="center">'.$langs->trans("avance").'</td>';




print "</tr>\n";

timesheetLines($j,$imputationchantier->rows, $level, $chantiersrole, $tasksrole, $mine, $perioduser);

print "</table>";
print '</div>';
print '</form>';

// pour activer ou non le week-end
print '<script language="javascript">';
print '$(document).ready(function() {';
print '$(".weekendtohide").toggle();';
print '	$("#lblBlurWeekEnd").click(function() {';
print '		$(".weekendtohide").toggle();';
print '		$(".weekendtoshow").toggle();';
print '	});';
print '});';
print '</script>';
?>
<style type="text/css">
	.table_temps td input[type=text]{
		padding: 4px 0px;
	}
	td.user_list, td.user_job {
	    background: #f1f1f1;
	}
	td.titre_td, td.empty_td_list {
	    background: #f9f9f9;
	}
	body div.table_temps>table.noborder{
		font-size: 11px !important;
	}
	.table_temps td:not(.titre_td){white-space: nowrap;}
	.table_temps button[disabled], html input[disabled]{text-align: center;}
	#id-container .side-nav {
	    float: left !important;
	}
	#id-container {
	    display: block !important;
	}
	#select_market .select2-container {
	    max-width: 600px !important;
	}
	#id-right {
	    display: block !important;
	    opacity : 0;
	    float: left !important;
	}
	body .table_temps table.noborder td{
		padding: 1px .5em !important;
	}
	body .table_temps table.noborder td.existuser{
		padding: .5em !important;
	}
</style>
<?php
llxFooter();

$db->close();
/**
 * Output a task line
 *
 * @param	string	   	&$inc			?
 * @param   string		$parent			?
 * @param   Object		$lines			?
 * @param   int			&$level			?
 * @param   string		&$chantiersrole	?
 * @param   string		&$tasksrole		?
 * @param   int			$mytask			0 or 1 to enable only if task is a task i am affected to
 * @return  $inc
 */
function timesheetLines(&$inc,$lines, &$level, &$chantiersrole, &$tasksrole, $mytask=0, $perioduser='')
{
	global $user, $bc, $langs;
	global $form, $formother, $imputationchantier, $taskstatic;
	global $periodyears, $periodmonths, $nbdaymonth,$imputationchantier;
	global $lines;
	global $numlines,$user_array,$chantier,$mid;
	$filter="and year_point=".$periodyears;
	$filter.=" and month_point=".$periodmonths;
    $imputationchantier->fetchAll('','p.fk_user',0,0,$filter,"","",$mid);
    
	$lastprojectid=0;
	$var=true;
	$array=['','HS'];
    
    $numlines=count($array);
    $num=count($lines);

    if (count($imputationchantier->rows)) {

	 	$iduser = 0;
	 	foreach($imputationchantier->rows as $line) {
		   	$user_array->fetch($line->fk_user);
		   	$title = '';
		   	if($line->fk_chantier){
				$chantier->fetch($line->fk_chantier);
				if ($chantier->market_id != $mid)
					continue;
				$title =$chantier->getNomUrl(1,$chantier->rowid,$chantier->name,$mid);
			}

			for ($i = 0 ; $i <$numlines ; $i++){
	 			$nbr=0;

				if(empty($array[$i])){
					$clss = "";
					if ($line->fk_user != $iduser )
						$clss = "existuser";
					print '<td align="left" class="user_list '.$clss.'">';
					if ($line->fk_user != $iduser )
						print $user_array->getNomUrl($line->fk_user);
					print '<p style="margin-left:30px;margin: 0;"></p></td>';
					print '<td align="center" class="user_job">';
					if ($line->fk_user != $iduser )
						print $user_array->job;
					print '</td>';
				}else{
					if($array[$i]=='HS'){
						print '<tr>';
							print '<td colspan="2" class="titre_td" style="max-width: 270px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">'.$title.'</td>';
					}else{
						print '<tr>';
							print '<td colspan="2" class="empty_td_list"></td>';
					}
				}

		        for ($day=1;$day <= $nbdaymonth ;$day++)
				{ 

					$curday=mktime(0, 0, 0, $periodmonths, $day, $periodyears);
					$bgcolor="";
					if (date('N', $curday) == 6 || date('N', $curday) == 7){
						print '<td width=1px class=weekendtoshow bgcolor=grey ></td>';
						$bgcolor=" class=weekendtohide bgcolor=grey ";
					}

					if(empty($array[$i])){
						print '<td '.$bgcolor.' align=center>';
						if ($line->fk_user != $iduser )
						print substr($langs->trans(date('l', $curday)),0,1)." ".$day.'</td>';
					}else{
						print '<td '.$bgcolor.' align=center size="12">';
						// le nom du champs c'est à la fois le jour et l'id de la tache
						print '<input type=text id="inputday" name="'.$array[$i].'-'.$day.'-'.$line->fk_user.'"'; 
						//$timespent=fetchSumTimeSpent($taskstatic->id, $curday, $perioduser);
						$val=$imputationchantier->getVal($periodmonths,$periodyears,$line->fk_user,$array[$i],$day,$line->fk_chantier);
						$nbr=$nbr+$val;
						print ' value="'.$val.'"';
						print ' size=2 style="font-size:0.8em !important" disabled>';
						print '</td>';
					}
				}
				$pe=$nbdaymonth+1;
				for ($s=$pe; $s <=32 ; $s++) {
					print '<td></td>';
				}
				for ($com=1; $com <$i ; $com++) {
					if(!empty($array[$i])) 
						print '<td align="center"></td>';
				}

				if(!empty($array[$i]))
					print '<td align="center">'.$nbr.'</td>';

				// for ($c=$com; $c<3 ; $c++) {
				//    if(!empty($array[$i])) 
				// print '<td align="center"></td>';

				//  }
				PRINT'</tr>';
			}

			PRINT'</tr>';
			$iduser = $line->fk_user;
		}

	}else{

     	print '<tr>';
	    print '<td colspan="40" '.$bc[false].' align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
			

	return $inc;
}
?>

