<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market_oeuvrechantiers/class/market_oeuvrechantiers.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/imputationchantier/class/imputationchantier.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';


// Protection if external user
if (!$user) accessforbidden();

$var 		= false;
$filter 	= '';
$sortfield 	= GETPOST("sortfield",'alpha');
$sortorder 	= GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action	 = GETPOST('action');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id','int');

if (!$mid)
	die('ID marché n\'existe pas!');

$constructionSite = new ConstructionSite($db);
$MarketOeuvrechantiers = new MarketOeuvrechantiers($db);


$market 		  = new Market($db);
$fuser 			  = new User($db);
$form 			  = new Form($db);
$imputationchantier= new imputationchantier($db);

$search_oeuvrechantier      	= GETPOST('search_oeuvrechantier');
$search_amount      = GETPOST('search_amount');
$search_adress    	= GETPOST('search_adress');
$search_tel    		= GETPOST('search_tel');
$search_market    	= GETPOST('search_market');
$search_head_site   = GETPOST('search_head_site');
$search_pointer    	= GETPOST('search_pointer');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_oeuvrechantier      	= '';
	$filter      	= '';
}

// $filter .= (!empty($search_oeuvrechantier) && $search_oeuvrechantier != -1) ? " AND chantier_id = '". $db->escape($search_oeuvrechantier)."'\n" : "";
// $getmarket_oeuvrechantierss = $MarketOeuvrechantiers->fetchAll($mid, $sortorder, $sortfield, "", $offset, $filter);




$getconstraction_sites = $constructionSite->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
// Si erreur SQL
if ($getmarket_oeuvrechantierss == '-1') {
    print_fiche_titre($langs->trans('ListOfmarket_oeuvrechantiers'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$MarketOeuvrechantiers->error);
    exit();
}

llxHeader('', $langs->trans('market_oeuvrechantiers'));
$market->fetch($mid);

if ($id > 0) {
	$MarketOeuvrechantiers->fetch($id);

	print_barre_liste($langs->trans("market_oeuvrechantiers"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'Oeuvrechantiers', $langs->trans("Oeuvrechantiers"), 0, '');

	// $head = market_market_oeuvrechantiers_prepare_head($MarketOeuvrechantiers);
	// dol_fiche_head($head, '', $langs->trans("const_site_diposals"), 0, '');

	echo $market->getMarketHeader();

	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="">'.$langs->trans("Réf.").'</td>';
	print '<td colspan="2">';
	print $MarketOeuvrechantiers->id;
	print '</td></tr>';
	// Oeuvrechantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Oeuvrechantier").'</td>';
	print '<td colspan="2">';
	$oeuvrechantier->fetch($MarketOeuvrechantiers->chantier_id);
	print $oeuvrechantier->getNomUrl(1,  $MarketOeuvrechantiers->chantier_id,"","","");
	print '</td></tr>';
	
	print '</table>';
	// print '<br>';
	print '<div style="text-align: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a class="butAction" href="./index.php?action=delete&id='. $id .'&mid='. $mid .'">'.$langs->trans('Delete').'</a>';

	print '</div>';

    if ($action == 'delete')
		print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
}
else {
	print_barre_liste($langs->trans("market_oeuvrechantiers"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, '', 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'Main d\'œuvre', $langs->trans("Main d'œuvre"), 0, '');

	dol_fiche_head('', 'Main d\'œuvre', $langs->trans(""), 1, 'submunu');

	echo $market->getMarketHeader($mid);
	$moreparam = '&mid='.$mid;
	
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Chantier"),$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Nombre d’heures prévues"),$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Côut horaire moyen"),$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Total"),$_SERVER["PHP_SELF"],"", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	// print '<tr class="liste_titre nc_filtrage_tr">';

	// // rowid
	// print '<td class="liste_titre" colspan="1" align="center">';
	// print $MarketOeuvrechantiers->select_with_filter($search_oeuvrechantier,'search_oeuvrechantier',1,"rowid","facnumber","","",true);
	// print '</td>';

	// // nom oeuvrechantier
	// print '<td class="liste_titre" colspan="1" align="center">';
	// print $MarketOeuvrechantiers->select_with_filter($search_oeuvrechantier,'search_oeuvrechantier',1,"rowid","facnumber","","",true);
	// print '</td>';

	// // Montant TTC
	// print '<td class="liste_titre" colspan="1" align="left">';
	// print '</td>';

	// // ACTION
	// print '<td align="right" style="min-width:62px;">';
	// print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	// print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	// print '</td>';

	// print "</tr>\n";

	// Lines
	if (count($constructionSite->rows)) {
		//$createdBy = new User($db);
		$tot_ttc = 0;
		// print_r($constructionSite->rows);
		// die();
		$tot_tot = 0;
		$tot_ch = 0;
		$tot_heur = 0;

		foreach($constructionSite->rows as $obj) {
			$amount = $obj->amount ;
			$name 	= $obj->name ;
			$tot_cout_h = 0;
			if ($imputationchantier->getSommeImputationsHeures($obj->id) > 0) {
				print '<tr '.$bc[$var].'>';

				print '<td align="left" style ="white-space: nowrap;" class="nomchantierwidth">';
					print $constructionSite->getNomUrl(1,  $obj->id, $name, $obj->market_id);
				print '</td>';

				print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
				print $imputationchantier->getSommeImputationsHeures($obj->id);

				$tot_heur += $imputationchantier->getSommeImputationsHeures($obj->id);
				$tot_cout_h = $obj->couthorairechantier*$imputationchantier->getSommeImputationsHeures($obj->id);
				print '</td>';

				print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
				print number_format($obj->couthorairechantier,2,","," ");
				$tot_ch += $obj->couthorairechantier;
				print '</td>';

				print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
				print number_format($tot_cout_h,2,","," ");
				$tot_tot += $tot_cout_h;
				print '</td>';

				print '<td><div style="float: right; margin-top: 8px;">';
				// print '<a href="./index.php?action=delete&id='. $obj->id .'&mid='. $obj->market_id .'">'.$langs->trans('Delete').'</a>';
				print '</div></td>';

				print '</tr>'."\n";
			}

		}
		print '<tr class="liste_titre ">';
		print '<td align="center">';
		print "<b>Total</b>";
		print '</td>';
		print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
		print "<b>".number_format($tot_heur,2,","," ")."</b>";
		print '</td>';
		print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
		print "<b>".number_format($tot_ch,2,","," ")."</b>";
		print '</td>';
		print '<td align="center" style ="white-space: nowrap;" class="nomchantierwidth">';
		print "<b>".number_format($tot_tot,2,","," ")."</b>";
		print '</td>';
		print '<td><div style="float: right; margin-top: 8px;">';
		// print '<a href="./index.php?action=delete&id='. $obj->id .'&mid='. $obj->market_id .'">'.$langs->trans('Delete').'</a>';
		print '</div></td>';

		print '</tr>'."\n";
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	// print '<br>';
	// print '<div style="text-align: right; margin-top: 8px;">';
	// print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddMarketOeuvrechantiers').'</a>';
	// print '</div>';
}

llxFooter();

$db->close();


?>