<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/market.class.php
 * \ingroup market
 * \brief   This file is market CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';
// require_once DOL_DOCUMENT_ROOT.'/btp/executions/class/execution.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


/**
 * Class market
 *
 * Contract Management class
 */
class MetreHeaders extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see market::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'metre_headers';
	/**
	 * @var string Name of table without pref_marketix where object is stored
	 */
	public $table_element = 'metre_headers';

	/**
	 * @var int ID
	 */
	public $id;
	public $ref;
	public $fk_createdby;
	public $operation;
	public $block;
	public $level;
	public $statut;
	public $fk_metre;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	public $tender = array();
	public $approval = array();
	public $winner = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
			

		$this->fk_createdby = $this->fk_createdby ?: null;
		$this->fk_metre 	= $this->fk_metre ?: null;
		$this->created_at 	= $this->now;
		$this->level		= $this->level ? $this->db->escape($this->level) : '';
		$this->block	= $this->block ? $this->db->escape($this->block) : 0;
		$this->operation	= $this->operation ? $this->db->escape($this->operation) : 0;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_metre,fk_createdby,block, created_at, updated_at,level,operation) VALUES (';		
		$sql .= '"'.$this->fk_metre.'", '.$this->fk_createdby.', "'.$this->block.'", "'.$this->created_at.'", "'.$this->updated_at.'","'.$this->level.'", "'.$this->operation.'")';
          
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error = 'Error header ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id          Id object
	 * @param string $fk_tender   Tender ID
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id=null, $fk_metre = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		// $extras = 'm.*';
		// $fields = (null === $fk_tender ? $extras : '*');

		$sql = 'SELECT  * FROM ' . MAIN_DB_PREFIX . $this->table_element ;

		if (null !== $fk_metre) {
			$sql .= ' WHERE fk_metre = ' . (int)$fk_metre;
		} else {
			$sql .= ' WHERE  rowid = ' . (int)$id;
		}

		

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->id 				 = $obj->rowid;
				$this->fk_createdby 	 = $obj->fk_createdby;
				$this->level 		 = $obj->level;
				$this->block		 = $obj->block;
				$this->operation			 = $obj->operation;
				$this->updated_at 		 = $this->db->jdate($obj->updated_at);
				$this->created_at 		 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid,$sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		
		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_metre = '. $mid;
		} else {
			$sql .= ' WHERE fk_metre = '. $mid;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 	 = $obj->rowid;
				$line->fk_createdby 	 = $obj->fk_createdby;
				$line->subject 			 = $obj->subject;
				$line->operation			 = $obj->operation;
				$line->block 				 = $obj->block;
				$line->level 		 = $obj->level;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function countmarket($id)
	{
		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		$sql .= ' WHERE fk_tender = ' . $this->getAoId($id);

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$ids = array();

				while ($obj = $this->db->fetch_object($resql))
					$ids[] = $obj;
				
				return $ids;
			}

			$this->db->free($resql);

			return 0;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getAoId($id)
	{
		$sql = 'SELECT fk_tender FROM ' . MAIN_DB_PREFIX . $this->table_element;

		$sql .= ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				
				return $obj->fk_tender;
			}

			$this->db->free($resql);

			return 0;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function ismarketCadre($id)
	{
		$sql = 'SELECT a.type as atype FROM ' . MAIN_DB_PREFIX . $this->table_element .' as m INNER JOIN '. MAIN_DB_PREFIX .'tender as a ON (a.rowid = m.fk_tender) WHERE m.rowid = '. $id .' AND a.type = 2';

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				
				return true;
			}

			$this->db->free($resql);

			return false;
		} else {
			return false;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . (int)$id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	
	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id = null, $ref_market = null)
    {
        global $langs;

        $result	= '';
        $setRef	= '';

        $setRef = (null !== $ref_market) ? $ref_market : '';
        $id  	= ($id  ?: '');
        $subject  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/market/index.php?id='. $id .'" title="'.dol_escape_htmltag($subject, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($subject, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    public function getMarketHeader($mid = null, $start_date_market = false)
    {
    	global $langs;

		// echo $this->marketDropDown($this->id);
    	$amount = $this->final_amount ?: $this->init_amount;
    	$html = '<table class="border" width="100%">';
		$html .= '<tr><td width="25%">'.$langs->trans("Code").'</td>';
		$html .= '<td colspan="2">'. $this->code .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
		$html .= '<td colspan="2">'. $this->subject .'</td></tr>';
		$html .= '<tr><td width="25%">'.$langs->trans("MarketDate").'</td>';
		$html .= '<td colspan="2">'. dol_print_date($this->date_start, 'day') .'</td></tr>';
		$html .= '<tr><td width="25%" class="fieldrequired">'.$langs->trans("MarketAmount").'</td>';
		$html .= '<td colspan="2">'. number_format($amount, 2) .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

		/*if (false !== $start_date_market && null !== $mid) {
			$execution = new Executions($this->db);
			$execution->fetch(0, $mid);
			if ($execution->id) {
				$start_date	= $execution->start_date ? dol_print_date($execution->start_date, 'day') : '';
				$execution_end_date = Tools::getEndDatFromDays(dol_print_date($execution->start_date, 'dayrfc'), $execution->months, $execution->days);
				$html .= '<tr><td width="25%" class="fieldrequired">'. $langs->trans("CommenceDate") .'</td>';
				$html .= '<td colspan="2">'. $start_date .'</td></tr>';
				if ($execution_end_date) {
					$html .= '<tr><td width="25%" class="fieldrequired">'. $langs->trans("EndDate") .'</td>';
					$html .= '<td colspan="2">'. $execution_end_date->format('d/m/Y') .'</td></tr>';
				}
			}
		}*/

		$html .= '</table><br />';

		return $html;
    }

    public function marketDropDown($id)
    {
    	global $langs;

    	if (!$id)
    		return false;

    	$html = '';

    	if (false !== $this->ismarketCadre($id)) {
    		$id 	 = (int)$id;
    		$market = $this->countmarket($id);

    		if (count($market)) {
    			$html .= '<div class="pull-right" style="float:right;margin-bottom:10px;"><div>';
    			$html .= "<span>". $langs->trans('SelectMarketRange') .":</span> ";
    			  $html .= '<select id="market_cadres">';

	    			foreach ($market as $key => $market) {
	    				$selected = ($market->rowid == $id ? ' selected="selected"' : '');
	    				$subject 	  = Tools::trunc_words($market->subject);
	    				$ref_market= (!empty($market->ref_market) ? (strlen($market->ref_market) > 20 ? substr(trim(ucfirst($market->ref_market)), 0, 20) .'...' : trim(ucfirst($market->ref_market))) : '');
	    		  		$html .= '<option value="'. $market->rowid .'"'. $selected .'>'. ucfirst($ref_market) .' - '. $subject .'</option>';
	    			}

	    		  $html .= '</select></div>';
	    		$html .= "<div style='float: right;margin-right: 0px;margin-top: 10px;'><a class='button' href='". DOL_URL_ROOT ."/btp/market/card.php?mid=". $id ."&action=clone_market'>". $langs->trans('CreateMarketRange') ."</a></div>";
	    		$html .= '</div>';
	    		$html .= '<script type="text/javascript">
	    		  var marchObj = document.getElementById("market_cadres");
	    		  marchObj.addEventListener("change", function() {
	    		  	var marketId = this.options[marchObj.selectedIndex].value;
	    		  	document.location.href = "'. DOL_URL_ROOT .'/btp/market/index.php?id="+marketId;
	    		  });
	    		</script>';
    		}
    	}

    	return $html;
    }

    public function clonemarket($id, $user)
	{
		if (!$id)
			return false;

		$sql = 'SELECT a.ref as cloned_ref, a.subject as cloned_subject, m.fk_tender as cloned_ao, p.signature_date as cloned_signature_date, c.amount as cloned_amount_ht FROM '. MAIN_DB_PREFIX .'market as m INNER JOIN '. MAIN_DB_PREFIX .'tender as a INNER JOIN '. MAIN_DB_PREFIX .'m_approval as p INNER JOIN '. MAIN_DB_PREFIX .'m_competitors as c WHERE m.rowid = 1 AND (a.rowid = m.fk_tender AND a.rowid = p.fk_tender AND c.fk_tender = a.rowid) AND c.winner = 1';

		$resql = $this->db->query($sql);

		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				
				return $obj;
			}

			$this->db->free($resql);

			return false;
		} else {
			return false;
		}
	}

    public function statusLevel($statut)
	{
		global $langs;
		$status = '';
		
		switch ($statut) {
			case 0:
				return $langs->trans('Still').' '.img_picto($langs->trans('Still'), 'statut0');
				break;
			case 1:
			case 3:
				return $langs->trans('Archived').' '.img_picto($langs->trans('Archived'), 'statut5');
				break;
		}

		return false;
    }
}
