
<?php
/* Copyright (C) 2016
 *
 */

/**
 * \file       btp/market/work_supplies/index.php
 * \ingroup    list
 * \brief      List of work_supplies
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_metres/class/work_metres.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/metre_workparts/class/metre_workparts.class.php';
// Protection if external user
if (!$user) accessforbidden();
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$metre_id 	  = GETPOST('metre_id','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$metre_id)
	die("ID de metre n'existe pas!");

$search_ref       = GETPOST('search_ref');
$search_tache     = GETPOST('search_tache');
$search_num       = GETPOST('search_num');
$search_long 	  = GETPOST('search_long');
$search_larg      = GETPOST('search_larg');
$search_haut      = GETPOST('search_haut');
$search_epais		 = GETPOST('search_epais');
$search_fond		 = GETPOST('search_fond');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_create  = "";
	$search_ref   	= "";
	$search_num   = "";
	$search_tache   = "";
    $search_haut = "";
    $search_larg = "";
    $search_long = "";
    $search_haut = "";
    $search_epais = "";
    $search_fond = "";
}
$metre  = new MarketWorkMetres($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$object = new MetreWorkParts($db);

llxHeader(array(), $langs->trans('workpart'), '', '', '', '', array('/btp/js/btp.js'));
// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";
$filter .= (isset($search_num) && !empty($search_num)) ? " AND num = ". $db->escape((int)$search_num) : "";
$filter .= isset($search_long) && !empty($search_long) ? " AND length = '". $db->escape($search_long) ."'" : '';
$filter .= (!empty($search_larg) && $search_larg != -1) ? " AND  width= ". $db->escape((int)$search_larg) : "";
$filter .= (!empty($search_fond) && $search_fond != -1) ? " AND  depth= ". $db->escape((int)$search_fond) : "";
$filter .= (!empty($search_epais) && $search_epais != -1) ? " AND  thickness= ". $db->escape((int)$search_epais) : "";

$filter .= isset($search_tache) && !empty($search_tache) ? " AND task = '". $db->escape($search_tache) ."'" : '';
$filter .= isset($search_haut) && !empty($search_haut) ? " AND height = '". $db->escape($search_haut) ."'" : '';
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getworkpart = $object->fetchAll($metre_id, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getworkpart == '-1') {
    print_fiche_titre($langs->trans('Workparts'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}
// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);
// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);
if ($id > 0) {
	$object->fetch($id);
	$metre->fetch($metre_id);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);
	
	print_barre_liste($langs->trans("Workparts"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');
	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
	$work_Head  = market_works_metre_prepare_head($metre);
	dol_fiche_head($work_Head,'metre_workparts', $langs->trans("Workparts"), 0, 'submunu1');
	$fk_createdby	= $object->fk_createdby ? $object->fk_createdby : '';
	
		print '<table class="border" width="100%">';
        print '<tbody>';
        print '<tr><td>'.$langs->trans("task").'</td><td>';
        print $object->task.'</td></tr>';
        print '<tr><td>'.$langs->trans("num").'</td><td>';
        print $object->num.'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("lenght").'</td><td>';
        print $object->length.'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("width").'</td><td>';
        print $object->width.'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("height").'</td><td>';
        print $object->height.'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("depth").'</td><td>';
        print $object->thickness.'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("thickness").'</td><td>';
        print $object->depth.'</td></tr>';
      	 print '</tbody>';
		print '</table><br />';
		print '<div style="float: right; margin-top: 8px;">';
	    print '<a href="./index.php?metre_id='. $metre_id .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	
		if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&metre_id='. $metre_id .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&metre_id='. $metre_id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
		
            print $form->formconfirm("./card.php?metre_id=".$metre_id."&id=".$id, $langs->trans("deleteworkpart"), $langs->trans("ConfirmDeleteworkpart"), "confirm_delete", '', 0, 1);
                // }
        }
	}	
	print '</div>';
}
else {				
	$metre->fetch($metre_id);
	$works->fetch($metre->fk_td_work);
	$market->fetch($works->fk_market);

	print_barre_liste($langs->trans("Workparts"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
	
	$work_Head  = market_works_metre_prepare_head($metre);
	dol_fiche_head($work_Head,'metre_workparts', $langs->trans("Workparts"), 0, 'submunu1');
	$moreparam = '&metre_id='.$metre_id;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="metre_id" value="'. $metre_id .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("task"), $_SERVER["PHP_SELF"],'task','', $moreparam,'align="center"',$sortfield,$sortorder);
	
	print_liste_field_titre($langs->trans("num"),$_SERVER["PHP_SELF"], 'ref', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("length"),$_SERVER["PHP_SELF"], "length", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("height"), $_SERVER["PHP_SELF"], 'height', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("width"), $_SERVER["PHP_SELF"],'width','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("depth"), $_SERVER["PHP_SELF"],'depth','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("thickness"), $_SERVER["PHP_SELF"],'thickness','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';
	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_tache" value="'.$search_tache.'"></td>';
    print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_num" value="'.$search_num.'" />';
	print '</td>';
	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_long" value="'.$search_long.'"></td>';
	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_haut" value="'.$search_haut.'"></td>';
print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_larg" value="'.$search_larg.'"></td>';
	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_fond" value="'.$search_fond.'"></td>';
	print '</td>';
 print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_epais" value="'.$search_epais.'"></td>';
print '</td>';
// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";
	// Lines
	
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
			print $object->getNomUrl(1,  $line->id,$line->fk_metre);
			print '</td>';
			print '<td align="center">'.$line->task .'</td>';
			print '<td align="center">'.$line->num .'</td>';
			print '<td align="center">'.$line->length .'</td>';
			print '<td align="center">'.$line->height .'</td>';
			print '<td align="center">'.$line->width .'</td>';
			print '<td align="center">'.$line->depth .'</td>';
			print '<td align="center">'.$line->thickness .'</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
	
if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&metre_id='. $metre_id .'" class="butAction">'.$langs->trans('AddWorkpart').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>
