<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/delays/class/delays.class.php
 * \ingroup delays
 * \brief   This file is delays CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';

/**
 * Class btp
 *
 * Payments Management class
 */
class MarketPayments extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see btp::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'market_payments';
	/**
	 * @var string Name of table without pnum_marcheix where object is stored
	 */
	public $table_element = 'market_payments';

	/**
	 * @var int ID
	 */
	public $id;
	public $num;
	public $fk_createdby;
	public $fk_market;
	public $fk_bank;
	public $date_start;
	public $date_end;
	public $amount;
	public $type;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape((int)$this->fk_createdby) : 0;
		$this->fk_market 	= $this->fk_market ? $this->db->escape((int)$this->fk_market) : 0;
		$this->fk_bank 		= $this->fk_bank ? $this->db->escape((int)$this->fk_bank) : 0;
		$this->amount		= $this->amount ? $this->db->escape((float)$this->amount) : null;
		$this->date_start	= $this->date_start ? $this->db->escape($this->date_start) : null;
		$this->date_end 	= $this->date_end ? $this->db->escape($this->date_end) : null;
		$this->num 			= $this->num ? $this->db->escape($this->num) : null;
		$this->type			= $this->type ? $this->db->escape((int)$this->type) : null;
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (amount, fk_createdby, fk_market, fk_bank, created_at, updated_at, date_start, date_end, num, type) VALUES (';
		$sql .= $this->amount .",".$this->fk_createdby.", ".$this->fk_market.", ".$this->fk_bank.", '".$this->created_at."', '".$this->updated_at ."', '".$this->date_start."', '". $this->date_end."', '". $this->num ."', ". $this->type .")";

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error delays ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_market = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $fk_market) {
			$sql .= ' WHERE fk_market = ' . $fk_market;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_createdby  = $obj->fk_createdby;
				$this->fk_market 	 = $obj->fk_market;
				$this->fk_bank 	 	 = $obj->fk_bank;
				$this->date_start  	 = $this->db->jdate($obj->date_start);
				$this->date_end 	 = $this->db->jdate($obj->date_end);
				$this->amount  		 = $obj->amount;
				$this->num  		 = $obj->num;
				$this->type  		 = $obj->type;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid = null, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4) .' AND fk_market = '. $mid;
		} else {
			if (!$ignore_id)
				$sql .= ' WHERE fk_market = '. $mid;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_createdby  = $obj->fk_createdby;
				$line->fk_market 	 = $obj->fk_market;
				$line->fk_bank 		 = $obj->fk_bank;
				$line->date_start  	 = $this->db->jdate($obj->date_start);
				$line->date_end 	 = $this->db->jdate($obj->date_end);
				$line->amount 		 = $obj->amount;
				$line->num 		 	 = $obj->num;
				$line->type 		 = $obj->type;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto=0,  $id, $mid = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setnum	= '';

        $id  	= ($id  ?: '');
        $label  = $ref ?: $langs->trans("Show").': '. $id;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/payments/index.php?id='. $id .'&mid='. $mid .'" class="classfortooltip" title="'. $label .'">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

    public function fetchPaymentTypeById($pid)
    {
    	if (!$pid) return;

    	$sql = 'SELECT code, libelle as type_libelle FROM '.MAIN_DB_PREFIX.'c_paiement';
		$sql.= ' WHERE id = '. (int)$pid;

		$result = $this->db->query($sql);

		if ($result) {
			if ($this->db->num_rows($result)) {
				$obj = $this->db->fetch_object($result);
				return $obj->type_libelle;
			}
		} else {
			return false;
		}
    }

    public function getStatData($market_id = false)
    {
    	global $langs;
    	$this->fetchAll(($market_id ?: null), '', '', 0, 0, '', ($market_id ? false : true));
    	$countAmount = 0;

    	foreach ($this->lines as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->lines);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('Payments');
    	$object->url 	= (int)$market_id ? DOL_URL_ROOT.'/btp/market/payments/index.php?mid='.(int)$market_id : '';

    	return $object;
    }
}
