<?php
/* Copyright (C) 2008-2014 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2008-2010 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/po_documentmanagement/index_auto.php
 *	\ingroup    ecm
 *	\brief      Main page for ECM section area
 *	\author		Laurent Destailleur
 */

if (! defined('REQUIRE_JQUERY_LAYOUT'))  define('REQUIRE_JQUERY_LAYOUT','1');
if (! defined('REQUIRE_JQUERY_BLOCKUI')) define('REQUIRE_JQUERY_BLOCKUI', 1);

require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/treeview.lib.php';
require_once DOL_DOCUMENT_ROOT.'/ecm/class/ecmdirectory.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/marches.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/formfile.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/purchaseorder/class/purchaseorder.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/po_documentmanagement/class/po_documentmanagement.class.php';

// Load traductions files
$langs->load("ecm");
$langs->load("other");
$langs->load("users");
$langs->load("marches");

// Security check
if ($user->societe_id) $socid = $user->societe_id;

$poid = GETPOST("poid", 'int');

if (!$poid)
    die('ID bon de commande est inconue!');

// Get parameters
$section=0;
$action = GETPOST("action");
$module = GETPOST("module");
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
if ($page == -1) { $page = 0; }
$offset = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
if (!$sortorder) $sortorder="ASC";
if (!$sortfield) $sortfield="fullname";

$object     = new PODocumentManagement($db);
$userstatic = new User($db);
$purchaseorder= new PurchaseOrder($db);
$purchaseorder->fetch($poid);
$form       = new Form($db);

$error=0;

/*
 *	Actions
 */

/*
 *	View
 */

// Define height of file area (depends on $_SESSION["dol_screenheight"])
$maxheightwin=(isset($_SESSION["dol_screenheight"]) && $_SESSION["dol_screenheight"] > 466)?($_SESSION["dol_screenheight"]-186):660;	// Also into index.php file

$morejs=array('/btp/nc_under_modules/marches/js/marches.js');
if (empty($conf->global->MAIN_ECM_DISABLE_JS)) $morejs[] = "/includes/jquery/plugins/jqueryFileTree/jqueryFileTree.js";
$moreheadcss="
<!-- dol_screenheight=".$_SESSION["dol_screenheight"]." -->
<style type=\"text/css\">
    #containerlayout {
        height:     ".$maxheightwin."px;
        margin:     0 auto;
        width:      100%;
        min-width:  700px;
        _width:     700px; /* min-width for IE6 */
    }
</style>";
$moreheadjs=empty($conf->use_javascript_ajax)?"":"
<script type=\"text/javascript\">
    jQuery(document).ready(function () {
        jQuery('#containerlayout').layout({
        	name: \"ecmlayout\"
        ,   paneClass:    \"ecm-layout-pane\"
        ,   resizerClass: \"ecm-layout-resizer\"
        ,   togglerClass: \"ecm-layout-toggler\"
        ,   center__paneSelector:   \"#ecm-layout-center\"
        ,   north__paneSelector:    \"#ecm-layout-north\"
        ,   west__paneSelector:     \"#ecm-layout-west\"
        ,   resizable: true
        ,   north__size:        32
        ,   north__resizable:   false
        ,   north__closable:    false
        ,   west__size:         340
        ,   west__minSize:      280
        ,   west__slidable:     true
        ,   west__resizable:    true
        ,   west__togglerLength_closed: '100%'
        ,   useStateCookie:     true
            });

        jQuery('#ecm-layout-center').layout({
            center__paneSelector:   \".ecm-in-layout-center\"
        ,   resizable: false
        });
        
        jQuery('.toggle_technical_files').on('click', function(){
            jQuery('.technical_file_list').toggle();
        });
        var getTechMods = '". $module ."';
        if (getTechMods == 'tc_piezometer' || getTechMods == 'tc_wells' || getTechMods == 'tc_reconnaissance_survey') {   
            jQuery('.technical_file_list').show('fast');
        }
    });
</script>";

llxHeader($moreheadcss.$moreheadjs,$langs->trans("ECMArea"),'','','','',$morejs,'',0,0);

// Add sections to manage
$rowspan     = 0;
$sectionauto = array();
$document_dirs = $object->getDocumentTypesDir();

if ($conf->global->MAIN_MODULE_MARCHES) {
	if ($conf->facture->enabled) {
        $rowspan++;
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'pv_implantation',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('PvImplantation'),
            'desc'  => $langs->trans('PvImplantation')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'technical_memory',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('TechnicalMemory'),
            'desc'  => $langs->trans('TechnicalMemory')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'os',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('OS'),
            'desc'  => $langs->trans('OS')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'pv_site_monitoring',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('PvSiteMonitoring'),
            'desc'  => $langs->trans('PvSiteMonitoring')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'report_end_work',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('ReportEndWork'),
            'desc'  => $langs->trans('ReportEndWork')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'daily_report',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('DailyReport'),
            'desc'  => $langs->trans('DailyReport')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'casing_certificates',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('CasingCertificates'),
            'desc'  => $langs->trans('CasingCertificates')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'certificate_of_origin',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('CertificateOfOrigin'),
            'desc'  => $langs->trans('CertificateOfOrigin')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'purchase_invoices',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('PurchaseInvoices'),
            'desc'  => $langs->trans('PurchaseInvoices')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'technical_file',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('TechnicalFile'),
            'desc'  => $langs->trans('TechnicalFile')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'tc_piezometer',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('Piezometer'),
            'desc'  => $langs->trans('Piezometer')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'tc_wells',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('Wells'),
            'desc'  => $langs->trans('Wells')
        );
        $sectionauto[] = array(
            'level' => 1,
            'module'=> 'tc_reconnaissance_survey',
            'test'  => $conf->marches->enabled,
            'label' => $langs->trans('ReconnaissancesSurvey'),
            'desc'  => $langs->trans('ReconnaissancesSurvey')
        );
    }
}

$classviewhide = (!empty($conf->use_javascript_ajax) ? 'hidden' : 'visible');

if (empty($conf->dol_use_jmobile)) {
    $head = purchaseorder_prepare_head($purchaseorder);
    dol_fiche_head($head, 'po_documentmanagement', $langs->trans("MarketDocuments"), 0, '');

    $headBtm = purchaseorder_documents_prepare_head($purchaseorder);
    dol_fiche_head($headBtm, 'documentmanagement', $langs->trans("DocumentTypes"), 0, '');

    // $headBtm2 = marche_documents2_prepare_head($purchaseorder);
    // dol_fiche_head($headBtm2, 'documentmanagement', $langs->trans("DocumentTypes"), 0, '');
}

// Start container of all panels
?>
<div id="containerlayout"> <!-- begin div id="containerlayout" -->
<div id="ecm-layout-north" class="toolbar largebutton">
<?php

// Start top panel, toolbar
print '<div class="toolbarbutton">';
print '<a href="./card.php?action=add&poid='. $poid .'" class="butAction" style="margin-top:5px;float:left;">'.$langs->trans('AddNewDocument').'</a>';
print '</div>';
// End top panel, toolbar

?>
</div>
<div id="ecm-layout-west" class="<?php echo $classviewhide; ?>">
<?php
// Start left area
if (empty($action) || $action == 'file_manager' || preg_match('/refresh/i',$action) || $action == 'delete') {
	print '<table width="100%" class="nobordernopadding">';

	print '<tr class="liste_titre nc_filtrage_tr">';
    print '<td class="liste_titre" align="left" colspan="6">';
    print '&nbsp;'.$langs->trans("ECMSections");
	print '</td></tr>';

    $showonrightsize='';
    // Auto section
	if (count($sectionauto)) {
		$sectionauto=dol_sort_array($sectionauto,'label','ASC',true,false);

		print '<tr>';
    	print '<td colspan="6" style="padding-left: 20px">';
	    print '<div id="filetreeauto" class="ecmfiletree"><ul class="ecmjqft">';

		$nbofentries=0;
		$oldvallevel=0;
		foreach ($sectionauto as $key => $val) {
			if (empty($val['test']) || in_array($key, array(6, 7, 12))) continue;   // If condition to show is ok

			$var=false;

		    print '<li class="directory collapsed">';
		    
            if ($val['module'] == 'technical_file') {
                print '<a class="fmdirlia jqft ecmjqft toggle_technical_files" href="javascript:void(0);">';
                print $val['label'];
                print '</a>';
                print '
                    <ul class="technical_file_list" style="display: none;">
                        <li class="directory collapsed">
                            <a href="'.$_SERVER["PHP_SELF"].'?module='.$sectionauto[6]['module'].'&poid='. $poid .'">'. $sectionauto[6]['label'] .'</a>';
                            print '<div class="ecmjqft">';
                            $htmltooltip="<b>".$langs->trans("ECMSection")."</b>: ". $sectionauto[6]["label"]."<br>";
                            $htmltooltip="<b>".$langs->trans("Type")."</b>: ".$langs->trans("ECMSectionAuto")."<br>";
                            $htmltooltip.="<b>".$langs->trans("ECMCreationUser")."</b>: ".$langs->trans("ECMTypeAuto")."<br>";
                            $htmltooltip.="<b>".$langs->trans("Description")."</b>: ". $sectionauto[6]["desc"];
                            print $form->textwithpicto("", $htmltooltip, 1, "info");
                            print "</div>";
                        print '</li>
                        <li class="directory collapsed">
                            <a href="'.$_SERVER["PHP_SELF"].'?module='.$sectionauto[7]['module'].'&poid='. $poid .'">'. $sectionauto[7]['label'] .'</a>';
                            print '<div class="ecmjqft">';
                            $htmltooltip="<b>".$langs->trans("ECMSection")."</b>: ". $sectionauto[7]["label"]."<br>";
                            $htmltooltip="<b>".$langs->trans("Type")."</b>: ".$langs->trans("ECMSectionAuto")."<br>";
                            $htmltooltip.="<b>".$langs->trans("ECMCreationUser")."</b>: ".$langs->trans("ECMTypeAuto")."<br>";
                            $htmltooltip.="<b>".$langs->trans("Description")."</b>: ". $sectionauto[7]["desc"];
                            print $form->textwithpicto("", $htmltooltip, 1, "info");
                            print "</div>";
                        print '</li>
                        <li class="directory collapsed">
                            <a href="'.$_SERVER["PHP_SELF"].'?module='.$sectionauto[12]['module'].'&poid='. $poid .'">'. $sectionauto[12]['label'] .'</a>';
                            print '<div class="ecmjqft">';
                            $htmltooltip="<b>".$langs->trans("ECMSection")."</b>: ". $sectionauto[12]["label"]."<br>";
                            $htmltooltip="<b>".$langs->trans("Type")."</b>: ".$langs->trans("ECMSectionAuto")."<br>";
                            $htmltooltip.="<b>".$langs->trans("ECMCreationUser")."</b>: ".$langs->trans("ECMTypeAuto")."<br>";
                            $htmltooltip.="<b>".$langs->trans("Description")."</b>: ". $sectionauto[12]["desc"];
                            print $form->textwithpicto("", $htmltooltip, 1, "info");
                            print "</div>";
                        print '</li>
                    </ul>
                ';
            $htmltooltip = '';
            } else {
                print '<a class="fmdirlia jqft ecmjqft" href="'.$_SERVER["PHP_SELF"].'?module='.$val['module'].'&poid='. $poid .'">';
                print $val['label'];
                print '</a>';
            }

		    print '<div class="ecmjqft">';
		    // Info
		    $htmltooltip='<b>'.$langs->trans("ECMSection").'</b>: '.$val['label'].'<br>';
		    $htmltooltip='<b>'.$langs->trans("Type").'</b>: '.$langs->trans("ECMSectionAuto").'<br>';
		    $htmltooltip.='<b>'.$langs->trans("ECMCreationUser").'</b>: '.$langs->trans("ECMTypeAuto").'<br>';
		    $htmltooltip.='<b>'.$langs->trans("Description").'</b>: '.$val['desc'];
		    print $form->textwithpicto('', $htmltooltip, 1, 'info');
		    print '</div>';
		    print '</li>';

		    $nbofentries++;
		}

	    print '</ul></div></td></tr>';
	}

	print "</table>";
}


// End left banner
?>
</div>
<div id="ecm-layout-center" class="<?php echo $classviewhide; ?>">
<div class="pane-in ecm-in-layout-center">
<div id="ecmfileview" class="ecmfileview">
<?php
// Start right panel
$mode='noajax';

include_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/dirpreview_po.php';
// End right panel
?>
</div>
</div>

</div>
</div> <!-- end div id="containerlayout" -->
<?php
// End of page

llxFooter();

$db->close();
