<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       btp/market/social_charges/index.php
 *		\ingroup    list
 *		\brief      Gestion des social charges
 */

require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.formsocialcontrib.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/social_charges/class/social_charges.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/sociales/class/chargesociales.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';

if (!$user) accessforbidden();

$langs->load("bills");

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action  = GETPOST('action','alpha');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid)
	die('ID du marché n\'est pas défine');

$search_cs 			= GETPOST('search_cs');
$search_created_by 	= (int) GETPOST('search_created_by');
$search_createdat  	= GETPOST('search_createdat');
$search_ref     	= GETPOST('search_ref');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_cs 			= "";
	$search_created_by 	= "";
	$search_createdat  	= "";
    $search_ref     	= "";
}

$social_charges	 	= new MarketChargeSociales($db);
$market 			= new Market($db);
$formsocialcontrib 	= new FormSocialContribChild($db);
$chargesociales 	= new ChargeSociales($db);
$userstatic 		= new User($db);
$form 				= new Form($db);

$morejs  = array("/btp/js/btp.js","/btp/js/market.js");
$morecss = array();
llxHeader(array(), $langs->trans('SocialCharges'),'','','','',$morejs,$morecss,0,0);
print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';

$filter .= (!empty($search_ref) ? " AND ch.libelle like '%". $db->escape($search_ref) ."%'" : "");
$filter .= (!empty($search_created_by) && $search_created_by != -1 ? " AND c.fk_createdby = ". $db->escape($search_created_by) : "");
$filter .= (!empty($search_cs) ? " AND ch.fk_type = ". $db->escape($search_cs) : "");
if (isset($search_createdat) && !empty($search_createdat)) {
	list($sd, $sm, $sy)  = explode("/", $search_createdat);
	$filter .=  " AND DATE_FORMAT(created_at, '%Y-%m-%d') = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}

$getsocial_charges = $social_charges->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getsocial_charges == '-1') {
    print_fiche_titre($langs->trans('SocialCharges'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$social_charges->error);
    exit();
}

// Show table of vacations
$var = true;
$num = count($social_charges->lines);

if ($id > 0) {
	$social_charges->fetch($id);
	
	print_barre_liste($langs->trans("SocialCharges"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$market->fetch($mid);
	$head = market_prepare_head($market);
	dol_fiche_head($head, 'social_charges', $langs->trans('SocialCharges'), 0, '');

	echo $market->getMarketHeader();

	$userstatic->fetch($social_charges->fk_createdby);
	$chargesociales->fetch($social_charges->fk_social_charge);
	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $userstatic->getNomUrl(1) .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. dol_print_date($social_charges->created_at, 'day') .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("SocialContributions").'</td>';
	print '<td colspan="2">'. $chargesociales->getNomUrl(1) .'</td></tr>';
	print '</table><br />';

	print '<div style="float: right;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';

	// if ($user->rights->market->delete)	{
    	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
    // }
	print '</div>';

	if(/*$user->rights->market->delete && */$action == 'delete') {
        print $form->formconfirm("./card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDeleteSocialCharges"),$langs->trans("ConfirmDeleteSocialCharges"),"confirm_delete", '', 0, 1);
    }
} else {
	print_barre_liste($langs->trans("SocialCharges"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$market->fetch($mid);
	$head = market_prepare_head($market);
	
	dol_fiche_head($head, 'social_charges', $langs->trans('SocialCharges'), 0, '');

	echo $market->getMarketHeader();
	$moreparam = '&mid='.$mid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">';
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "id", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_createdby", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("SocialContributions"), $_SERVER["PHP_SELF"], 'fk_social_charge', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedAt"),$_SERVER["PHP_SELF"],"created_at","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat center" size="30" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" colspan="1" align="center">';
	$formsocialcontrib->select_type_socialcontrib($search_cs,'search_cs', 1, 200, 0);
	print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="14" name="search_createdat" value="'.$search_createdat.'"></td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($social_charges->lines)) {
		foreach($social_charges->lines as $line) {
			$var = !$var;
			$userstatic->fetch($db->escape($line->fk_createdby));
			$chargesociales->fetch($line->fk_social_charge);
			$created_at	 = $line->created_at ? dol_print_date($line->created_at, 'day'): '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $social_charges->getNomUrl(1,  $line->id, $mid, ucfirst($line->label));
			print '</td>';
			print '<td align="center">'.$userstatic->getNomUrl('1').'</td>';
			print '<td align="center">'. $chargesociales->getNomUrl(1) .'</td>';
			print '<td align="center">'. $created_at .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}

	print '</table>';
	print '</form>';

	if ($user->id/* && $user->rights->market->write*/) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		$formsocialcontrib->select_type_socialcontrib('','chargesociales_list', 1, 200, 0);
		print '<a data-mid="'. $mid .'" id="addCerts" href="javascript:void(0);" class="butAction">'.$langs->trans('Add').'</a>';
		print '</div><br /><br />';
	}
}

print '<form id="cs-form" action="./card.php" method="post">
<input type="hidden" name="action" value="create">
<input type="hidden" name="mid" value="'. $mid .'">
<table id="social_charges_wrapper" class="border" style="margin-top: 15px;width:100%;display:none;">
<tr class="impair">
<td align="center">'. $langs->trans('Ref') .'</td><td align="center">'. $langs->trans('Label') .'</td><td align="center">'. $langs->trans('PeriodEndDate') .'</td><td align="center">'. $langs->trans('Amount') .'</td><td align="center">'. $langs->trans('DateDue') .'</td><td align="center">&nbsp;</td>
</tr>
</table>';
print '<div style="float: right; margin-top: 8px;display:none;">';
print '<input type="submit" class="button sub_cert" value="'. $langs->trans('AddSocialCharges') .'" />';
print '</div></form>';

llxFooter();

$db->close();

?>
