<?php
/* Copyright (C) 2016 Yassine Belkaid  y.belkaid@nextconcept.ma
 * 
 */

/**
 * \file    marches/purchaseorder/purchaseorder.class.php
 * \ingroup marches
 * \brief   This file is purchaseorder CRUD class file
 *
 */

require_once DOL_DOCUMENT_ROOT . '/btp/db/nxdb.class.php';


/**
 * Class marches
 *
 * Contract Management class
 */
class sous_traitance extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'soustraitance';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'soustraitance';

	/**
	 * @var int ID
	 */
	public $contact;
	public $id;
	public $fk_created_by;
	public $fk_third_party;
	public $ref;
	public $label;
	public $subject;
	public $num;
	public $creation_date;
	public $date_etabli;
	public $budget;
	public $reception_date;
	public $deadline;
	public $country;
	public $forfaitouhoraire;
	public $couthoraire;
	public $nbrheurs;
	public $state;
	public $city;
	public $statut;
	public $created_at;
	public $updated_at;
   	public $type;

	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		  = $db;
		$this->now 		  = new \DateTime("now");
		$this->now 		  = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_third_party 		= $this->fk_third_party ?: null;
		$this->fk_created_by  		= $this->fk_created_by ?: null;
		$this->subject 				= $this->subject ?: null;
		$this->num 					= $this->num ?: null;
		$this->creation_date 		= $this->creation_date ?: null;
		$this->date_etabli 			= $this->date_etabli ?: null;
		$this->budget 				= $this->budget ?: 0;
		$this->reception_date 		= $this->reception_date ?: null;
		$this->state 				= $this->state ?: null;
		$this->deadline 			= $this->deadline ?: null;
		$this->created_at 	  		= $this->now;
		$this->type 			    = $this->type ?: null;
		$this->forfaitouhoraire 			    = $this->forfaitouhoraire ?: "forfait";
		$this->couthoraire 				= $this->couthoraire ?: 0;
		$this->nbrheurs 				= $this->nbrheurs ?: 0;


		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' ( fk_created_by,created_at, updated_at, subject, num, date_etabli, budget, reception_date, deadline, country, forfaitouhoraire, couthoraire, nbrheurs, state, city, entity,type) VALUES (';
		$sql .= /*$this->fk_third_party.', '.*/$this->fk_created_by.', "'.$this->created_at.'", "'.$this->updated_at .'", "'. $this->db->escape($this->subject) .'", "'. $this->db->escape($this->num) .'", "'.$this->date_etabli.'", '.$this->budget.', "'.$this->reception_date.'", "'.$this->deadline.'", "'. $this->db->escape($this->country) .'", "'. $this->db->escape($this->forfaitouhoraire) .'", '. $this->db->escape($this->couthoraire) .', '. $this->db->escape($this->nbrheurs) .', "'. $this->db->escape($this->state) .'", "'. $this->db->escape($this->city) .'", '. (int)$conf->entity .' ,"'. $this->db->escape($this->type) .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error Concurrents ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element. ' WHERE rowid = ' . $id . ' AND entity = ' . $conf->entity;;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->id 		  	  = $obj->rowid;
				$this->fk_created_by  = $obj->fk_created_by;
/*				$this->fk_third_party = $obj->fk_third_party;
*/				$this->subject 			= nl2br($obj->subject);
				$this->num 				= $obj->num;
				$this->budget			= $obj->budget;
				$this->country			= $obj->country;
				$this->forfaitouhoraire			= $obj->forfaitouhoraire;
				$this->couthoraire			= $obj->couthoraire;
				$this->nbrheurs			= $obj->nbrheurs;
				$this->state			= $obj->state;
				$this->city				= $obj->city;
				$this->date_etabli		= $this->db->jdate($obj->date_etabli);
				$this->reception_date	= $this->db->jdate($obj->reception_date);
				$this->deadline			= $this->db->jdate($obj->deadline);
				$this->updated_at 	  = $this->db->jdate($obj->updated_at);
				$this->created_at 	  = $this->db->jdate($obj->created_at);
				$this->type				= $obj->type;

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '')
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
			$sql .= ' AND entity = ' . $conf->entity;

		}else{
			$sql .= ' Where  entity = ' . $conf->entity;
		}

		// echo $sql;
		// die();
	
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if(!empty($limit)){
         	$sql.= " limit  ".$limit ;
		}
		$this->lines = array();
		// $this->db->begin();
		$resql 		 = $this->db->query($sql);
		// print $sql;
		// die();
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		  	  	= $obj->rowid;
				$line->fk_created_by  	= $obj->fk_created_by;
/*				$line->fk_third_party 	= $obj->fk_third_party;
*/				$line->subject 			= nl2br($obj->subject);
				$line->num 				= $obj->num;
				$line->budget			= $obj->budget;
				$line->country			= $obj->country;
				$line->forfaitouhoraire			= $obj->forfaitouhoraire;
				$line->couthoraire			= $obj->couthoraire;
				$line->nbrheurs			= $obj->nbrheurs;
				$line->couthoraire			= $obj->couthoraire;
				$line->nbrheurs			= $obj->nbrheurs;
				$line->state			= $obj->state;
				$line->city				= $obj->city;
				$line->type				= $obj->type;

				$line->date_etabli		= $this->db->jdate($obj->date_etabli);
				$line->reception_date	= $this->db->jdate($obj->reception_date);
				$line->deadline			= $this->db->jdate($obj->deadline);
				$line->updated_at 	  = $this->db->jdate($obj->updated_at);
				$line->created_at 	  = $this->db->jdate($obj->created_at);
				$this->lines[] 	  	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}

	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $this->db->escape($val) .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int) $id;
		// echo $sql;
		// die();
		// $this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id, $ref = null)
    {
        global $langs;

        $result	= '';
        $ref 	= (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $ref;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/btp/market/sous_traitance/index.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$ref.$linkend;
        return $result;
    }

    public function getTraitanceHeader()
    {
    	global $langs;

    	$thirdParty = '';

		/*if (isset($this->fk_third_party) && !empty($this->fk_third_party)) {
			$socstatic = new Societe($this->db);
			$socstatic->fetch($this->fk_third_party);
			$thirdParty = $socstatic->getNomUrl(1);
		}*/

    /*	$html = '<table class="border" width="100%" data-row-id="0">';
	    $html .= '<tbody>';

	    $html .= '<tr><td class="fieldrequired" width="25%">'.$langs->trans("PONum").'</td><td>';
	    $html .= $this->num;
	    $html .= '</td></tr>';

	    $html .= '<tr><td>'.$langs->trans("Subject").'</td><td>';
	    $html .= nl2br($this->subject);
	    $html .= '</td></tr>';

		$html .= '<tr><td class="fieldrequired">'.$langs->trans("Label").'</td><td>';
	    $html .= ucfirst($this->label);
	    $html .= '</td></tr>';

	    // Thirdparty
	    $html .= '<tr><td>'.$langs->trans("ThirdPartyMarket").'</td><td>';
		$html .= $thirdParty;
	    $html .= '</td></tr>';

	    $html .= '<tr><td class="">'.$langs->trans("Ref").'</td><td>';
	    $html .= ucfirst($this->ref);
	    $html .= '</td></tr>';

	    $html .= '<tr><td>'.$langs->trans("CreationDate").'</td><td>';
	    $html .=  dol_$html .=_date($this->creation_date, 'day') .'</td></tr>';

	    $html .= '<tr><td class="">'.$langs->trans("Country").'</td><td>';
	    $html .= ucfirst($this->country) .'</td></tr>';

	    $html .= '<tr><td class="">'.$langs->trans("Province").'</td><td>';
	    $html .= ucfirst($this->state) .'</td></tr>';

	    $html .= '<tr><td class="">'.$langs->trans("City").'</td><td>';
	    $html .= ucfirst($this->city) .'</td></tr>';

	    $html .= '</tbody>';
	    $html .= '</table>';

		$html .= '</table><br />';

		return $html;

*/





















		$html .= '<table class="border" width="100%" data-row-id="0">';
    $html .= '<tbody>';

    $html .= '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td><td>';
    $html .= $this->num;
    $html .= '</td></tr>';

    $html .= '<tr><td>'.$langs->trans("Subject").'</td><td>';
    $html .= nl2br($this->subject);
    $html .= '</td></tr>';

	
    // Thirdparty
    $html .= '<tr><td class="fieldrequired">'.$langs->trans("maitreo").'</td><td>';
/*	$html .= $thirdParty;
*/    $html .= '</td></tr>';

    $html .= '<tr><td class="">'.$langs->trans("Country").'</td><td>';
    $html .= ucfirst($this->country) .'</td></tr>';

    $html .= '<tr><td class="">'.$langs->trans("Province").'</td><td>';
    $html .= ucfirst($this->state) .'</td></tr>';

    $html .= '<tr><td class="">'.$langs->trans("City").'</td><td>';
    $html .= ucfirst($this->city) .'</td></tr>';

    $html .= '</tbody>';
    $html .= '</table>';


    $html .= '<table class="border" width="100%" data-row-id="0">';
    $html .= '<tbody>';

    $html .= '<tr><td class="" width="25%">'.$langs->trans("ContDateEtab").'</td><td>';
    $html .= dol_print_date($this->date_etabli, 'day');
    $html .= '</td></tr>';

    // Coût Forfait ou Horaire
    $forfaitinp=$horaireinp="";
	if($this->forfaitouhoraire=='forfait' )
		$forfaitinp ='checked="checked"';
	else
		$horaireinp ='checked="checked"';
	
	$html .= '<tr><td class="fieldrequired">'.$langs->trans("Coût Forfait ou Horaire").'</td><td>';
    $html .= '<label><input type="radio" name="forfaitouhoraire" checked value="forfait" '.$forfaitinp.' disabled >Coût Forfait</label>
		<label><input type="radio" name="forfaitouhoraire" value="horaire" '.$horaireinp.' disabled >Coût Horaire</label>';
    $html .= '</td>';

    if ($this->forfaitouhoraire == "horaire") {
	    $html .= '<tr class="hideonhoraire"><td class="fieldrequired">'.$langs->trans("Coût horaire prestataire").'</td><td>';
	    $html .= number_format($this->couthoraire, 2,","," ");
	    $html .= '</td></tr>';
	    $html .= '<tr class="hideonhoraire"><td class="fieldrequired">'.$langs->trans("Nombre d'heures").'</td><td>';
	    $html .= number_format($this->nbrheurs, 2,","," ");
	    $html .= '</td></tr>';
    }   

    $html .= '<tr><td>'.$langs->trans("AmountTtc").'</td><td>';
    $html .= number_format($this->budget, 2);
    $html .= '</td></tr>';

     $html .= '</tbody>';
    $html .= '</table>';

   $html .= print_barre_liste($langs->trans("BCInfoConsLetter"), '', '', '', '', '', "", "","", '');

    $html .= '<table class="border" width="100%" data-row-id="0">';
    $html .= '<tbody>';

    $html .= '<tr><td class="" width="25%">'.$langs->trans("StartDate").'</td><td>';
    $html .= dol_print_date($this->reception_date, 'day');
    $html .= '</td></tr>';

    $html .= '<tr><td>'.$langs->trans("DtProvi").'</td><td>';
    $html .= dol_print_date($this->deadline, 'day');
    $html .= '</td></tr>';

    $html .= '</tbody>';
    $html .= '</table>';
    $html .= '</table><br />';

		return $html;

    }

    
    public function updatemaitreo($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		
		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'maitreo' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  rowid = ' . $id;

	//	$this->db->begin();
/*	die($sql);*/
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function deletemaitreo($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'maitreo' .' WHERE fk_soustratanc = ' . $id;
	
	$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

public function createmaitreo()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);


		// Clean parameters
		$this->fk_soustratanc 				= $this->fk_soustratanc ? $this->db->escape($this->fk_soustratanc): null;
		$this->fk_idsoc				= $this->fk_idsoc ? $this->db->escape($this->fk_idsoc): null;
		


		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'maitreo' . ' (fk_soustratanc,fk_idsoc,contact) VALUES (';
		
		$sql .= '"'.$this->fk_soustratanc.'",  "'.$this->fk_idsoc.'","'.$this->contact.'")';

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error  ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}
		public function fetchmaitreo($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'maitreo';
		
			$sql .= ' WHERE rowid = ' . $id;
		

		$resql = $this->db->query($sql);
		//die($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->id 				 = $obj->rowid;
	
				$this->fk_idsoc 			 = $obj->fk_idsoc;
				$this->fk_soustratanc 		 	 = $obj->fk_soustratanc;
				$this->contact			 = $obj->contact;


			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
public function fetchbyidsoc($idsoc)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

$sql = 'SELECT * ';


$sql.= ' FROM '. MAIN_DB_PREFIX .'maitreo '   ;
			$sql .= ' WHERE fk_soustratanc = ' . $idsoc;
		//	die($sql);
$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
$line->rowid 			 = $obj->rowid;

				$line->fk_idsoc 			 = $obj->fk_idsoc;
	
				$line->fk_soustratanc 		 	 = $obj->fk_soustratanc;
								$line->contact			 = $obj->contact;


					$this->rows[] = $line;
				}
				return $this->rows;
			}
			return false;
		}
		return false;
	}

public function findcontact($id)
{
   	$sql = 'SELECT lastname ,rowid ';
$sql.= ' FROM '. MAIN_DB_PREFIX .'socpeople' ;
$sql .= ' WHERE rowid = ' . $id;
$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
									$line->id 			 = $obj->rowid;

					$line->name 			 = $obj->lastname;
				


					$this->rows[] = $line;
				}
				return $this->rows;
			}
			return false;
		}
		return false;
}
 public function getcontactBysoc($socid,$nan=false)
    {
    	
    	$sql = 'SELECT lastname ,rowid ';
$sql.= ' FROM '. MAIN_DB_PREFIX .'socpeople' ;
$sql .= ' WHERE fk_soc = ' . $socid;

    	$resql = $this->db->query($sql);
    	$contact = array();
    	if($nan)
    		$contact[0] = 'neant';
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$contact[$obj->rowid] = $obj->lastname;
			}
			$this->db->free($resql);
    	}

    	ksort($contact);
    	return $contact;
    }

}
