<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       market/sous_traitance/index.php
 * \ingroup    marche
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/sous_traitance/class/sous_traitance.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/nc_under_modules/marches/lib/tools.lib.php';
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';


$langs->load('users');$langs->load('btp');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$action   = GETPOST('action','alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');

$search_num = GETPOST('search_num');
$search_subject = GETPOST('search_subject');
$search_tier      = GETPOST('search_tier');
$search_city       = GETPOST('search_city');
$search_startdate       = GETPOST('search_startdate');
$search_enddate       = GETPOST('search_enddate');
$search_budget     = GETPOST('search_budget');
$search_type    = GETPOST('search_type','int');
$types=[0 =>"Privé", 1=>"État"];

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_num        = "";
	$search_subject    = "";
	$search_tier  	   = "";
    $search_budget     = "";
    $search_city       = "";
    $search_startdate  = "";
    $search_enddate    = "";
    $search_type       = "";

}

/**
 * Actions
 */

// None

/**
 * View
 */

$object = new sous_traitance($db);
$filter = '';




// Filter
$filter.= ($search_type!="" && $search_type!=-1)?" AND type ='".$db->escape($search_type)."'":"";
$filter .= (!empty($search_num) && $search_num != -1) ? ' AND num = "'. $db->escape($search_num) .'"' : '';
$filter .= (!empty($search_subject) && $search_subject != -1) ? ' AND subject LIKE "%'. $db->escape($search_subject) .'%"' : '';
$filter .= (!empty($search_tier) && $search_tier != -1) ? " AND fk_third_party = ". $db->escape($search_tier) : '';
$filter .= (!empty($search_budget) && $search_budget != -1) ? " AND budget = ". $db->escape($search_budget) : "";
$filter .= (!empty($search_city) && $search_city != -1) ? ' AND city = "'. $db->escape($search_city) .'"' : "";
$filter .= (isset($search_startdate) && !empty($search_startdate)) ? ' AND reception_date = "'. $db->escape(Tools::convertDateTo($search_startdate, 'sql')) .'"' : "";
$filter .= (isset($search_enddate) && !empty($search_enddate)) ? ' AND deadline = "'. $db->escape(Tools::convertDateTo($search_enddate, 'sql')) .'"' : "";
$filterStatus = '';
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getMarchesList = $object->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getMarchesList)  && $action == "xsl" ) {
$filename="sous_traitance.xls";
      require_once DOL_DOCUMENT_ROOT.'/btp/market/sous_traitance/tpl/sous_traitance_xsl.php';
 die();
 
}
llxHeader(array(), $langs->trans('ListOfContract'),'','','','',array("/btp/js/btp.js"),array(),0,0);
// Si erreur SQL
if ($getMarchesList == '-1') {
    print_fiche_titre($langs->trans('ListOfContract'), '', '');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($object->lines);
$form 		= new Form($db);

if ($id > 0) {
	$title = $langs->trans("DetailSous_trai");
	print_fiche_titre($title,'');
	$object->fetch($id);

	$head = soustraitance_prepare_head($object);
	dol_fiche_head($head, 'contractFile', $langs->trans("ContractFile"), 0, '');

	$thirdParty = '';

	if (isset($object->fk_third_party) && !empty($object->fk_third_party)) {
		$socstatic = new Societe($db);
		$socstatic->fetch($object->fk_third_party);
		$thirdParty = $socstatic->getNomUrl(1);
	}

	print '<table class="border" width="100%" data-row-id="0">';
    print '<tbody>';

    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td><td>';
    print $object->num;
    print '</td></tr>';
    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("type").'</td><td>';
    print ($object->type ? ' État' : ' Privé') ;
    print '</td></tr>';
    print '<tr><td>'.$langs->trans("Subject").'</td><td>';
    print nl2br($object->subject);
    print '</td></tr>';

	
    // Thirdparty
    print '<tr><td class="fieldrequired">'.$langs->trans("maitreo").'/Contact</td><td>';
/*	print $thirdParty;
*/   
    $object->fetchbyidsoc($id);  

    if (count($object->rows)) {
    foreach($object->rows as $li ) {
    $socs= new Societe($db);
    $socs->fetch($li->fk_idsoc);
    $soc =$socs->getNomUrl(1);
     $contactstatic=new Contact($db);
    $contactstatic->fetch($li->contact);
    $socs->fetch($li->fk_idsoc);
    $soc =$socs->getNomUrl(1);

    print '-'.$soc .'/'.dol_trunc($contactstatic->firstname,20).' ' .dol_trunc($contactstatic->lastname,20).'<br>';
 
    }

}




 print '</td></tr>';



    print '<tr><td class="">'.$langs->trans("Country").'</td><td>';
    print ucfirst($object->country) .'</td></tr>';

    print '<tr><td class="">'.$langs->trans("Province").'</td><td>';
    print ucfirst($object->state) .'</td></tr>';

    print '<tr><td class="">'.$langs->trans("City").'</td><td>';
    print ucfirst($object->city) .'</td></tr>';

    print '</tbody>';
    print '</table>';

	print_barre_liste($langs->trans("Detail"), '', '', '', '', '', "", "", "", '');

    print '<table class="border" width="100%" data-row-id="0">';
    print '<tbody>';

    print '<tr><td class="" width="25%">'.$langs->trans("ContDateEtab").'</td><td>';
    print dol_print_date($object->date_etabli, 'day');
    print '</td></tr>';

    // Coût Forfait ou Horaire
    $forfaitinp=$horaireinp="";
	if($object->forfaitouhoraire=='forfait' )
		$forfaitinp ='checked="checked"';
	else
		$horaireinp ='checked="checked"';
	
	print '<tr><td class="fieldrequired">'.$langs->trans("Coût Forfait ou Horaire").'</td><td>';
    print '<label><input type="radio" name="forfaitouhoraire" checked value="forfait" '.$forfaitinp.' disabled >Coût Forfait</label>
		<label><input type="radio" name="forfaitouhoraire" value="horaire" '.$horaireinp.' disabled >Coût Horaire</label>';
    print '</td>';

    if ($object->forfaitouhoraire == "horaire") {
	    print '<tr class="hideonhoraire"><td class="fieldrequired">'.$langs->trans("Coût horaire prestataire").'</td><td>';
	    print number_format($object->couthoraire, 2,","," ");
	    print '</td></tr>';
	    print '<tr class="hideonhoraire"><td class="fieldrequired">'.$langs->trans("Nombre d'heures").'</td><td>';
	    print number_format($object->nbrheurs, 2,","," ");
	    print '</td></tr>';
    }   

    print '<tr><td>'.$langs->trans("AmountTtc").'</td><td>';
    print number_format($object->budget, 2,","," ");
    print '</td></tr>';










     print '</tbody>';
    print '</table>';

    print_barre_liste($langs->trans("BCInfoConsLetter"), '', '', '', '', '', "", "", "", '');

    print '<table class="border" width="100%" data-row-id="0">';
    print '<tbody>';

    print '<tr><td class="" width="25%">'.$langs->trans("StartDate").'</td><td>';
    print dol_print_date($object->reception_date, 'day');
    print '</td></tr>';

    print '<tr><td>'.$langs->trans("DtProvi").'</td><td>';
    print dol_print_date($object->deadline, 'day');
    print '</td></tr>';

    print '</tbody>';
    print '</table>';

	if ($user->id && $user->rights->btp
		->write_all) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=edit&id='.$id.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '</div>';
	}
}
else {
	print_barre_liste($langs->trans("ListOfContract"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	if ($user->id && $user->rights->btp->write) {
		print '<div style="float: right; margin-bottom: 6px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('AddSubContracting').'</a>';
		print '</div>';
	}
	print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
		print '<input name="search_num" value="'. $search_num .'" type="hidden" />';
		print '<input name="search_subject" value="'. $search_subject .'" type="hidden" />';
		print '<input name="search_tier" value="'. $search_tier .'" type="hidden" />';
		print '<input name="search_city" value="'. $search_city .'" type="hidden" />';
		print '<input name="search_startdate" value="'. $search_startdate .'" type="hidden" />';
		print '<input name="search_enddate" value="'. $search_enddate .'" type="hidden" />';
		print '<input name="search_budget" value="'. $search_budget .'" type="hidden" />';
		print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
		print '<input name="action" value="xsl" type="hidden" />';

	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>'; 
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder cls" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "num", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Subject"),$_SERVER["PHP_SELF"],"subject", '','','align="center" ',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ThirdPartyMarket"), $_SERVER["PHP_SELF"],"fk_third_party", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("City"), $_SERVER["PHP_SELF"], 'city', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("StartDate"),$_SERVER["PHP_SELF"], 'reception_date', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("DtProvi"),$_SERVER["PHP_SELF"], 'deadline', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Amount"),$_SERVER["PHP_SELF"], 'budget', '', '', 'align="center"', $sortfield, $sortorder);
	
	print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"], 'budget', '', '', 'align="center"', $sortfield, $sortorder);
	
	
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr" id="fiels">';
	// Num
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="14" name="search_num" value="'.$search_num.'"></td>';

	// Objet
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="25" name="search_subject" value="'.$search_subject.'"></td>';

	// Thirdparty
   print '<td>';
    $filteronlist='';
    if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
    print $form->select_thirdparty_list(GETPOST('search_tier','int'),'search_tier',$filteronlist,1,1);
    print '</td>';

    print '<style>#fiels td:nth-child(1) input{ width: 150px !important;} #s2id_search_tier{ width: 200px !important;}</style>';

	// ville
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_city" value="'.$search_city.'">';
	print '</td>';

	// date rec
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_startdate" value="'.$search_startdate.'">';
	print '</td>';
	// date eche
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_enddate" value="'.$search_enddate.'">';
	print '</td>';

	// Budget
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="14" name="search_budget" value="'.$search_budget.'"></td>';
    print '<td class="liste_titre" colspan="1" align="center">';

    print $form->selectarray('search_type',$types, $search_type, 1, 0, 0, 'required="required"');
    print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (!empty($object->lines)) {
		
		foreach($object->lines as $line) {
			$var = !$var;
			
			$thirdParty = '';

			if (isset($line->fk_third_party) && !empty($line->fk_third_party)) {
				$socstatic = new Societe($db);
				$socstatic->fetch($line->fk_third_party);
				$thirdParty = $socstatic->getNomUrl(1);
			}

			$num      = $line->num ?: $line->ref;
			$city     = $line->city ?: '';
			$reception_date = $line->reception_date ?: '';
			$deadline     = $line->deadline ?: '';

			$subject = $fullsubject = '';
			if (null !== $line->subject) {
				$fullsubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject 	= substr($line->subject, 0, 70);
				$subject 	= strlen($line->subject) > 70 ? $subject.'...' : $subject;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="8%">';
				print $object->getNomUrl(1,  $line->id, $num);
			print '</td>';
			print '<td align="left"><span class="classfortooltip" title="'. $fullsubject .'">'. $subject .'</span></td>';
/*			print '<td align="center">'. $thirdParty .'</td>';
*/			
        
              $maitro     = new sous_traitance($db);
            $maitro->fetchbyidsoc($line->id);
            $idsoc= ''; 
            if (count($maitro->rows)) {

            foreach($maitro->rows as $li ) {
            $socs= new Societe($db);
            $socs->fetch($li->fk_idsoc);
            $soc =$socs->getNomUrl(1);

            $idsoc.=$soc."<br>" ;
            }
            }

            print '<td align="left">'.  $idsoc .'</td>';

            print '<td align="center">'. $city .'</td>';
			print '<td align="center">'. dol_print_date($reception_date, 'day') .'</td>';
			print '<td align="center">'. dol_print_date($deadline, 'day') .'</td>';
			print '<td align="center" class="montant_td">'. number_format($line->budget, 2, ',', ' ') .'</td>';
			print '<td align="center">'.  ($line->type ? ' État' : ' Privé') .'</td>';

			print '<td></td>';
			print '</tr>'."\n";

		}
	}

          
	print '</table>';
	print '</form>';

	
}

llxFooter();

$db->close();

?>