<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/stakeholders/index.php
 * \ingroup    list
 * \brief      List of stakeholders
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/stakeholders/class/stakeholders.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/stakeholders/class/StakeHolder.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "t.rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$mid)
	die("ID du marché n'existe pas!");

$search_ref        = GETPOST('search_ref');
$search_createdby  = GETPOST('search_createdby');
$search_tel = GETPOST('search_tel');
$search_fax = GETPOST('search_fax');
$search_name= GETPOST('search_name');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   	 	= "";
	$search_createdby 	= "";
    $search_tel 	= "";
	$search_name = "";
	$search_fax = "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketStakeholders($db);
$market  = new Market($db);
$fuser 	 = new User($db);
$stakeholderobj = new StakeHolder($db);

llxHeader(array(), $langs->trans('Stakeholders'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND t.rowid = ". $db->escape((int)$search_ref) : "";
$filter .= (!empty($search_createdby) && $search_createdby != -1) ? " AND t.fk_createdby = ". $db->escape((int)$search_createdby) : "";
$filter .= isset($search_tel) && !empty($search_tel) ? " AND s.tel = '". $db->escape($search_tel) ."'" : '';
$filter .= isset($search_fax) && !empty($search_fax) ? " AND s.fax = '". $db->escape($search_fax) ."'" : '';
$filter .= (!empty($search_name)) ? " AND s.name = '". $db->escape($search_name) ."'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getstakeholders = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getstakeholders == '-1') {
    print_fiche_titre($langs->trans('Stakeholders'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch  market objects
$market->fetch($mid);

if ($id > 0) {
	$object->fetch($id);
	$head  = market_prepare_head($market);
	
	print_barre_liste($langs->trans("Stakeholders"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	dol_fiche_head($head, 'stakeholders', $langs->trans("Stakeholders"), 0, '');

	echo $market->getMarketHeader($mid);

	$fuser->fetch($object->fk_createdby);
	
	print '<table class="border" width="100%">';

	// User
	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';

	print '<tr><td class="">'.$langs->trans("Name").'</td>';
	print '<td colspan="2">'. $object->name .'</td></tr>';

	print '<tr><td class="">'.$langs->trans("Tel").'</td>';
	print '<td colspan="2">'. $object->tel .'</td></tr>';

	print '<tr><td class="">'.$langs->trans("Fax").'</td>';
	print '<td colspan="2">'. $object->fax .'</td></tr>';

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeleteStakeholder"), $langs->trans("ConfirmDeleteStakeholder"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	$head  = market_prepare_head($market);
	
	print_barre_liste($langs->trans("Stakeholders"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	dol_fiche_head($head, 'stakeholders', $langs->trans("Stakeholders"), 0, '');

	echo $market->getMarketHeader($mid);

	$moreparam = '&mid='.$mid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "t.rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"], "t.fk_createdby", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Name"), $_SERVER["PHP_SELF"],'s.name','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Tel"), $_SERVER["PHP_SELF"],'s.tel','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Fax"), $_SERVER["PHP_SELF"],'s.fax','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

    print '<td class="liste_titre" align="center">';
	print $form->select_dolusers($search_createdby,"search_createdby",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" align="center"><input class=" center" type="text" size="14" name="search_name" value="'.$search_name.'"></td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_tel" value="'.$search_tel.'" /></td>';
	
	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_fax" value="'.$search_fax.'" /></td>';
	
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_createdby));

			$name	= $line->name ? $line->name : '';
			$tel 	= $line->tel ? $line->tel : '';
			$fax 	= $line->fax ? $line->fax : '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $object->getNomUrl(1,  $line->id, $line->fk_market);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl('1') .'</td>';
			print '<td align="center">'. $name .'</td>';
			print '<td align="center">'. $tel .'</td>';
			print '<td align="center">'. $fax .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="6" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="6" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddStakeholder').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>