<?php
/* Copyright (C) 2016   Souieh Laghdaf <laghdaf.souieh@nextconcept.ma>
 *
 */

/**
 * \file       stock_const/index.php
 * \ingroup    list
 * \brief      List of markets
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/market/stock_const/class/stock_const.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$cid     = GETPOST('cid','int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$cid)
    die('ID chantier n\'existe pas!');


$error 	= false;
$form                 = new FormChild($db);
$constructionSite     = new ConstructionSite($db);
$market               = new Market($db);
$product              = new product($db);
$stock_const          = new stock_const($db);

$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);

if (!empty($cid)  && $action == "pdf") {
    
    require_once DOL_DOCUMENT_ROOT.'/btp/material/stock/pdf/pdf.lib.php';
    $pdf->SetFont('times', '', 13, '', true);
    $pdf->AddPage();

    
    $today          = date('d/m/Y');
    // require template
    require_once DOL_DOCUMENT_ROOT.'/btp/material/stock/tpl/etat_const.tpl.php';
    /*echo($html);
    die();*/
    //$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_end_clean();
    $pdf->Output('etat_stock_marché-'.$market->code.'.pdf', 'I');
    die();
}

if ($action == 'create' && $request_method === 'POST' && !empty($_POST['cid'])) {
	
    $cid          = (int)trim($_POST['cid']);
    $product_id   = (int)trim($_POST['product_id_']);
    $qty          = (int)trim($_POST['qty_']);
    $datec        = trim($_POST['datec_']);

    if ($cid <= 0 || $product_id <= 0   || $qty <= 0 || empty($datec)  ) {
           $msg ='Remplir tous les champs';
        header("Location: card.php?action=add&cid=".$cid."&msg=Remplir tous les champs");
         setEventMessage($msg, 'errors');
        exit;
    }


    if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($vtd, $vtm, $vty) = explode("/", $_POST['datec_']);
             $datec_time = '22:00:00';
            $datec      = $vty.'-'.$vtm.'-'.$vtd.' '. $datec_time;
        }
    
        $product->fetch($product_id);
        $product->load_stock();
        if($product->stock_reel<$qty)
            {
                $msg ='le stock est insuffisant ('.$product->stock_reel.')';
        header("Location: card.php?action=add&cid=".$cid."&msg=le stock est insuffisant");
         setEventMessage($msg, 'errors');
        exit;
    }
    require_once DOL_DOCUMENT_ROOT .'/product/stock/class/mouvementstock.class.php';
        $movementstock=new MouvementStock($db);

        $result1=$movementstock->_create($user,$product_id,1,"-".trim($qty),1,0,$market->code.'->'.$constructionSite->name,$constructionSite->market_id.'-'.$cid,$datec);
  /* $result1=$product->correct_stock(
                        $user,
                        1,
                        $qty,
                        1,
                        $market->code.'->'.$constructionSite->name,
                        0,
                        $constructionSite->market_id.'-'.$cid
                    );*/
   

    // If no SQL error we redirect to the request card
   if (! $error && $result1 >= 0 )
            {
                $db->commit();
                 $db->commit();
        header('Location: index.php?cid='.$cid);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: card.php?action=request&cid='.$cid.'&error=SQL_Create&msg='.$consumptionsSupplies->error);
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST' && !empty($_POST['cid']) && !empty($_POST['id'])) {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/
    // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
     $stock_const->fetch($id);
    $canedit = true ; 

    // If this is the requestor or has read/write rights
    if ($canedit) {

        $cid          = (int)trim($_POST['cid']);
        $id           = (int)trim($_POST['id']);
        $product_id   = (int)trim($_POST['product_id_']);
        $qty          = (int)trim($_POST['qty_']);
        $datec        = trim($_POST['datec_']);

         if ($cid <= 0 || $product_id <= 0 || $qty <= 0 || empty($datec)) {
             $msg ='Remplir tous les champs';
            header("Location: index.php?cid=".$cid."&msg=Remplir tous les champs");
            setEventMessage($msg, 'errors');
          exit;
        }
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($vtd, $vtm, $vty) = explode("/", $_POST['datec_']);
            $datec_time = '22:00:00';
            $datec      = $vty.'-'.$vtm.'-'.$vtd.' '. $datec_time ;
        }
        $product->fetch($product_id);
        $product->load_stock();
        if($product->stock_reel<$qty)
            {
                 $msg ='le stock est insuffisant ('.$product->stock_reel.')';
        header("Location: card.php?action=add&cid=".$cid."&msg=le stock est insuffisant");
                setEventMessage($msg, 'errors');
       exit;
    }

        $data = array(
          'datem'         => $datec,
          'value'           => (-1*$qty),
          'fk_product'    => $product_id
        );

		$getstock_constID = $stock_const->update($id, $data);
        
        if ($getstock_constID > 0) {
            header('Location: ./index.php?id='.$id.'&cid='.$cid);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='.$id.'&cid='. $cid .'&action=edit&error=SQL_Create&msg='.$consumptionsSupplies->error);
            exit;
        }
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	if ($id <= 0)
        die('Missing id');
    $stock_const->fetch($id);
	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$stock_const->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?cid='.$cid);
		exit;
	}
	else {
        header('Location: index.php?leftmenu=marches&cid='.$cid);
        exit;
	}
}

/*
 * View
 */
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/btp.js");
$morecss = array();

llxHeader(array(), $langs->trans('stock_const'),'','','','',$morejs,$morecss,0,0);

// Fetch both market and construction site


if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        $head = market_prepare_head($market);
        dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

        $head = market_construction_site_prepare_head($constructionSite);
        dol_fiche_head($head, 'stock_const', $langs->trans("stock_const"), 0, 'submunu');

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="cid" value="'.$cid.'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        
        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
      print '<input type="hidden" class="timepicker" name="datec_time_" readonly="readonly" value="00:00:00" />';
        print '</td></tr>';

        //produit
        print '<tr><td class="fieldrequired">'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits(null,'product_id_', 0, 30, 0, 0, 0,'',1);
        print '</td></tr>';
       
        //unité 
        /*print '<tr><td>'.$langs->trans("unit_type").'</td><td>'; 
        print $form->selectarray('unit_type_id_', $unitType->getNames(),(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" value="" min="1" name="qty_" required="required" />';
        print '</td></tr>';
        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createstock_const") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}

else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $stock_const->fetch($id);
             $head = market_prepare_head($market);
            dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

            $head = market_construction_site_prepare_head($constructionSite);
            dol_fiche_head($head, 'stock_const', $langs->trans("stock_const"), 0, 'submunu');

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

    if ($action == 'edit') {
        $edit = true;
        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
        print '<input type="hidden" name="action" value="update" />'."\n";
        print '<input type="hidden" name="id" value="'.$id.'" />'."\n";
        print '<input type="hidden" name="cid" value="'.$cid.'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';
        $start_date = dol_print_date($stock_const->datem,'day');
         print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" value="'. $start_date .'" /> ';
         print '<input type="hidden" class="timepicker" name="datec_time_" readonly="readonly" value="23:00:00" />';
        print '</td></tr>';

        //produit
        print '<tr><td>'.$langs->trans("product").'</td><td>'; 
        print $form->select_produits($stock_const->fk_product,'product_id_', 0, 30, 0, '', 0, 0);
        print '</td></tr>';
       

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" value="'.(-1*$stock_const->value).'" min="1" name="qty_" required="required" />';
        print '</td></tr>';
       print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</table>';
    }

    dol_fiche_end();

        if (!$edit) {
            print '<div class="tabsAction">';

            // Boutons d'actions
            //if ($canedit) {
                print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
            //}
            print '</div>';
        }
} else {        
        print '<div class="tabBar">';
        print $langs->trans('ErrorUserViewSC');
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
}

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>