<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 *   	\file       marches/card.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_advancement_noslip/class/work_advancement_noslip.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/construction_site/class/construction_site.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$action  = GETPOST('action', 'alpha');
$cid     = GETPOST('cid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$cid)
    die('ID chantier n\'existe pas!');

$workAdvancementNoSlip= new WorkAdvancementNoSlip($db);
$constructionSite     = new ConstructionSite($db);
$market               = new Market($db);
$unitType             = new unitType($db);
$product              = new product($db);
$form                 = new FormChild($db);

$error 	              = false;

if ($action == 'create' && $request_method === 'POST' && !empty($_POST['cid'])) {
    
    $cid          = (int)trim($_POST['cid']);
    $company_id   = (int)trim($_POST['company_id_']);
    $supply_id    = (int)trim($_POST['supply_id_']);
    $unit_type_id = (int)trim($_POST['unit_type_id_']);
    $qty          = (int)trim($_POST['qty_']);
    $salaries_num = (int)trim($_POST['salaries_num_']);
    $amount       = (float)trim($_POST['amount_']);
    $datec        = trim($_POST['datec_']);
    $works_nature = trim($_POST['works_nature_']);
    $works_place  = trim($_POST['works_place_']);

    if ($cid <= 0 || $company_id <= 0 || $supply_id <= 0 || $unit_type_id <= 0 || $qty <= 0 || $salaries_num <= 0 || $amount <= 0 || empty($datec) || empty($works_nature) || empty($works_place)) {
        header("Location: card.php?action=add&cid=".$cid."&msg=Remplir tous les champs");
        die();
    }

    $workAdvancementNoSlip->datec         = Tools::convertDateTo($datec, 'sql');
    $workAdvancementNoSlip->works_nature  = $works_nature;
    $workAdvancementNoSlip->works_place   = $works_place;
    $workAdvancementNoSlip->qty           = $qty;
    $workAdvancementNoSlip->salaries_num  = $salaries_num;
    $workAdvancementNoSlip->amount        = $amount;
    $workAdvancementNoSlip->company_id    = $company_id;
    $workAdvancementNoSlip->supply_id     = $supply_id;
    $workAdvancementNoSlip->unit_type_id  = $unit_type_id;
    $workAdvancementNoSlip->const_site_id = $cid;
    $workAdvancementNoSlip->created_by    = $user->id;

    $workAdvancementNoSlipID = $workAdvancementNoSlip->create();

    // If no SQL error we redirect to the request card
    if ($workAdvancementNoSlipID > 0) {
        header('Location: index.php?id='.$workAdvancementNoSlipID.'&cid='.$cid);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: card.php?action=request&cid='.$cid.'&error=SQL_Create&msg='.$workAdvancementNoSlip->error);
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST' && !empty($_POST['cid']) && !empty($_POST['id'])) {
    // If no right to modify a request
    /*if (!$user->rights->marches->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    // $canedit = ($user->rights->marches->write || $user->rights->marches->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $id           = (int)trim($_POST['id']);
        $cid          = (int)trim($_POST['cid']);
        $company_id   = (int)trim($_POST['company_id_']);
        $supply_id    = (int)trim($_POST['supply_id_']);
        $unit_type_id = (int)trim($_POST['unit_type_id_']);
        $qty          = (int)trim($_POST['qty_']);
        $salaries_num = (int)trim($_POST['salaries_num_']);
        $amount       = (float)trim($_POST['amount_']);
        $datec        = trim($_POST['datec_']);
        $works_nature = trim($_POST['works_nature_']);
        $works_place  = trim($_POST['works_place_']);

        if ($cid <= 0 || $company_id <= 0 || $supply_id <= 0 || $unit_type_id <= 0 || $qty <= 0 || $salaries_num <= 0 || $amount <= 0 || empty($datec) || empty($works_nature) || empty($works_place)) {
            header("Location: index.php?cid=".$cid."&msg=Remplir tous les champs");
            die();
        }

        $data = array(
          'works_nature'    =>  $works_nature,
          'works_place'     =>  $works_place,
          'datec'           =>  Tools::convertDateTo($datec, 'sql'),
          'qty'             =>  $qty,
          'salaries_num'    =>  $salaries_num,
          'amount'          =>  $amount,
          'company_id'      =>  $company_id,
          'supply_id'       =>  $supply_id,
          'unit_type_id'    =>  $unit_type_id,
          'const_site_id'   =>  $cid,
        );

		$updated = $workAdvancementNoSlip->update($id, $data);
        
        if ($updated > 0) {
            header('Location: ./index.php?id='.$id.'&cid='.$cid);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='.$id.'&cid='. $cid .'&action=edit&error=SQL_Create&msg='.$workAdvancementNoSlip->error);
            exit;
        }
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$canedit = ($user->rights->marches->write_all || $user->rights->marches->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$workAdvancementNoSlip->delete($id);
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?cid='.$cid);
		exit;
	}
	else {
        header('Location: index.php?cid='.$cid);
        exit;
	}
}

/*
 * View
 */
$morejs  = array("/btp/js/btp.js");
$morecss = array();

llxHeader(array(), $langs->trans('work_advances_noslip'),'','','','',$morejs,$morecss,0,0);

// Fetch both market and construction site
$constructionSite->fetch($cid);
$market->fetch($constructionSite->market_id);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->marches->write) || empty($user->rights->marches->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        $head = market_prepare_head($market);
        dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

        $head = market_construction_site_prepare_head($constructionSite);
        dol_fiche_head($head, 'work_advancement_noslip', $langs->trans("AdvancementNoSlip"), 0, 'submunu');

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="cid" value="'. $cid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        // works_nature
        print '<tr><td class="fieldrequired">'.$langs->trans("works_nature").'</td><td>';
        print '<input type="text" value="" name="works_nature_" required="required" />';
        print '</td></tr>';

        //fourniture
        print '<tr><td class="fieldrequired">'.$langs->trans("supply").'</td><td>'; 
        print $form->select_produits_list(null,'supply_id_', 0, 30, 0, '', 0, 2);
        print '</td></tr>';

        //carburant
        print '<tr><td class="fieldrequired">'.$langs->trans("unit_type").'</td><td>'; 
        $mark_work_advances_noslip = $unitType->getNames();
        print $form->selectarray('unit_type_id_', $mark_work_advances_noslip,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        // Thirdparty
        print '<tr><td class="fieldrequired">'.$langs->trans("company").'</td><td>';
        $filteronlist='';
        if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
        $text=$form->select_thirdparty_list('','company_id_',$filteronlist,1,1);
        if (empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) && empty($conf->dol_use_jmobile))
        {
            $texthelp=$langs->trans("IfNeedToUseOhterObjectKeepEmpty");
            print $form->textwithtooltip($text.' '.img_help(),$texthelp,1);
        }
        else print $text;

        $dircustom = DOL_DOCUMENT_ROOT.'/societe/soc.php';
        $createsoci = "soc.php";
        if (!is_dir($dircustom)) {
            $createsoci = "card.php";
        }
        print ' <a href="'.DOL_URL_ROOT.'/societe/'.$createsoci.'?action=create&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'">'.$langs->trans("AddThirdParty").'</a>';
        print '</td></tr>';

        //compteur
        print '<tr><td class="fieldrequired">'.$langs->trans("works_place").'</td><td>';
        print '<input type="text" value="" name="works_place_" required="required" />';
        print '</td></tr>';

        //réservoir carburant
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="1" value="" name="qty_" required="required" />';
        print '</td></tr>';


        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("salaries_num").'</td><td>';
        print '<input type="number" min="1" value="" name="salaries_num_" required="required" />';
        print '</td></tr>';

        //Quantité de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="text" value="" name="amount_" required="required" /> '.$langs->getCurrencySymbol($conf->currency).'';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Creatework_advances_noslip") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $workAdvancementNoSlip->fetch($id);
            $head = market_prepare_head($market);
            dol_fiche_head($head, 'construction_site', $langs->trans("constraction_site"), 0, '');

            $head = market_construction_site_prepare_head($constructionSite);
            dol_fiche_head($head, 'work_advancement_noslip', $langs->trans("AdvancementNoSlip"), 0, 'submunu');

			//$canedit = ($user->rights->marches->delete || $user->rights->marches->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

    if ($action == 'edit') {
        $edit = true;
        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
        print '<input type="hidden" name="action" value="update" />'."\n";
        print '<input type="hidden" name="id" value="'.$id.'" />'."\n";
        print '<input type="hidden" name="cid" value="'.$cid.'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        // works_nature
        print '<tr><td class="fieldrequired">'.$langs->trans("works_nature").'</td><td>';
        print '<input type="text" value="'.$workAdvancementNoSlip->works_nature.'" name="works_nature_" required="required" />';
        print '</td></tr>';

        //supply
        print '<tr><td class="fieldrequired">'.$langs->trans("supply").'</td><td>'; 
        print $form->select_produits_list($workAdvancementNoSlip->supply_id,'supply_id_', 0, 30, 0, '', 0, 2);
        print '</td></tr>';

        // Thirdparty
        print '<tr><td class="fieldrequired">'.$langs->trans("company").'</td><td>';
        $filteronlist='';
        if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
        $text=$form->select_thirdparty_list($workAdvancementNoSlip->company_id,'company_id_',$filteronlist,1,1);
        if (empty($conf->global->PROJECT_CAN_ALWAYS_LINK_TO_ALL_SUPPLIERS) && empty($conf->dol_use_jmobile)) {
            $texthelp=$langs->trans("IfNeedToUseOhterObjectKeepEmpty");
            print $form->textwithtooltip($text.' '.img_help(),$texthelp,1);
        }
        else print $text;

        $dircustom = DOL_DOCUMENT_ROOT.'/societe/soc.php';
        $createsoci = "soc.php";
        if (!is_dir($dircustom)) {
            $createsoci = "card.php";
        }
        print ' <a href="'.DOL_URL_ROOT.'/societe/'.$createsoci.'?action=create&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'">'.$langs->trans("AddThirdParty").'</a>';
        print '</td></tr>';

        //unit type
        print '<tr><td class="fieldrequired">'.$langs->trans("unit_type").'</td><td>'; 
        $unitTypes = $unitType->getNames();
        print $form->selectarray('unit_type_id_', $unitTypes,(GETPOST('unit_type_id_') ? GETPOST('unit_type_id_') : $workAdvancementNoSlip->unit_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //works_place
        print '<tr><td class="fieldrequired">'.$langs->trans("works_place").'</td><td>';
        print '<input type="text" value="'.$workAdvancementNoSlip->works_place.'" name="works_place_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($workAdvancementNoSlip->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //année
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0" value="'.$workAdvancementNoSlip->qty.'" name="qty_" required="required" />';
        print '</td></tr>';

        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("salaries_num").'</td><td>';
        print '<input type="number" min="0" value="'.$workAdvancementNoSlip->salaries_num.'" name="salaries_num_" required="required" />';
        print '</td></tr>';

        //Quantité location   
        print '<tr><td class="fieldrequired">'.$langs->trans("amount").'</td><td>';
        print '<input type="number" min="0" step="0.01" value="'.$workAdvancementNoSlip->amount.'" name="amount_" required="required" />';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</table>';
    }

    dol_fiche_end();

    if (!$edit) {
        print '<div class="tabsAction">';

        // Boutons d'actions
        //if ($canedit) {
            print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
        //}

        // If draft
       // if ($user->rights->marches->delete)	{
        	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
       // }

        print '</div>';
    }

} else {
    
    print '<div class="tabBar">';
    print $langs->trans('ErrorUserViewSC');
    print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
    print '</div>';
}
}

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>