<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_delays/index.php
 * \ingroup    list
 * \brief      List of work_delays
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_delays/class/work_delays.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$wid 	  = GETPOST('wid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$wid)
	die("ID travaux n'existe pas!");

$search_ref      		= GETPOST('search_ref');
$search_createdby      	= GETPOST('search_createdby');
$search_note      		= GETPOST('search_note');
$search_date_start    	= GETPOST('search_date_start');
$search_date_resumption	= GETPOST('search_date_end');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   			= "";
	$search_note   			= "";
	$search_createdby 		= "";
    $search_date_start  	= "";
	$search_date_resumption	= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketWorkDelays($db);
$works   = new MarketWorks($db);
$fuser 	 = new User($db);
$market  = new Market($db);

llxHeader(array(), $langs->trans('Listwork_delays'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";

if (isset($search_date_start) && !empty($search_date_start)) {
  $filter .=  " AND date_start = '". $db->escape(Tools::convertDateTo($search_date_start, 'sql')) ."'";
}
if (isset($search_date_resumption) && !empty($search_date_resumption)) {
  $filter .=  " AND date_resumption = '". $db->escape(Tools::convertDateTo($search_date_resumption, 'sql')) ."'";
}

$filter .= (!empty($search_createdby) && $search_createdby != -1) ? " AND fk_createdby = ". $db->escape((int)$search_createdby) : "";
$filter .= (!empty($search_note)) ? " AND note LIKE '%". $db->escape($search_note) ."%'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getwork_delays = $object->fetchAll($wid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_delays == '-1') {
    print_fiche_titre($langs->trans('work_delays'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

if ($id > 0) {
	$object->fetch($id);
	$title = $langs->trans("Works");
	$head  = market_prepare_head($market);

	print_barre_liste($langs->trans("Delays"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	dol_fiche_head($head, 'works', $title, 0, '');

	$head  = market_works_prepare_head($works);
	dol_fiche_head($head, 'work_delays', $langs->trans("Delays"), 0, 'submunu');
	// echo $market->getMarketHeader($wid, true);

	$fuser->fetch($object->fk_createdby);

	$note				= $object->note ?: '';
	$date_start			= $object->date_start ? dol_print_date($object->date_start,'day') : '';
	$date_resumption	= $object->date_resumption ? dol_print_date($object->date_resumption,'day') : '';

	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';

	// Start date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("StoppedDate").'</td>';
	print '<td colspan="2">'. $date_start .'</td></tr>';
	// End date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ResumptionDate").'</td>';
	print '<td colspan="2">'. $date_resumption .'</td></tr>';

	// note
	print '<tr><td>'.$langs->trans("TNote").'</td>';
	print '<td colspan="2">'. $note .'</td></tr>';
	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?wid='. $wid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&wid='. $wid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?wid=".$wid."&id=".$id, $langs->trans("TitleDeleteDelay"), $langs->trans("ConfirmDeleteDelay"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("Delays"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $title, 0, '');

	$head  = market_works_prepare_head($works);
	dol_fiche_head($head, 'work_delays', $langs->trans("Delays"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);
	$moreparam = '&wid='.$wid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="wid" value="'. $wid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_createdby", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("TNote"),$_SERVER["PHP_SELF"], "note", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("StoppedDate"), $_SERVER["PHP_SELF"], 'date_start', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ResumptionDate"),$_SERVER["PHP_SELF"], 'date_resumption', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("totalDays"), '','','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

	// UTILISATEUR
	// if ($user->rights->btp->write_all) {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($search_createdby,"search_createdby",1,"",0,'','',0,32);
	    print '</td>';
	/*}
	else {
	    print '<td class="liste_titre" align="center">';
	    print $form->select_dolusers($user->id,"search_createdby",1,"",1,'','',0,32);
	    print '</td>';
	}*/

	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="30" type="text" name="search_note" value="'.dol_escape_htmltag($search_note).'" />';
	print '</td>';

	// Start Date
	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_date_start" value="'.$search_date_start.'"></td>';
	// Resumption Date
	print '<td class="liste_titre" align="center"><input class="flat datepicker center" type="text" size="14" name="search_date_end" value="'.$search_date_resumption.'"></td>';
	// Statut
	print '<td class="liste_titre" align="center">&nbsp;</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($db->escape($line->fk_createdby));
			$date_start		= $line->date_start ? dol_print_date($line->date_start,'day') : '';
			$date_resumption= $line->date_resumption ? dol_print_date($line->date_resumption,'day') : '';
			$totalDaysSpent =  Tools::getDiffOfDates(dol_print_date($line->date_start, 'dayrfc'), dol_print_date($line->date_resumption, 'dayrfc'));

			$note 	  = '';
			$fullnote = '';
			if (null !== $line->note) {
				$fullnote = str_replace(array("\r\n", "\n"), "", strip_tags($line->note));
				$note = substr($line->note, 0, 100);
				$note = strlen($line->note) > 100 ? $note.'...' : $note;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $object->getNomUrl(1,  $line->id, $line->fk_td_work);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl('1') .'</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullnote .'">'.$note.'</span></td>';
			print '<td align="center">'. $date_start .'</td>';
			print '<td align="center">'. $date_resumption .'</td>';
			print '<td align="center">'.  $totalDaysSpent .' '. $langs->trans('Days') .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&wid='. $wid .'" class="butAction">'.$langs->trans('AddDelay').'</a>';
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>