<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_equipments/index.php
 * \ingroup    list
 * \brief      CRUD of work_equipments
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_equipments/class/work_equipments.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';

require_once DOL_DOCUMENT_ROOT.'/btp/settings/unit_type/class/unitType.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/settings/machine_categories/class/MachineCategories.class.php';

// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$wid 	 = GETPOST('wid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$wid && $request_method !== 'POST')
	die('ID travaux n\'existe pas!');

$error 	= false;
$object  = new MarketWorkEquipments($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$unitType= new unitType($db);
$machineCat= new MachineCategories($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    // 	$error++;
    // 	setEventMessage($langs->trans('CantCreate'));
    // } else {
	    $wid 			= (int)trim($_POST['wid']);
	    $machine_cat	= (int)trim($_POST['machine_cat']);
	    $unit_type		= (int)trim($_POST['unit_type']);
	    $unit_cost		= (float)trim($_POST['unit_cost']);
    	$qty			= (int)trim($_POST['qty']);
	    $equip_num		= trim($_POST['equip_num']);
    	$amortization	= trim($_POST['amortization']);
    	$maintenance	= trim($_POST['maintenance']);
    	$expendable		= trim($_POST['expendable']);

	    if ($wid <= 0 || $machine_cat <= 0 || $unit_type <= 0 || $qty <= 0 || $unit_cost <= 0) {
			header('Location: ./card.php?action=add&wid='.$wid);
			die();
	    }

	    $object->fk_createdby 	= $user->id;
	    $object->fk_td_work  	= $wid;
	    $object->fk_machine_cat	= $machine_cat;
	    $object->fk_unit_type	= $unit_type;
	    $object->unit_cost 		= $unit_cost;
	    $object->qty 			= $qty;
	    $object->equip_num 		= $equip_num;
	    $object->amortization	= $amortization;
	    $object->maintenance	= $maintenance;
	    $object->expendable		= $expendable;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&wid='.$wid);
		    die();
		} else {
			header('Location: ./index.php?wid='.$wid);
		    die();
		}
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['wid'] > 0 && $request_method === 'POST') {

	 // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
  //   	$error++;
  //   	setEventMessage($langs->trans('CantCreate'));
  //   } else {
	    $id 			= (int)trim($_POST['id']);
	    $wid 			= (int)trim($_POST['wid']);
	    $machine_cat	= (int)trim($_POST['machine_cat']);
	    $unit_type		= (int)trim($_POST['unit_type']);
	    $unit_cost		= (float)trim($_POST['unit_cost']);
    	$qty			= (int)trim($_POST['qty']);
	    $equip_num		= trim($_POST['equip_num']);
    	$amortization	= trim($_POST['amortization']);
    	$maintenance	= trim($_POST['maintenance']);
    	$expendable		= trim($_POST['expendable']);

	    if ($id <= 0 || $wid <= 0 || $machine_cat <= 0 || $unit_type <= 0 || $qty <= 0 || $unit_cost <= 0) {
			header('Location: ./index.php?wid='.$wid);
			die();
	    }

	    $data = array(
		    'fk_machine_cat' => $machine_cat,
		    'fk_unit_type'	 => $unit_type,
		    'unit_cost' 	 => $unit_cost,
		    'qty' 			 => $qty,
		    'equip_num' 	 => $equip_num,
		    'amortization'	 => $amortization,
		    'maintenance'	 => $maintenance,
		    'expendable'	 => $expendable,
		);

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&wid='.$wid);
	    die();
	// }

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes'/* && $user->rights->btp->delete*/) {
	$error = 0;
	$wid = GETPOST('wid', 'int');
	$id  = (int) GETPOST('id', 'int');
	
	if (!$wid || !$id)
		return;

	$db->begin();

	$canedit = true/*($user->rights->btp->write_all || $user->rights->btp->delete)*/;

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?wid='.$wid);
	exit;
}

$form = new FormChild($db);
// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

llxHeader(array(), $langs->trans('Equipments'),'','','','',array('/btp/js/btp.js'),array(),0,0);
$market->fetch($wid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
 //        $errors[] = $langs->trans('CantCreate');
 //    } else {
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_equipmentsHead  = market_works_prepare_head($works);
		dol_fiche_head($work_equipmentsHead, 'work_equipments', $langs->trans("Equipments"), 0, 'submunu');

		// echo $market->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("MachineCategory").'</td><td>';
		print $form->selectarray("machine_cat", $machineCat->getNames(), '',1);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("UnitType").'</td><td>';
		print $form->selectarray("unit_type", $unitType->getNames(), '', 1, 0, 0, ' required="required"');
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("UnitCost").'</td><td>';
        print '<input type="text" class="flat" name="unit_cost" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
        print '<input type="number" class="flat" name="qty" min="1" required="required" />';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("EquipmentNum").'</td><td>';
        print '<input type="text" class="flat" name="equip_num" />';
        print '</tr>';

        print '<tr><td class="">'.$langs->trans("Amortization").'</td><td>';
        print '<input type="text" class="flat" name="amortization" />';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("Maintenance").'</td><td>';
        print '<input type="text" class="flat" name="maintenance" />';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("Expendable").'</td><td>';
        print '<input type="text" class="flat" name="expendable" />';
        print '</td></tr>';	

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateEquipment") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $wid > 0) {
		$object->fetch($id);
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_equipmentsHead  = market_works_prepare_head($works);
		dol_fiche_head($work_equipmentsHead, 'work_equipments', $langs->trans("Equipments"), 0, 'submunu');

		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
			if ($action == 'edit') {
				// echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$qty 		= $object->qty ? $object->qty : '';
				$unit_cost 	= $object->unit_cost ? $object->unit_cost : '';
				$equip_num 	= $object->equip_num ? $object->equip_num : '';
				$amortization= $object->amortization ? $object->amortization : '';
				$maintenance = $object->maintenance ? $object->maintenance : '';
				$expendable  = $object->expendable ? $object->expendable : '';
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

				print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("MachineCategory").'</td><td>';
				print $form->selectarray("machine_cat", $machineCat->getNames(), $object->fk_machine_cat,1);
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("UnitType").'</td><td>';
				print $form->selectarray("unit_type", $unitType->getNames(), $object->fk_unit_type, 1, 0, 0, ' required="required"');
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("UnitCost").'</td><td>';
		        print '<input type="text" class="flat" name="unit_cost" value="'. $unit_cost .'" required="required" /> '.$langs->getCurrencySymbol($conf->currency);
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
		        print '<input type="number" class="flat" name="qty" min="1" value="'. $qty .'" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="">'.$langs->trans("EquipmentNum").'</td><td>';
		        print '<input type="text" class="flat" name="equip_num" value="'. $equip_num .'" />';
		        print '</tr>';

		        print '<tr><td class="">'.$langs->trans("Amortization").'</td><td>';
		        print '<input type="text" class="flat" name="amortization" value="'. $amortization .'" />';
		        print '</td></tr>';

		        print '<tr><td class="">'.$langs->trans("Maintenance").'</td><td>';
		        print '<input type="text" class="flat" name="maintenance" value="'. $maintenance .'" />';
		        print '</td></tr>';

		        print '<tr><td class="">'.$langs->trans("Expendable").'</td><td>';
		        print '<input type="text" class="flat" name="expendable" value="'. $expendable .'" />';
		        print '</td></tr>';	

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
