<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_subcontracting/index.php
 * \ingroup    list
 * \brief      List of work_subcontracting
 */
require_once('../../../main.inc.php');
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/btp/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/work_subcontracting/class/work_subcontracting.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/market/class/market.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/market/works/class/works.class.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/btp.lib.php';
require_once DOL_DOCUMENT_ROOT.'/btp/lib/tools.lib.php';


// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$wid 	  = GETPOST('wid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$wid)
	die("ID de travaux n'existe pas!");

$search_ref   = GETPOST('search_ref');
$search_qty   = GETPOST('search_qty');
$search_sdate = GETPOST('search_sdate');
$search_price = GETPOST('search_price');
$search_createdby = GETPOST('search_createdby');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   	= "";
    $search_qty 	= "";
	$search_sdate	= "";
	$search_price	= "";
	$search_createdby	= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object  = new MarketWorkSubContracting($db);
$works   = new MarketWorks($db);
$market  = new Market($db);
$fuser 	 = new User($db);

llxHeader(array(), $langs->trans('SubContracting'), '', '', '', '', array('/btp/js/btp.js'));
if (isset($search_sdate) && !empty($search_sdate)) {
	list($sd, $sm, $sy)  = explode("/", $search_sdate);
	$filter .=  " AND sdate = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";
$filter .= (isset($search_qty) && !empty($search_qty)) ? " AND qty = ". $db->escape((int)$search_qty) : '';
//$filter .= isset($search_sdate) && !empty($search_sdate) ? " AND sdate = '". $db->escape($search_sdate) ."'" : '';
$filter .= (!empty($search_product) && $search_product != -1) ? " AND fk_product = ". $db->escape((int)$search_product) : "";
$filter .= (!empty($search_createdby) && $search_createdby != -1) ? " AND fk_createdby = ". $db->escape((int)$search_createdby) : "";
$filter .= (!empty($search_transport)) ? " AND transport = '". $db->escape($search_transport) ."'" : "";
$filter .= (!empty($search_price)) ? " AND price = ". $db->escape($search_price) : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getwork_subcontracting = $object->fetchAll($wid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_subcontracting == '-1') {
    print_fiche_titre($langs->trans('Supplies'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

if ($id > 0) {
	$object->fetch($id);
	
	print_barre_liste($langs->trans("SubContracting"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_subcontractingHead  = market_works_prepare_head($works);
	dol_fiche_head($work_subcontractingHead, 'work_subcontracting', $langs->trans("SubContracting"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$fuser->fetch($object->fk_createdby);
	$qty 	= $object->qty ? $object->qty : '';
	$price 	= $object->price ? number_format($object->price, 2) : '';
	$sdate 	= $object->sdate ? dol_print_date($object->sdate, 'day') : '';

	print '<table class="border" width="100%">';
	// User
	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';

	// Price
	print '<tr><td class="fieldrequired">'.$langs->trans("Price").'</td>';
	print '<td colspan="2">'. $price .' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';

	// quantity
	print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
	print '<td colspan="2">'. $qty .'</td></tr>';

	// sdate
	print '<tr><td class="fieldrequired">'.$langs->trans("SubContractingDate").'</td>';
	print '<td colspan="2">'. $sdate .'</td></tr>';

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?wid='. $wid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&wid='. $wid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
            print $form->formconfirm("./card.php?wid=".$wid."&id=".$id, $langs->trans("TitleDeleteSubContracting"), $langs->trans("ConfirmDeleteSubContracting"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("SubContracting"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_subcontractingHead  = market_works_prepare_head($works);
	dol_fiche_head($work_subcontractingHead, 'work_subcontracting', $langs->trans("Supplies"), 0, 'submunu');

	// echo $market->getMarketHeader($wid);

	$moreparam = '&wid='.$wid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="wid" value="'. $wid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"), $_SERVER["PHP_SELF"], 'fk_createdby', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Price"), $_SERVER["PHP_SELF"],'price','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Quantity"),$_SERVER["PHP_SELF"], 'qty', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("total"),$_SERVER["PHP_SELF"], '', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("SubContractingDate"), $_SERVER["PHP_SELF"],'sdate','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

    print '<td class="liste_titre" align="center">';
	print $form->select_dolusers($search_createdby,"search_createdby",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="number" step="0.01" name="search_price" value="'.dol_escape_htmltag($search_price).'" />';
	print '</td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="number" size="14" name="search_qty" value="'.$search_qty.'" min="1" /></td>';

	print '<td class="liste_titre" align="center"></td>';

	print '<td class="liste_titre" align="center"><input class="flat center datepicker" type="text" size="20" name="search_sdate" value="'.$search_sdate.'"></td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$fuser->fetch($line->fk_createdby);
			$price	= $line->price ? number_format($line->price, 2) : '';
			$qty 	= $line->qty ? $line->qty : '';
			$sdate	= $line->sdate ? dol_print_date($line->sdate, 'day') : '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $object->getNomUrl(1,  $line->id, $line->fk_td_work);
			print '</td>';
			print '<td align="center">'. $fuser->getNomUrl(1) .'</td>';
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $qty*$price .'</td>';
			print '<td align="center">'. $sdate .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="6" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="6" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&wid='. $wid .'" class="butAction">'.$langs->trans('AddSubContracting').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>